/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.configuration.Configuration;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.adv.Banner;
import ru.softlogic.reference.adv.Movie;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.updater.UpdateOptions;
import ru.softlogic.srv.api.adv.BannerObserver;
import ru.softlogic.srv.api.status.UpdateState;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;
import ru.softlogic.system.util.ThreadUtil;
import ru.softlogic.system.util.network.RemoteStatusObserver;
import ru.softlogic.update.updater.HttpUpdateStore;
import ru.softlogic.update.updater.UpdateItem;
import ru.softlogic.update.updater.UpdateLocks;
import ru.softlogic.update.updater.exceptions.RemoteFileNotFoundException;

public class BannerUpdater
implements Runnable,
BannerObserver,
RemoteStatusObserver {
    private Logger log;
    private boolean needUpdate;
    private long lastCheck;
    private boolean allowUpdate;
    private ClientInterface clientInterface;
    private Short lastState;

    public BannerUpdater(ClientInterface clientInterface) {
        if (clientInterface == null) {
            throw new NullPointerException("ClientInteface is null");
        }
        this.clientInterface = clientInterface;
        this.log = Logger.getLogger((String)"update");
        this.log.setAdditivity(false);
    }

    public void update(Banner[] banners) {
        this.needUpdate = true;
    }

    public void update(int remoteStatus) {
        this.allowUpdate = (remoteStatus & 0x80) > 0;
    }

    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        this.sendUpdateStatus((short)0);
        ThreadUtil.sleep((long)60000L);
        int hours = 3;
        while (!Thread.currentThread().isInterrupted()) {
            if (this.allowUpdate && (this.lastCheck == 0L || this.needUpdate || System.currentTimeMillis() - this.lastCheck > (long)(hours * 60 * 60 * 1000))) {
                if (!UpdateLocks.getInstance().isSoftwareLocked() && !UpdateLocks.getInstance().isBdpnLocked()) {
                    block34: {
                        try {
                            int point;
                            File bannerDir = new File(Configuration.getInstance().getApplicationDir() + "/banners");
                            FileUtil.checkDir((String)bannerDir.getAbsolutePath());
                            File moviesDir = new File(Configuration.getInstance().getApplicationDir() + "/ad");
                            FileUtil.checkDir((String)moviesDir.getAbsolutePath());
                            UpdateOptions uo = ReferenceManager.getInstance().getUpdateOptions();
                            Point p = ReferenceManager.getInstance().getPoint();
                            int n = point = p == null ? 0 : p.getId();
                            if (uo != null && uo.getUpdateUrl() != null && uo.getUpdateUrl().length() > 0) {
                                File file;
                                int number;
                                boolean firstTime;
                                HttpUpdateStore us;
                                String vPath = "/banners/";
                                if (!uo.getUpdateUrl().endsWith("/")) {
                                    vPath = "/" + vPath;
                                }
                                boolean isErrorStatus = false;
                                List<UpdateItem> downloadList = this.getDownloadList(bannerDir);
                                if (downloadList.size() > 0) {
                                    us = new HttpUpdateStore(uo.getUpdateUrl() + vPath, uo.getUpdateLogin(), uo.getUpdatePassword(), point, AppDefaults.getInstance().getIntegerValue("system.update.socket.timeout"));
                                    this.sendUpdateStatus((short)1);
                                    firstTime = true;
                                    number = 1;
                                    do {
                                        this.log.info((Object)("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 " + number + ", \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u043a\u0430\u0447\u0430\u0442\u044c: " + downloadList));
                                        for (UpdateItem ui : downloadList) {
                                            boolean res;
                                            block32: {
                                                file = new File(bannerDir, ui.getFilename());
                                                try {
                                                    if (!file.exists()) {
                                                        FileUtil.mkParentDirs((File)file);
                                                        break block32;
                                                    }
                                                    if (!firstTime) break block32;
                                                    res = file.delete();
                                                    this.log.info((Object)("Delete file result: " + res));
                                                }
                                                catch (FileUtilException fue) {
                                                    this.log.error((Object)fue.getMessage(), (Throwable)fue);
                                                    continue;
                                                }
                                            }
                                            this.log.info((Object)("\u0421\u043a\u0430\u0447\u0438\u0432\u0430\u0435\u043c \u0444\u0430\u0439\u043b " + ui.getFilename()));
                                            res = true;
                                            try {
                                                file.setLastModified(0L);
                                                us.download(ui, file, null, null);
                                            }
                                            catch (RemoteFileNotFoundException ex) {
                                                this.log.error((Object)("Error: remote file not found, " + ex.getMessage()));
                                                res = false;
                                            }
                                            catch (IOException ex) {
                                                this.log.error((Object)ex);
                                                res = false;
                                            }
                                            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
                                        }
                                        firstTime = false;
                                        downloadList = this.getDownloadList(bannerDir);
                                        if (downloadList.size() <= 0) continue;
                                        this.log.info((Object)("\u041d\u0435\u0443\u0434\u0430\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 " + number + ". \u0421\u043f\u0438\u043c 20 \u0441\u0435\u043a\u0443\u043d\u0434"));
                                        ThreadUtil.sleep((long)20000L);
                                    } while (downloadList.size() > 0 && number++ < 5);
                                    if (downloadList.size() > 0) {
                                        this.log.error((Object)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
                                        hours = 1;
                                        isErrorStatus = true;
                                    } else {
                                        this.log.info((Object)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0448\u043b\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
                                        hours = 3;
                                    }
                                }
                                vPath = "/ad/";
                                if (!uo.getUpdateUrl().endsWith("/")) {
                                    vPath = "/" + vPath;
                                }
                                if ((downloadList = this.getDownloadMoviesList(moviesDir)).size() > 0) {
                                    us = new HttpUpdateStore(uo.getUpdateUrl() + vPath, uo.getUpdateLogin(), uo.getUpdatePassword(), point, AppDefaults.getInstance().getIntegerValue("system.update.socket.timeout"));
                                    this.sendUpdateStatus((short)1);
                                    firstTime = true;
                                    number = 1;
                                    do {
                                        this.log.info((Object)("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 " + number + ", \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u043a\u0430\u0447\u0430\u0442\u044c \u0440\u043e\u043b\u0438\u043a\u0438: " + downloadList));
                                        for (UpdateItem ui : downloadList) {
                                            block33: {
                                                file = new File(moviesDir, ui.getFilename());
                                                try {
                                                    if (!file.exists()) {
                                                        FileUtil.mkParentDirs((File)file);
                                                        break block33;
                                                    }
                                                    if (!firstTime) break block33;
                                                    file.delete();
                                                }
                                                catch (FileUtilException fue) {
                                                    this.log.error((Object)fue.getMessage(), (Throwable)fue);
                                                    continue;
                                                }
                                            }
                                            this.log.info((Object)("\u0421\u043a\u0430\u0447\u0438\u0432\u0430\u0435\u043c \u0440\u043e\u043b\u0438\u043a " + ui.getFilename()));
                                            boolean res = true;
                                            try {
                                                file.setLastModified(0L);
                                                us.download(ui, file, null, null);
                                            }
                                            catch (RemoteFileNotFoundException ex) {
                                                this.log.error((Object)("Error: remote file not found, " + ex.getMessage()));
                                                res = false;
                                            }
                                            catch (IOException ex) {
                                                this.log.error((Object)ex);
                                                res = false;
                                            }
                                            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
                                        }
                                        firstTime = false;
                                        downloadList = this.getDownloadMoviesList(moviesDir);
                                        if (downloadList.size() <= 0) continue;
                                        this.log.info((Object)("\u041d\u0435\u0443\u0434\u0430\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 " + number + ". \u0421\u043f\u0438\u043c 20 \u0441\u0435\u043a\u0443\u043d\u0434"));
                                        this.log.info((Object)("\u041e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u0441\u043a\u0430\u0447\u0430\u0442\u044c \u0440\u043e\u043b\u0438\u043a\u0438:" + downloadList));
                                        UpdateLocks locks = UpdateLocks.getInstance();
                                        if (locks.isSoftwareLocked() || locks.isBdpnLocked()) {
                                            this.log.info((Object)"\u0417\u0430\u043f\u0443\u0449\u0435\u043d \u0431\u043e\u043b\u0435\u0435 \u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442\u043d\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f. \u041f\u0440\u0435\u0440\u044b\u0432\u0430\u044e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0431\u0430\u043d\u043d\u0435\u0440\u043e\u0432.");
                                            break;
                                        }
                                        ThreadUtil.sleep((long)20000L);
                                    } while (downloadList.size() > 0 && number++ < 5);
                                    if (downloadList.size() > 0) {
                                        this.log.error((Object)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
                                        hours = 1;
                                        isErrorStatus = true;
                                    } else {
                                        this.log.info((Object)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0448\u043b\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
                                        hours = 3;
                                    }
                                }
                                this.sendUpdateStatus(isErrorStatus ? (short)3 : 2);
                                break block34;
                            }
                            this.log.error((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u044f\u0442\u044c\u0441\u044f, \u043d\u043e \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u043e\u043f\u0446\u0438\u0439: " + uo));
                        }
                        catch (Exception e) {
                            this.log.error((Object)"\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u043e \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438", (Throwable)e);
                            this.sendUpdateStatus((short)3);
                        }
                    }
                    this.lastCheck = System.currentTimeMillis();
                    this.needUpdate = false;
                }
            } else {
                this.sendUpdateStatus((short)0);
            }
            ThreadUtil.sleep((long)300000L);
        }
        this.log.info((Object)"Stop thread");
    }

    private void sendUpdateStatus(short state) {
        if (this.lastState == null || this.lastState != state) {
            this.lastState = state;
            this.clientInterface.sendUpdateStatus(new UpdateState(state, 1));
        }
    }

    private List<UpdateItem> getDownloadList(File bannerDir) {
        ArrayList<UpdateItem> result = new ArrayList<UpdateItem>();
        try {
            Banner[] banners = ReferenceManager.getInstance().getBanners();
            if (banners != null) {
                for (Banner b : banners) {
                    File file2;
                    if (b.getId() <= 0) continue;
                    File file = new File(bannerDir, b.getUrl());
                    UpdateItem ui = new UpdateItem(b.getUrl(), b.getCrc(), 0, 0L);
                    if (!(file.exists() && b.getCrc() == this.calculateChecksum(file) || result.contains(ui))) {
                        result.add(ui);
                    }
                    ui = new UpdateItem(b.getPopupUrl(), b.getCrc(), 0, 0L);
                    if (b.getPopupUrl() == null || b.getPopupCrc() == 0L || (file2 = new File(bannerDir, b.getPopupUrl())).exists() && b.getPopupCrc() == this.calculateChecksum(file2) || result.contains(ui)) continue;
                    result.add(ui);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0441\u043f\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u043e\u0432", (Throwable)e);
        }
        return result;
    }

    private List<UpdateItem> getDownloadMoviesList(File moviesDir) {
        ArrayList<UpdateItem> result = new ArrayList<UpdateItem>();
        try {
            Movie[] movies = ReferenceManager.getInstance().getMovies();
            if (movies != null) {
                for (Movie b : movies) {
                    if (b.getId() <= 0) continue;
                    File file = new File(moviesDir, b.getUrl());
                    long bCrc = b.getCrc();
                    long crcFile = this.calculateChecksum(file);
                    UpdateItem ui = new UpdateItem(b.getUrl(), bCrc, 0, 0L);
                    if (file.exists() && bCrc == crcFile || result.contains(ui)) continue;
                    this.log.info((Object)("Bad file: " + b.getUrl() + ". References crc=" + bCrc + ", download file crc=" + crcFile));
                    result.add(ui);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0441\u043f\u0438\u0441\u043a\u0430 \u0440\u043e\u043b\u0438\u043a\u043e\u0432", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private long calculateChecksum(File file) {
        block8: {
            FileInputStream fis = null;
            try {
                CRC32 cs = new CRC32();
                cs.reset();
                fis = new FileInputStream(file);
                byte[] buf = new byte[1024];
                int l = 0;
                while ((l = fis.read(buf)) >= 0) {
                    cs.update(buf, 0, l);
                }
                fis.close();
                long l2 = cs.getValue();
                IOUtils.closeQuietly((InputStream)fis);
                return l2;
            }
            catch (FileNotFoundException ex) {
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0434\u0441\u0447\u0435\u0442\u0435 crc32, " + ex.getMessage()));
                IOUtils.closeQuietly((InputStream)fis);
            }
            catch (Exception ex2) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0434\u0441\u0447\u0435\u0442\u0435 crc32", (Throwable)ex2);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(fis);
            }
        }
        return 0L;
    }
}

