/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.html.connector.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import ru.softlogic.app.html.connector.utils.CommissionRenderException;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.CommissionUnit;
import ru.softlogic.system.util.PathUtils;

public class CommissionRender {
    public static final String COMMON = PathUtils.getAppHome() + "/resources/comm/common.vm";
    public static final String SIMPLE = PathUtils.getAppHome() + "/resources/comm/simple.vm";

    public static String generate(String templateName, Commission commission) throws CommissionRenderException {
        if (commission == null) {
            throw new NullPointerException("Commission");
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(templateName);
        }
        catch (FileNotFoundException ex) {
            throw new CommissionRenderException(ex);
        }
        VelocityContext context = new VelocityContext();
        context.put("c", (Object)commission);
        context.put("ST", (Object)new String());
        context.put("SU", (Object)new StringUtils());
        context.put("DF", (Object)CommissionRender.createFormat());
        CommissionRender.addUnits(context, commission);
        StringWriter sw = new StringWriter();
        try {
            Velocity.evaluate((Context)context, (Writer)sw, (String)"", (Reader)new InputStreamReader((InputStream)is, "UTF-8"));
            String string = sw.toString().trim();
            return string;
        }
        catch (MethodInvocationException ex) {
            throw new CommissionRenderException(ex);
        }
        catch (ParseErrorException ex) {
            throw new CommissionRenderException(ex);
        }
        catch (ResourceNotFoundException ex) {
            throw new CommissionRenderException(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new CommissionRenderException(ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private static DecimalFormat createFormat() {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(0);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        return df;
    }

    private static void addUnits(VelocityContext context, Commission commission) {
        if (commission.getUnits() != null && commission.getUnits().size() > 0) {
            HashMap<Integer, CashUnit> unitsList = new HashMap<Integer, CashUnit>();
            for (CashUnit cu : CashFactory.getDefaultInstance().getCoinUnits()) {
                unitsList.put(cu.getId(), cu);
            }
            for (CashUnit cu : CashFactory.getDefaultInstance().getCashUnits()) {
                unitsList.put(cu.getId(), cu);
            }
            TreeMap<Sum, Sum> coins = new TreeMap<Sum, Sum>();
            TreeMap<Sum, Sum> notes = new TreeMap<Sum, Sum>();
            for (CommissionUnit unit : commission.getUnits()) {
                if (unit.getFixedValue().getSum() == 0.0) continue;
                CashUnit cu = (CashUnit)unitsList.get(unit.getCashUnit());
                if (cu != null && cu.getType() == 4) {
                    coins.put(cu.getNominal(), unit.getFixedValue());
                    continue;
                }
                if (cu == null || cu.getType() != 3) continue;
                notes.put(cu.getNominal(), unit.getFixedValue());
            }
            if (coins.size() > 0) {
                context.put("coins", coins);
            }
            if (notes.size() > 0) {
                context.put("notes", notes);
            }
        }
    }
}

