/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.html.connector.card;

import org.apache.log4j.Logger;
import ru.softlogic.app.html.connector.InterfaceNotifier;
import ru.softlogic.cards.v2.module.UserInterfaceEvent;
import ru.softlogic.cards.v2.module.UserInterfaceEventListener;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.card.DataProvider;
import ru.softlogic.module.card.DataProviderAdapter;

public abstract class HtmlGL
implements UserInterfaceEventListener {
    private Logger log;
    private InterfaceNotifier notifier;
    private DataProvider dataProvider;

    public HtmlGL(Logger log, InterfaceNotifier notifier) {
        this(log, notifier, null);
    }

    public HtmlGL(Logger log, InterfaceNotifier notifier, DataProvider dataProvider) {
        if (notifier == null) {
            throw new IllegalArgumentException("InterfaceNotifier \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        this.log = log;
        this.notifier = notifier;
        this.dataProvider = dataProvider;
        if (this.dataProvider == null) {
            this.dataProvider = new DataProviderAdapter();
        }
    }

    public void onEvent(UserInterfaceEvent uie, Runnable r) {
        this.log.info((Object)("Event: " + uie));
        UserAction.getInstance().update();
        switch (uie) {
            case CARD_REQUIRE: {
                UserAction.getInstance().update();
                this.log.info((Object)">>>onCardRequire");
                this.notifier.onCMEvent(4, null);
                ModuleHelper.invoke(r);
                break;
            }
            case CARD_INSERT_TRY: {
                UserAction.getInstance().update();
                this.log.info((Object)"Card insert try");
                ModuleHelper.invoke(r);
                break;
            }
            case PIN_TRY_LEFT_1: {
                UserAction.getInstance().update();
                this.log.info((Object)"pin-try-left1");
                this.notifier.onCMEvent(5, null);
                ModuleHelper.invoke(r);
                break;
            }
            case PIN_TRY_LEFT_2: {
                UserAction.getInstance().update();
                this.log.info((Object)"pin-try-left2");
                this.notifier.onCMEvent(5, null);
                ModuleHelper.invoke(r);
                break;
            }
            case PIN_REQUIRE: {
                UserAction.getInstance().update();
                this.log.info((Object)">>>onPinRequire");
                this.notifier.onCMEvent(7, null);
                ModuleHelper.invoke(r);
                break;
            }
            case ONLINE_REQUEST: {
                UserAction.getInstance().update();
                this.log.info((Object)">>>onStartNetworkRequest");
                this.notifier.onCMEvent(8, null);
                ModuleHelper.invoke(r);
                break;
            }
            case TAKE_CARD: {
                this.log.info((Object)">>>onTakeCard");
                UserAction.getInstance().update();
                this.notifier.onCMEvent(9, null);
                ModuleHelper.invoke(r);
                break;
            }
            case CARD_CAPTURED_BY_HOST: {
                this.unusedEvent("CARD_CAPTURED_BY_HOST", r);
                break;
            }
            case CARD_CAPTURED_BY_TIMEOUT: {
                this.unusedEvent("CARD_CAPTURED_BY_TIMEOUT", r);
                break;
            }
            case CARD_CAPTURE_FAIL: {
                this.unusedEvent("CARD_CAPTURE_FAIL", r);
                break;
            }
            case CARD_RETURNED: {
                this.unusedEvent("CARD_RETURNED", r);
                break;
            }
            case SESSION_CLOSED: {
                UserAction.getInstance().update();
                this.log.info((Object)"SESSION_CLOSED");
                this._onClosed();
                ModuleHelper.invoke(r);
                break;
            }
        }
    }

    public void onPinEdit(String pin) {
        this.log.info((Object)("PinEdit: " + pin));
        this.notifier.onPinEdit(pin);
    }

    private void unusedEvent(String event, Runnable r) {
        UserAction.getInstance().update();
        this.log.info((Object)("unusedEvent: " + event));
        ModuleHelper.invoke(r);
    }

    public abstract void _onClosed();
}

