/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.context;

import i18n.B;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import ru.softlogic.app.DeviceSummaryInit;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.ChequeGenerator;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.cash.unit.CashUnitGroup;
import ru.softlogic.cash.unit.CashUnitProfile;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.utils.menu.GroupByMenuItemVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.module.ModuleFactory;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.RedirectProxy;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.completive.CompletiveModule;
import ru.softlogic.module.ending.EndingModule;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InputModule;
import ru.softlogic.module.input.InputModuleFactory;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.payment.PaymentModule;
import ru.softlogic.module.payout.PayoutModule;
import ru.softlogic.module.present.PresentModule;
import ru.softlogic.module.print.PrintModule;
import ru.softlogic.module.processing.ProcessingModule;
import ru.softlogic.module.reinit.ReinitModule;
import ru.softlogic.module.utils.managerpl.ManagerPL;
import ru.softlogic.operation.CashlessData;
import ru.softlogic.operation.Operation;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.adv.Bonus;
import ru.softlogic.reference.adv.Promo;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.point.PaymentSystem;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.service.Service;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.BannerNotifier;
import ru.softlogic.system.util.CbcUtil;
import ru.softlogic.system.util.PinCodeGenerator;

public class PaymentHelper {
    private static final SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");
    public static final String BARCODE = "barcode";
    public static final String CARD = "card";
    private static Logger log = Logger.getLogger((String)"pay");

    public static Environment run(MenuItem menuItem, ApplicationContext context, Locale locale, Restorable parent, PaymentModule paymentModule, PayoutModule payoutModule, ProcessingModule processingModule, PrintModule printModule, EndingModule endingModule, ReinitModule reinitModule, PresentModule presentModule, CompletiveModule completiveModule, boolean printerError, Map<String, Object> initData, RedirectProxy redirectProxy) {
        log.info((Object)("Try to run module: " + menuItem.getService().getProviderType()));
        InputModule im = InputModuleFactory.getModule(menuItem.getService().getProviderType());
        if (im instanceof BaseInputModule) {
            BaseInputModule bim = (BaseInputModule)im;
            bim.addListener(ManagerPL.getInstance());
            bim.addListener(BannerNotifier.getDefaultInstance());
            bim.setContext(context);
        }
        paymentModule = ModuleFactory.createPaymentModule(context, menuItem, paymentModule);
        endingModule = ModuleFactory.createEndingModule(context, menuItem, endingModule);
        processingModule = ModuleFactory.createProcessingModule(context, menuItem, processingModule);
        reinitModule = ModuleFactory.createReinitModule(context, menuItem, reinitModule);
        payoutModule = ModuleFactory.createPayoutModule(context, menuItem, payoutModule);
        presentModule = ModuleFactory.createPresentModule(context, menuItem, presentModule);
        completiveModule = ModuleFactory.createCompletiveModule(context, menuItem, completiveModule);
        printModule = ModuleFactory.createPrintModule(context, menuItem, printModule);
        Environment env = null;
        String srvId = menuItem.getService().getName() + "," + menuItem.getService().getId();
        String messageId = null;
        if (im != null) {
            try {
                env = PaymentHelper.createEnviroment(menuItem, locale, printerError, paymentModule, payoutModule, processingModule, printModule, endingModule, reinitModule, presentModule, completiveModule, initData, redirectProxy);
                im.start(env, parent);
            }
            catch (DescriptionException ex) {
                log.error((Object)"Can't run module", (Throwable)ex);
                context.getServerConnector().sendEvent(new Event(EventType.SoftwareFault, srvId + "->DescriptionError: " + ex.getMessage()));
                messageId = "Module.entry.create.desc";
            }
            catch (ModuleInitException ex) {
                log.error((Object)"Can't run module", (Throwable)ex);
                context.getServerConnector().sendEvent(new Event(EventType.SoftwareFault, srvId + "->InitError: " + ex.getMessage()));
                messageId = "Module.entry.create.init";
            }
            catch (Throwable ex) {
                log.error((Object)"Unknown error", ex);
                context.getServerConnector().sendEvent(new Event(EventType.SoftwareFault, srvId + "->Unknown: " + ex.getMessage()));
                messageId = "Module.entry.create.init";
            }
        } else {
            log.error((Object)"Can't create module");
            context.getServerConnector().sendEvent(new Event(EventType.SoftwareFault, srvId + "->Create: " + menuItem.getService().getProviderType()));
            messageId = "Module.entry.create.error";
        }
        if (messageId != null) {
            DialogScreen dlg = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)messageId, (Locale)locale), 10, DC.cases((int)1), UserCase.Ok);
            context.showDialog((DialogInterface)dlg);
        }
        return env;
    }

    public static Environment run(ProviderType type, ApplicationContext context, Locale locale, Restorable parent, PaymentModule paymentModule, PayoutModule payoutModule, ProcessingModule processingModule, PrintModule printModule, EndingModule endingModule, ReinitModule reinitModule, PresentModule presentModule, CompletiveModule completiveModule, boolean printerError, Map<String, Object> initData, RedirectProxy redirectProxy) {
        log.info((Object)("Try to run module: " + type));
        InputModule im = InputModuleFactory.getModule(type);
        if (im instanceof BaseInputModule) {
            ((BaseInputModule)im).addListener(ManagerPL.getInstance());
            ((BaseInputModule)im).addListener(BannerNotifier.getDefaultInstance());
        }
        Environment env = null;
        String messageId = null;
        if (im != null) {
            try {
                env = PaymentHelper.createEnviroment(PaymentHelper.createVoidItem(type), locale, printerError, paymentModule, payoutModule, processingModule, printModule, endingModule, reinitModule, presentModule, completiveModule, initData, redirectProxy);
                im.start(env, parent);
            }
            catch (DescriptionException ex) {
                log.error((Object)"Can't run module", (Throwable)ex);
                context.getServerConnector().sendEvent(new Event(EventType.SoftwareFault, type + "->DescriptionError: " + ex.getMessage()));
                messageId = "Module.entry.create.desc";
            }
            catch (ModuleInitException ex) {
                log.error((Object)"Can't run module", (Throwable)ex);
                context.getServerConnector().sendEvent(new Event(EventType.SoftwareFault, type + "->InitError: " + ex.getMessage()));
                messageId = "Module.entry.create.init";
            }
        } else {
            log.error((Object)"Can't create module");
            context.getServerConnector().sendEvent(new Event(EventType.SoftwareFault, "Create: " + type));
            messageId = "Module.entry.create.error";
        }
        if (messageId != null) {
            DialogScreen dlg = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)messageId, (Locale)locale), 10, DC.cases((int)1), UserCase.Ok);
            context.showDialog((DialogInterface)dlg);
        }
        return env;
    }

    private static Environment createEnviroment(MenuItem menuItem, Locale locale, boolean printerError, PaymentModule paymentModule, PayoutModule payoutModule, ProcessingModule processingModule, PrintModule printModule, EndingModule endingModule, ReinitModule reinitModule, PresentModule presentModule, CompletiveModule completiveModule, Map<String, Object> initData, RedirectProxy redirectProxy) {
        Environment env = PaymentHelper.createEnviroment(locale, printerError, paymentModule, payoutModule, processingModule, printModule, endingModule, reinitModule, presentModule, completiveModule, initData, redirectProxy);
        log.debug((Object)"Build enviroment");
        GroupByMenuItemVisitor gbmiv = new GroupByMenuItemVisitor(menuItem);
        MenuUtils.processMenu((MenuVisitor)gbmiv);
        log.info((Object)("Group: " + gbmiv.getServiceType()));
        log.debug((Object)"Get units");
        Date now = new Date();
        Set<CashUnit> cash = PaymentHelper.getAllowedUnits(menuItem, 3, now);
        Set<CashUnit> coin = PaymentHelper.getAllowedUnits(menuItem, 4, now);
        env.setMenuItem(menuItem);
        env.setServiceType(gbmiv.getServiceType());
        env.setAllowedNotes(cash);
        env.setAllowedCoins(coin);
        log.debug((Object)"Done");
        return env;
    }

    private static Environment createEnviroment(Locale locale, boolean printerError, PaymentModule paymentModule, PayoutModule payoutModule, ProcessingModule processingModule, PrintModule printModule, EndingModule endingModule, ReinitModule reinitModule, PresentModule presentModule, CompletiveModule completiveModule, Map<String, Object> initData, RedirectProxy redirectProxy) {
        Sum change;
        log.debug((Object)"Get references");
        Dealer dealer = null;
        Point point = null;
        PaymentSystem ps = null;
        Promo[] promos = null;
        Bonus[] bonuses = null;
        try {
            dealer = ReferenceManager.getInstance().getDealer();
            point = ReferenceManager.getInstance().getPoint();
            ps = ReferenceManager.getInstance().getPaymentSystem();
            promos = ReferenceManager.getInstance().getPromos();
            bonuses = ReferenceManager.getInstance().getBonuses();
        }
        catch (ReferenceException ex) {
            log.error((Object)ex);
        }
        Pack pkg = new Pack();
        pkg.setKeeper(Session.getInstance().getCurrentKeeper());
        Pack sPkg = Session.getInstance().getPack();
        Sum sum = change = sPkg.getKeeper() == null ? null : sPkg.getKeeper().getSum();
        if (change != null && !change.isEmpty()) {
            pkg.setService(sPkg.getService());
            pkg.setCommission(sPkg.getCommission());
        }
        Environment env = new Environment();
        env.setLocale(locale);
        env.setDealer(dealer);
        env.setPoint(point);
        env.setPaymentSystem(ps);
        env.setPromos(promos);
        env.setBonuses(bonuses);
        env.setPrinterError(printerError);
        Session.getInstance().setPack(pkg);
        Session.getInstance().setPaymentAddedToQueue(false);
        env.setPaymentModule(paymentModule);
        env.setPayoutModule(payoutModule);
        env.setProcessingModule(processingModule);
        env.setPrintModule(printModule);
        env.setEndingModule(endingModule);
        env.setReinitModule(reinitModule);
        env.setPresentModule(presentModule);
        env.setCompletiveModule(completiveModule);
        env.setInitData(initData != null ? initData : new HashMap());
        env.setRedirectProxy(redirectProxy);
        log.debug((Object)"Done");
        return env;
    }

    @Deprecated
    public static Set<CashUnit> getAllowedUnits(MenuItem menuItem, int type) {
        return PaymentHelper.getAllowedUnits(menuItem, type, null);
    }

    public static Set<CashUnit> getAllowedUnits(MenuItem menuItem, int type, Date date) {
        CashUnitProfile cup = null;
        try {
            cup = ReferenceManager.getInstance().getPointOptions().getCashUnitProfile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cup != null) {
            log.info((Object)"Use new method");
            return PaymentHelper.getAllowedUnitsNew(menuItem, type, date);
        }
        log.info((Object)"Use old method");
        return PaymentHelper.getAllowedUnitsOld(menuItem, type);
    }

    public static Set<CashUnit> getAllowedUnitsOld(MenuItem menuItem, int type) {
        if (type != 4 && type != 3) {
            throw new IllegalArgumentException("Type is wrong");
        }
        CashUnit[] pointUnits = null;
        try {
            pointUnits = ReferenceManager.getInstance().getPointOptions().getUnits();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CashUnit[] menuUnits = menuItem != null ? menuItem.getUnits() : null;
        CashUnit[] units = menuUnits == null || menuUnits.length == 0 ? pointUnits : menuUnits;
        CashUnit[] currUnits = type == 4 ? CashFactory.getDefaultInstance().getCoinUnits() : CashFactory.getDefaultInstance().getCashUnits();
        TreeSet<CashUnit> allowed = new TreeSet<CashUnit>();
        for (CashUnit cu : currUnits) {
            if (!PaymentHelper.present(cu, units)) continue;
            allowed.add(cu);
        }
        if (allowed.isEmpty() && PaymentHelper.isEmptyUnits(type, units)) {
            allowed.addAll(Arrays.asList(currUnits));
        }
        log.info((Object)("Allowed " + (type == 4 ? "coins" : "banknotes") + ": " + allowed));
        return allowed;
    }

    private static boolean present(CashUnit cu, CashUnit[] units) {
        if (units == null || units.length == 0) {
            return true;
        }
        if (cu == null) {
            return false;
        }
        for (CashUnit unit : units) {
            if (!cu.equals((Object)unit)) continue;
            return true;
        }
        return false;
    }

    public static Set<CashUnit> getAllowedUnitsNew(MenuItem menuItem, int type, Date date) {
        if (type != 4 && type != 3) {
            throw new IllegalArgumentException("Type is wrong");
        }
        CashUnitProfile cupPoint = null;
        try {
            cupPoint = ReferenceManager.getInstance().getPointOptions().getCashUnitProfile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CashUnitProfile cupMenuItem = menuItem != null ? menuItem.getCashUnitProfile() : null;
        CashUnitProfile cup = cupMenuItem == null ? cupPoint : cupMenuItem;
        CashUnit[] currUnits = type == 4 ? CashFactory.getDefaultInstance().getCoinUnits() : CashFactory.getDefaultInstance().getCashUnits();
        TreeSet<CashUnit> allowed = new TreeSet<CashUnit>();
        for (CashUnit cu : currUnits) {
            if (!PaymentHelper.present(cu, cup, date)) continue;
            allowed.add(cu);
        }
        if (allowed.isEmpty() && PaymentHelper.isEmptyCashUnitProfile(type, cup)) {
            log.info((Object)"Cash unit profile is empty. Enable all units");
            allowed.addAll(Arrays.asList(currUnits));
        }
        log.info((Object)("Allowed " + (type == 4 ? "coins" : "banknotes") + ": " + allowed));
        return allowed;
    }

    private static boolean present(CashUnit cu, CashUnitProfile cup, Date date) {
        if (cup == null) {
            return true;
        }
        if (cu == null) {
            return false;
        }
        if (cu.getType() == 4 && !cup.hasFlag((short)2) || cu.getType() == 3 && !cup.hasFlag((short)1)) {
            return false;
        }
        if (cup.getCashUnitGroups() == null || cup.getCashUnitGroups().length == 0) {
            return true;
        }
        for (CashUnitGroup cug : cup.getCashUnitGroups()) {
            if (!cu.equals((Object)cug.getCashUnit())) continue;
            if (cup.hasFlag((short)4) && date != null) {
                return PaymentHelper.isEnable(cug, date);
            }
            return cug.isEnable();
        }
        return true;
    }

    private static boolean isEnable(CashUnitGroup cug, Date date) {
        if (!cug.isEnable()) {
            return false;
        }
        try {
            Calendar now = Calendar.getInstance();
            now.set(11, 0);
            now.set(12, 0);
            now.set(13, 0);
            Date start = cug.getStartTime() == null ? now.getTime() : cug.getStartTime();
            now.set(11, 23);
            now.set(12, 59);
            now.set(13, 59);
            Date end = cug.getEndTime() == null ? now.getTime() : cug.getEndTime();
            Date d = timeFormatter.parse(timeFormatter.format(date));
            start = timeFormatter.parse(timeFormatter.format(start));
            end = timeFormatter.parse(timeFormatter.format(end));
            if (start.after(d) || end.before(d)) {
                return false;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return cug.isEnable();
    }

    private static MenuItem createVoidItem(ProviderType type) {
        Service service = new Service();
        Commission commission = new Commission(1);
        MenuItem mi = new MenuItem();
        mi.setService(service);
        mi.setCommission(commission);
        return mi;
    }

    private static boolean isEmptyUnits(int type, CashUnit[] units) {
        if (units == null || units.length == 0) {
            return true;
        }
        for (CashUnit cu : units) {
            if (cu.getType() != type) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmptyCashUnitProfile(int type, CashUnitProfile cup) {
        if (cup == null) {
            return true;
        }
        if (type == 4 && !cup.hasFlag((short)2) || type == 3 && !cup.hasFlag((short)1)) {
            return false;
        }
        if (cup.getCashUnitGroups() == null || cup.getCashUnitGroups().length == 0) {
            return true;
        }
        for (CashUnitGroup cug : cup.getCashUnitGroups()) {
            if (cug.getCashUnit().getType() != type) continue;
            return false;
        }
        return true;
    }

    public static void sendFaultPayment(ClientInterface ci, boolean mainPaymentToChenge) {
        try {
            Random random = new Random();
            Pack pack = Session.getInstance().getCorrectPack();
            if (pack == null) {
                pack = Session.getInstance().getPack();
            }
            List payments = pack == null ? null : pack.getPayments();
            Keeper keeper = Session.getInstance().getCurrentKeeper();
            Operation lastPayment = Session.getInstance().getLastPayment();
            Map<String, String> forms = new LinkedHashMap();
            Map<String, String> views = new LinkedHashMap();
            Map<String, String> titles = new LinkedHashMap();
            Map<String, InputElement> inputElements = new LinkedHashMap();
            if (payments != null && !payments.isEmpty()) {
                for (InputElement ie : StoreHelper.clear((Map)((Payment)payments.get(0)).getData()).values()) {
                    forms.put(ie.getKey(), ie.getValue());
                    views.put(ie.getKey(), ie.getValueTitle());
                    titles.put(ie.getKey(), ie.getKeyTitle());
                    inputElements.put(ie.getKey(), ie);
                }
            } else if (lastPayment != null) {
                forms = lastPayment.getForm();
                views = lastPayment.getViews();
                titles = lastPayment.getTitles();
                inputElements = lastPayment.getInputElements();
            }
            int id = SequenceManager.getValueQuietly((String)"operation-id");
            Dealer d = null;
            Point p = null;
            PaymentSystem ps = null;
            Service s = null;
            Commission com = null;
            CashlessData cd = null;
            Keeper changePayedKeeper = new Keeper();
            if (pack != null) {
                PackUtility.printPack("Processing pack", pack);
                if (pack.getService() != null) {
                    s = pack.getService();
                } else if (lastPayment != null && lastPayment.getService() != null) {
                    s = lastPayment.getService();
                } else {
                    log.error((Object)"Incorrect service. Cancel payment process");
                    return;
                }
                if (pack.getCommission() != null) {
                    com = pack.getCommission();
                } else if (lastPayment != null && lastPayment.getCommission() != null) {
                    com = lastPayment.getCommission();
                } else {
                    log.error((Object)"Incorrect commission. Cancel payment process");
                    return;
                }
                if (pack.getCashlessData() != null) {
                    cd = pack.getCashlessData();
                } else if (lastPayment != null && lastPayment.getCashlessData() != null) {
                    cd = lastPayment.getCashlessData();
                } else {
                    log.error((Object)"Incorrect cashlessdata.");
                }
                if (pack.getChange() != null) {
                    changePayedKeeper = pack.getChange();
                    Pack sPack = Session.getInstance().getPack();
                    if (sPack != null && !sPack.equals(pack)) {
                        changePayedKeeper = sPack.getChange();
                    }
                    if (pack.getPaybackType() == 3) {
                        changePayedKeeper = new Keeper();
                    }
                }
            }
            if (changePayedKeeper == null) {
                changePayedKeeper = new Keeper();
            }
            try {
                ps = ReferenceManager.getInstance().getPaymentSystem();
                d = ReferenceManager.getInstance().getDealer();
                p = ReferenceManager.getInstance().getPoint();
            }
            catch (Exception ex) {
                log.error((Object)"Can't generate fault payment", (Throwable)ex);
                return;
            }
            Operation operation = new Operation();
            operation.setFeHash(PaymentHelper.getFeHash());
            operation.setIdOperation(id % 32000);
            if (AppDefaults.getInstance().getBooleanProperty("Module.processing.change.old-check", false)) {
                Operation lp = Session.getInstance().getLastPayment();
                if (keeper.getCashSum().isEmpty() && lp != null) {
                    operation.setCheckNumber(lp.getCheckNumber());
                    if (AppDefaults.getInstance().getBooleanProperty("printer.cheque.complexformat", false)) {
                        operation.getInputElements().put("cheque_number", lp.getInputElements().get("cheque_number"));
                    }
                } else {
                    operation.setCheckNumber(random.nextInt(32000));
                    if (AppDefaults.getInstance().getBooleanProperty("printer.cheque.complexformat", false)) {
                        operation.getInputElements().put("cheque_number", new InputElement("cheque_number", "cheque_number", ChequeGenerator.getInstance().getChequeNumber()));
                    }
                }
            } else {
                operation.setCheckNumber(random.nextInt(32000));
                if (AppDefaults.getInstance().getBooleanProperty("printer.cheque.complexformat", false)) {
                    operation.getInputElements().put("cheque_number", new InputElement("cheque_number", "cheque_number", ChequeGenerator.getInstance().getChequeNumber()));
                }
            }
            operation.setDate(new Date());
            operation.setService(s);
            operation.setCommission(com);
            operation.setDealer(d);
            operation.setPoint(p);
            operation.setPaymentSystem(ps);
            operation.setCashlessData(cd);
            if (pack != null) {
                operation.setPaymentTool(pack.getPaymentTool());
                if (pack.isFixedSum()) {
                    operation.setFlags(operation.getFlags() | 0x800);
                }
            }
            Sum mainPaymentSum = new Sum();
            if (mainPaymentToChenge || pack != null && pack.getSumResult() == null) {
                operation.setSumResult(new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(), new Sum(), new Sum(), keeper.getSum(), pack != null ? pack.getProviderFee() : null, null));
            } else {
                Pack sPack = Session.getInstance().getPack();
                if (sPack != null && !sPack.equals(pack)) {
                    changePayedKeeper = new Keeper();
                } else if (pack != null) {
                    SumResult sr = pack.getSumResult();
                    mainPaymentSum = sr.getOut().add(sr.getCommission());
                }
                operation.setSumResult(new SumResult(new Sum(), keeper.getSum().sub(mainPaymentSum), new Sum(), new Sum(), new Sum(), keeper.getSum().sub(mainPaymentSum), null, null));
            }
            operation.setPinCode(PinCodeGenerator.generate());
            operation.setPinCodeNominal(keeper.getSum().sub(changePayedKeeper.getSum()).sub(mainPaymentSum));
            operation.getForm().putAll(forms);
            operation.getViews().putAll(views);
            operation.getTitles().putAll(titles);
            operation.getInputElements().putAll(inputElements);
            if (lastPayment != null) {
                operation.setChangeDate(lastPayment.getDate());
            }
            operation.setLocale(Locale.getDefault());
            operation.setKeeper(keeper);
            operation.setChange(changePayedKeeper);
            operation.setChangeDate(Session.getInstance().getChangeDate());
            if (ModuleHelper.toSavePayout(s)) {
                operation.setFlags(operation.getFlags() | 0x100);
                log.info((Object)"Set payment to safe change service");
                SumResult sumRes = operation.getSumResult();
                operation.setSumResult(new SumResult(sumRes.getCash(), sumRes.getCashLess(), sumRes.getChange(), new Sum(), new Sum(), new Sum(), sumRes.getProviderFee(), sumRes.getCommService()));
                operation.setPinCode(null);
                operation.setPinCodeNominal(null);
                operation.setCommission(new Commission(1));
                operation.setChange(new Keeper());
            }
            if (pack != null) {
                operation.setFraudControlRule(pack.getFraudControlRule());
            }
            log.info((Object)("Process fault payment " + operation + " with result: " + ci.process(operation)));
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
    }

    private static Keeper createPayoutSum(Pack pack) {
        Keeper changePayedKeeper = new Keeper();
        if (pack.getChange() != null) {
            changePayedKeeper = pack.getChange();
            Pack sPack = Session.getInstance().getPack();
            if (sPack != null && !sPack.equals(pack)) {
                changePayedKeeper = sPack.getChange();
            }
            if (pack.getPaybackType() == 3) {
                changePayedKeeper = new Keeper();
            }
        }
        if (changePayedKeeper == null) {
            changePayedKeeper = new Keeper();
        }
        return changePayedKeeper;
    }

    private static CashlessData getCashlessData(Pack pack, Operation lastPayment) {
        if (pack.getCashlessData() != null) {
            return pack.getCashlessData();
        }
        if (lastPayment != null && lastPayment.getCashlessData() != null) {
            return lastPayment.getCashlessData();
        }
        log.error((Object)"Incorrect cashlessdata.");
        return null;
    }

    public static void sendFaultOnlinePayment(ClientInterface ci) {
        block20: {
            try {
                Point p;
                Dealer d;
                PaymentSystem ps;
                Commission com;
                Service s;
                Pack pack = Session.getInstance().getCorrectPack();
                if (pack == null) {
                    pack = Session.getInstance().getPack();
                }
                if (pack == null) {
                    return;
                }
                List payments = pack.getPayments();
                Keeper keeper = Session.getInstance().getCurrentKeeper();
                Operation lastPayment = Session.getInstance().getLastPayment();
                boolean sendedLastPayment = false;
                if (lastPayment != null) {
                    lastPayment.setLastProcess(System.currentTimeMillis() - 240000L);
                    if (CbcUtil.cancelOnlineOperationWithPINAfterReboot(lastPayment, pack)) {
                        sendedLastPayment = true;
                        ProcessingResult result = ci.process(lastPayment);
                        log.info((Object)("Process fault cancel - payment " + lastPayment + " with result: " + result));
                    }
                }
                if (pack.getPaybackType() == 0) break block20;
                Map<String, String> forms = new LinkedHashMap();
                Map<String, String> views = new LinkedHashMap();
                Map<String, String> titles = new LinkedHashMap();
                Map<String, InputElement> inputElements = new LinkedHashMap();
                if (payments != null && !payments.isEmpty()) {
                    for (InputElement ie : StoreHelper.clear((Map)((Payment)payments.get(0)).getData()).values()) {
                        forms.put(ie.getKey(), ie.getValue());
                        views.put(ie.getKey(), ie.getValueTitle());
                        titles.put(ie.getKey(), ie.getKeyTitle());
                        inputElements.put(ie.getKey(), ie);
                    }
                } else if (lastPayment != null) {
                    forms = lastPayment.getForm();
                    views = lastPayment.getViews();
                    titles = lastPayment.getTitles();
                    inputElements = lastPayment.getInputElements();
                }
                int id = SequenceManager.getValueQuietly((String)"operation-id");
                PackUtility.printPack("Processing pack", pack);
                if (pack.getService() != null) {
                    s = pack.getService();
                } else if (lastPayment != null && lastPayment.getService() != null) {
                    s = lastPayment.getService();
                } else {
                    log.error((Object)"Incorrect service. Cancel payment process");
                    return;
                }
                if (pack.getCommission() != null) {
                    com = pack.getCommission();
                } else if (lastPayment != null && lastPayment.getCommission() != null) {
                    com = lastPayment.getCommission();
                } else {
                    log.error((Object)"Incorrect commission. Cancel payment process");
                    return;
                }
                try {
                    ps = ReferenceManager.getInstance().getPaymentSystem();
                    d = ReferenceManager.getInstance().getDealer();
                    p = ReferenceManager.getInstance().getPoint();
                }
                catch (Exception ex) {
                    log.error((Object)"Can't generate fault payment", (Throwable)ex);
                    return;
                }
                Operation operation = PaymentHelper.createFaultOnlineOperation(id, keeper, s, ps, pack, lastPayment, forms, views, titles, inputElements, sendedLastPayment);
                operation.setCommission(com);
                operation.setDealer(d);
                operation.setPoint(p);
                ProcessingResult result = ci.process(operation);
                log.info((Object)("Process fault payment " + operation + " with result: " + result));
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
            }
        }
    }

    private static Operation createFaultOnlineOperation(int id, Keeper keeper, Service s, PaymentSystem ps, Pack pack, Operation lastPayment, Map<String, String> forms, Map<String, String> views, Map<String, String> titles, Map<String, InputElement> inputElements, boolean sendedLastPayment) {
        Operation operation = new Operation();
        Random random = new Random();
        operation.setFeHash(PaymentHelper.getFeHash());
        operation.setIdOperation(id % 32000);
        if (AppDefaults.getInstance().getBooleanProperty("Module.processing.change.old-check", false)) {
            Operation lp = Session.getInstance().getLastPayment();
            if (keeper.getCashSum().isEmpty() && lp != null) {
                operation.setCheckNumber(lp.getCheckNumber());
                operation.getInputElements().put("cheque_number", lp.getInputElements().get("cheque_number"));
            } else {
                operation.setCheckNumber(random.nextInt(32000));
                if (AppDefaults.getInstance().getBooleanProperty("printer.cheque.complexformat", false)) {
                    operation.getInputElements().put("cheque_number", new InputElement("cheque_number", "cheque_number", ChequeGenerator.getInstance().getChequeNumber()));
                }
            }
        } else {
            operation.setCheckNumber(random.nextInt(32000));
            if (AppDefaults.getInstance().getBooleanProperty("printer.cheque.complexformat", false)) {
                operation.getInputElements().put("cheque_number", new InputElement("cheque_number", "cheque_number", ChequeGenerator.getInstance().getChequeNumber()));
            }
        }
        operation.setDate(new Date());
        operation.setService(s);
        operation.setPaymentSystem(ps);
        operation.setPaymentTool(pack.getPaymentTool());
        operation.setCashlessData(PaymentHelper.getCashlessData(pack, lastPayment));
        if (pack.isFixedSum()) {
            operation.setFlags(operation.getFlags() | 0x800);
        }
        SumResult sr = pack.getSumResult();
        Sum mainPaymentSum = sr.getOut().add(sr.getCommission());
        Sum payback = new Sum();
        if (pack.getPaybackType() == 2 && pack.getChange() != null) {
            payback = pack.getChange().getSum();
        }
        Sum change = keeper.getSum().sub(mainPaymentSum).sub(payback);
        operation.setSumResult(new SumResult(new Sum(), new Sum(), new Sum(), new Sum(), new Sum(), change, null, null));
        operation.setPinCode(PinCodeGenerator.generate());
        operation.setPinCodeNominal(change);
        operation.getForm().putAll(forms);
        operation.getViews().putAll(views);
        operation.getTitles().putAll(titles);
        operation.getInputElements().putAll(inputElements);
        operation.setLocale(Locale.getDefault());
        operation.setChange(PaymentHelper.createPayoutSum(pack));
        if (sendedLastPayment) {
            Keeper newKeeper = new Keeper();
            newKeeper.addPayback(change);
            operation.setKeeper(newKeeper);
            operation.setChangeDate(lastPayment.getDate());
        } else {
            operation.setKeeper(keeper);
            operation.setChangeDate(Session.getInstance().getChangeDate());
        }
        if (ModuleHelper.toSavePayout(s)) {
            operation.setFlags(operation.getFlags() | 0x100);
            log.info((Object)"Set payment to safe change service");
            SumResult sumRes = operation.getSumResult();
            operation.setSumResult(new SumResult(sumRes.getCash(), sumRes.getCashLess(), sumRes.getChange(), new Sum(), new Sum(), new Sum(), sumRes.getProviderFee(), sumRes.getCommService()));
            operation.setPinCode(null);
            operation.setPinCodeNominal(null);
            operation.setCommission(new Commission(1));
            operation.setChange(new Keeper());
        }
        operation.setFraudControlRule(pack.getFraudControlRule());
        return operation;
    }

    public static void preparePackToDefferedPayback() {
        Pack pack = Session.getInstance().getPack();
        if (pack == null) {
            return;
        }
        log.info((Object)"Do deferred payback");
        Pack pb = new Pack();
        pb.setPaymentType(2);
        Payment payment = new Payment();
        if (pack.getPayments() != null && pack.getPayments().get(0) != null) {
            payment.setData(((Payment)pack.getPayments().get(0)).getData());
        }
        payment.setSumOut(new Sum());
        pb.getPayments().add(payment);
        pb.setService(pack.getService());
        pb.setCommission(pack.getCommission());
        Keeper keeper = new Keeper();
        keeper.addPayback(pack.getSumResult().getChange());
        pb.setKeeper(keeper);
        pb.setSumResult(new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(), new Sum(), new Sum(), keeper.getSum(), null, null));
        Session.getInstance().setPack(pb);
        PackUtility.printPack("Deferred payout pack", pb);
    }

    public static String getFeHash() {
        DeviceInfo info;
        StringBuilder sb = new StringBuilder();
        if (DeviceSummaryInit.getCashAcceptor() != null && (info = DeviceSummaryInit.getCashAcceptor().getInfo()) != null) {
            sb.append(info.getVendor());
            sb.append(info.getModel());
            sb.append(info.getSerial());
            sb.append(info.getPort());
            sb.append(info.getProto());
        }
        if (DeviceSummaryInit.getCoinAcceptor() != null && (info = DeviceSummaryInit.getCoinAcceptor().getInfo()) != null) {
            sb.append(info.getVendor());
            sb.append(info.getModel());
            sb.append(info.getSerial());
            sb.append(info.getPort());
            sb.append(info.getProto());
        }
        try {
            return PaymentHelper.getBase64(PaymentHelper.getSHA256(sb.toString()));
        }
        catch (NoSuchAlgorithmException ex) {
            log.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    private static byte[] getSHA256(String source) throws NoSuchAlgorithmException {
        byte[] res = null;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.reset();
        md.update(source.getBytes());
        res = md.digest();
        return res;
    }

    private static String getBase64(byte[] source) {
        return new String(Base64.encodeBase64((byte[])source));
    }
}

