/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app;

import i18n.B;
import i18n.NoMessageListener;
import it.sauronsoftware.cron4j.Scheduler;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.AppEnvironmentListener;
import ru.softlogic.app.Application;
import ru.softlogic.app.ApplicationException;
import ru.softlogic.app.DaemonVersion;
import ru.softlogic.app.DeviceSummaryInit;
import ru.softlogic.app.FrameStore;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.configuration.CardReaderConfiguration;
import ru.softlogic.app.configuration.Configuration;
import ru.softlogic.app.configuration.ConfigurationException;
import ru.softlogic.app.configuration.ConfigurationSN;
import ru.softlogic.app.configuration.DeviceConfiguration;
import ru.softlogic.app.configuration.PresentConfiguration;
import ru.softlogic.app.configuration.SerialNumbersStore;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.BaseApplicationContext;
import ru.softlogic.app.context.PaymentHelper;
import ru.softlogic.app.diagnostic.SimpleProblemNotifier;
import ru.softlogic.app.messages.AppB;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.ServiceZReportStorage;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.state.AppStateWatcherImpl;
import ru.softlogic.app.state.BaseFacadeEngine;
import ru.softlogic.app.state.StateFacade;
import ru.softlogic.app.timer.GuiControl;
import ru.softlogic.app.timer.TimerThread;
import ru.softlogic.application.AppDiskErrorListener;
import ru.softlogic.application.AppHopperStateListener;
import ru.softlogic.application.BDPNUpdater;
import ru.softlogic.application.BannerUpdater;
import ru.softlogic.application.CardEmergencyEventListener;
import ru.softlogic.application.CashAcceptorIdentificationListener;
import ru.softlogic.application.CashAcceptorStatisticObserver;
import ru.softlogic.application.CashAcceptorStatisticThread;
import ru.softlogic.application.CashAcceptorStatusObserver;
import ru.softlogic.application.ClickChecker;
import ru.softlogic.application.CoffeeMachineSwitchModeListener;
import ru.softlogic.application.CoinAcceptorStatusObserver;
import ru.softlogic.application.CommandLauncher;
import ru.softlogic.application.CompatDeviceInfoListener;
import ru.softlogic.application.DeviceInfoHandlingSender;
import ru.softlogic.application.DeviceInfoSender;
import ru.softlogic.application.DispenserStatusListener;
import ru.softlogic.application.ECardSender;
import ru.softlogic.application.ErrorDumpProcessor;
import ru.softlogic.application.FrameMaximizer;
import ru.softlogic.application.HopperThrowDownThread;
import ru.softlogic.application.JammInformer;
import ru.softlogic.application.KkmErrorListener;
import ru.softlogic.application.NetworkAddressManager;
import ru.softlogic.application.NetworkInterfaceObserver;
import ru.softlogic.application.NetworkObserver;
import ru.softlogic.application.NetworkStatisticHandler;
import ru.softlogic.application.NoPaymentsRebooter;
import ru.softlogic.application.OpenFilesWatcher;
import ru.softlogic.application.PppWatcher;
import ru.softlogic.application.PrinterInfoListener;
import ru.softlogic.application.PrinterStatusObserver;
import ru.softlogic.application.QueueAgent;
import ru.softlogic.application.Rebooter;
import ru.softlogic.application.SimplePayoutManager;
import ru.softlogic.application.SystemUpdateListener;
import ru.softlogic.application.UncaughtExceptionListener;
import ru.softlogic.application.UpdateChecker;
import ru.softlogic.application.UssdChecker;
import ru.softlogic.application.VpnObserver;
import ru.softlogic.application.ZReportCloseThread;
import ru.softlogic.application.ZReportServiceObserver;
import ru.softlogic.application.cdm.Cdm;
import ru.softlogic.application.collection.EncashmentSynch;
import ru.softlogic.application.collection.MoneyCollectionHandler;
import ru.softlogic.application.collection.MoneyCollectionObserver;
import ru.softlogic.application.collection.MoneyCollectionProxy;
import ru.softlogic.application.disk.DiskObserver;
import ru.softlogic.application.kkm.RefsKkmControl;
import ru.softlogic.application.statistic.adv.AdvStatisticEnviromentListener;
import ru.softlogic.application.statistic.adv.AdvStatisticStore;
import ru.softlogic.application.statistic.adv.AdvStatisticThread;
import ru.softlogic.application.system.PcInfoCollector;
import ru.softlogic.application.system.RfRunnable;
import ru.softlogic.application.tmm.Tmm;
import ru.softlogic.cards.v2.module.CloseDaySchedule;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.acceptor.DriverControl;
import ru.softlogic.cash.acceptor.ManagedCashAcceptor;
import ru.softlogic.cash.manager.BaseCashManager;
import ru.softlogic.cash.manager.CashManager;
import ru.softlogic.cash.manager.observer.FraudListener;
import ru.softlogic.command.CommandStore;
import ru.softlogic.date.DateStore;
import ru.softlogic.ecard.TransportModule;
import ru.softlogic.encashment.EncashmentStore;
import ru.softlogic.gui.GuiOptions;
import ru.softlogic.gui.Rendering;
import ru.softlogic.gui.component.BaseFrame;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.gui.utils.ScreenUtil;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceInfoListener;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.CashBox;
import ru.softlogic.hardware.device.cashin.CashDeviceManager;
import ru.softlogic.hardware.device.cashin.CashInFactory;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.statistics.Event;
import ru.softlogic.hardware.device.cashin.validator.statistics.StatisticListener;
import ru.softlogic.hardware.device.cashin.validator.statistics.StatisticStore;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatusListener;
import ru.softlogic.hardware.device.hopper.BaseHopper;
import ru.softlogic.hardware.device.hopper.Hopper;
import ru.softlogic.hardware.device.hopper.HopperFactory;
import ru.softlogic.hardware.device.hopper.HopperStateListener;
import ru.softlogic.hardware.device.hopper.IHopper;
import ru.softlogic.hardware.device.hopper.PayoutManager;
import ru.softlogic.hardware.device.present.Dispenser;
import ru.softlogic.hardware.device.present.DispenserNetworkOptions;
import ru.softlogic.hardware.device.present.DispenserOptions;
import ru.softlogic.hardware.device.present.Factory;
import ru.softlogic.hardware.device.present.StatusListener;
import ru.softlogic.hardware.device.print.Printer;
import ru.softlogic.hardware.device.print.PrinterFactory;
import ru.softlogic.hardware.device.print.ipp.IppPrinterOptions;
import ru.softlogic.hardware.device.print.kkm.Kkm;
import ru.softlogic.hardware.device.print.kkm.KkmControl;
import ru.softlogic.hardware.device.print.kkm.KkmListener;
import ru.softlogic.hardware.device.print.kkm.KkmOptions;
import ru.softlogic.hardware.device.print.kkm.leokas.LeoKkm;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.queue.PrinterQueue;
import ru.softlogic.hardware.device.print.queue.PrinterQueueFactory;
import ru.softlogic.hardware.device.scanner.BarcodeScanner;
import ru.softlogic.hardware.device.scanner.BarcodeScannerFactory;
import ru.softlogic.hardware.device.scanner.BarcodeScannerListener;
import ru.softlogic.hardware.device.scanner.BarcodeScannerOptions;
import ru.softlogic.hardware.device.scanner.BarcodeScannerType;
import ru.softlogic.hardware.device.scanner.BaseBarcodeScanner;
import ru.softlogic.hardware.device.watchdog.EventListener;
import ru.softlogic.hardware.device.watchdog.WatchDog;
import ru.softlogic.hardware.device.watchdog.WatchDogFactory;
import ru.softlogic.hardware.device.watchdog.WatchDogSettings;
import ru.softlogic.hardware.keyboard.StandartKeyboard;
import ru.softlogic.hdw.dev.crd.CardReader;
import ru.softlogic.hdw.dev.crd.CardReaderDriver;
import ru.softlogic.hdw.dev.crd.CardReaderFactory;
import ru.softlogic.hdw.dev.crd.CardReaderOptions;
import ru.softlogic.hdw.dev.keyboard.ExtKeyboard;
import ru.softlogic.hdw.dev.keyboard.VoidExtKeyboard;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.usb.UsbPort;
import ru.softlogic.media.MediaPlayer;
import ru.softlogic.module.DynamicTimeoutManager;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.TimeoutManager;
import ru.softlogic.module.card.CardModuleConfigurator;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.card.proxy.CardModuleEventsProxy;
import ru.softlogic.module.entry.CardBackManager;
import ru.softlogic.module.entry.ChangeCancelManager;
import ru.softlogic.module.input.InputModule;
import ru.softlogic.module.input.InputModuleFactory;
import ru.softlogic.module.input.admin.AdminInputModule;
import ru.softlogic.module.input.admin.log.ViewAppender;
import ru.softlogic.module.input.advanced.CardProcessorStore;
import ru.softlogic.module.input.hopper.CoinHopperInputModule;
import ru.softlogic.module.input.mobile.FederalNumberValidator;
import ru.softlogic.module.input.ntscoffee.CoffeeMachineStatisticSender;
import ru.softlogic.module.input.ntscoffee.CoffeeMachineUtil;
import ru.softlogic.module.input.ntscoffee.EntryCashManagerSwitcher;
import ru.softlogic.module.input.ntssnack.SnackMachineStatisticSender;
import ru.softlogic.module.input.ntssnack.SnackMachineUtil;
import ru.softlogic.module.input.runner.RunnerModule;
import ru.softlogic.module.ups.UPSManager;
import ru.softlogic.module.utils.managerpl.ManagerPL;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.ServerUser;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.srv.api.adv.BannerObserver;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.modem.ModemState;
import ru.softlogic.srv.api.modem.Operator;
import ru.softlogic.srv.api.oth.SystemInfo;
import ru.softlogic.srv.connector.AppStateWatcher;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.srv.connector.ConnectorConfiguration;
import ru.softlogic.srv.connector.ConnectorFactory;
import ru.softlogic.srv.connector.ConnectorType;
import ru.softlogic.srv.connector.ProxyConfiguration;
import ru.softlogic.srv.connector.ServerInterface;
import ru.softlogic.srv.queue.DiskErrorListener;
import ru.softlogic.srv.queue.Queue;
import ru.softlogic.statistic.PromoStatisticStore;
import ru.softlogic.system.util.AppTimeMarker;
import ru.softlogic.system.util.DaemonUtil;
import ru.softlogic.system.util.EventNotifier;
import ru.softlogic.system.util.EventNotifierImpl;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.NoMessageListenerImpl;
import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.PreloaderTask;
import ru.softlogic.system.util.ProcessExecutor;
import ru.softlogic.system.util.UsersUtil;
import ru.softlogic.system.util.fraud.FraudQueue;
import ru.softlogic.system.util.fraud.FraudQueueAgent;
import ru.softlogic.system.util.hwd.SerialExtractorApi;
import ru.softlogic.system.util.network.NetObserver;
import ru.softlogic.system.util.network.RemoteStatusObserver;
import ru.softlogic.system.util.os.OsApi;
import ru.softlogic.update.postproc.Decompressor;
import ru.softlogic.update.updater.StateListener;
import ru.softlogic.update.updater.UpdateHandler;
import ru.softlogic.update.updater.UpdateSystem;

public class TerminalApplication
implements Application {
    private final Logger log = Logger.getLogger((String)"start");
    private Printer printer;
    private PrinterQueue printerQueue;
    private Thread printerQueueThread;
    private PrinterStatusObserver printerStatusObserver;
    private Validator cashAcceptor;
    private Thread cashAcceptorThread;
    private CashBox cashAcceptorBox;
    private CashAcceptorStatusObserver cashAcceptorObserver;
    private Thread cashAcceptorObserverThread;
    private Validator coinAcceptor;
    private Thread coinAcceptorThread;
    private CashBox coinAcceptorBox;
    private CashBox flowDownCoinBox;
    private WatchDog watchDog;
    private NetworkObserver netObserver;
    private Thread netObserverThread;
    private JammInformer jammInformer;
    private final List<Thread> threads;
    private ApplicationContext context;
    private BaseFrame frame;
    private ServerInterface serverInterface;
    private ClientInterface clientInterface;
    private Queue queue;
    private QueueAgent queueAgent;
    private FraudQueue fraudQueue;
    private FraudQueueAgent fraudQueueAgent;
    private BannerUpdater bannerUpdater;
    private FrameMaximizer frameMaximizer;
    private ProcessExecutor executor;
    private final List<ru.softlogic.srv.api.event.Event> updateEvents;
    private ScheduledExecutorService scheduler;
    private Scheduler cronScheduler;
    private CommandLauncher commandLauncher;
    private PppWatcher pppWatcher;
    private MoneyCollectionHandler cashCollectionHandler;
    private MoneyCollectionHandler coinCollectionHandler;

    public TerminalApplication() {
        this.log.setAdditivity(false);
        this.threads = new LinkedList<Thread>();
        this.updateEvents = new LinkedList<ru.softlogic.srv.api.event.Event>();
    }

    public void start() {
        UncaughtExceptionListener exceptionListener = new UncaughtExceptionListener();
        Thread.setDefaultUncaughtExceptionHandler(exceptionListener);
        try {
            if (ReferenceManager.getInstance().getPoint() != null && ReferenceManager.getInstance().getPoint().getTimeZone() != null && AppDefaults.getInstance().getBooleanProperty("timezone.update.enable", false)) {
                this.log.info((Object)ReferenceManager.getInstance().getPoint().getTimeZone());
                this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0447\u0430\u0441\u043e\u0432\u043e\u0433\u043e \u043f\u043e\u044f\u0441\u0430: " + OsApi.getInstance().setTimeZone(TimeZone.getTimeZone(ReferenceManager.getInstance().getPoint().getTimeZone()).getRawOffset() / 3600000)));
                TimeZone.setDefault(TimeZone.getTimeZone(ReferenceManager.getInstance().getPoint().getTimeZone()));
            }
        }
        catch (Throwable e) {
            this.log.error((Object)e, e);
        }
        B.logLocale = AppDefaults.getInstance().getLogLocale();
        this.log.info((Object)("Log locale: " + B.logLocale));
        this.log.info((Object)("System locale: " + Locale.getDefault()));
        this.log.info((Object)("\u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e                   : " + DaemonVersion.version));
        this.log.info((Object)("\u0412\u0435\u0440\u0441\u0438\u044f Java                 : " + SystemProp.getJavaVersion()));
        this.log.info((Object)("\u0412\u0435\u0440\u0441\u0438\u044f OS                   : " + SystemProp.getOSName() + " " + SystemProp.getOSVersion() + " " + SystemProp.getOSArch()));
        this.log.info((Object)B.log((String)"split"));
        Decompressor.process((File)new File(PathUtils.getAppHome()));
        this.log.info((Object)B.log((String)"split"));
        try {
            this.log.info((Object)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u0430\u0445");
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.log.info((Object)("max window bounds: " + ge.getMaximumWindowBounds()));
            this.log.info((Object)("default screen device: " + ge.getDefaultScreenDevice().getIDstring()));
            GraphicsDevice[] gs = ge.getScreenDevices();
            this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u043e\u0432: " + gs.length));
            for (int j = 0; j < gs.length; ++j) {
                this.log.info((Object)("  \u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u0435 " + j));
                GraphicsDevice gd = gs[j];
                this.log.info((Object)("    id: " + gd.getIDstring()));
                this.log.info((Object)("    memory available, Mb: " + gd.getAvailableAcceleratedMemory() / 1024 / 1024));
                this.log.info((Object)("    bounds: " + gd.getDefaultConfiguration().getBounds()));
                DisplayMode dm = gd.getDisplayMode();
                if (dm != null) {
                    this.log.info((Object)"  Current display mode");
                    this.log.info((Object)("    depth: " + dm.getBitDepth()));
                    this.log.info((Object)("    refresh rate: " + dm.getRefreshRate()));
                    continue;
                }
                this.log.info((Object)"Not avaliable");
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        this.log.info((Object)B.log((String)"split"));
        String hddSerial = null;
        try {
            hddSerial = SerialExtractorApi.getInstance().getHddSerial();
            this.log.info((Object)("\u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 HDD: " + hddSerial));
            this.log.info((Object)("\u041c\u043e\u0434\u0435\u043b\u044c \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0440\u0430 : " + SerialExtractorApi.getInstance().getProcessorName()));
        }
        catch (Throwable gs) {
            // empty catch block
        }
        this.log.info((Object)"--- \u0424\u043b\u0430\u0433\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 ----------------------------");
        int reboot = 0;
        if (DaemonUtil.checkAndDeleteExitFlag((String)"_flag_neterror")) {
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0438\u0437-\u0437\u0430 \u043e\u0442\u0441\u0443\u0442\u0432\u0438\u044f \u0441\u0432\u044f\u0437\u0438");
            reboot |= 1;
        }
        if (DaemonUtil.checkAndDeleteExitFlag((String)"_flag_cmdreboot")) {
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u043f\u043e \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u0435 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
            reboot |= 2;
        }
        if (DaemonUtil.checkAndDeleteExitFlag((String)"_flag_sftupdate")) {
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0438\u0437-\u0437\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u041f\u041e");
            reboot |= 4;
        }
        if (DaemonUtil.checkAndDeleteExitFlag((String)"_flag_servmenu")) {
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0438\u0437 \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e \u043c\u0435\u043d\u044e");
            reboot |= 8;
        }
        if (DaemonUtil.checkAndDeleteExitFlag((String)"_flag_sftupdate_exec")) {
            this.log.info((Object)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u041f\u041e \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
            reboot |= 0x10;
        }
        if (DaemonUtil.checkAndDeleteExitFlag((String)"_flag_rpc")) {
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0438\u0437-\u0437\u0430 \u043e\u0448\u0438\u0431\u043a\u0438 \u0441\u043b\u0443\u0436\u0431\u044b RPC");
            reboot |= 0x20;
        }
        if (DaemonUtil.checkAndDeleteExitFlag((String)"_flag_schedule")) {
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0431\u044b\u043b\u0430 \u0437\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0430");
            reboot |= 0x40;
        }
        if (DaemonUtil.checkAndDeleteExitFlag((String)"_flag_sffault")) {
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0431\u044b\u043b\u0430 \u0438\u0437-\u0437\u0430 \u043f\u0430\u0434\u043d\u0438\u044f \u041f\u041e");
            reboot |= 0x80;
        }
        if (DaemonUtil.checkAndDeleteExitFlag((String)"_flag_nopaytimeout")) {
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0431\u044b\u043b\u0430 \u0438\u0437-\u0437\u0430 \u043f\u0430\u0434\u043d\u0438\u044f \u041f\u041e");
            reboot |= 0x100;
        }
        this.log.info((Object)"--- \u0424\u043b\u0430\u0433\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u044b ------------------");
        this.cronScheduler = new Scheduler();
        this.scheduler = Executors.newScheduledThreadPool(3);
        try {
            InputModule rm;
            PresentConfiguration pc;
            Logger l;
            try {
                FileUtil.checkDir((String)(PathUtils.getAppHome() + "/data/"));
                FileUtil.checkDir((String)(PathUtils.getAppHome() + "/data/cash-in/"));
                FileUtil.checkDir((String)(PathUtils.getAppHome() + "/data/network/"));
                FileUtil.checkDir((String)(PathUtils.getAppHome() + "/data/dispenser/"));
                FileUtil.checkDir((String)(PathUtils.getAppHome() + "/data/dispenser/bill/"));
                FileUtil.checkDir((String)(PathUtils.getAppHome() + "/templates/"));
                FileUtil.checkDir((String)(PathUtils.getAppHome() + "/templates/logo/"));
            }
            catch (Exception j) {
                // empty catch block
            }
            long begin = System.currentTimeMillis();
            Configuration conf = Configuration.getInstance();
            ConnectorConfiguration conn = conf.getDefaultConnectorConfiguration();
            if (conn != null) {
                Properties p = new Properties();
                try {
                    DeviceClass printerClass;
                    String timeout;
                    String httpsPort;
                    String httpPort;
                    boolean needUpdate = false;
                    p.load(new FileInputStream(PathUtils.getAppHome() + File.separator + "resources" + File.separator + "update.properties"));
                    this.log.info((Object)"\u0424\u0430\u0439\u043b \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d");
                    String host = p.getProperty("server.host");
                    if (host != null && !host.isEmpty() && !host.equals(conn.getParams().get("server"))) {
                        this.log.info((Object)("\u041c\u0435\u043d\u044f\u044e \u0441\u0442\u0430\u0440\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + (String)conn.getParams().get("server") + " \u043d\u0430 \u043d\u043e\u0432\u044b\u0439 " + host));
                        conn.getParams().put("server", host);
                        needUpdate = true;
                    }
                    if ((httpPort = p.getProperty("server.http-port")) != null && !httpPort.isEmpty() && !httpPort.equals(conn.getParams().get("http-port"))) {
                        this.log.info((Object)("\u041c\u0435\u043d\u044f\u044e \u0441\u0442\u0430\u0440\u044b\u0439 http-\u043f\u043e\u0440\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + (String)conn.getParams().get("http-port") + " \u043d\u0430 \u043d\u043e\u0432\u044b\u0439 " + httpPort));
                        conn.getParams().put("http-port", httpPort);
                        needUpdate = true;
                    }
                    if ((httpsPort = p.getProperty("server.https-port")) != null && !httpsPort.isEmpty() && !httpsPort.equals(conn.getParams().get("port"))) {
                        this.log.info((Object)("\u041c\u0435\u043d\u044f\u044e \u0441\u0442\u0430\u0440\u044b\u0439 https-\u043f\u043e\u0440\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + (String)conn.getParams().get("port") + " \u043d\u0430 \u043d\u043e\u0432\u044b\u0439 " + httpsPort));
                        conn.getParams().put("port", httpsPort);
                        needUpdate = true;
                    }
                    if ((timeout = p.getProperty("connection.timeout")) != null && !timeout.isEmpty() && !timeout.equals(conn.getParams().get("timeout"))) {
                        this.log.info((Object)("\u041c\u0435\u043d\u044f\u044e \u0442\u0430\u0439\u043c\u0430\u0443\u0442 \u0441\u043e\u0435\u0434\u043d\u0438\u0435\u043d\u0438\u044f: " + (String)conn.getParams().get("timeout") + " \u043d\u0430 \u043d\u043e\u0432\u044b\u0439 " + timeout));
                        conn.getParams().put("timeout", timeout);
                        needUpdate = true;
                    }
                    if ((printerClass = conf.getPrinterClass()) != null) {
                        String printDisp;
                        String printLeft;
                        String printScroll;
                        String deviceName = null;
                        switch (printerClass) {
                            case PosPrinter: {
                                deviceName = conf.getPosPrinterConfiguration().getDeviceType().getName();
                                break;
                            }
                            case FiscalPrinter: {
                                deviceName = conf.getFiscalPrinterConfiguration().getDeviceType().getName();
                            }
                        }
                        Integer w = null;
                        Integer scroll = null;
                        Integer left = null;
                        Integer disp = null;
                        String printWidth = p.getProperty("print." + deviceName + ".width");
                        if (printWidth != null && !printWidth.trim().isEmpty() && printWidth.matches("^\\d{1,5}$")) {
                            w = Integer.parseInt(printWidth.trim());
                        }
                        if ((printScroll = p.getProperty("print." + deviceName + ".scroll")) != null && !printScroll.trim().isEmpty() && printScroll.matches("^\\d{1,5}$")) {
                            scroll = Integer.parseInt(printScroll.trim());
                        }
                        if ((printLeft = p.getProperty("print." + deviceName + ".left")) != null && !printLeft.trim().isEmpty() && printLeft.matches("^\\d{1,5}$")) {
                            left = Integer.parseInt(printLeft.trim());
                        }
                        if ((printDisp = p.getProperty("print." + deviceName + ".disp")) != null && !printDisp.trim().isEmpty() && printDisp.matches("^\\d{1,5}$")) {
                            disp = Integer.parseInt(printDisp.trim());
                        }
                        if (w != null || scroll != null || left != null || disp != null) {
                            switch (printerClass) {
                                case PosPrinter: {
                                    if (w != null && !w.equals(conf.getPosPrinterOptions().getWidth())) {
                                        conf.getPosPrinterOptions().setWidth(w.intValue());
                                        needUpdate = true;
                                    }
                                    if (scroll != null && !scroll.equals(conf.getPosPrinterOptions().getScroll())) {
                                        conf.getPosPrinterOptions().setScroll(scroll.intValue());
                                        needUpdate = true;
                                    }
                                    if (left != null && !left.equals(conf.getPosPrinterOptions().getLeftMargin())) {
                                        conf.getPosPrinterOptions().setLeftMargin(left.intValue());
                                        needUpdate = true;
                                    }
                                    if (disp == null || disp.equals(conf.getPosPrinterOptions().getDispense())) break;
                                    conf.getPosPrinterOptions().setDispense(disp);
                                    needUpdate = true;
                                    break;
                                }
                                case FiscalPrinter: {
                                    if (w != null && !w.equals(conf.getKkmOptions().getWidth())) {
                                        conf.getKkmOptions().setWidth(w);
                                        needUpdate = true;
                                    }
                                    if (scroll == null || scroll.equals(conf.getKkmOptions().getScroll())) break;
                                    conf.getKkmOptions().setScroll(scroll);
                                    needUpdate = true;
                                }
                            }
                        }
                    }
                    if (needUpdate) {
                        this.log.info((Object)"\u041e\u0431\u043d\u043e\u0432\u043b\u044f\u044e \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e");
                        try {
                            conf.updateConfiguration();
                            this.log.info((Object)"\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430");
                        }
                        catch (ConfigurationException ex) {
                            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438", (Throwable)ex);
                        }
                    } else {
                        this.log.info((Object)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f");
                    }
                }
                catch (IOException needUpdate) {
                    // empty catch block
                }
            }
            this.log.info((Object)"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435");
            ScreenUtil.setScreenSize((String)conf.getScreenSize());
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gs = ge.getScreenDevices();
            if (gs.length == 2) {
                if (SystemProp.isBindToDisplay00()) {
                    GraphicsDevice gd = gs[0];
                    Rectangle rec = gs[1].getDefaultConfiguration().getBounds();
                    if (rec.x == 0 && rec.y == 0) {
                        gd = gs[1];
                    }
                    ScreenUtil.setScreenSize((Rectangle)gd.getDefaultConfiguration().getBounds());
                } else {
                    ScreenUtil.setScreenSize((Rectangle)gs[0].getDefaultConfiguration().getBounds());
                }
            }
            this.log.info((Object)("\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435 \u044d\u043a\u0440\u0430\u043d\u0430: " + ScreenUtil.getScreenSize()));
            new Thread((Runnable)new ImagePreLoader(), "ImagePreLoader").start();
            this.executor = new ProcessExecutor();
            OsApi.getInstance().setExecutor(this.executor);
            SequenceManager.getInstance().createManager(conf.getApplicationDir() + File.separator + "sequence");
            Locale loc = conf.getLocale();
            this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u043b\u043e\u043a\u0430\u043b\u044c \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f: " + loc));
            Locale.setDefault(loc);
            this.log.info((Object)"\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u044e \u043c\u0435\u0434\u0438\u0430 \u043f\u043b\u0435\u0439\u0435\u0440");
            MediaPlayer.getInstance().setDirectory(PathUtils.getAppHome() + "/sound/");
            this.log.info((Object)"*** \u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u0442\u043e\u0447\u043a\u0435 *******************************");
            try {
                this.log.info((Object)("\u0414\u0438\u043b\u0435\u0440: " + ReferenceManager.getInstance().getDealer()));
                this.log.info((Object)("\u0422\u043e\u0447\u043a\u0430: " + ReferenceManager.getInstance().getPoint()));
            }
            catch (ReferenceException rec) {
                // empty catch block
            }
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u0445\u0440\u0430\u043d\u0438\u0442\u0435\u043b\u044f \u043a\u043e\u043c\u043c\u0430\u043d\u0434 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 ******************");
            CommandStore commandStore = new CommandStore(conf.getApplicationDir() + "/data/commands.obj");
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u0445\u0440\u0430\u043d\u0438\u0442\u0435\u043b\u044f \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 ******************");
            PromoStatisticStore.getInstance((String)(conf.getApplicationDir() + "/data/promo.obj"));
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440 **********************************");
            ConnectorConfiguration connectorConfiguration = conf.getDefaultConnectorConfiguration();
            if (connectorConfiguration == null) {
                throw new ApplicationException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430");
            }
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
            this.queue = new Queue(conf.getApplicationDir() + "/data/queue.obj", (DiskErrorListener)new AppDiskErrorListener(null));
            this.log.info((Object)"Send system info");
            SystemInfo pcInfo = PcInfoCollector.getPcInfo();
            if (pcInfo != null) {
                pcInfo.setSkinVersion(ComponentFactory.getInstance().getSkinCode());
                SerialNumbersStore store = ConfigurationSN.getInstance().getStore();
                if (store.getNumbers() != null) {
                    if (store.getSerial(SerialNumbersStore.Type.FIRST_MONITOR) != null) {
                        pcInfo.setDisplay1Serial(store.getSerial(SerialNumbersStore.Type.FIRST_MONITOR));
                    }
                    if (store.getSerial(SerialNumbersStore.Type.SECOND_MONITOR) != null) {
                        pcInfo.setDisplay2Serial(store.getSerial(SerialNumbersStore.Type.SECOND_MONITOR));
                    }
                    if (store.getSerial(SerialNumbersStore.Type.TERMINAL) != null) {
                        pcInfo.setInvNumber(store.getSerial(SerialNumbersStore.Type.TERMINAL));
                    }
                }
                pcInfo.setHomePath(PathUtils.getAppHome());
            }
            this.queue.setSystemInfo(pcInfo);
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u0441\u0435\u0440\u0432\u0435\u0440-\u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440");
            ProxyConfiguration proxy = new ProxyConfiguration();
            proxy.setUseProxy(conf.isUseProxy());
            proxy.setProxyHost(conf.getProxyHost());
            proxy.setProxyPort(conf.getProxyPort());
            proxy.setAuthProxy(conf.isAuthProxy());
            proxy.setProxyUser(conf.getProxyUser());
            proxy.setProxyPassword(conf.getProxyPassword());
            this.log.info((Object)("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b proxy=" + proxy));
            this.serverInterface = ConnectorFactory.createConnector((ConnectorType)connectorConfiguration.getType(), (ConnectorConfiguration)connectorConfiguration, (ProxyConfiguration)proxy, (AppStateWatcher)new AppStateWatcherImpl());
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043a\u043b\u0438\u0435\u043d\u0442-\u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440");
            this.clientInterface = new ClientInterface(this.serverInterface, this.queue, conf.isCashEmulator());
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043e\u0442\u0441\u044b\u043b\u044c\u0449\u0438\u043a\u0430 \u043f\u0430\u043a\u0435\u0442\u043e\u0432");
            this.queueAgent = new QueueAgent(this.queue, commandStore, this.serverInterface);
            if (SystemProp.isSkipSendPackets()) {
                this.log.info((Object)"\u041e\u0442\u0441\u044b\u043b\u043a\u0430 \u043f\u0430\u043a\u0435\u0442\u043e\u0432 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430");
            } else {
                Thread queueAgentThread = new Thread((Runnable)this.queueAgent, "QueueAgentThread");
                this.threads.add(queueAgentThread);
            }
            if (AppDefaults.getInstance().getBooleanProperty("fraud.timeout.enable", false)) {
                this.fraudQueue = new FraudQueue(conf.getApplicationDir() + "/data/queue-fraud.obj", new AppDiskErrorListener(null));
                this.fraudQueueAgent = new FraudQueueAgent(this.fraudQueue, this.clientInterface);
                Thread fraudQueueAgentThread = new Thread((Runnable)this.fraudQueueAgent, "FraudQueueAgentThread");
                this.threads.add(fraudQueueAgentThread);
            }
            SystemUpdateListener sul = new SystemUpdateListener(this.clientInterface);
            this.serverInterface.addRemoteStatusObserver((RemoteStatusObserver)sul);
            UpdateHandler uh = new UpdateHandler((StateListener)sul);
            this.threads.add(new Thread((Runnable)uh, "Updater"));
            UpdateSystem.setUpdateHandler((UpdateHandler)uh);
            if (SystemProp.isSkipUpdate()) {
                this.log.info((Object)"Update system disabled");
            } else {
                UpdateChecker uc = new UpdateChecker(uh);
                this.serverInterface.addRemoteStatusObserver((RemoteStatusObserver)uc);
                this.scheduler.scheduleAtFixedRate(uc, 60L, 120L, TimeUnit.SECONDS);
            }
            this.serverInterface.addRemoteStatusObserver((RemoteStatusObserver)new VpnObserver());
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u0437\u0430\u0433\u0440\u0443\u0437\u0447\u0438\u043a\u0430 \u0431\u0430\u043d\u043d\u0435\u0440\u043e\u0432");
            this.bannerUpdater = new BannerUpdater(this.clientInterface);
            this.threads.add(new Thread((Runnable)this.bannerUpdater, "BannerUpdater"));
            this.serverInterface.addBannerObserver((BannerObserver)this.bannerUpdater);
            this.serverInterface.addRemoteStatusObserver((RemoteStatusObserver)this.bannerUpdater);
            BDPNUpdater bdpnUpdater = new BDPNUpdater(this.clientInterface);
            this.threads.add(new Thread((Runnable)bdpnUpdater, "BDPNUpdater"));
            this.serverInterface.addRemoteStatusObserver((RemoteStatusObserver)bdpnUpdater);
            if (AppDefaults.getInstance().getBooleanProperty("Module.ecard.sender.enable", false)) {
                ECardSender s = new ECardSender();
                Integer timeout = AppDefaults.getInstance().getIntegerValue("Module.ecard.sender.timeout", 1440);
                this.scheduler.scheduleAtFixedRate(s, 5L, timeout.intValue(), TimeUnit.MINUTES);
            }
            NoPaymentsRebooter npr = new NoPaymentsRebooter(this.clientInterface);
            this.scheduler.scheduleAtFixedRate(npr, 60L, 60L, TimeUnit.SECONDS);
            if (SystemProp.isNetworkAddrManagerEnable()) {
                this.log.info((Object)"\u041c\u0435\u043d\u0435\u0434\u0436\u0435\u0440 \u0441\u0435\u0442\u0435\u0432\u044b\u0445 \u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0432\u043a\u043b\u044e\u0447\u0435\u043d. \u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0440\u0430\u0437 \u0432 5 \u043c\u0438\u043d");
                NetworkAddressManager nam = new NetworkAddressManager(this.serverInterface);
                this.scheduler.scheduleAtFixedRate(nam, 1L, 5L, TimeUnit.MINUTES);
            }
            if (OpenFilesWatcher.isSupported()) {
                this.scheduler.scheduleAtFixedRate(new OpenFilesWatcher(), 1L, 1L, TimeUnit.MINUTES);
            }
            this.scheduler.scheduleAtFixedRate(new RfRunnable(this.queue), 1L, 240L, TimeUnit.MINUTES);
            NetworkStatisticHandler nsh = new NetworkStatisticHandler(this.clientInterface);
            this.serverInterface.addNetObserver((NetObserver)nsh);
            this.threads.add(new Thread((Runnable)nsh, "NetworkStatisticHandler"));
            EventNotifier.init(new EventNotifierImpl(this.clientInterface, this.log), new AppTimeMarker());
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u043f\u0435\u0447\u0430\u0442\u0438 *****************************");
            this.log.info((Object)"\u041f\u044b\u0442\u0430\u044e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c pos-\u043f\u0440\u0438\u043d\u0442\u0435\u0440");
            DeviceClass printerClass = conf.getPrinterClass();
            if (printerClass == null) {
                this.printer = PrinterFactory.createStub();
            } else {
                switch (printerClass) {
                    case IppPrinter: {
                        this.printer = PrinterFactory.createIppPrinter((String)conf.getIppPrinterName(), (boolean)true, (IppPrinterOptions)conf.getIppPrinterOptions(), (String)AppDefaults.getInstance().getProperty("printer.ipp.render"));
                        break;
                    }
                    case PosPrinter: {
                        DeviceConfiguration<Port> prnCfg = conf.getPosPrinterConfiguration();
                        if (prnCfg == null) {
                            throw new ApplicationException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 pos-\u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430");
                        }
                        this.printer = PrinterFactory.createPosPrinterInstance((DeviceType)prnCfg.getDeviceType(), (Port)prnCfg.getPort(), (PosPrinterOptions)conf.getPosPrinterOptions());
                        if (this.printer == null) {
                            throw new ApplicationException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0440\u0438\u043d\u0442\u0435\u0440 " + prnCfg.getDeviceType() + " \u0434\u043b\u044f " + prnCfg.getPort().getName());
                        }
                        this.log.info((Object)"Pos-\u043f\u0440\u0438\u043d\u0442\u0435\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d");
                        break;
                    }
                    case FiscalPrinter: {
                        DeviceConfiguration<SerialPort> frCfg = conf.getFiscalPrinterConfiguration();
                        if (frCfg == null) {
                            throw new ApplicationException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430");
                        }
                        this.printer = PrinterFactory.createFiscalPrinterInstance((DeviceType)frCfg.getDeviceType(), (Port)frCfg.getPort(), (boolean)conf.isFiscalPrinterMode(), (KkmOptions)conf.getKkmOptions(), (KkmControl)new RefsKkmControl());
                        if (this.printer == null) {
                            throw new ApplicationException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0440\u0438\u043d\u0442\u0435\u0440 " + frCfg.getDeviceType() + " \u0434\u043b\u044f " + frCfg.getPort().getName());
                        }
                        if (this.printer instanceof Kkm) {
                            ((Kkm)this.printer).addKkmListener((KkmListener)new KkmErrorListener(this.clientInterface));
                            this.log.info((Object)"\u0424\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u0438\u043d\u0442\u0435\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d");
                            break;
                        }
                        this.log.info((Object)"\u041f\u043e\u0441-\u043f\u0440\u0438\u043d\u0442\u0435\u043d \u043d\u0430 \u0431\u0430\u0437\u0435 \u043a\u043a\u043c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d");
                        break;
                    }
                }
            }
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u043f\u0435\u0447\u0430\u0442\u0438");
            this.printerQueue = PrinterQueueFactory.createPrinterQueue((Printer)this.printer, (String)conf.getPrintHandler());
            this.log.info((Object)("\u0421\u043e\u0437\u0434\u0430\u044e \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432, \u0440\u0435\u0430\u043a\u0446\u0438\u044f \u043d\u0430 \u0434\u0430\u0442\u0447\u0438\u043a \u0441\u043a\u043e\u0440\u043e\u0433\u043e \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043b\u0435\u043d\u0442\u044b: " + conf.isUsePaperNearEndSensor()));
            this.printerStatusObserver = new PrinterStatusObserver(this.clientInterface, conf.isUsePaperNearEndSensor());
            this.log.info((Object)"\u041f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u044f\u044e \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432");
            this.printerQueue.addObserver((ru.softlogic.hardware.device.print.status.PrinterStatusObserver)this.printerStatusObserver);
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043f\u043e\u0442\u043e\u043a \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043f\u0435\u0447\u0430\u0442\u0438");
            this.printerQueueThread = new Thread((Runnable)this.printerQueue, "PrinterQueueThread");
            this.threads.add(this.printerQueueThread);
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430");
            this.printerQueue.addInfoListener((ru.softlogic.hardware.device.print.queue.PrinterInfoListener)new PrinterInfoListener(this.clientInterface));
            this.log.info((Object)"\u041e\u0447\u0435\u0440\u0435\u0434\u044c \u043f\u0435\u0447\u0430\u0442\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0430. \u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043f\u0435\u0447\u0430\u0442\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e");
            DeviceSummaryInit.setPrinter(this.printer);
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u0438\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044f \u043a\u043e\u043c\u043c\u0430\u043d\u0434 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 ****************");
            this.commandLauncher = new CommandLauncher(commandStore, this.clientInterface, this.printerQueue, this.executor, conf.getModemConfiguration() == null ? null : conf.getModemConfiguration().getPort());
            this.threads.add(new Thread((Runnable)this.commandLauncher, "CommandLauncher"));
            if (OsDetector.current() == 1) {
                this.threads.add(new Thread((Runnable)new OpenFilesWatcher(), "OpenFilesWatcher"));
            }
            this.threads.add(new Thread((Runnable)new TimerThread(), "TimerThread"));
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u043f\u0440\u0438\u0435\u043c\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 ******************");
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u043a\u0443\u043f\u044e\u0440");
            this.cashAcceptorBox = new CashBox(conf.getApplicationDir() + "/data/cash-in/cash-acceptor.obj", DeviceClass.CashAcceptor);
            this.coinAcceptorBox = new CashBox(conf.getApplicationDir() + "/data/cash-in/coin-acceptor.obj", DeviceClass.CoinAcceptor);
            this.flowDownCoinBox = new CashBox(conf.getApplicationDir() + "/data/cash-in/coin-flowbox.obj", DeviceClass.CoinAcceptor);
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a");
            DeviceConfiguration<SerialPort> cashAccCfg = conf.getCashAcceptorConfiguration();
            if (cashAccCfg == null) {
                throw new ApplicationException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
            }
            this.cashAcceptor = CashInFactory.createInstance((DeviceType)cashAccCfg.getDeviceType(), (SerialPort)cashAccCfg.getPort());
            if (this.cashAcceptor == null) {
                throw new ApplicationException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a " + cashAccCfg.getDeviceType());
            }
            DeviceSummaryInit.setCashAcceptor(this.cashAcceptor);
            CashDeviceManager.getInstance().setDefaultCashValidator(this.cashAcceptor);
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043f\u043e\u0442\u043e\u043a \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
            this.cashAcceptorThread = new Thread((Runnable)this.cashAcceptor, "CashAcceptorThread");
            this.threads.add(this.cashAcceptorThread);
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0439");
            this.cashCollectionHandler = new MoneyCollectionHandler(this.cashAcceptorBox);
            this.coinCollectionHandler = new MoneyCollectionHandler(this.coinAcceptorBox, this.flowDownCoinBox);
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0437\u0430 \u0432\u044b\u0434\u0435\u0440\u0433\u0438\u0432\u0430\u043d\u0438\u0435\u043c \u043a\u0430\u0441\u0441\u0435\u0442\u044b");
            MoneyCollectionObserver moneyCollectionObserver = new MoneyCollectionObserver(this.cashCollectionHandler, this.coinCollectionHandler);
            MoneyCollectionProxy mcProxy = new MoneyCollectionProxy(moneyCollectionObserver);
            this.log.info((Object)"  \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e \u0435\u0433\u043e \u043a \u0432\u0430\u043b\u0438\u0434\u0430\u0442\u043e\u0440\u0443");
            this.cashAcceptor.addStatusObserver((ValidatorStatusListener)mcProxy);
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0437\u0430 \u0444\u043e\u0444\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435\u043c \u0435\u0436\u0435\u0434\u043d\u0435\u0432\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e z-\u043e\u0442\u0447\u0451\u0442\u0430");
            ZReportServiceObserver reportObserver = new ZReportServiceObserver(this.cashCollectionHandler, this.coinCollectionHandler);
            this.threads.add(new Thread((Runnable)reportObserver, "ZReportServiceObserver"));
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0435\u0440\u0430 \u043f\u043e \u0437\u0430\u0436\u0435\u0432\u044b\u0432\u0430\u043d\u0438\u044e");
            this.jammInformer = new JammInformer(this.clientInterface);
            this.log.info((Object)"  \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e \u0435\u0433\u043e \u043a \u0432\u0430\u043b\u0438\u0434\u0430\u0442\u043e\u0440\u0443");
            this.cashAcceptor.addStatusObserver((ValidatorStatusListener)this.jammInformer);
            this.log.info((Object)"\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430:");
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438");
            StatisticStore statisticStore = new StatisticStore(conf.getApplicationDir() + "/data/cash-in/cash-acceptor-stat.obj", DeviceClass.CashAcceptor);
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438");
            final CashAcceptorStatisticObserver statisticObserver = new CashAcceptorStatisticObserver(statisticStore);
            this.log.info((Object)"  \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u043a \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0443");
            this.cashAcceptor.addStatisticObserver((StatisticListener)statisticObserver);
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043f\u043e\u0442\u043e\u043a \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438");
            Thread statisticThread = new Thread((Runnable)new CashAcceptorStatisticThread(statisticStore, this.clientInterface), "CashAcceptorStatisticThread");
            this.threads.add(statisticThread);
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 adv \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438");
            AdvStatisticStore ass = new AdvStatisticStore(conf.getApplicationDir() + "/data/adv-stat.obj");
            AppEnvironment.getInstance().addListener((AppEnvironmentListener)new AdvStatisticEnviromentListener(ass));
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043f\u043e\u0442\u043e\u043a \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f adv \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438");
            Thread advStatisticThread = new Thread((Runnable)new AdvStatisticThread(ass, this.clientInterface), "AdvStatisticThread");
            this.threads.add(advStatisticThread);
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438");
            CashManager.setDefaultInstance((CashManager)new BaseCashManager(this.cashAcceptorBox, this.coinAcceptorBox, new BaseCashManager.PermitListener(){

                @Override
                public void onPermit() {
                    statisticObserver.notify(Event.ProgramReject);
                }
            }));
            this.log.info((Object)"\u041c\u043e\u043d\u0438\u0442\u043e\u0440\u0438\u043d\u0433:");
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u0432\u0430\u043b\u0438\u0434\u0430\u0442\u043e\u0440\u0430");
            this.cashAcceptorObserver = new CashAcceptorStatusObserver(this.clientInterface, this.cashAcceptor);
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u044e\u0449\u0438\u0439 \u043f\u043e\u0442\u043e\u043a");
            this.cashAcceptorObserverThread = new Thread((Runnable)this.cashAcceptorObserver, "CashAcceptorObserverThread");
            this.threads.add(this.cashAcceptorObserverThread);
            this.log.info((Object)"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f:");
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0439");
            CashAcceptorIdentificationListener acceptorSnListener = new CashAcceptorIdentificationListener(this.clientInterface, this.cashAcceptor);
            this.log.info((Object)"  \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u043a \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0443");
            this.cashAcceptor.addStatusObserver((ValidatorStatusListener)acceptorSnListener);
            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a \u043a \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u0443 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438");
            CashManager.getDefaultInstance().addCashDevice((ManagedCashAcceptor)this.cashAcceptor);
            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430 \u043a \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u0443 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438");
            CashManager.getDefaultInstance().addCashDevice((ManagedCashAcceptor)this.cashAcceptorObserver);
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a");
            this.log.info((Object)"\u0423\u0447\u0435\u0442 \u043a\u0443\u043f\u044e\u0440:");
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0439");
            DeviceConfiguration<SerialPort> coinAccCfg = conf.getCoinAcceptorConfiguration();
            if (coinAccCfg != null) {
                this.createLoggerWithViewAppender("coin", "coin", "cashinview");
                this.coinAcceptor = CashInFactory.createInstance((DeviceType)coinAccCfg.getDeviceType(), (SerialPort)coinAccCfg.getPort());
                if (this.coinAcceptor != null) {
                    this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043f\u043e\u0442\u043e\u043a \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
                    this.coinAcceptorThread = new Thread((Runnable)this.coinAcceptor, "CoinAcceptorThread");
                    this.threads.add(this.coinAcceptorThread);
                    this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0437\u0430 \u0432\u044b\u0434\u0435\u0440\u0433\u0438\u0432\u0430\u043d\u0438\u0435\u043c \u043a\u0430\u0441\u0441\u0435\u0442\u044b");
                    this.log.info((Object)"  \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e \u0435\u0433\u043e \u043a \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0443");
                    this.coinAcceptor.addStatusObserver((ValidatorStatusListener)mcProxy);
                    this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432");
                    CoinAcceptorStatusObserver caso = new CoinAcceptorStatusObserver(this.clientInterface);
                    this.log.info((Object)"  \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e \u0435\u0433\u043e \u043a \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0443");
                    this.coinAcceptor.addStatusObserver((ValidatorStatusListener)caso);
                    this.log.info((Object)"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f:");
                    this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0439");
                    CashAcceptorIdentificationListener coinAcceptorSnListener = new CashAcceptorIdentificationListener(this.clientInterface, this.coinAcceptor);
                    this.log.info((Object)"  \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u043a \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0443");
                    this.coinAcceptor.addStatusObserver((ValidatorStatusListener)coinAcceptorSnListener);
                    CashManager.getDefaultInstance().addCashDevice((ManagedCashAcceptor)this.coinAcceptor);
                    CashDeviceManager.getInstance().setDefaultCoinValidator(this.coinAcceptor);
                } else {
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043d\u0438\u043a\u0430");
                }
                DeviceSummaryInit.setCoinAcceptor(this.coinAcceptor);
            } else {
                this.log.info((Object)"\u041c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a \u043e\u0442\u0441\u0443\u0442\u0441\u0432\u0443\u0435\u0442");
            }
            this.log.info((Object)"\u0421\u0438\u0441\u0442\u0435\u043c\u0430 \u043f\u0440\u0438\u0435\u043c\u0430 \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0441\u0442\u0440\u0435\u0434\u0441\u0442\u0432 \u0441\u043e\u0437\u0434\u0430\u043d\u0430");
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u0438\u043d\u0433\u0430 \u0441\u0435\u0442\u0438 *******************");
            this.netObserver = new NetworkObserver((reboot & 1) > 0);
            this.netObserverThread = new Thread((Runnable)this.netObserver, "NetObserverThread");
            this.threads.add(this.netObserverThread);
            this.serverInterface.addNetObserver((NetObserver)this.netObserver);
            DeviceConfiguration<SerialPort> wdogCfg = conf.getWatchDogConfiguration();
            if (wdogCfg != null) {
                this.log.info((Object)("\u0422\u0438\u043f \u0441\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0433\u043e \u0442\u0430\u0439\u043c\u0435\u0440\u0430: " + wdogCfg.getDeviceType()));
                this.log.info((Object)("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0441\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0433\u043e \u0442\u0430\u0439\u043c\u0435\u0440\u0430: " + conf.getWatchDogSettings()));
                this.watchDog = WatchDogFactory.createInstance((DeviceType)wdogCfg.getDeviceType(), (SerialPort)wdogCfg.getPort(), (WatchDogSettings)conf.getWatchDogSettings());
                this.watchDog.addEventListener(new EventListener(){

                    public void onEvent(EventListener.EventPair event) {
                        TerminalApplication.this.clientInterface.sendEvent(new ru.softlogic.srv.api.event.Event(EventType.Warning, event.getChannel().toString() + " is " + event.getType().toString()));
                        TerminalApplication.this.log.info((Object)(event.getChannel().toString() + " is " + event.getType().toString()));
                    }
                });
            } else {
                this.log.info((Object)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0435\u043a\u0446\u0438\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0441\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0433\u043e \u0442\u0430\u0439\u043c\u0435\u0440\u0430. \u041f\u0440\u043e\u0431\u0443\u044e \u043d\u0430\u0439\u0442\u0438 \u0442\u0430\u0439\u043c\u0435\u0440\u044b \u043d\u0430 \u0448\u0438\u043d\u0435 USB");
                this.watchDog = WatchDogFactory.createInstance();
            }
            if (this.watchDog != null) {
                this.clientInterface.send(this.watchDog.getInfo());
                this.log.info((Object)("\u0421\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0439 \u0442\u0430\u0439\u043c\u0435\u0440 \u043d\u0430\u0439\u0434\u0435\u043d: " + this.watchDog.getInfo()));
                this.log.info((Object)"\u041f\u043e\u0434\u043f\u0438\u0441\u044b\u0432\u0430\u044e\u0441\u044c \u043d\u0430 \u043f\u0440\u043e\u0441\u043b\u0443\u0448\u043a\u0443 \u0441\u043e\u0431\u044b\u0442\u0438\u0439");
                this.netObserver.setWatchDog(this.watchDog);
            } else {
                this.log.error((Object)"\u0421\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0439 \u0442\u0430\u0439\u043c\u0435\u0440 \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d");
            }
            DeviceInfoSender dis = new DeviceInfoSender(this.clientInterface);
            BarcodeScannerType bst = conf.getBarcodeScannerType();
            if (bst == BarcodeScannerType.Serial) {
                BaseBarcodeScanner bbs;
                DeviceConfiguration<SerialPort> sp = conf.getBarcodeScannerConfiguration();
                if (sp != null && (bbs = BarcodeScannerFactory.createSerialScanner((DeviceType)sp.getDeviceType(), (SerialPort)sp.getPort(), (BarcodeScannerOptions)new BarcodeScannerOptions(), (DeviceInfoListener)dis)) != null) {
                    this.threads.add(new Thread((Runnable)bbs, "BarcodeScanner"));
                    BarcodeScanner.setScanner((BarcodeScanner)bbs);
                }
            } else if (bst == BarcodeScannerType.Keyboard) {
                BarcodeScanner.setScanner((BarcodeScanner)BarcodeScannerFactory.createKeyboardScanner((BarcodeScannerOptions)new BarcodeScannerOptions(), (DeviceInfoListener)dis));
            }
            if (BarcodeScanner.getScanner() == null) {
                BarcodeScanner.setScanner((BarcodeScanner)BarcodeScannerFactory.createScannerStub(null));
            }
            BarcodeScanner.getScanner().addListener((BarcodeScannerListener)new LocalBarcodeScannerListener());
            DeviceConfiguration<SerialPort> hopperCfg = conf.getCoinHopperConfiguration();
            if (hopperCfg != null) {
                this.log.info((Object)("\u0422\u0438\u043f \u0445\u043e\u043f\u043f\u0435\u0440\u0430: " + hopperCfg.getDeviceType()));
                BaseHopper baseHopper = HopperFactory.createInstance((DeviceType)hopperCfg.getDeviceType(), (SerialPort)hopperCfg.getPort(), (CashBox)this.coinAcceptorBox, (CashBox)this.flowDownCoinBox, (PayoutManager)new SimplePayoutManager(), (DeviceInfoListener)new DeviceInfoSender(this.clientInterface), (HopperStateListener)new AppHopperStateListener(this.clientInterface));
                if (baseHopper != null) {
                    this.threads.add(new Thread((Runnable)baseHopper, "HopperThread"));
                    this.log.info((Object)"\u0425\u043e\u043f\u043f\u0435\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d");
                    Hopper.setDefaultHopper((IHopper)baseHopper);
                } else {
                    this.log.info((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0445\u043e\u043f\u043f\u0435\u0440");
                }
            } else if (this.coinAcceptor instanceof IHopper) {
                this.log.info((Object)"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a-\u0445\u043e\u043f\u043f\u0435\u0440");
                Hopper.setDefaultHopper((IHopper)((IHopper)this.coinAcceptor));
            }
            String MPPKPath = conf.getMppkPath();
            if (MPPKPath != null) {
                Logger tmmLog = this.createLogger("tmm", "add/tmm");
                try {
                    this.log.info((Object)"\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u0435\u043c \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u043d\u044b\u0439 \u043c\u043e\u0434\u0443\u043b\u044c");
                    this.log.info((Object)("\u041f\u0443\u0442\u044c \u0434\u043e MPPK: " + MPPKPath));
                    Tmm.setInstance(new TransportModule(MPPKPath, tmmLog));
                }
                catch (Throwable e) {
                    this.log.info((Object)"E-Card module is not available");
                }
            }
            if (CoffeeMachineUtil.isCoffeeMachinePresent()) {
                this.createLogger("coffee-machine", "add/coffee-machine");
                l = Logger.getLogger((String)"coffee-machine");
                l.info((Object)"create logger succ");
                this.threads.add(new Thread((Runnable)new CoffeeMachineStatisticSender(this.clientInterface), "CoffeeMachineStatisticSender"));
            }
            if (SnackMachineUtil.isSnackMachinePresent()) {
                this.createLogger("snack-machine", "add/snack-machine");
                l = Logger.getLogger((String)"snack-machine");
                l.info((Object)"create logger succ");
                this.threads.add(new Thread((Runnable)new SnackMachineStatisticSender(this.clientInterface), "SnackMachineStatisticSender"));
            }
            if ((pc = conf.getPresentConfiguration()) != null) {
                this.log.info((Object)"\u041c\u043e\u0434\u0443\u043b\u044c \u0432\u044b\u0434\u0430\u0447\u0438 \u043f\u043e\u0434\u0430\u0440\u043a\u043e\u0432");
                this.log.info((Object)("\u0422\u0438\u043f: " + pc.getType() + ", \u0434\u0440\u0430\u0439\u0432\u0435\u0440: " + pc.getDriver()));
                if ("NetworkModule".equalsIgnoreCase(pc.getType())) {
                    Dispenser dispenser = Factory.createNetwork((String)pc.getDriver(), (DispenserOptions)pc.getOptions(), (DispenserNetworkOptions)pc.getNetworkOptions(), (StatusListener)new DispenserStatusListener(this.clientInterface), (DeviceInfoListener)dis);
                    Dispenser.setInstance((Dispenser)dispenser);
                    if (dispenser != null) {
                        this.log.info((Object)"\u041c\u043e\u0434\u0443\u043b\u044c \u0432\u044b\u0434\u0430\u0447\u0438 \u043f\u043e\u0434\u0430\u0440\u043a\u043e\u0432 \u0441\u043e\u0437\u0434\u0430\u043d.");
                        this.threads.add(new Thread((Runnable)dispenser, "PresentDispencer"));
                    }
                }
            } else {
                this.log.info((Object)"\u041c\u043e\u0434\u0443\u043b\u044c \u0432\u044b\u0434\u0430\u0447\u0438 \u043f\u043e\u0434\u0430\u0440\u043a\u043e\u0432 \u043e\u0442\u0441\u0443\u0441\u0442\u0432\u0443\u0435\u0442");
            }
            try {
                CardModuleConfigurator cmc = null;
                cmc = new CardModuleConfigurator(new File(PathUtils.getAppHome()), this.log);
                cmc.start(new DeviceInfoHandlingSender(this.clientInterface), new DeviceInfoHandlingSender(this.clientInterface), new CardEmergencyEventListener(this.clientInterface));
                this.log.info((Object)("\u041c\u043e\u0434\u0443\u043b\u044c \u043f\u043e \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 \u0431\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u043c\u0438 \u043a\u0430\u0440\u0442\u0430\u043c\u0438: " + cmc.getManager()));
                this.threads.addAll(cmc.getThreads());
                CardModuleStore.getInstance().setManager(cmc.getManager());
                CardModuleStore.getInstance().setCardReaderOnly(cmc.isCardReaderOnly());
                Runnable closeDayTask = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CardModuleStore.getInstance().openSession(new CardModuleEventsProxy()).closeBusinessDay();
                        }
                        catch (IllegalStateException ex) {
                            TerminalApplication.this.log.info((Object)"day not closed");
                        }
                    }
                };
                CloseDaySchedule closeDaySchedule = cmc.getManager().getCloseDaySchedule();
                if (closeDaySchedule != null) {
                    for (CloseDaySchedule.Day d : CloseDaySchedule.Day.values()) {
                        CloseDaySchedule.Time time = closeDaySchedule.getTime(d);
                        if (time == null) continue;
                        this.cronScheduler.schedule(String.format("%d %d * * %s", time.getMinute(), time.getHour(), d.toString()), closeDayTask);
                        this.log.info((Object)("Scheduled closeday task at: " + time.getHour() + ":" + time.getMinute() + " " + d.toString()));
                    }
                    this.cronScheduler.start();
                    this.log.info((Object)"Closeday scheduler thread started");
                } else {
                    this.log.info((Object)"Schedule of closeday tasks is not available");
                }
            }
            catch (FileNotFoundException e) {
                this.log.info((Object)"BankCard module is not available");
            }
            catch (Throwable e) {
                this.log.error((Object)"Can't create card-module", e);
            }
            if (CardProcessorStore.getInstance().getCardReader() == null && conf.getCardReaderConfiguration() != null) {
                try {
                    CardReaderConfiguration<Port> c = conf.getCardReaderConfiguration();
                    Logger l2 = Logger.getLogger((String)"cardreader");
                    Port port = c.getPort();
                    CardReaderDriver drv = null;
                    if (port instanceof UsbPort) {
                        drv = CardReaderFactory.createHIDDriver((String)c.getName(), (int)c.getVendor(), (int)c.getProduct(), (String)c.getSerialNo(), (CardReaderOptions)new CardReaderOptions(), (Logger)l2);
                    } else if (port instanceof SerialPort) {
                        drv = CardReaderFactory.createDriver((String)conf.getCardReaderConfiguration().getName(), (SerialPort)((SerialPort)conf.getCardReaderConfiguration().getPort()), (CardReaderOptions)new CardReaderOptions(), (Logger)l2);
                    }
                    this.log.info((Object)("Driver create successfully and contains " + drv.getThreads().size() + " thread(s)"));
                    CardReader dev = drv.getCardReader();
                    dev.addDeviceInfoListener((ru.softlogic.hdw.handling.DeviceInfoListener)new CompatDeviceInfoListener(this.clientInterface));
                    dev.addStateListener((DeviceStateListener)new DeviceInfoHandlingSender(this.clientInterface));
                    CardProcessorStore.getInstance().setCardReader(dev);
                    this.threads.addAll(drv.getThreads());
                }
                catch (Throwable ex) {
                    this.log.error((Object)ex);
                }
            }
            if (AppDefaults.getInstance().getBooleanProperty("keyboard.input.enable", false)) {
                ExtKeyboard.setInstance((ExtKeyboard)new StandartKeyboard());
            }
            if (ExtKeyboard.getInstance() == null) {
                ExtKeyboard.setInstance((ExtKeyboard)new VoidExtKeyboard());
            }
            this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u044c \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f ppp-\u0441\u043e\u0434\u0438\u043d\u0435\u043d\u0438\u044f: " + conf.isPppUse()));
            if (conf.isPppUse()) {
                this.log.info((Object)"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043f\u043e\u0442\u043e\u043a \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f ppp-\u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f");
                this.pppWatcher = new PppWatcher(conf.getPppName());
                this.threads.add(new Thread((Runnable)this.pppWatcher, "PppWatcher"));
            } else {
                this.log.info((Object)"\u041e\u043f\u043e\u0432\u0435\u0449\u0430\u044e \u0441\u0435\u0440\u0432\u0435\u0440 \u043e\u0431 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0441\u0435\u0442\u0435\u0432\u043e\u0433\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f");
                this.clientInterface.sendModemState(new ModemState(null, 0, new Operator(1, ""), null, null, null));
            }
            this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0438 \u0443\u0440\u043e\u0432\u043d\u044f \u0441\u0438\u0433\u043d\u0430\u043b\u0430: " + conf.isUssdCheck()));
            if (conf.getModemConfiguration() != null && conf.getModemConfiguration().getPort() != null && conf.isUssdCheck()) {
                this.log.info((Object)"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043f\u043e\u0442\u043e\u043a \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u043c\u043e\u0434\u0435\u043c\u0435 \u0438 \u0431\u0430\u043b\u0430\u043d\u0441\u0430");
                this.createLoggerWithViewAppender("modem", "add/modem", "modemview");
                this.threads.add(new Thread((Runnable)new UssdChecker(this.clientInterface, new DateStore(conf.getApplicationDir() + "/data/ussd.obj"), conf.getUssdRequest(), conf.getModemConfiguration().getPort(), conf.isUssdCheck()), "ModemBalanceChecker"));
            }
            this.log.info((Object)"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0441\u0435\u0442\u0435\u0432\u044b\u0445 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u043e\u0432:");
            this.threads.add(new Thread((Runnable)new NetworkInterfaceObserver(this.clientInterface), "NetworkInterfaceChecker"));
            this.log.info((Object)"************* \u0417\u0430\u043f\u0443\u0441\u043a \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0433\u043e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f *************");
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u043e\u0431\u043e\u0440\u0443\u0434\u043e\u0432\u0430\u043d\u0438\u044f");
            BaseFacadeEngine stateFacade = new BaseFacadeEngine(this.queue, this.cashAcceptorBox, this.coinAcceptorBox, this.clientInterface);
            StateFacade.setEngine(stateFacade);
            CashManager.getDefaultInstance().addFraudListener((FraudListener)stateFacade.getFraudListener());
            this.cashAcceptor.addStatusObserver(stateFacade.getCashAcceptorListener());
            this.printerQueue.addObserver(stateFacade.getPrinterListener());
            this.serverInterface.addRemoteStatusObserver(stateFacade.getNetworkObserver());
            this.serverInterface.addNetObserver(stateFacade.getNetworkErrorObserver());
            if (Cdm.getInstance() != null) {
                Cdm.getInstance().addStateListener(stateFacade.getCDMStateListener());
            }
            if (conf.getRendering() != null) {
                GuiOptions.setRendering((Rendering)conf.getRendering());
            }
            TimeoutManager.setInstance(new DynamicTimeoutManager());
            this.log.info((Object)"************* \u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0441\u0435\u0441\u0441\u0438\u043e\u043d\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 ********************");
            Keeper kp = Session.getInstance().getCurrentKeeper();
            if (kp != null && !kp.getSum().isEmpty()) {
                Pack pack = Session.getInstance().getPack();
                this.log.info((Object)("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u0438\u0437\u043b\u0438\u0448\u0435\u043a " + kp));
                PackUtility.printPack("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", pack);
                if (Session.getInstance().isPaymentAddedToQueue() && (pack == null || pack.getPaybackType() == 1 || pack.getPaybackType() == 2)) {
                    this.log.info((Object)"\u041f\u043b\u0430\u0442\u0435\u0436 \u0431\u044b\u043b \u043f\u043e\u043c\u0435\u0449\u0435\u043d \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439, \u043d\u0435 \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u043c \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436");
                } else if (Session.getInstance().isPaymentAddedToQueue() && pack != null && pack.getPaybackType() != 0) {
                    this.log.info((Object)"\u041f\u043b\u0430\u0442\u0435\u0436 \u0431\u044b\u043b \u043f\u043e\u043c\u0435\u0449\u0435\u043d \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439, \u043d\u043e \u043e\u0441\u0442\u0430\u043b\u0430\u0441\u044c \u0441\u0434\u0430\u0447\u0430. \u0413\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u043c \u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0430 \u0441\u0434\u0430\u0447\u0443");
                    PaymentHelper.sendFaultPayment(this.clientInterface, false);
                } else if (Session.getInstance().isOnlinePaymentStart() && Session.getInstance().getLastPayment() != null) {
                    this.log.info((Object)"\u041e\u043d\u043b\u0430\u0439\u043d \u043f\u043b\u0430\u0442\u0451\u0436 \u0431\u044b\u043b \u043f\u0440\u0435\u0440\u0432\u0430\u043d \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430. \u0413\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u043c \u043f\u043b\u0430\u0442\u0435\u0436 \u0434\u043b\u044f \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f(\u0432 \u0441\u043b\u0443\u0447\u0430\u0435 \u043e\u0448\u0438\u0431\u043a\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430, \u0435\u0441\u043b\u0438 \u043f\u0435\u0440\u0432\u044b\u0439 \u043f\u043b\u0430\u0442\u0451\u0436 \u0432 \u0443\u0441\u043f\u0435\u0445\u0435 \u0442\u043e \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u0441\u044f) \u0438 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e \u043d\u0430 \u0441\u0434\u0430\u0447\u0443(\u0435\u0441\u043b\u0438 \u043e\u043d\u0430 \u043e\u0441\u0442\u0430\u043b\u0430\u0441\u044c)");
                    PaymentHelper.sendFaultOnlinePayment(this.clientInterface);
                } else if (pack != null && pack.getPaybackType() == 4) {
                    this.log.info((Object)"\u041e\u0431\u0440\u044b\u0432 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u043f\u043e\u0441\u043b\u0435 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e\u043d\u043b\u0430\u0439\u043d \u043f\u043b\u0430\u0442\u0435\u0436\u0430, \u0434\u043e \u0437\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0441\u0434\u0430\u0447\u0438. \u0413\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u043c \u0441\u0434\u0430\u0447\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436");
                    PaymentHelper.preparePackToDefferedPayback();
                    PaymentHelper.sendFaultPayment(this.clientInterface, true);
                } else {
                    ServiceZReportStorage.getInstance().getCurrentSnapshot().addZCashSum(Session.getInstance().getCurrentKeeper());
                    this.log.info((Object)"\u0413\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u043c \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436");
                    PaymentHelper.sendFaultPayment(this.clientInterface, true);
                }
                Session.getInstance().setCurrentKeeper(null);
            }
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u0433\u043b\u0430\u0432\u043d\u044b\u0439 \u0444\u0440\u0435\u0439\u043c ******************************");
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice[] gs = ge.getScreenDevices();
                    if (gs.length == 1) {
                        TerminalApplication.this.log.info((Object)"\u041e\u0434\u043d\u043e\u043c\u043e\u043d\u0438\u0442\u043e\u0440\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f, \u0441\u043e\u0437\u0434\u0430\u044e \u043f\u0440\u043e\u0441\u0442\u043e\u0439 \u0444\u0440\u0435\u0439\u043c");
                        TerminalApplication.this.frame = new BaseFrame();
                    } else if (SystemProp.isBindToDisplay00()) {
                        TerminalApplication.this.log.info((Object)"\u0414\u0432\u0443\u043c\u043e\u043d\u0438\u0442\u043e\u0440\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f, \u0441\u043e\u0437\u0434\u0430\u044e \u0444\u0440\u0435\u0439\u043c \u0441 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u043e\u0439 \u043a \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u0443 c \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u0430\u043c\u0438 0,0");
                        GraphicsDevice gd = gs[0];
                        Rectangle rec = gs[1].getDefaultConfiguration().getBounds();
                        if (rec.x == 0 && rec.y == 0) {
                            gd = gs[1];
                        }
                        TerminalApplication.this.log.info((Object)("\u041a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b: " + gd.getDefaultConfiguration().getBounds()));
                        ScreenUtil.setScreenSize((Rectangle)gd.getDefaultConfiguration().getBounds());
                        TerminalApplication.this.frame = new BaseFrame(gd.getDefaultConfiguration());
                    } else {
                        TerminalApplication.this.log.info((Object)"\u0414\u0432\u0443\u043c\u043e\u043d\u0438\u0442\u043e\u0440\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f, \u0441\u043e\u0437\u0434\u0430\u044e \u0444\u0440\u0435\u0439\u043c \u0441 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u043e\u0439 \u043a \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u0443 0");
                        TerminalApplication.this.log.info((Object)("\u041a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b: " + gs[0].getDefaultConfiguration().getBounds()));
                        ScreenUtil.setScreenSize((Rectangle)gs[0].getDefaultConfiguration().getBounds());
                        TerminalApplication.this.frame = new BaseFrame(gs[0].getDefaultConfiguration());
                    }
                    FrameStore.setFrame((JFrame)TerminalApplication.this.frame);
                    DriverControl control = TerminalApplication.this.cashAcceptor.getDriverControl();
                    if (control != null) {
                        TerminalApplication.this.frame.addKeyListener((KeyListener)new GuiControl(control));
                    }
                    UIManager.put("ScrollBar.width", Scaler.x((int)45));
                    TerminalApplication.this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f ************************");
                    if (Configuration.getInstance().getShowCursor() == null || !Configuration.getInstance().getShowCursor().booleanValue()) {
                        TerminalApplication.this.frame.setCursor(TerminalApplication.this.frame.getToolkit().createCustomCursor(new BufferedImage(3, 3, 2), new Point(0, 0), "null"));
                    }
                    TerminalApplication.this.context = new BaseApplicationContext(TerminalApplication.this.printerQueue, TerminalApplication.this.clientInterface, TerminalApplication.this.fraudQueue, TerminalApplication.this.jammInformer, TerminalApplication.this.watchDog, TerminalApplication.this.scheduler);
                    TerminalApplication.this.context.getModuleStore().addListener(TerminalApplication.this.commandLauncher);
                    if (TerminalApplication.this.pppWatcher != null) {
                        TerminalApplication.this.context.getModuleStore().addListener(TerminalApplication.this.pppWatcher);
                    }
                    if (Hopper.getDefaultHopper() != null && Hopper.getDefaultHopper().isFlowDownSupported()) {
                        TerminalApplication.this.threads.add(new Thread((Runnable)new HopperThrowDownThread(TerminalApplication.this.context, TerminalApplication.this.coinAcceptorBox), "HopperFrowDownThread"));
                    }
                }
            });
            this.log.info((Object)("\u041f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u044b \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u044b\u0435 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438: " + Arrays.toString(EncashmentStore.getInstance().getEncashments())));
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u044b\u0445 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0439 ************");
            EncashmentSynch encSynch = new EncashmentSynch(this.cashAcceptorBox, this.coinAcceptorBox, this.context, stateFacade.getAddStateListener(), mcProxy);
            this.threads.add(new Thread((Runnable)encSynch, "EncashmentSynch"));
            if (CoffeeMachineUtil.isCoffeeMachinePresent()) {
                CoffeeMachineSwitchModeListener cmsml = new CoffeeMachineSwitchModeListener(((BaseApplicationContext)this.context).getContextExecutor());
                this.context.getModuleStore().addListener(cmsml);
                this.context.getModuleStore().addListener(new EntryCashManagerSwitcher(this.context));
            }
            try {
                if (CardModuleStore.getInstance().isInit()) {
                    if (CardModuleStore.getInstance().isNeedReverse()) {
                        CardModuleStore.getInstance().reverse();
                    }
                    this.context.getModuleStore().addListener(new CardBackManager(this.context));
                }
            }
            catch (Throwable cmsml) {
                // empty catch block
            }
            if (this.printer instanceof LeoKkm) {
                this.createLoggerWithViewAppender("zrep", "add/zrep", "zrepview");
                ZReportCloseThread zrct = new ZReportCloseThread((LeoKkm)this.printer, this.context, stateFacade.getAddStateListener());
                this.threads.add(new Thread((Runnable)zrct, "ZReportCloseThread"));
            }
            UPSManager upsManager = UPSManager.getInstance();
            upsManager.addListener(stateFacade.getUpsListener());
            upsManager.setContext(this.context);
            this.threads.add(new Thread((Runnable)upsManager, "UPSManager"));
            this.frameMaximizer = new FrameMaximizer((JFrame)this.frame);
            if (conf.getOnTop() != null && !conf.getOnTop().booleanValue()) {
                this.frameMaximizer.setTop(false);
            }
            this.threads.add(new Thread((Runnable)this.frameMaximizer, "FrameMaximizer"));
            ManagerPL managerPL = ManagerPL.getInstance();
            this.context.getModuleStore().addListener(managerPL);
            this.threads.add(new Thread((Runnable)managerPL, "ManagerPL"));
            moneyCollectionObserver.setContext((BaseApplicationContext)this.context);
            this.cashCollectionHandler.setApplicationContext(this.context);
            this.coinCollectionHandler.setApplicationContext(this.context);
            ProblemNotifier.setDefaultNotifier((ProblemNotifier)new SimpleProblemNotifier(this.context));
            B.setNoMessageListener((NoMessageListener)new NoMessageListenerImpl());
            InputModuleFactory.init(this.context);
            this.log.info((Object)"\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u044c \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0439 \u0432 \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0435 \u043c\u0435\u043d\u044e");
            InputModule sp = InputModuleFactory.getModule(ProviderType.AdminProvider);
            if (sp != null && sp instanceof AdminInputModule) {
                AdminInputModule ap = (AdminInputModule)sp;
                ap.setCollectionHandlers(this.cashCollectionHandler, this.coinCollectionHandler);
                ap.setFrameMaximizer(this.frameMaximizer);
                this.cashAcceptor.addStatusObserver((ValidatorStatusListener)ap);
                this.printerQueue.addObserver((ru.softlogic.hardware.device.print.status.PrinterStatusObserver)ap);
                this.serverInterface.addRemoteStatusObserver((RemoteStatusObserver)ap);
                this.serverInterface.addNetObserver((NetObserver)ap);
                this.context.getModuleStore().addListener(ap);
                if (this.fraudQueueAgent != null) {
                    this.fraudQueueAgent.addAgentListener(ap.getQueueAgentListener());
                } else {
                    this.queueAgent.addAgentListener(ap.getQueueAgentListener());
                }
            }
            if ((rm = InputModuleFactory.getModule(ProviderType.RunExternal)) != null && rm instanceof RunnerModule) {
                RunnerModule ap = (RunnerModule)rm;
                ap.setFrameMaximizer(this.frameMaximizer);
            }
            if (Hopper.getDefaultHopper() != null && (sp = InputModuleFactory.getModule(ProviderType.CoinHopperProvider)) != null && sp instanceof CoinHopperInputModule) {
                CoinHopperInputModule chim = (CoinHopperInputModule)sp;
                chim.setCoinBox(this.coinAcceptorBox);
            }
            int startTime = (int)((System.currentTimeMillis() - begin) / 1000L);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            String res = (int)dim.getWidth() + "x" + (int)dim.getHeight();
            this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f: " + startTime + " c"));
            this.log.info((Object)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u043e\u043a\u0440\u0443\u0436\u0435\u043d\u0438\u0438: ");
            this.log.info((Object)("  \u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e                   : " + DaemonVersion.version));
            this.log.info((Object)("  \u0412\u0435\u0440\u0441\u0438\u044f Java                 : " + SystemProp.getJavaVersion()));
            this.log.info((Object)("  \u0412\u0435\u0440\u0441\u0438\u044f OS                   : " + SystemProp.getOSName() + " " + SystemProp.getOSVersion() + " " + SystemProp.getOSArch()));
            this.log.info((Object)("  \u0414\u043e\u043c\u0430\u0448\u043d\u044f\u044f \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f         : " + conf.getApplicationDir()));
            this.log.info((Object)("  \u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435 \u044d\u043a\u0440\u0430\u043d\u0430           : " + res));
            this.threads.add(new Thread((Runnable)new DiskObserver(this.clientInterface), "DiskObserver"));
            this.threads.add(new Thread((Runnable)new Rebooter(stateFacade.getDisplayStateLIstener()), "Rebooter"));
            this.threads.add(new Thread((Runnable)new ErrorDumpProcessor(this.clientInterface), "ErrorDumpProcessor"));
            if (!SystemProp.isClickCheckerDisable()) {
                this.threads.add(new Thread((Runnable)new ClickChecker(), "ClickChecker"));
            }
            this.threads.add(new Thread((Runnable)new ChangeCancelManager(this.clientInterface, (BaseApplicationContext)this.context), "ChangeCancelManager"));
            this.log.info((Object)"*** \u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043f\u043e\u0442\u043e\u043a\u0438 ***********************************");
            for (Thread t : this.threads) {
                this.log.info((Object)("\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e: " + t.getName()));
                t.start();
            }
            this.log.info((Object)"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435");
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TerminalApplication.this.frame.setVisible(true);
                        TerminalApplication.this.context.toMainMenu();
                        if ("ADMIN".equals(SystemProp.getStartModule())) {
                            AppEnvironment.getInstance().open(ProviderType.AdminProvider);
                        }
                    }
                });
                if ((reboot & 0x40) == 0) {
                    this.clientInterface.sendEvent(new ru.softlogic.srv.api.event.Event(EventType.Start, "cause=" + AppB.get("start." + Integer.toHexString(reboot)) + ", app.st=" + startTime));
                }
                for (ru.softlogic.srv.api.event.Event event : this.updateEvents) {
                    this.clientInterface.sendEvent(event);
                }
                Object obj = DaemonUtil.readObject((String)"_update_exception", (boolean)true);
                if (obj != null && obj instanceof Exception) {
                    Exception ex = (Exception)obj;
                    this.clientInterface.sendEvent(new ru.softlogic.srv.api.event.Event(EventType.UpdateFault, ex.getMessage()));
                }
                this.log.info((Object)"************* \u0417\u0430\u043f\u0443\u0441\u043a \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e *************");
                if (AppDefaults.getInstance().getBooleanProperty("preloading.enable", false)) {
                    this.log.info((Object)"************* \u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043f\u0440\u0435\u0434\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0443 \u0444\u043e\u0440\u043c \u0438 \u044d\u043a\u0440\u0430\u043d\u043e\u0432 *************");
                    this.context.getTaskExecutor().execute(new PreloaderTask(this.context));
                }
                try {
                    FederalNumberValidator.getInstance();
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            }
            catch (Throwable ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0443\u0441\u043a\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f", ex);
                this.stop();
            }
        }
        catch (Throwable ex) {
            this.log.error((Object)ex, ex);
            System.exit(1);
        }
    }

    public void stop() {
        if (this.threads != null) {
            for (Thread t : this.threads) {
                this.log.info((Object)("\u041e\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e: " + t.getName()));
                t.interrupt();
            }
            for (Thread t : this.threads) {
                try {
                    this.log.info((Object)("\u041e\u0436\u0438\u0434\u0430\u044e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f: " + t.getName()));
                    t.join();
                    this.log.info((Object)("\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d: " + t.getName()));
                }
                catch (Exception ex) {
                    this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u043f\u043e\u0442\u043e\u043a\u0430 " + t.getName() + ", " + ex.getMessage()));
                }
            }
        }
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        this.log.info((Object)"\u041e\u0441\u0442\u0430\u043d\u043e\u0432 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f");
    }

    public void closeFiles() {
        this.cashAcceptorBox.close();
        this.coinAcceptorBox.close();
    }

    private Logger createLogger(String name, String path, Level level) {
        Logger itemLogger = Logger.getLogger((String)name);
        itemLogger.setAdditivity(false);
        itemLogger.setLevel(level);
        DailyRollingFileAppender drfa = new DailyRollingFileAppender();
        drfa.setEncoding("UTF-8");
        drfa.setLayout((Layout)new PatternLayout("%d{ABSOLUTE} %5p [%t] %m%n"));
        drfa.setFile(PathUtils.getPath((String)("/log/" + path + ".log")));
        drfa.setDatePattern("'.'yyyy-MM-dd");
        drfa.activateOptions();
        itemLogger.addAppender((Appender)drfa);
        return itemLogger;
    }

    private Logger createLoggerWithViewAppender(String name, String path, String appenderName, Level level) {
        Logger itemLogger = Logger.getLogger((String)name);
        itemLogger.setAdditivity(false);
        itemLogger.setLevel(level);
        DailyRollingFileAppender drfa = new DailyRollingFileAppender();
        drfa.setEncoding("UTF-8");
        drfa.setLayout((Layout)new PatternLayout("%d{ABSOLUTE} %5p [%t] %m%n"));
        drfa.setFile(PathUtils.getPath((String)("/log/" + path + ".log")));
        drfa.setDatePattern("'.'yyyy-MM-dd");
        drfa.activateOptions();
        itemLogger.addAppender((Appender)drfa);
        ViewAppender va = new ViewAppender();
        va.setLayout((Layout)new PatternLayout("%d{ABSOLUTE} %5p [%t] %m%n"));
        va.setName(appenderName);
        itemLogger.addAppender((Appender)va);
        return itemLogger;
    }

    private Logger createLogger(String name, String path) {
        return this.createLogger(name, path, Level.INFO);
    }

    private Logger createLoggerWithViewAppender(String name, String path, String appenderName) {
        return this.createLoggerWithViewAppender(name, path, appenderName, Level.INFO);
    }

    private class ImagePreLoader
    implements Runnable {
        private ImagePreLoader() {
        }

        @Override
        public void run() {
            TerminalApplication.this.log.info((Object)"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043f\u0440\u0435\u0434\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0443 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449");
            try {
                TerminalApplication.this.log.info((Object)"\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438");
                ReferenceManager.getInstance();
            }
            catch (Exception ex) {
                TerminalApplication.this.log.error((Object)ex, (Throwable)ex);
            }
            try {
                TerminalApplication.this.log.info((Object)"\u041a\u0430\u0440\u0442\u0438\u043d\u043a\u0438");
                ComponentFactory.getInstance().createDialog(DialogType.Info, "\u0422\u0435\u0441\u0442", 10, DC.cases((int)8), UserCase.Ok);
            }
            catch (Exception ex) {
                TerminalApplication.this.log.error((Object)ex, (Throwable)ex);
            }
            TerminalApplication.this.log.info((Object)"\u041f\u0440\u0435\u0434\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
        }
    }

    private class LocalBarcodeScannerListener
    implements BarcodeScannerListener {
        private static final String CASH_ACTION = "encashment";
        private static final String COIN_ACTION = "encoinment";
        private static final String BOTH_ACTION = "allmoney";

        private LocalBarcodeScannerListener() {
        }

        public void onData(String data) {
            TerminalApplication.this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0434\u0430\u043d\u043d\u044b\u0435 \u043e\u0442 \u0441\u043a\u0430\u043d\u0435\u0440\u0430 \u0448\u0442\u0440\u0438\u0445\u043a\u043e\u0434\u0430: " + data));
            try {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Collection.barcode.error"), 10, DC.cases((int)8), UserCase.Ok);
                if (data != null && !data.isEmpty()) {
                    boolean permitCash;
                    String[] strs = data.split("\\|");
                    String userLogin = null;
                    String userPass = null;
                    String actionName = "";
                    if (strs.length <= 1) {
                        return;
                    }
                    actionName = strs[0];
                    userLogin = strs[1];
                    ServerUser curUser = null;
                    if (strs.length > 2) {
                        userPass = strs[2];
                    } else {
                        ServerUser[] serverUsers;
                        for (ServerUser su : serverUsers = ReferenceManager.getInstance().getServerUsers()) {
                            if (!userLogin.equals(su.getLogin())) continue;
                            curUser = su;
                            break;
                        }
                    }
                    if (curUser == null) {
                        curUser = UsersUtil.authentication(userLogin, userPass);
                    }
                    if (curUser == null) {
                        TerminalApplication.this.context.showDialog((DialogInterface)dialog);
                        return;
                    }
                    boolean permitCoin = UsersUtil.canShowButton(curUser, "main", "coinMoneyCollection") || UsersUtil.canShowButton(curUser, "cash", "coinMoneyCollection");
                    boolean bl = permitCash = UsersUtil.canShowButton(curUser, "main", "cashMoneyCollection") || UsersUtil.canShowButton(curUser, "cash", "cashMoneyCollection");
                    if ((!permitCoin || !permitCash) && BOTH_ACTION.equals(actionName) || !permitCoin && COIN_ACTION.equals(actionName) || !permitCash && CASH_ACTION.equals(actionName)) {
                        TerminalApplication.this.context.showDialog((DialogInterface)dialog);
                        return;
                    }
                    final ServerUser moneyUser = curUser;
                    final String moneyActionName = actionName;
                    String message = B.get((String)"Collection.question");
                    if (COIN_ACTION.equals(moneyActionName)) {
                        message = B.get((String)"Collection.coin.question");
                    } else if (BOTH_ACTION.equals(moneyActionName)) {
                        message = B.get((String)"Collection.cash.coin.question");
                    }
                    dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, message, 10, DC.cases((int)2), UserCase.Cancel);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            if (userCase == UserCase.Ok) {
                                try {
                                    if (LocalBarcodeScannerListener.CASH_ACTION.equals(moneyActionName)) {
                                        TerminalApplication.this.cashCollectionHandler.onMoneyCollection(moneyUser);
                                    } else if (LocalBarcodeScannerListener.COIN_ACTION.equals(moneyActionName)) {
                                        TerminalApplication.this.coinCollectionHandler.onMoneyCollection(moneyUser);
                                    } else if (LocalBarcodeScannerListener.BOTH_ACTION.equals(moneyActionName)) {
                                        TerminalApplication.this.cashCollectionHandler.onMoneyCollection(moneyUser);
                                        TerminalApplication.this.coinCollectionHandler.onMoneyCollection(moneyUser);
                                    }
                                }
                                catch (Exception ex) {
                                    TerminalApplication.this.log.info((Object)ex.getMessage());
                                    TerminalApplication.this.log.info((Object)Arrays.toString(ex.getStackTrace()));
                                }
                            }
                        }
                    });
                }
                TerminalApplication.this.context.showDialog((DialogInterface)dialog);
            }
            catch (Exception ex) {
                TerminalApplication.this.log.info((Object)ex.getMessage());
                TerminalApplication.this.log.info((Object)Arrays.toString(ex.getStackTrace()));
            }
        }
    }
}

