/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.task;

import java.awt.EventQueue;
import java.awt.Frame;
import java.util.concurrent.ExecutorService;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import ru.softlogic.configurator.WaitBox;
import ru.softlogic.configurator.task.Task;

public class TaskExecutor {
    private JFrame frame;
    private WaitBox waitBox;
    private ExecutorService executorService;

    public TaskExecutor(JFrame frame, ExecutorService executorService) {
        if (frame == null) {
            throw new NullPointerException("JFrame");
        }
        this.frame = frame;
        this.waitBox = new WaitBox((Frame)frame, true);
        this.waitBox.setLocationRelativeTo(null);
        this.executorService = executorService;
    }

    public void execute(Task task) {
        if (task == null) {
            throw new NullPointerException("Task");
        }
        this.executorService.submit(new ExecutorThread(task));
    }

    private class ResultRunnable
    implements Runnable {
        private final Object result;
        private final Task task;

        public ResultRunnable(Object result, Task task) {
            this.result = result;
            this.task = task;
        }

        @Override
        public void run() {
            try {
                this.task.onResult(this.result);
            }
            catch (Throwable ex) {
                Logger.getLogger((String)"start").info((Object)ex, ex);
            }
        }
    }

    private class ExecutorThread
    implements Runnable {
        private final Task task;

        public ExecutorThread(Task task) {
            this.task = task;
        }

        @Override
        public void run() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskExecutor.this.waitBox.setText(ExecutorThread.this.task.getTitle());
                    TaskExecutor.this.waitBox.setLocationRelativeTo(TaskExecutor.this.frame);
                    TaskExecutor.this.waitBox.setVisible(true);
                }
            });
            Object obj = null;
            try {
                obj = this.task.execute();
            }
            catch (Throwable ex) {
                obj = ex;
            }
            EventQueue.invokeLater(new ResultRunnable(obj, this.task));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskExecutor.this.waitBox.dispose();
                }
            });
        }
    }
}

