/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.serial;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.elements.ComboBoxItem;
import ru.softlogic.configurator.serial.PortConfiguratorListener;
import ru.softlogic.configurator.serial.PortPanel;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class PortConfigurator
extends JDialog {
    private final PortPanel portPanel;
    private SerialPort port;
    private final LazyInitializator initializator;
    private final Set<PortConfiguratorListener> listeners;

    public PortConfigurator(Frame parent, boolean modal, LazyInitializator initializator) {
        super(parent, modal);
        this.initializator = initializator;
        this.initComponents();
        this.setMinimumSize(new Dimension(500, 280));
        this.portPanel = new PortPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.portPanel);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PortConfigurator.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.portPanel.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PortConfigurator.this.setVisible(false);
            }
        });
        this.portPanel.getSaveButton().addActionListener(new LocalSaveListener());
        this.listeners = new HashSet<PortConfiguratorListener>();
    }

    public void init(SerialPort port) {
        this.port = port;
        if (port != null) {
            this.portPanel.getPortLabel().setText("<html><p style='width:" + Scaler.x((int)300) + "px; word-break: break-all;'>" + port.getName() + "</p></html>");
            this.portPanel.getPortLabel().setVerticalAlignment(1);
            this.portPanel.getPortLabel().setVerticalTextPosition(1);
            SerialParams sp = port.getParams();
            this.portPanel.getSpeedComboBox().setSelectedItem(new ComboBoxItem(sp.getSpeed(), null));
            this.portPanel.getDataBitsComboBox().setSelectedItem(new ComboBoxItem(sp.getDataBits(), null));
            this.portPanel.getStopBitsComboBox().setSelectedItem(new ComboBoxItem(sp.getStopBits(), null));
            this.portPanel.getParityComboBox().setSelectedItem(new ComboBoxItem(sp.getParity(), null));
        } else {
            this.portPanel.getPortLabel().setText("");
            this.portPanel.getSpeedComboBox().setSelectedItem(new ComboBoxItem(null, null));
            this.portPanel.getDataBitsComboBox().setSelectedItem(new ComboBoxItem(null, null));
            this.portPanel.getStopBitsComboBox().setSelectedItem(new ComboBoxItem(null, null));
            this.portPanel.getParityComboBox().setSelectedItem(new ComboBoxItem(null, null));
        }
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setResizable(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.pack();
    }

    public void addListener(PortConfiguratorListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private class LocalSaveListener
    implements ActionListener {
        private LocalSaveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ComboBoxItem cbi = (ComboBoxItem)PortConfigurator.this.portPanel.getSpeedComboBox().getSelectedItem();
            Integer speed = (Integer)cbi.getObject();
            cbi = (ComboBoxItem)PortConfigurator.this.portPanel.getDataBitsComboBox().getSelectedItem();
            DataBits db = (DataBits)cbi.getObject();
            cbi = (ComboBoxItem)PortConfigurator.this.portPanel.getStopBitsComboBox().getSelectedItem();
            StopBits sb = (StopBits)cbi.getObject();
            cbi = (ComboBoxItem)PortConfigurator.this.portPanel.getParityComboBox().getSelectedItem();
            Parity pt = (Parity)cbi.getObject();
            SerialParams sp = new SerialParams(speed.intValue(), db, sb, pt);
            PortConfigurator.this.port.putParams(sp);
            for (PortConfiguratorListener pcl : PortConfigurator.this.listeners) {
                pcl.onResult(PortConfigurator.this.port);
            }
            PortConfigurator.this.setVisible(false);
        }
    }
}

