/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.panels.print;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.jdesktop.application.ResourceMap;
import ru.softlogic.configurator.Application;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.app.NameExtractor;
import ru.softlogic.configurator.elements.ComboBoxItem;
import ru.softlogic.configurator.panels.print.FiscalPrinterPanel;
import ru.softlogic.configurator.panels.print.IppPrinterPanel;
import ru.softlogic.configurator.panels.print.PosPrinterPanel;
import ru.softlogic.hardware.device.DeviceClass;

public class PrinterPanel
extends JPanel {
    private PosPrinterPanel posPrinterPanel;
    private FiscalPrinterPanel fiscalPrinterPanel;
    private IppPrinterPanel ippPrinterPanel;
    private final LazyInitializator initializator;
    private JPanel contentPanel;
    private JButton exitButton;
    private JButton initKkmButton;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JButton portConfButton;
    private JButton saveButton;
    private JButton scanPortsButton;
    private JButton scanPrinterButton;
    private JButton testButton;
    private JComboBox typeComboBox;
    private JLabel typeLabel;
    private JCheckBox usePaperNearEndSensor;

    public PrinterPanel(LazyInitializator initializator) {
        this.initializator = initializator;
        this.initComponents();
        this.init();
    }

    public final void init() {
        ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(org.jdesktop.application.Application.class).getContext().getResourceMap(PrinterPanel.class);
        LinkedList<ComboBoxItem> items = new LinkedList<ComboBoxItem>();
        items.add(new ComboBoxItem(null, NameExtractor.getUndefinedName()));
        items.add(new ComboBoxItem(DeviceClass.PosPrinter, NameExtractor.getComboBoxTitle(resourceMap.getString("PrinterPanel.type.posprinter", new Object[0]))));
        items.add(new ComboBoxItem(DeviceClass.FiscalPrinter, NameExtractor.getComboBoxTitle(resourceMap.getString("PrinterPanel.type.fiscal", new Object[0]))));
        items.add(new ComboBoxItem(DeviceClass.IppPrinter, NameExtractor.getComboBoxTitle(resourceMap.getString("PrinterPanel.type.ipp", new Object[0]))));
        this.typeComboBox.setModel(new DefaultComboBoxModel<ComboBoxItem>(items.toArray(new ComboBoxItem[items.size()])));
        this.typeComboBox.setSelectedIndex(0);
    }

    public JComboBox getTypeComboBox() {
        return this.typeComboBox;
    }

    public JButton getExitButton() {
        return this.exitButton;
    }

    public JButton getPortConfButton() {
        return this.portConfButton;
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public JButton getScanPortsButton() {
        return this.scanPortsButton;
    }

    public JButton getScanPrinterButton() {
        return this.scanPrinterButton;
    }

    public JButton getTestButton() {
        return this.testButton;
    }

    public JButton getInitKkmButton() {
        return this.initKkmButton;
    }

    public JCheckBox getUsePaperNearEndSensor() {
        return this.usePaperNearEndSensor;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.scanPrinterButton = new JButton();
        this.testButton = new JButton();
        this.portConfButton = new JButton();
        this.scanPortsButton = new JButton();
        this.exitButton = new JButton();
        this.saveButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.initKkmButton = new JButton();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.contentPanel = new JPanel();
        this.usePaperNearEndSensor = new JCheckBox();
        ResourceMap resourceMap = ((Application)org.jdesktop.application.Application.getInstance(Application.class)).getContext().getResourceMap(PrinterPanel.class);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("actions.title", new Object[0]), 0, 0, new Font("Tahoma", 0, 15)));
        this.scanPrinterButton.setFont(new Font("Tahoma", 0, 15));
        this.scanPrinterButton.setText(resourceMap.getString("PrinterPanel.scanPrinterButton.text", new Object[0]));
        this.testButton.setFont(new Font("Tahoma", 0, 15));
        this.testButton.setText(resourceMap.getString("PrinterPanel.testButton.text", new Object[0]));
        this.portConfButton.setFont(new Font("Tahoma", 0, 15));
        this.portConfButton.setText(resourceMap.getString("actions.portConfButton.text", new Object[0]));
        this.scanPortsButton.setFont(new Font("Tahoma", 0, 15));
        this.scanPortsButton.setText(resourceMap.getString("actions.scanPortsButton.text", new Object[0]));
        this.exitButton.setFont(new Font("Tahoma", 0, 15));
        this.exitButton.setText(resourceMap.getString("actions.exitButton.text", new Object[0]));
        this.saveButton.setFont(new Font("Tahoma", 0, 15));
        this.saveButton.setText(resourceMap.getString("actions.saveButton.text", new Object[0]));
        this.initKkmButton.setFont(new Font("Tahoma", 0, 15));
        this.initKkmButton.setText(resourceMap.getString("PrinterPanel.initKkmButton.text", new Object[0]));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.initKkmButton, GroupLayout.Alignment.LEADING, -1, 228, Short.MAX_VALUE).addComponent(this.jSeparator2, GroupLayout.Alignment.LEADING, -1, 228, Short.MAX_VALUE).addComponent(this.testButton, GroupLayout.Alignment.LEADING, -1, 228, Short.MAX_VALUE).addComponent(this.scanPrinterButton, GroupLayout.Alignment.LEADING, -1, 228, Short.MAX_VALUE).addComponent(this.exitButton, GroupLayout.Alignment.LEADING, -1, 228, Short.MAX_VALUE).addComponent(this.saveButton, GroupLayout.Alignment.LEADING, -1, 228, Short.MAX_VALUE).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING, -1, 228, Short.MAX_VALUE).addComponent(this.portConfButton, -1, 228, Short.MAX_VALUE).addComponent(this.scanPortsButton, GroupLayout.Alignment.LEADING, -1, 228, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.scanPrinterButton, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testButton, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.portConfButton, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanPortsButton, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.initKkmButton, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 106, Short.MAX_VALUE).addComponent(this.saveButton, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exitButton, -2, 35, -2).addContainerGap()));
        this.typeLabel.setFont(new Font("Tahoma", 0, 15));
        this.typeLabel.setText(resourceMap.getString("PrinterPanel.typeLabel.text", new Object[0]));
        this.typeComboBox.setFont(new Font("Tahoma", 0, 15));
        this.typeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PrinterPanel.this.typeComboBoxItemStateChanged(evt);
            }
        });
        this.contentPanel.setLayout(new BorderLayout());
        this.usePaperNearEndSensor.setFont(new Font("Tahoma", 0, 14));
        this.usePaperNearEndSensor.setText(resourceMap.getString("PrinterPanel.usePaperNearEndSensor.text", new Object[0]));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contentPanel, -1, 419, Short.MAX_VALUE).addComponent(this.typeLabel, -1, 419, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.typeComboBox, 0, 200, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.usePaperNearEndSensor, -1, 201, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.typeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.usePaperNearEndSensor, -2, 35, -2).addComponent(this.typeComboBox, -2, 35, -2)).addGap(18, 18, 18).addComponent(this.contentPanel, -1, 378, Short.MAX_VALUE))).addContainerGap()));
    }

    private void typeComboBoxItemStateChanged(ItemEvent evt) {
        if (evt != null && evt.getStateChange() == 1) {
            DeviceClass dc;
            this.contentPanel.setVisible(false);
            this.contentPanel.removeAll();
            ComboBoxItem cbi = (ComboBoxItem)evt.getItem();
            this.scanPrinterButton.setEnabled(true);
            if (cbi != null && (dc = (DeviceClass)cbi.getObject()) != null) {
                if (dc == DeviceClass.PosPrinter) {
                    this.scanPrinterButton.setEnabled(true);
                    PosPrinterPanel p = this.getPosPrinterPanel();
                    this.contentPanel.add(p);
                } else if (dc == DeviceClass.FiscalPrinter) {
                    this.scanPrinterButton.setEnabled(true);
                    FiscalPrinterPanel p = this.getFiscalPrinterPanel();
                    this.contentPanel.add(p);
                } else if (dc == DeviceClass.IppPrinter) {
                    this.scanPrinterButton.setEnabled(false);
                    this.contentPanel.add(this.getIppPrinterPanel());
                }
            }
            this.initializator.updateGui();
            this.contentPanel.setVisible(true);
        }
    }

    public PosPrinterPanel getPosPrinterPanel() {
        if (this.posPrinterPanel == null) {
            this.posPrinterPanel = new PosPrinterPanel();
        }
        return this.posPrinterPanel;
    }

    public FiscalPrinterPanel getFiscalPrinterPanel() {
        if (this.fiscalPrinterPanel == null) {
            this.fiscalPrinterPanel = new FiscalPrinterPanel();
        }
        return this.fiscalPrinterPanel;
    }

    public IppPrinterPanel getIppPrinterPanel() {
        if (this.ippPrinterPanel == null) {
            this.ippPrinterPanel = new IppPrinterPanel();
        }
        return this.ippPrinterPanel;
    }
}

