/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.panels;

import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.jdesktop.application.ResourceMap;
import ru.softlogic.configurator.Application;
import ru.softlogic.configurator.app.NameExtractor;
import ru.softlogic.configurator.elements.ComboBoxItem;
import ru.softlogic.configurator.elements.DigitalDocument;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.watchdog.WatchDogDescriptor;

public class WatchDogPanel
extends JPanel {
    private JPanel addTabPanel;
    private JButton exitButton;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator2;
    private JPanel mainTabPanel;
    private JPanel mappingTabPanel;
    private JTable mappingTable;
    private JButton modemChannelButton;
    private JLabel modemChannelLabel;
    private JTextField modemChannelTextField;
    private JButton portConfButton;
    private JLabel portLabel;
    private JLabel portParamsLabel;
    private JComboBox portsComboBox;
    private JButton rebootPcTimeoutButton;
    private JLabel rebootPcTimeoutLabel;
    private JTextField rebootPcTimeoutTextField;
    private JButton saveButton;
    private JButton scanPortsButton;
    private JButton scanWatchDogButton;
    private JTabbedPane tabbedPane;
    private JButton testButton;
    private JLabel typeDescriptionLabel;
    private JLabel typeLabel;
    private JComboBox typesComboBox;

    public WatchDogPanel() {
        this.initComponents();
        this.init();
        this.myInit();
        this.modemChannelTextField.setDocument(new DigitalDocument(2));
        this.rebootPcTimeoutTextField.setDocument(new DigitalDocument(2));
    }

    public final void init() {
        List<ComboBoxItem> model = NameExtractor.getModelByType(DeviceClass.WatchDog);
        this.typesComboBox.setModel(new DefaultComboBoxModel<ComboBoxItem>(model.toArray(new ComboBoxItem[model.size()])));
        this.portParamsLabel.setText("");
    }

    private void myInit() {
    }

    public void setChannelColumnModel(List<ComboBoxItem> channelsModel) {
        TableColumn channelColumn = this.mappingTable.getColumnModel().getColumn(1);
        JComboBox<ComboBoxItem> comboBox = new JComboBox<ComboBoxItem>(new DefaultComboBoxModel<ComboBoxItem>(channelsModel.toArray(new ComboBoxItem[channelsModel.size()])));
        channelColumn.setCellEditor(new DefaultCellEditor(comboBox));
    }

    public JComboBox getPortsComboBox() {
        return this.portsComboBox;
    }

    public JButton getScanPortsButton() {
        return this.scanPortsButton;
    }

    public JButton getExitButton() {
        return this.exitButton;
    }

    public JButton getPortConfButton() {
        return this.portConfButton;
    }

    public JLabel getPortParamsLabel() {
        return this.portParamsLabel;
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public JButton getScanWatchDogButton() {
        return this.scanWatchDogButton;
    }

    public JLabel getTypeDescriptionLabel() {
        return this.typeDescriptionLabel;
    }

    public JComboBox getTypesComboBox() {
        return this.typesComboBox;
    }

    public JButton getTestButton() {
        return this.testButton;
    }

    public JButton getModemChannelButton() {
        return this.modemChannelButton;
    }

    public JTextField getModemChannelTextField() {
        return this.modemChannelTextField;
    }

    public JLabel getModemChannelLabel() {
        return this.modemChannelLabel;
    }

    public JButton getRebootPcTimeoutButton() {
        return this.rebootPcTimeoutButton;
    }

    public JLabel getRebootPcTimeoutLabel() {
        return this.rebootPcTimeoutLabel;
    }

    public JTextField getRebootPcTimeoutTextField() {
        return this.rebootPcTimeoutTextField;
    }

    public JPanel getMappingTabPanel() {
        return this.mappingTabPanel;
    }

    public JTable getMappingTable() {
        return this.mappingTable;
    }

    public void clearMappingTable() {
        ((DefaultTableModel)this.mappingTable.getModel()).setRowCount(0);
    }

    public void setChannel(Integer id, ComboBoxItem channel) {
        int rowCount = this.mappingTable.getModel().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (!id.equals(this.mappingTable.getModel().getValueAt(i, 0))) continue;
            this.mappingTable.getModel().setValueAt(channel, i, 1);
            break;
        }
    }

    public void setMappingRows(WatchDogDescriptor watchDogDescriptor) {
        Set switches = watchDogDescriptor.getSwitches();
        int i = 0;
        ((DefaultTableModel)this.mappingTable.getModel()).setRowCount(switches.size());
        for (Integer id : switches) {
            this.mappingTable.getModel().setValueAt(id, i++, 0);
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.scanWatchDogButton = new JButton();
        this.testButton = new JButton();
        this.jSeparator2 = new JSeparator();
        this.portConfButton = new JButton();
        this.scanPortsButton = new JButton();
        this.exitButton = new JButton();
        this.saveButton = new JButton();
        this.typeLabel = new JLabel();
        this.typesComboBox = new JComboBox();
        this.typeDescriptionLabel = new JLabel();
        this.portLabel = new JLabel();
        this.portsComboBox = new JComboBox();
        this.portParamsLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.mainTabPanel = new JPanel();
        this.addTabPanel = new JPanel();
        this.modemChannelLabel = new JLabel();
        this.modemChannelTextField = new JTextField();
        this.modemChannelButton = new JButton();
        this.rebootPcTimeoutButton = new JButton();
        this.rebootPcTimeoutLabel = new JLabel();
        this.rebootPcTimeoutTextField = new JTextField();
        this.mappingTabPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.mappingTable = new JTable();
        ResourceMap resourceMap = ((Application)org.jdesktop.application.Application.getInstance(Application.class)).getContext().getResourceMap(WatchDogPanel.class);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("actions.title", new Object[0]), 0, 0, new Font("Tahoma", 0, 15)));
        this.jPanel2.setMaximumSize(new Dimension(260, 800));
        this.scanWatchDogButton.setFont(new Font("Tahoma", 0, 15));
        this.scanWatchDogButton.setText(resourceMap.getString("WatchDogPanel.scanWatchDogButton.text", new Object[0]));
        this.testButton.setFont(new Font("Tahoma", 0, 15));
        this.testButton.setText(resourceMap.getString("WatchDogPanel.testButton.text", new Object[0]));
        this.portConfButton.setFont(new Font("Tahoma", 0, 15));
        this.portConfButton.setText(resourceMap.getString("actions.portConfButton.text", new Object[0]));
        this.scanPortsButton.setFont(new Font("Tahoma", 0, 15));
        this.scanPortsButton.setText(resourceMap.getString("actions.scanPortsButton.text", new Object[0]));
        this.exitButton.setFont(new Font("Tahoma", 0, 15));
        this.exitButton.setText(resourceMap.getString("actions.exitButton.text", new Object[0]));
        this.saveButton.setFont(new Font("Tahoma", 0, 15));
        this.saveButton.setText(resourceMap.getString("actions.saveButton.text", new Object[0]));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2, -1, 228, Short.MAX_VALUE).addComponent(this.testButton, -1, 228, Short.MAX_VALUE).addComponent(this.scanWatchDogButton, -1, 228, Short.MAX_VALUE).addComponent(this.portConfButton, -1, 228, Short.MAX_VALUE).addComponent(this.scanPortsButton, -2, 228, Short.MAX_VALUE).addComponent(this.exitButton, -1, 228, Short.MAX_VALUE).addComponent(this.saveButton, -2, 228, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.scanWatchDogButton, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testButton, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.portConfButton, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanPortsButton, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 188, Short.MAX_VALUE).addComponent(this.saveButton, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exitButton, -2, 35, -2).addContainerGap()));
        this.typeLabel.setFont(new Font("Tahoma", 0, 15));
        this.typeLabel.setText(resourceMap.getString("WatchDogPanel.typeLabel.text", new Object[0]));
        this.typesComboBox.setFont(new Font("Tahoma", 0, 15));
        this.typesComboBox.setMaximumRowCount(15);
        this.typeDescriptionLabel.setText(">");
        this.portLabel.setFont(new Font("Tahoma", 0, 15));
        this.portLabel.setText(resourceMap.getString("content.portLabel.text", new Object[0]));
        this.portsComboBox.setFont(new Font("Tahoma", 0, 15));
        this.portParamsLabel.setFont(new Font("Tahoma", 0, 15));
        this.portParamsLabel.setHorizontalAlignment(4);
        this.portParamsLabel.setText(">");
        this.tabbedPane.setFont(new Font("Tahoma", 0, 15));
        GroupLayout mainTabPanelLayout = new GroupLayout(this.mainTabPanel);
        this.mainTabPanel.setLayout(mainTabPanelLayout);
        mainTabPanelLayout.setHorizontalGroup(mainTabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        mainTabPanelLayout.setVerticalGroup(mainTabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.tabbedPane.addTab(resourceMap.getString("WathcDogPanel.main.tabTitle", new Object[0]), this.mainTabPanel);
        this.addTabPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 250));
        this.addTabPanel.setPreferredSize(new Dimension(400, 250));
        this.modemChannelLabel.setFont(new Font("Tahoma", 0, 15));
        this.modemChannelLabel.setText(resourceMap.getString("WatchDogPanel.modemChannelLabel.text", new Object[0]));
        this.modemChannelTextField.setFont(new Font("Tahoma", 0, 15));
        this.rebootPcTimeoutLabel.setFont(new Font("Tahoma", 0, 15));
        this.rebootPcTimeoutLabel.setText(resourceMap.getString("WatchDogPanel.rebootPcTimeoutLabel.text", new Object[0]));
        this.rebootPcTimeoutTextField.setFont(new Font("Tahoma", 0, 15));
        GroupLayout addTabPanelLayout = new GroupLayout(this.addTabPanel);
        this.addTabPanel.setLayout(addTabPanelLayout);
        addTabPanelLayout.setHorizontalGroup(addTabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, addTabPanelLayout.createSequentialGroup().addContainerGap().addGroup(addTabPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.rebootPcTimeoutLabel, GroupLayout.Alignment.LEADING, -1, 453, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, addTabPanelLayout.createSequentialGroup().addGroup(addTabPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.modemChannelLabel, GroupLayout.Alignment.LEADING, -1, 401, Short.MAX_VALUE).addComponent(this.modemChannelTextField, -1, 401, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modemChannelButton, -2, 40, -2)).addGroup(GroupLayout.Alignment.LEADING, addTabPanelLayout.createSequentialGroup().addComponent(this.rebootPcTimeoutTextField, -1, 407, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rebootPcTimeoutButton, -2, 40, -2))).addContainerGap()));
        addTabPanelLayout.setVerticalGroup(addTabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(addTabPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.modemChannelLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(addTabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.modemChannelButton, -1, -1, Short.MAX_VALUE).addComponent(this.modemChannelTextField, -2, 35, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rebootPcTimeoutLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(addTabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rebootPcTimeoutTextField, -2, 35, -2).addComponent(this.rebootPcTimeoutButton, -2, 35, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.tabbedPane.addTab(resourceMap.getString("WatchDogPanel.add.tabTitle", new Object[0]), this.addTabPanel);
        this.mappingTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"<html><table><td style=\"width:140px;height:20px;text-align:center;vertical-align:middle\">\u0414\u0430\u0442\u0447\u0438\u043a</td></table>", "<html><table><td style=\"width:140px;height:20px;text-align:center;vertical-align:middle\">\u041a\u0430\u043d\u0430\u043b</td></table>"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.mappingTable.setEnabled(false);
        this.mappingTable.setRowHeight(32);
        this.jScrollPane1.setViewportView(this.mappingTable);
        if (this.mappingTable.getColumnModel().getColumnCount() > 0) {
            this.mappingTable.getColumnModel().getColumn(0).setResizable(false);
            this.mappingTable.getColumnModel().getColumn(0).setHeaderValue(resourceMap.getString("WatchDogPanel.mapping.sensorColumn", new Object[0]));
            this.mappingTable.getColumnModel().getColumn(1).setResizable(false);
            this.mappingTable.getColumnModel().getColumn(1).setHeaderValue(resourceMap.getString("WatchDogPanel.mapping.channelColumn", new Object[0]));
        }
        GroupLayout mappingTabPanelLayout = new GroupLayout(this.mappingTabPanel);
        this.mappingTabPanel.setLayout(mappingTabPanelLayout);
        mappingTabPanelLayout.setHorizontalGroup(mappingTabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mappingTabPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1).addContainerGap()));
        mappingTabPanelLayout.setVerticalGroup(mappingTabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mappingTabPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 173, Short.MAX_VALUE).addContainerGap()));
        this.tabbedPane.addTab(resourceMap.getString("WatchDogPanel.mapping.tabTitle", new Object[0]), this.mappingTabPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane).addComponent(this.typesComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.typeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.typeDescriptionLabel, -1, -1, Short.MAX_VALUE).addComponent(this.portsComboBox, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.portLabel, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.portParamsLabel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.typeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typesComboBox, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeDescriptionLabel).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portLabel).addComponent(this.portParamsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portsComboBox, -2, 35, -2).addGap(18, 18, 18).addComponent(this.tabbedPane, -1, 304, Short.MAX_VALUE)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }
}

