/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.keyboard;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import ru.softlogic.configurator.keyboard.KeyBoardListener;
import ru.softlogic.configurator.keyboard.KeyBoardPanel;
import ru.softlogic.configurator.keyboard.ScreenKeyboard;
import ru.softlogic.configurator.utils.DialogUtils;

public class DigitalKeyboardDialog
extends ScreenKeyboard {
    private KeyBoardPanel keyBoardPanel;
    private KeyBoardListener keyBoardListener;

    public DigitalKeyboardDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.postInit();
    }

    public DigitalKeyboardDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.postInit();
    }

    private void postInit() {
        Dimension size = new Dimension(480, 370);
        this.setSize(size);
        this.setPreferredSize(size);
        this.initComponents();
        this.keyBoardPanel = new KeyBoardPanel();
        this.keyBoardPanel.getExitButton().addActionListener(new LocalExitListener());
        this.keyBoardPanel.getSaveButton().addActionListener(new LocalActionListener());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.keyBoardPanel);
        DialogUtils.setEscapeAction(this);
    }

    @Override
    public void setKeyBoardListener(KeyBoardListener keyBoardListener) {
        this.keyBoardListener = keyBoardListener;
    }

    @Override
    public void init(String value, int maxLen, boolean showExtSymbols, String title) {
        this.keyBoardPanel.init(value, maxLen, showExtSymbols, title);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(480, 339));
        this.setResizable(false);
        this.pack();
    }

    private class LocalActionListener
    implements ActionListener {
        private LocalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DigitalKeyboardDialog.this.keyBoardListener != null) {
                DigitalKeyboardDialog.this.keyBoardListener.onResult(DigitalKeyboardDialog.this.keyBoardPanel.getValueTextField().getText());
            } else {
                DigitalKeyboardDialog.this.setVisible(false);
            }
        }
    }

    private class LocalExitListener
    implements ActionListener {
        private LocalExitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DigitalKeyboardDialog.this.setVisible(false);
        }
    }
}

