/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.elements;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;

public class LetterDocument
extends PlainDocument {
    private int maxLen;
    private String prefix;

    public LetterDocument(int maxLen) {
        this(maxLen, "");
    }

    public LetterDocument(int maxLen, String prefix) {
        if (maxLen <= 0) {
            throw new IllegalArgumentException("Length must be positive");
        }
        if (prefix == null) {
            prefix = "";
        }
        this.maxLen = maxLen;
        this.prefix = prefix;
    }

    @Override
    public String getText(int offset, int length) throws BadLocationException {
        StringBuilder text = new StringBuilder(super.getText(offset, length));
        if (offset == 0) {
            text.insert(0, this.prefix);
        }
        return text.toString();
    }

    @Override
    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        super.getText(offset, length, txt);
        if (offset == 0) {
            StringBuilder text = new StringBuilder();
            text.append(this.prefix.toCharArray());
            text.append(txt.array);
            txt.array = text.toString().toCharArray();
            txt.count += this.prefix.length();
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        char[] addedFigures = str.toCharArray();
        for (int i = addedFigures.length; i > 0; --i) {
            char c = addedFigures[i - 1];
            if (this.getLength() + 1 > this.maxLen - this.prefix.length()) continue;
            super.insertString(offs, String.valueOf(c), a);
        }
    }
}

