/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.app.NameExtractor;
import ru.softlogic.configurator.elements.ComboBoxItem;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.watchdog.EventListener;
import ru.softlogic.hardware.device.watchdog.WatchDogDescriptor;
import ru.softlogic.hardware.device.watchdog.WatchDogFactory;

public class WatchDogChangeListener
implements ItemListener {
    private final LazyInitializator initializator;
    private final Map<Integer, ComboBoxItem> watchDogSwitchMap;

    public WatchDogChangeListener(LazyInitializator init, Map<Integer, ComboBoxItem> switchMap) {
        this.watchDogSwitchMap = switchMap;
        this.initializator = init;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        DeviceType type;
        if (e.getStateChange() == 1 && (type = (DeviceType)((ComboBoxItem)e.getItem()).getObject()) != null) {
            WatchDogDescriptor wdtdesc = WatchDogFactory.createDescriptor((DeviceType)type);
            if (!wdtdesc.getSwitches().containsAll(this.watchDogSwitchMap.keySet()) || !this.watchDogSwitchMap.keySet().containsAll(wdtdesc.getSwitches())) {
                for (Integer id : wdtdesc.getDefaultMapping().keySet()) {
                    EventListener.Event.Channel chan = (EventListener.Event.Channel)wdtdesc.getDefaultMapping().get(id);
                    if (chan != null) {
                        this.watchDogSwitchMap.put(id, new ComboBoxItem(wdtdesc.getDefaultMapping().get(id), NameExtractor.getComboBoxTitle(chan.toString())));
                        continue;
                    }
                    this.watchDogSwitchMap.put(id, new ComboBoxItem(wdtdesc.getDefaultMapping().get(id), NameExtractor.getComboBoxTitle(NameExtractor.getDeviceName(null))));
                }
            }
            this.initializator.updateGui();
        }
    }
}

