/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.keyboard.KeyBoardListener;
import ru.softlogic.configurator.keyboard.LetterKeyboardDialog;

public class TextEditListener
implements ActionListener {
    private final String title;
    private final JTextField field;
    private final int maxLen;
    private final LazyInitializator initializator;

    public TextEditListener(String title, JTextField field, int maxLen, LazyInitializator initializator) {
        this.title = title;
        this.field = field;
        this.maxLen = maxLen;
        this.initializator = initializator;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final LetterKeyboardDialog kbd = this.initializator.getLetterKeyboard();
        kbd.setKeyBoardListener(new KeyBoardListener(){

            @Override
            public void onResult(String data) {
                TextEditListener.this.field.setText(data);
                kbd.setVisible(false);
            }
        });
        kbd.init(this.field.getText(), this.maxLen, true, this.title);
        kbd.setVisible(true);
    }
}

