/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.panels.WatchDogPanel;
import ru.softlogic.configurator.resources.B;
import ru.softlogic.configurator.task.Task;
import ru.softlogic.configurator.task.TaskExecutor;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.watchdog.WatchDog;
import ru.softlogic.hardware.device.watchdog.WatchDogFactory;
import ru.softlogic.hardware.device.watchdog.WatchDogSettings;
import ru.softlogic.io.serial.SerialPort;

public class TestWatchDogListener
implements ActionListener {
    private final LazyInitializator initializator;
    private final WatchDogPanel panel;
    private final TaskExecutor taskExecutor;

    public TestWatchDogListener(LazyInitializator initializator, WatchDogPanel panel, TaskExecutor taskExecutor) {
        this.initializator = initializator;
        this.panel = panel;
        this.taskExecutor = taskExecutor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WatchDog wd;
        DeviceType dt = this.initializator.getDeviceTypes().get(DeviceClass.WatchDog);
        SerialPort sp = this.initializator.getSerialPort(DeviceClass.WatchDog);
        WatchDogSettings wds = new WatchDogSettings();
        if (!this.panel.getModemChannelTextField().getText().isEmpty()) {
            wds.setModemChannel(Integer.valueOf(Integer.parseInt(this.panel.getModemChannelTextField().getText())));
        }
        if ((wd = WatchDogFactory.createInstance((DeviceType)dt, (SerialPort)sp, (WatchDogSettings)wds)) != null) {
            this.taskExecutor.execute(new WatchDogActionTask(wd));
        } else {
            this.initializator.getDialog(B.get("listener.watchdog.create.err"), true);
        }
    }

    private class WatchDogActionTask
    extends Task {
        private final WatchDog watchDog;

        public WatchDogActionTask(WatchDog watchDog) {
            this.watchDog = watchDog;
        }

        @Override
        public Object execute() {
            try {
                this.watchDog.resetModem();
                return null;
            }
            catch (Exception ex) {
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            if (object == null) {
                TestWatchDogListener.this.initializator.getDialog(B.get("listener.watchdog.exec.succsess"), true);
            } else {
                TestWatchDogListener.this.initializator.getDialog(B.get("listener.watchdog.exec.fail") + object, true);
            }
        }
    }
}

