/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.TreeSet;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.manager.SessionCashStorage;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.configurator.TestCashinDialog;
import ru.softlogic.configurator.TestCashinDialogListener;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.resources.B;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.CashInFactory;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.statistics.Event;
import ru.softlogic.hardware.device.cashin.validator.statistics.StatisticListener;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatusListener;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.system.util.ThreadUtil;

public class TestValidatorWorkListener
implements ActionListener {
    private final LazyInitializator initializator;
    private final DeviceClass deviceClass;
    private Thread thread;
    private Validator validator;
    private TestCashinDialog dialog;

    public TestValidatorWorkListener(LazyInitializator initializator, DeviceClass deviceClass) {
        this.initializator = initializator;
        this.deviceClass = deviceClass;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DeviceType dt = this.initializator.getDeviceTypes().get(this.deviceClass);
        SerialPort sp = this.initializator.getSerialPort(this.deviceClass);
        this.validator = CashInFactory.createInstance((DeviceType)dt, (SerialPort)sp);
        this.validator.setCashStorage((SessionCashStorage)new TestSessionCashStorage());
        this.validator.addStatusObserver((ValidatorStatusListener)new TestStatusObserver());
        this.validator.addStatisticObserver((StatisticListener)new LocalStatisticListener());
        this.dialog = this.initializator.getCashinDialog();
        this.dialog.getTextArea().setText(B.get("listener.testcashin.init.wait") + "\n");
        this.dialog.setListener(new LocalDialogListener());
        this.thread = new Thread((Runnable)this.validator, "TestValidator");
        this.thread.setDaemon(true);
        this.thread.start();
        this.dialog.setVisible(true);
    }

    private class LocalStatisticListener
    implements StatisticListener {
        private LocalStatisticListener() {
        }

        public void notify(Event event) {
            TestValidatorWorkListener.this.dialog.getTextArea().append(MessageFormat.format(B.get("listener.testcashin.onstate"), event) + "\n");
        }
    }

    private class LocalDialogListener
    implements TestCashinDialogListener {
        private LocalDialogListener() {
        }

        @Override
        public void onClose() {
            TestValidatorWorkListener.this.validator.disable();
            ThreadUtil.sleep((long)500L);
            TestValidatorWorkListener.this.thread.interrupt();
        }
    }

    private class TestStatusObserver
    implements ValidatorStatusListener {
        private TestStatusObserver() {
        }

        public void update(final ValidatorStatus status) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TestValidatorWorkListener.this.dialog.getTextArea().append(MessageFormat.format(B.get("listener.testcashin.onstate"), status) + "\n");
                }
            });
            if (status == ValidatorStatus.Init) {
                TestValidatorWorkListener.this.validator.enable(null, new TreeSet<CashUnit>(Arrays.asList(CashFactory.getDefaultInstance().getCoinUnits())));
                TestValidatorWorkListener.this.dialog.getTextArea().append(B.get("listener.testcashin.init.ready") + "\n");
            }
        }
    }

    private class TestSessionCashStorage
    implements SessionCashStorage {
        private TestSessionCashStorage() {
        }

        public Sum getCurrentSum() {
            return new Sum();
        }

        public Sum getMaximumSum() {
            return new Sum(10000000);
        }

        public Sum getAllowedSum() {
            return new Sum(10000000);
        }

        public boolean cashPermit(CashUnit cashUnit) {
            return true;
        }

        public void addCash(final CashUnit cashUnit) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TestValidatorWorkListener.this.dialog.getTextArea().append(MessageFormat.format(B.get("listener.testcashin.oncash"), cashUnit) + "\n");
                }
            });
        }

        public void addCbc(CashBackCard cbc) {
        }

        public boolean sumPermit(Sum sum) {
            return true;
        }
    }
}

