/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.log4j.Logger;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.panels.ValidatorPanel;
import ru.softlogic.configurator.resources.B;
import ru.softlogic.configurator.task.Task;
import ru.softlogic.configurator.task.TaskExecutor;
import ru.softlogic.hardware.api.ApiFactory;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.validator.ValidatorApi;
import ru.softlogic.hardware.device.cashin.validator.ValidatorInfo;
import ru.softlogic.io.serial.SerialPort;

public class TestValidatorListener
implements ActionListener {
    private final LazyInitializator initializator;
    private final ValidatorPanel panel;
    private final TaskExecutor taskExecutor;
    private final Logger log;

    public TestValidatorListener(LazyInitializator initializator, ValidatorPanel panel, TaskExecutor taskExecutor) {
        this.initializator = initializator;
        this.panel = panel;
        this.taskExecutor = taskExecutor;
        this.log = Logger.getLogger((String)"scanner");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SerialPort sp;
        DeviceType dt = this.initializator.getDeviceTypes().get(DeviceClass.CashAcceptor);
        SerialDeviceApi api = ApiFactory.createDeviceApi((DeviceType)dt, (SerialPort)(sp = this.initializator.getSerialPort(DeviceClass.CashAcceptor)));
        if (api != null && api instanceof ValidatorApi) {
            this.taskExecutor.execute(new ValidatorActionTask((ValidatorApi)api));
        } else {
            this.initializator.getDialog(B.get("listener.cashacceptor.create.err"), true);
        }
    }

    private class ValidatorActionTask
    extends Task {
        private final ValidatorApi api;

        public ValidatorActionTask(ValidatorApi api) {
            this.api = api;
        }

        @Override
        public Object execute() {
            try {
                TestValidatorListener.this.log.info((Object)B.get("listener.cashacceptor.start"));
                this.api.open();
                this.api.test();
                TestValidatorListener.this.log.info((Object)B.get("listener.cashacceptor.finish"));
                ValidatorInfo validatorInfo = this.api.getValidatorInfo();
                return validatorInfo;
            }
            catch (Exception ex) {
                Exception exception = ex;
                return exception;
            }
            finally {
                this.api.close();
            }
        }

        @Override
        public void onResult(Object object) {
            if (object instanceof ValidatorInfo) {
                ValidatorInfo info = (ValidatorInfo)object;
                TestValidatorListener.this.panel.getFirmwareLabel().setText(info.getFirmware());
                TestValidatorListener.this.initializator.getDialog(B.get("listener.cashacceptor.exec.succsess"), true);
            } else {
                TestValidatorListener.this.panel.getFirmwareLabel().setText(B.get("ValidatorPanel.firmwareLabel.text"));
                TestValidatorListener.this.initializator.getDialog(B.get("listener.cashacceptor.exec.fail") + object, true);
            }
        }
    }
}

