/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutorService;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.Configuration;
import ru.softlogic.configurator.TestConnectionDialog;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.app.listeners.AppStateWatcherStub;
import ru.softlogic.configurator.panels.NetworkPanel;
import ru.softlogic.configurator.resources.B;
import ru.softlogic.srv.connector.AppStateWatcher;
import ru.softlogic.srv.connector.ConnectorConfiguration;
import ru.softlogic.srv.connector.ConnectorConfigurationException;
import ru.softlogic.srv.connector.ConnectorException;
import ru.softlogic.srv.connector.ConnectorFactory;
import ru.softlogic.srv.connector.ConnectorType;
import ru.softlogic.srv.connector.ProxyConfiguration;
import ru.softlogic.srv.connector.ServerInterface;
import ru.softlogic.system.util.network.Ping;

public class TestConnectionListener
implements ActionListener {
    private final JFrame owner;
    private final NetworkPanel panel;
    private final LazyInitializator lazyInitializator;
    private final ExecutorService executorService;
    private TestConnectionDialog dialog;
    private ConnectorConfiguration configuration;
    private final Logger log;
    private int counter;
    private boolean networkOk;
    private boolean psOk;
    private boolean psReady;

    public TestConnectionListener(JFrame owner, NetworkPanel panel, LazyInitializator lazyInitializator, ExecutorService executorService) {
        this.owner = owner;
        this.panel = panel;
        this.lazyInitializator = lazyInitializator;
        this.executorService = executorService;
        this.log = Logger.getLogger((String)"scanner");
        this.log.setAdditivity(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (Configuration.getInstance().getDefaultConnectorConfiguration() != null) {
            this.log.info((Object)"-----------------------------------------------------------");
            TestConnectionDialog d = this.getDialog();
            d.getPingPublicLabel().setText(B.get("listener.test-connection.result.wait"));
            d.getPingPublicLabel().setForeground(Color.BLACK);
            d.getPingPsLabel().setText(B.get("listener.test-connection.result.wait"));
            d.getPingPsLabel().setForeground(Color.BLACK);
            d.getRequestPsLabel().setText(B.get("listener.test-connection.result.wait"));
            d.getRequestPsLabel().setForeground(Color.BLACK);
            d.getHelpLabel().setText("");
            d.getTotalLabel().setText(B.get("listener.test-connection.result.wait"));
            d.getCloseButton().setEnabled(false);
            d.setVisible(true);
            this.configuration = new ConnectorConfiguration(Configuration.getInstance().getDefaultConnectorConfiguration());
            this.configuration.getParams().put("server", this.panel.getServerAddressTextField().getText());
            this.configuration.getParams().put("http-port", this.panel.getHttpPortTextField().getText());
            this.configuration.getParams().put("port", this.panel.getHttpsPortTextField().getText());
            this.log.info((Object)(B.get("listener.test-connection.conf") + this.configuration));
            this.counter = 0;
            this.executorService.submit(new PingNetwork());
            this.executorService.submit(new PingServer());
            this.executorService.submit(new RequestServer());
        } else {
            this.lazyInitializator.getDialog(B.get("listener.test-connection.err.nokey"), true);
        }
    }

    private TestConnectionDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new TestConnectionDialog((Frame)this.owner, false);
            this.dialog.setLocationRelativeTo(this.owner);
        }
        return this.dialog;
    }

    private synchronized void updateResult() {
        ++this.counter;
        if (this.counter == 3) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TestConnectionListener.this.getDialog().getCloseButton().setEnabled(true);
                    String message = null;
                    message = TestConnectionListener.this.psReady ? B.get("listener.test-connection.ok") : (TestConnectionListener.this.networkOk ? B.get("listener.test-connection.err.key") : B.get("listener.test-connection.err.network"));
                    TestConnectionListener.this.getDialog().getTotalLabel().setText(message);
                }
            });
        }
    }

    private class RequestServer
    implements Runnable {
        private RequestServer() {
        }

        @Override
        public void run() {
            TestConnectionListener.this.log.info((Object)B.get("listener.test-connection.request"));
            TestConnectionListener.this.psReady = false;
            try {
                TestConnectionListener.this.log.info((Object)B.get("listener.test-connection.request.create"));
                ProxyConfiguration proxy = new ProxyConfiguration();
                proxy.setUseProxy(TestConnectionListener.this.panel.getUseProxyCheckBox().isSelected());
                proxy.setProxyHost(TestConnectionListener.this.panel.getProxyHostTextField().getText());
                proxy.setProxyPort(TestConnectionListener.this.panel.getProxyPortTextField().getText());
                proxy.setAuthProxy(TestConnectionListener.this.panel.getUseProxyAuthCheckBox().isSelected());
                proxy.setProxyUser(TestConnectionListener.this.panel.getProxyUserTextField().getText());
                proxy.setProxyPassword(TestConnectionListener.this.panel.getProxyPasswordTextField().getText());
                ServerInterface serverInterface = ConnectorFactory.createConnector((ConnectorType)TestConnectionListener.this.configuration.getType(), (ConnectorConfiguration)TestConnectionListener.this.configuration, (ProxyConfiguration)proxy, (AppStateWatcher)new AppStateWatcherStub());
                TestConnectionListener.this.log.info((Object)B.get("listener.test-connection.request.exec"));
                TestConnectionListener.this.psReady = serverInterface.ping() != null;
                TestConnectionListener.this.log.info((Object)B.get("listener.test-connection.request.succsess"));
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TestConnectionListener.this.getDialog().getRequestPsLabel().setText(B.get("listener.test-connection.result.succsess"));
                        TestConnectionListener.this.getDialog().getRequestPsLabel().setForeground(Color.GREEN);
                    }
                });
            }
            catch (ConnectorException ex) {
                TestConnectionListener.this.log.info((Object)B.get("listener.test-connection.request.error"), (Throwable)ex);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TestConnectionListener.this.getDialog().getRequestPsLabel().setText(B.get("listener.test-connection.result.err"));
                        TestConnectionListener.this.getDialog().getRequestPsLabel().setForeground(Color.RED);
                    }
                });
            }
            catch (ConnectorConfigurationException ex) {
                TestConnectionListener.this.log.info((Object)B.get("listener.test-connection.request.error"), (Throwable)ex);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TestConnectionListener.this.getDialog().getRequestPsLabel().setText(B.get("listener.test-connection.result.err"));
                        TestConnectionListener.this.getDialog().getRequestPsLabel().setForeground(Color.RED);
                    }
                });
            }
            catch (Throwable ex) {
                TestConnectionListener.this.log.info((Object)B.get("listener.test-connection.request.error"), ex);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TestConnectionListener.this.getDialog().getRequestPsLabel().setText(B.get("listener.test-connection.result.err"));
                        TestConnectionListener.this.getDialog().getRequestPsLabel().setForeground(Color.RED);
                    }
                });
            }
            TestConnectionListener.this.updateResult();
        }
    }

    private class PingServer
    implements Runnable {
        private PingServer() {
        }

        @Override
        public void run() {
            String ip = TestConnectionListener.this.configuration != null && TestConnectionListener.this.configuration.getParams() != null ? (String)TestConnectionListener.this.configuration.getParams().get("server") : null;
            TestConnectionListener.this.log.error((Object)(B.get("listener.test-connection.ping-ps") + ip));
            TestConnectionListener.this.psOk = Ping.isAlive((String)ip);
            if (!TestConnectionListener.this.psOk) {
                TestConnectionListener.this.log.info((Object)B.get("listener.test-connection.ping-ps.err"));
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TestConnectionListener.this.getDialog().getPingPsLabel().setText(B.get("listener.test-connection.result.err"));
                        TestConnectionListener.this.getDialog().getPingPsLabel().setForeground(Color.RED);
                    }
                });
            } else {
                TestConnectionListener.this.log.info((Object)B.get("listener.test-connection.ping-ps.ok"));
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TestConnectionListener.this.getDialog().getPingPsLabel().setText(B.get("listener.test-connection.result.succsess"));
                        TestConnectionListener.this.getDialog().getPingPsLabel().setForeground(Color.GREEN);
                    }
                });
            }
            TestConnectionListener.this.updateResult();
        }
    }

    private class PingNetwork
    implements Runnable {
        private PingNetwork() {
        }

        @Override
        public void run() {
            TestConnectionListener.this.log.info((Object)B.get("listener.test-connection.ping-public"));
            TestConnectionListener.this.networkOk = Ping.isNetworkAlive();
            if (!TestConnectionListener.this.networkOk) {
                TestConnectionListener.this.log.error((Object)B.get("listener.test-connection.ping-public.err"));
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TestConnectionListener.this.getDialog().getPingPublicLabel().setText(B.get("listener.test-connection.result.err"));
                        TestConnectionListener.this.getDialog().getPingPublicLabel().setForeground(Color.RED);
                    }
                });
            } else {
                TestConnectionListener.this.log.info((Object)B.get("listener.test-connection.ping-public.ok"));
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TestConnectionListener.this.getDialog().getPingPublicLabel().setText(B.get("listener.test-connection.result.succsess"));
                        TestConnectionListener.this.getDialog().getPingPublicLabel().setForeground(Color.GREEN);
                    }
                });
            }
            TestConnectionListener.this.updateResult();
        }
    }
}

