/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import ru.softlogic.configurator.app.listeners.ScanAllHardwareListener;
import ru.softlogic.configurator.elements.ComboBoxItem;
import ru.softlogic.configurator.panels.print.PrinterPanel;
import ru.softlogic.hardware.device.DeviceClass;

public class ScanPrinterListener
implements ActionListener {
    private final PrinterPanel printerPanel;
    private final ScanAllHardwareListener listener;

    public ScanPrinterListener(PrinterPanel printerPanel, ScanAllHardwareListener listener) {
        this.printerPanel = printerPanel;
        this.listener = listener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ComboBoxItem cbi = (ComboBoxItem)this.printerPanel.getTypeComboBox().getSelectedItem();
        if (cbi != null) {
            DeviceClass deviceClass = (DeviceClass)cbi.getObject();
            if (deviceClass == DeviceClass.FiscalPrinter) {
                this.listener.init(DeviceClass.FiscalPrinter);
            } else if (deviceClass == DeviceClass.PosPrinter) {
                this.listener.init(DeviceClass.PosPrinter);
            } else {
                this.listener.init(DeviceClass.FiscalPrinter, DeviceClass.PosPrinter);
            }
            this.listener.actionPerformed(e);
        }
    }
}

