/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.elements.ComboBoxItem;
import ru.softlogic.configurator.panels.ProximityPanel;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceType;

public class ProximityTypeSelectedListener
implements ItemListener {
    private final LazyInitializator initializator;
    private final DeviceClass deviceClass;
    private final ProximityPanel proximityPanel;

    public ProximityTypeSelectedListener(LazyInitializator initializator, DeviceClass deviceClass, ProximityPanel proximityPanel) {
        this.deviceClass = deviceClass;
        this.initializator = initializator;
        this.proximityPanel = proximityPanel;
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            DeviceType dt = (DeviceType)((ComboBoxItem)evt.getItem()).getObject();
            this.initializator.getDeviceTypes().put(this.deviceClass, dt);
            if (dt == null) {
                this.proximityPanel.setMppkPathElementsVisible(false);
                this.proximityPanel.getScanReaderButton().setEnabled(true);
                this.proximityPanel.getScanPortsButton().setEnabled(true);
                this.proximityPanel.getPortsComboBox().setEnabled(true);
            } else if (dt == DeviceType.RosanProximityReader) {
                this.proximityPanel.setMppkPathElementsVisible(true);
                this.proximityPanel.getScanReaderButton().setEnabled(false);
                this.proximityPanel.getTestButton().setEnabled(false);
                this.proximityPanel.getPortConfButton().setEnabled(false);
                this.proximityPanel.getScanPortsButton().setEnabled(false);
                this.proximityPanel.getPortsComboBox().setEnabled(false);
            } else {
                this.proximityPanel.setMppkPathElementsVisible(false);
                this.proximityPanel.getScanReaderButton().setEnabled(true);
                this.proximityPanel.getTestButton().setEnabled(true);
                this.proximityPanel.getPortConfButton().setEnabled(true);
                this.proximityPanel.getScanPortsButton().setEnabled(true);
                this.proximityPanel.getPortsComboBox().setEnabled(true);
            }
            this.initializator.updateGui();
        }
    }
}

