/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import ru.softlogic.configurator.SelectKeyStoreDialogListener;
import ru.softlogic.configurator.TerminalKey;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.resources.B;
import ru.softlogic.configurator.utils.KeyLoader;

public class LocalStoreListener
implements SelectKeyStoreDialogListener {
    private final JFrame owner;
    private final LazyInitializator initializator;

    public LocalStoreListener(JFrame owner, LazyInitializator initializator) {
        this.owner = owner;
        this.initializator = initializator;
    }

    @Override
    public void loadFromFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogType(0);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(B.get("listener.loadkey.filter"), "tkey", "xml");
        fileChooser.addChoosableFileFilter(filter);
        if (fileChooser.showOpenDialog(this.owner) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                TerminalKey tk = KeyLoader.loadKey(file);
                this.initializator.loadTerminalKey(tk);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.owner, ex.getMessage(), B.get("dialog.error"), 0);
            }
        }
    }

    @Override
    public void generateAndUpload() {
        this.initializator.getLoadKeyDialog().init();
        this.initializator.getLoadKeyDialog().setVisible(true);
    }
}

