/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import ru.softlogic.application.kkm.SimpleKkmControl;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.elements.ComboBoxItem;
import ru.softlogic.configurator.panels.print.PrinterPanel;
import ru.softlogic.configurator.resources.B;
import ru.softlogic.configurator.task.Task;
import ru.softlogic.configurator.task.TaskExecutor;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.print.Printer;
import ru.softlogic.hardware.device.print.PrinterFactory;
import ru.softlogic.hardware.device.print.kkm.Kkm;
import ru.softlogic.hardware.device.print.kkm.KkmControl;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;

public class InitKkmListener
implements ActionListener {
    private final LazyInitializator initializator;
    private final TaskExecutor executor;
    private final PrinterPanel panel;

    public InitKkmListener(LazyInitializator initializator, TaskExecutor executor, PrinterPanel panel) {
        this.initializator = initializator;
        this.executor = executor;
        this.panel = panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ComboBoxItem cbi = (ComboBoxItem)this.panel.getTypeComboBox().getSelectedItem();
        DeviceClass cl = (DeviceClass)cbi.getObject();
        if (cl == null) {
            return;
        }
        if (cl == DeviceClass.FiscalPrinter) {
            SerialPort sp;
            DeviceType dt = this.initializator.getDeviceTypes().get(DeviceClass.FiscalPrinter);
            Printer prn = PrinterFactory.createFiscalPrinterInstance((DeviceType)dt, (Port)(sp = this.initializator.getSerialPort(DeviceClass.FiscalPrinter)), (boolean)this.panel.getFiscalPrinterPanel().getPrinterModeCheckBox().isSelected(), null, (KkmControl)new SimpleKkmControl());
            if (prn != null && prn instanceof Kkm) {
                this.executor.execute(new KkmInitTask((Kkm)prn));
            } else {
                this.initializator.getDialog(B.get("listener.printer.kkm.error"), true);
            }
        }
    }

    private class KkmInitTask
    extends Task {
        private final Kkm kkm;

        public KkmInitTask(Kkm kkm) {
            this.kkm = kkm;
        }

        @Override
        public Object execute() {
            try {
                this.kkm.open();
                this.kkm.setDefaultValues();
                Object var1_1 = null;
                return var1_1;
            }
            catch (Exception ex) {
                Exception exception = ex;
                return exception;
            }
            finally {
                this.kkm.close();
            }
        }

        @Override
        public void onResult(Object object) {
            if (object == null) {
                InitKkmListener.this.initializator.getDialog(B.get("listener.kkm.exec-init.succsess"), true);
            } else {
                InitKkmListener.this.initializator.getDialog(B.get("listener.kkm.exec-init.fail") + object, true);
            }
        }
    }
}

