/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.resources.B;
import ru.softlogic.configurator.task.Task;
import ru.softlogic.configurator.task.TaskExecutor;
import ru.softlogic.system.util.os.OsApi;
import ru.softlogic.system.util.os.OsException;

public class FiscalShareListener
implements ActionListener {
    private final TaskExecutor executor;
    private final LazyInitializator initializator;

    public FiscalShareListener(LazyInitializator initializator, TaskExecutor executor) {
        this.executor = executor;
        this.initializator = initializator;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.executor.execute(new FiscalShareTask("enable".equals(e.getActionCommand())));
    }

    private class FiscalShareTask
    extends Task {
        private final boolean enabled;

        public FiscalShareTask(boolean enabled) {
            super("");
            this.enabled = enabled;
        }

        @Override
        public Object execute() {
            OsException ret = null;
            try {
                OsApi.getInstance().sharingNetwork(this.enabled);
            }
            catch (OsException ex) {
                ret = ex;
            }
            return ret;
        }

        @Override
        public void onResult(Object object) {
            if (object == null) {
                FiscalShareListener.this.initializator.getDialog(B.get("ModemPanel.fiscalshare.dialog.success"), true);
            } else {
                FiscalShareListener.this.initializator.getDialog(B.get("ModemPanel.fiscalshare.dialog.fail") + object, true);
            }
        }
    }
}

