/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.elements.ComboBoxItem;
import ru.softlogic.configurator.panels.NetworkPanel;
import ru.softlogic.configurator.resources.B;
import ru.softlogic.configurator.task.Task;
import ru.softlogic.configurator.task.TaskExecutor;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.OperationResult;

public class ConnectListener
implements ActionListener {
    private final LazyInitializator initializator;
    private final TaskExecutor executor;
    private final NetworkPanel panel;
    private final ConnectionManager connectionManager;

    public ConnectListener(LazyInitializator initializator, TaskExecutor executor, NetworkPanel panel, ConnectionManager connectionManager) {
        this.initializator = initializator;
        this.executor = executor;
        this.panel = panel;
        this.connectionManager = connectionManager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ComboBoxItem cbi = (ComboBoxItem)this.panel.getConnectionsComboBox().getSelectedItem();
        this.executor.execute(new ConnectionTask((String)cbi.getObject()));
    }

    private class ConnectionTask
    extends Task {
        private final String name;

        public ConnectionTask(String name) {
            super(name);
            this.name = name;
        }

        @Override
        public Object execute() {
            return ConnectListener.this.connectionManager.connect(this.name);
        }

        @Override
        public void onResult(Object object) {
            OperationResult res = (OperationResult)object;
            if (res.isError()) {
                ConnectListener.this.initializator.getDialog(B.get("listener.connection.fail") + res.getResult(), true);
            } else {
                ConnectListener.this.initializator.getDialog(B.get("listener.connection.succsess"), true);
            }
        }
    }
}

