/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app;

import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.configurator.elements.ComboBoxItem;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.watchdog.EventListener;
import ru.softlogic.hardware.device.watchdog.WatchDogDescriptor;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.lookup.HardwareLookup;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;

public class NameExtractor {
    public static String getDeviceName(DeviceType deviceType) {
        try {
            return ResourceBundle.getBundle("ru.softlogic.configurator.resources.devices").getString("device." + deviceType);
        }
        catch (Exception ex) {
            return deviceType.toString();
        }
    }

    public static String getDeviceClassName(DeviceClass deviceClass) {
        try {
            return ResourceBundle.getBundle("ru.softlogic.configurator.resources.devices").getString("class." + deviceClass);
        }
        catch (Exception ex) {
            return deviceClass.toString();
        }
    }

    public static String getUndefinedName() {
        try {
            return NameExtractor.getComboBoxTitle(ResourceBundle.getBundle("ru.softlogic.configurator.resources.devices").getString("undefined"));
        }
        catch (Exception ex) {
            return "<?>";
        }
    }

    public static List<ComboBoxItem> getModelByType(DeviceClass deviceClass) {
        LinkedList<ComboBoxItem> model = new LinkedList<ComboBoxItem>();
        model.add(new ComboBoxItem(null, NameExtractor.getComboBoxTitle(NameExtractor.getUndefinedName())));
        for (DeviceType dt : DeviceType.getByDeviceClass((DeviceClass)deviceClass, (boolean)true)) {
            if (!AppDefaults.getInstance().isDeviceAllowed(dt)) continue;
            model.add(new ComboBoxItem(dt, NameExtractor.getComboBoxTitle(NameExtractor.getDeviceName(dt))));
        }
        return model;
    }

    public static List<ComboBoxItem> getModelByCategoryDeviceDescription(String category) {
        LinkedList<ComboBoxItem> model = new LinkedList<ComboBoxItem>();
        model.add(new ComboBoxItem(null, NameExtractor.getComboBoxTitle(NameExtractor.getUndefinedName())));
        for (DeviceDescription dd : HardwareLookup.lookup((String)category)) {
            model.add(new ComboBoxItem(dd, dd.getName()));
        }
        return model;
    }

    public static List<ComboBoxItem> getWatchDogChannelsModel(WatchDogDescriptor watchDogDescriptor) {
        LinkedList<ComboBoxItem> eventsModel = new LinkedList<ComboBoxItem>();
        eventsModel.add(new ComboBoxItem(null, NameExtractor.getComboBoxTitle(NameExtractor.getUndefinedName())));
        for (EventListener.Event.Channel ev : watchDogDescriptor.getChannels()) {
            eventsModel.add(new ComboBoxItem(ev, NameExtractor.getComboBoxTitle(ev.toString())));
        }
        return eventsModel;
    }

    public static String getDeviceDescription(DeviceType deviceType) {
        try {
            return ResourceBundle.getBundle("ru.softlogic.configurator.resources.devices").getString("device." + deviceType + ".description");
        }
        catch (Exception ex) {
            return ResourceBundle.getBundle("ru.softlogic.configurator.resources.devices").getString("device.null.description");
        }
    }

    public static String getDeviceDescription(DeviceDescription dd) {
        return dd == null ? null : dd.getDescription();
    }

    public static String getPortDescription(SerialPort port) {
        if (port == null) {
            return "";
        }
        SerialParams sp = port.getParams();
        return sp.toString();
    }

    public static String getComboBoxTitle(String title) {
        return "<html><table><td style=\"height:25px;text-align:left;vertical-align:middle\">" + title + "</td></table>";
    }
}

