/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app;

import ru.softlogic.configurator.elements.ComboBoxItem;
import ru.softlogic.configurator.panels.print.FiscalPrinterPanel;
import ru.softlogic.configurator.panels.print.PosPrinterPanel;
import ru.softlogic.hardware.device.print.kkm.KkmOptions;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;

public class Helper {
    public static KkmOptions extractOption(FiscalPrinterPanel fpp) {
        KkmOptions opt = new KkmOptions();
        ComboBoxItem cbi = (ComboBoxItem)fpp.getPresenterComboBox().getSelectedItem();
        opt.setPresenterMode((Integer)cbi.getObject());
        String scroll = fpp.getScrollTextField().getText();
        if (scroll != null && scroll.matches("^\\d+$")) {
            opt.setScroll(Integer.valueOf(Integer.parseInt(scroll)));
        } else {
            opt.setScroll(null);
        }
        String width = fpp.getPrintWidthTextField().getText();
        if (width != null && width.matches("^\\d+$")) {
            opt.setWidth(Integer.valueOf(Integer.parseInt(width)));
        } else {
            opt.setWidth(null);
        }
        if (!fpp.getAdminPasswordTextField().getText().isEmpty()) {
            opt.setAdminPassword(fpp.getAdminPasswordTextField().getText());
        }
        if (!fpp.getOperPasswordTextField().getText().isEmpty()) {
            opt.setOperatorPassword(fpp.getOperPasswordTextField().getText());
        }
        return opt;
    }

    public static PosPrinterOptions extractPosPrinterOptions(PosPrinterPanel ppp) {
        PosPrinterOptions ppo = new PosPrinterOptions();
        if (ppp.getLeftMarginField().getText().matches("^\\d+$")) {
            ppo.setLeftMargin(Integer.parseInt(ppp.getLeftMarginField().getText()));
        }
        if (ppp.getPrintWidthTextField().getText().matches("^\\d+$")) {
            ppo.setWidth(Integer.parseInt(ppp.getPrintWidthTextField().getText()));
        }
        if (ppp.getScrollTextField().getText().matches("^\\d+$")) {
            ppo.setScroll(Integer.parseInt(ppp.getScrollTextField().getText()));
        }
        if (ppp.getDispenseTextField().getText().matches("^\\d+$")) {
            ppo.setDispense(Integer.valueOf(Integer.parseInt(ppp.getDispenseTextField().getText())));
        }
        ppo.setSpan(((Integer)((ComboBoxItem)ppp.getLineSpanComboBox().getSelectedItem()).getObject()).intValue());
        ppo.setFontSize(((Integer)((ComboBoxItem)ppp.getFontSizeComboBox().getSelectedItem()).getObject()).intValue());
        ppo.setEncoding((String)((ComboBoxItem)ppp.getEncodingComboBox().getSelectedItem()).getObject());
        return ppo;
    }
}

