/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jdesktop.application.ResourceMap;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.configurator.Application;
import ru.softlogic.configurator.InfoDialog;
import ru.softlogic.configurator.LoadKeyDialogListener;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.app.tasks.LoadKeyTask;
import ru.softlogic.configurator.elements.DigitalDocument;
import ru.softlogic.configurator.elements.LetterDocument;
import ru.softlogic.configurator.keyboard.DigitalKeyboardDialog;
import ru.softlogic.configurator.keyboard.KeyBoardListener;
import ru.softlogic.configurator.keyboard.LetterKeyboardDialog;
import ru.softlogic.configurator.keyboard.ScreenKeyboard;
import ru.softlogic.configurator.resources.B;
import ru.softlogic.configurator.task.TaskExecutor;
import ru.softlogic.configurator.utils.DialogUtils;
import ru.softlogic.system.util.ResourceLoader;

public class LoadKeyDialog
extends JDialog {
    private final LazyInitializator initializator;
    private final TaskExecutor taskExecutor;
    private ScreenKeyboard lk;
    private ScreenKeyboard dk;
    private InfoDialog infoDialog;
    private final List<LoadKeyDialogListener> listeners;
    private JButton cancelButton;
    private JButton passwordButton;
    private JLabel passwordLabel;
    private JTextField passwordTextField;
    private JButton pointButton;
    private JLabel pointLabel;
    private JTextField pointTextField;
    private JButton processButton;
    private JLabel titleLabel;

    public LoadKeyDialog(Frame parent, boolean modal, LazyInitializator initializator, TaskExecutor taskExecutor) {
        super(parent, modal);
        this.initializator = initializator;
        this.taskExecutor = taskExecutor;
        this.initComponents();
        DialogUtils.setEscapeAction(this);
        DialogUtils.addCloseAction(this.cancelButton, this);
        Icon kbd32 = ResourceLoader.getIcon((String)"/icon/x32/keyboard.png");
        this.pointButton.setIcon(kbd32);
        this.passwordButton.setIcon(kbd32);
        this.pointTextField.setDocument(new DigitalDocument(5));
        this.passwordTextField.setDocument(new LetterDocument(25));
        this.listeners = new LinkedList<LoadKeyDialogListener>();
    }

    public void init() {
        this.pointTextField.setText("");
        this.passwordTextField.setText("");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoadKeyDialog.this.pointTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.pointLabel = new JLabel();
        this.pointTextField = new JTextField();
        this.pointButton = new JButton();
        this.passwordLabel = new JLabel();
        this.passwordTextField = new JTextField();
        this.passwordButton = new JButton();
        this.cancelButton = new JButton();
        this.processButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.titleLabel.setFont(new Font("Tahoma", 0, 15));
        this.titleLabel.setHorizontalAlignment(0);
        ResourceMap resourceMap = ((Application)org.jdesktop.application.Application.getInstance(Application.class)).getContext().getResourceMap(LoadKeyDialog.class);
        this.titleLabel.setText(resourceMap.getString("LoadKeyDialog.titleLabel.text", new Object[0]));
        this.pointLabel.setFont(new Font("Tahoma", 0, 15));
        this.pointLabel.setText(resourceMap.getString("LoadKeyDialog.pointLabel.text", new Object[0]));
        this.pointTextField.setFont(new Font("Tahoma", 0, 15));
        this.pointButton.setFont(new Font("Tahoma", 0, 15));
        this.pointButton.setFocusable(false);
        this.pointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadKeyDialog.this.pointButtonActionPerformed(evt);
            }
        });
        this.passwordLabel.setFont(new Font("Tahoma", 0, 15));
        this.passwordLabel.setText(resourceMap.getString("LoadKeyDialog.passwordLabel.text", new Object[0]));
        this.passwordTextField.setFont(new Font("Tahoma", 0, 15));
        this.passwordButton.setFont(new Font("Tahoma", 0, 15));
        this.passwordButton.setFocusable(false);
        this.passwordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadKeyDialog.this.passwordButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setFont(new Font("Tahoma", 0, 15));
        this.cancelButton.setText(resourceMap.getString("LoadKeyDialog.cancelButton.text", new Object[0]));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadKeyDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.processButton.setFont(new Font("Tahoma", 0, 15));
        this.processButton.setText(resourceMap.getString("LoadKeyDialog.processButton.text", new Object[0]));
        this.processButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadKeyDialog.this.processButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titleLabel, -1, 450, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.pointLabel, -1, 404, Short.MAX_VALUE).addGap(46, 46, 46)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.passwordLabel, GroupLayout.Alignment.LEADING, -1, 404, Short.MAX_VALUE).addComponent(this.pointTextField, -1, 404, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pointButton, -2, 40, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.passwordTextField, -1, 404, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordButton, -2, 40, -2)).addGroup(layout.createSequentialGroup().addComponent(this.cancelButton).addGap(18, 18, 18).addComponent(this.processButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.titleLabel).addGap(18, 18, 18).addComponent(this.pointLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pointTextField, -2, 35, -2).addComponent(this.pointButton, -2, 35, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.passwordLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordTextField, -2, 35, -2).addComponent(this.passwordButton, -2, 35, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, 35, -2).addComponent(this.processButton, -2, 35, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void processButtonActionPerformed(ActionEvent evt) {
        if (this.pointTextField.getText().isEmpty()) {
            this.getInfoDialog().setText(B.get("LoadKeyDialog.error.point"));
            this.getInfoDialog().setVisible(true);
            return;
        }
        if (this.passwordTextField.getText().isEmpty()) {
            this.getInfoDialog().setText(B.get("LoadKeyDialog.error.password"));
            this.getInfoDialog().setVisible(true);
            return;
        }
        this.setVisible(false);
        this.taskExecutor.execute(new LoadKeyTask(this.pointTextField.getText(), this.passwordTextField.getText(), this.initializator));
    }

    private void pointButtonActionPerformed(ActionEvent evt) {
        if (this.dk == null) {
            this.dk = new DigitalKeyboardDialog((Dialog)this, true);
            this.dk.setLocationRelativeTo(null);
            this.dk.setKeyBoardListener(new LocalDigitalKeyBoardListener());
        }
        this.dk.init(this.pointTextField.getText(), 5, false, this.pointLabel.getText());
        this.dk.setVisible(true);
    }

    private void passwordButtonActionPerformed(ActionEvent evt) {
        if (this.lk == null) {
            this.lk = "digital".equals(SystemProp.getLoadKeyDialogKBType()) ? new DigitalKeyboardDialog((Dialog)this, true) : new LetterKeyboardDialog((Dialog)this, true);
            this.lk.setLocationRelativeTo(null);
            this.lk.setKeyBoardListener(new LocalLetterKeyBoardListener());
        }
        this.lk.init(this.passwordTextField.getText(), 25, true, this.passwordLabel.getText());
        this.lk.setVisible(true);
    }

    private InfoDialog getInfoDialog() {
        if (this.infoDialog == null) {
            this.infoDialog = new InfoDialog((Dialog)this, this.rootPaneCheckingEnabled);
            this.infoDialog.setLocationRelativeTo(null);
        }
        return this.infoDialog;
    }

    private class LocalLetterKeyBoardListener
    implements KeyBoardListener {
        private LocalLetterKeyBoardListener() {
        }

        @Override
        public void onResult(String data) {
            LoadKeyDialog.this.passwordTextField.setText(data);
            LoadKeyDialog.this.lk.setVisible(false);
        }
    }

    private class LocalDigitalKeyBoardListener
    implements KeyBoardListener {
        private LocalDigitalKeyBoardListener() {
        }

        @Override
        public void onResult(String data) {
            LoadKeyDialog.this.pointTextField.setText(data);
            LoadKeyDialog.this.dk.setVisible(false);
        }
    }
}

