/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.MozillaDelegate;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.webkit.JSClassDefinition;
import org.eclipse.swt.internal.webkit.WebKitGTK;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class WebKit
extends WebBrowser {
    int webView;
    int webViewData;
    int scrolledWindow;
    int failureCount;
    int lastKeyCode;
    int lastCharCode;
    String postData;
    String[] headers;
    boolean ignoreDispose;
    boolean loadingText;
    boolean untrustedText;
    byte[] htmlBytes;
    BrowserFunction eventFunction;
    static int ExternalClass;
    static int PostString;
    static boolean LibraryLoaded;
    static final String ABOUT_BLANK = "about:blank";
    static final String CHARSET_UTF8 = "UTF-8";
    static final String CLASSNAME_EXTERNAL = "External";
    static final String ENCODING_FORM = "Content-Type: application/x-www-form-urlencoded";
    static final String FUNCTIONNAME_CALLJAVA = "callJava";
    static final String OBJECTNAME_EXTERNAL = "external";
    static final String PROPERTY_LENGTH = "length";
    static final String PROPERTY_PROXYHOST = "network.proxy_host";
    static final String PROPERTY_PROXYPORT = "network.proxy_port";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_HTTP = "http://";
    static final String URI_FILEROOT = "file:///";
    static final String USER_AGENT = "user-agent";
    static final int MAX_PORT = 65535;
    static final int MAX_PROGRESS = 100;
    static final int[] MIN_VERSION;
    static final char SEPARATOR_FILE;
    static final int STOP_PROPOGATE = 1;
    static final String DOMEVENT_DRAGSTART = "dragstart";
    static final String DOMEVENT_KEYDOWN = "keydown";
    static final String DOMEVENT_KEYPRESS = "keypress";
    static final String DOMEVENT_KEYUP = "keyup";
    static final String DOMEVENT_MOUSEDOWN = "mousedown";
    static final String DOMEVENT_MOUSEUP = "mouseup";
    static final String DOMEVENT_MOUSEMOVE = "mousemove";
    static final String DOMEVENT_MOUSEOUT = "mouseout";
    static final String DOMEVENT_MOUSEOVER = "mouseover";
    static final String DOMEVENT_MOUSEWHEEL = "mousewheel";
    static final int HOVERING_OVER_LINK = 1;
    static final int NOTIFY_PROGRESS = 2;
    static final int NAVIGATION_POLICY_DECISION_REQUESTED = 3;
    static final int NOTIFY_TITLE = 4;
    static final int POPULATE_POPUP = 5;
    static final int STATUS_BAR_TEXT_CHANGED = 6;
    static final int CREATE_WEB_VIEW = 7;
    static final int WEB_VIEW_READY = 8;
    static final int NOTIFY_LOAD_STATUS = 9;
    static final int RESOURCE_REQUEST_STARTING = 10;
    static final int DOWNLOAD_REQUESTED = 11;
    static final int MIME_TYPE_POLICY_DECISION_REQUESTED = 12;
    static final int CLOSE_WEB_VIEW = 13;
    static final int WINDOW_OBJECT_CLEARED = 14;
    static final int CONSOLE_MESSAGE = 15;
    static final String KEY_CHECK_SUBWINDOW = "org.eclipse.swt.internal.control.checksubwindow";
    static Callback Proc2;
    static Callback Proc3;
    static Callback Proc4;
    static Callback Proc5;
    static Callback Proc6;
    static Callback JSObjectHasPropertyProc;
    static Callback JSObjectGetPropertyProc;
    static Callback JSObjectCallAsFunctionProc;
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        MIN_VERSION = nArray;
        SEPARATOR_FILE = System.getProperty("file.separator").charAt(0);
        try {
            Library.loadLibrary("swt-webkit12");
            LibraryLoaded = true;
        }
        catch (Throwable throwable) {
            try {
                Library.loadLibrary("swt-webkit");
                LibraryLoaded = true;
            }
            catch (Throwable throwable2) {}
        }
        if (LibraryLoaded) {
            Class<?> clazz;
            Class<?> clazz2;
            Class<?> clazz3;
            Class<?> clazz4;
            Class<?> clazz5;
            Class<?> clazz6;
            Class<?> clazz7;
            Class<?> clazz8 = class$0;
            if (clazz8 == null) {
                try {
                    clazz8 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((Proc2 = new Callback(clazz8, "Proc", 2)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((clazz7 = class$0) == null) {
                try {
                    clazz7 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((Proc3 = new Callback(clazz7, "Proc", 3)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((clazz6 = class$0) == null) {
                try {
                    clazz6 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((Proc4 = new Callback(clazz6, "Proc", 4)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((clazz5 = class$0) == null) {
                try {
                    clazz5 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((Proc5 = new Callback(clazz5, "Proc", 5)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((clazz4 = class$0) == null) {
                try {
                    clazz4 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((Proc6 = new Callback(clazz4, "Proc", 6)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((clazz3 = class$0) == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((JSObjectHasPropertyProc = new Callback(clazz3, "JSObjectHasPropertyProc", 3)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((clazz2 = class$0) == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((JSObjectGetPropertyProc = new Callback(clazz2, "JSObjectGetPropertyProc", 4)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((JSObjectCallAsFunctionProc = new Callback(clazz, "JSObjectCallAsFunctionProc", 6)).getAddress() == 0) {
                SWT.error(3);
            }
            NativeClearSessions = new Runnable(){

                public void run() {
                    int n;
                    if (!LibraryLoaded) {
                        return;
                    }
                    int n2 = WebKitGTK.webkit_get_default_session();
                    int n3 = WebKitGTK.soup_session_get_feature(n2, n = WebKitGTK.soup_cookie_jar_get_type());
                    if (n3 == 0) {
                        return;
                    }
                    int n4 = WebKitGTK.soup_cookie_jar_all_cookies(n3);
                    int n5 = OS.g_slist_length(n4);
                    int n6 = n4;
                    int n7 = 0;
                    while (n7 < n5) {
                        int n8 = OS.g_slist_data(n6);
                        int n9 = WebKitGTK.SoupCookie_expires(n8);
                        if (n9 == 0) {
                            WebKitGTK.soup_cookie_jar_delete_cookie(n3, n8);
                        }
                        n6 = OS.g_slist_next(n6);
                        ++n7;
                    }
                    OS.g_slist_free(n4);
                }
            };
            NativeGetCookie = new Runnable(){

                public void run() {
                    int n;
                    if (!LibraryLoaded) {
                        return;
                    }
                    int n2 = WebKitGTK.webkit_get_default_session();
                    int n3 = WebKitGTK.soup_session_get_feature(n2, n = WebKitGTK.soup_cookie_jar_get_type());
                    if (n3 == 0) {
                        return;
                    }
                    byte[] byArray = Converter.wcsToMbcs(null, CookieUrl, true);
                    int n4 = WebKitGTK.soup_uri_new(byArray);
                    if (n4 == 0) {
                        return;
                    }
                    int n5 = WebKitGTK.soup_cookie_jar_get_cookies(n3, n4, 0);
                    WebKitGTK.soup_uri_free(n4);
                    if (n5 == 0) {
                        return;
                    }
                    int n6 = OS.strlen(n5);
                    byArray = new byte[n6];
                    C.memmove(byArray, n5, n6);
                    OS.g_free(n5);
                    String string = new String(Converter.mbcsToWcs(null, byArray));
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2;
                        String string3 = stringTokenizer.nextToken();
                        int n7 = string3.indexOf(61);
                        if (n7 == -1 || !(string2 = string3.substring(0, n7).trim()).equals(CookieName)) continue;
                        CookieValue = string3.substring(n7 + 1).trim();
                        return;
                    }
                }
            };
            NativeSetCookie = new Runnable(){

                public void run() {
                    int n;
                    if (!LibraryLoaded) {
                        return;
                    }
                    int n2 = WebKitGTK.webkit_get_default_session();
                    int n3 = WebKitGTK.soup_session_get_feature(n2, n = WebKitGTK.soup_cookie_jar_get_type());
                    if (n3 == 0) {
                        WebKitGTK.soup_session_add_feature_by_type(n2, n);
                        n3 = WebKitGTK.soup_session_get_feature(n2, n);
                    }
                    if (n3 == 0) {
                        return;
                    }
                    byte[] byArray = Converter.wcsToMbcs(null, CookieUrl, true);
                    int n4 = WebKitGTK.soup_uri_new(byArray);
                    if (n4 == 0) {
                        return;
                    }
                    byArray = Converter.wcsToMbcs(null, CookieValue, true);
                    int n5 = WebKitGTK.soup_cookie_parse(byArray, n4);
                    if (n5 != 0) {
                        WebKitGTK.soup_cookie_jar_add_cookie(n3, n5);
                        CookieResult = true;
                    }
                    WebKitGTK.soup_uri_free(n4);
                }
            };
            if (NativePendingCookies != null) {
                WebKit.SetPendingCookies(NativePendingCookies);
                NativePendingCookies = null;
            }
        }
    }

    WebKit() {
    }

    static Browser findBrowser(int n) {
        if (n == 0) {
            return null;
        }
        int n2 = OS.gtk_widget_get_parent(n);
        n2 = OS.gtk_widget_get_parent(n2);
        return (Browser)Display.getCurrent().findWidget(n2);
    }

    static boolean isInstalled() {
        if (!LibraryLoaded) {
            return false;
        }
        int n = WebKitGTK.webkit_major_version();
        int n2 = WebKitGTK.webkit_minor_version();
        int n3 = WebKitGTK.webkit_micro_version();
        return n > MIN_VERSION[0] || n == MIN_VERSION[0] && n2 > MIN_VERSION[1] || n == MIN_VERSION[0] && n2 == MIN_VERSION[1] && n3 >= MIN_VERSION[2];
    }

    static int JSObjectCallAsFunctionProc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (WebKitGTK.JSValueIsObjectOfClass(n, n3, ExternalClass) == 0) {
            return WebKitGTK.JSValueMakeUndefined(n);
        }
        int n7 = WebKitGTK.JSObjectGetPrivate(n3);
        int[] nArray = new int[1];
        C.memmove(nArray, n7, C.PTR_SIZEOF);
        Browser browser = WebKit.findBrowser(nArray[0]);
        if (browser == null) {
            return 0;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.callJava(n, n2, n3, n4, n5, n6);
    }

    static int JSObjectGetPropertyProc(int n, int n2, int n3, int n4) {
        byte[] byArray = null;
        try {
            byArray = "callJava\u0000".getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, FUNCTIONNAME_CALLJAVA, true);
        }
        int n5 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
        int n6 = WebKitGTK.JSObjectMakeFunctionWithCallback(n, n5, JSObjectCallAsFunctionProc.getAddress());
        WebKitGTK.JSStringRelease(n5);
        return n6;
    }

    static int JSObjectHasPropertyProc(int n, int n2, int n3) {
        byte[] byArray = null;
        try {
            byArray = "callJava\u0000".getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, FUNCTIONNAME_CALLJAVA, true);
        }
        return WebKitGTK.JSStringIsEqualToUTF8CString(n3, byArray);
    }

    static int Proc(int n, int n2) {
        Browser browser = WebKit.findBrowser(n);
        if (browser == null) {
            return 0;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.webViewProc(n, n2);
    }

    static int Proc(int n, int n2, int n3) {
        if (OS.GTK_IS_SCROLLED_WINDOW(n)) {
            return n3;
        }
        int n4 = WebKitGTK.WEBKIT_IS_WEB_FRAME(n) ? WebKitGTK.webkit_web_frame_get_web_view(n) : n;
        Browser browser = WebKit.findBrowser(n4);
        if (browser == null) {
            return 0;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        if (n4 == n) {
            return webKit.webViewProc(n, n2, n3);
        }
        return webKit.webFrameProc(n, n2, n3);
    }

    static int Proc(int n, int n2, int n3, int n4) {
        Browser browser = WebKit.findBrowser(n);
        if (browser == null) {
            return 0;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.webViewProc(n, n2, n3, n4);
    }

    static int Proc(int n, int n2, int n3, int n4, int n5) {
        int n6 = WebKitGTK.SOUP_IS_SESSION(n) ? n5 : n;
        Browser browser = WebKit.findBrowser(n6);
        if (browser == null) {
            return 0;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        if (n6 == n) {
            return webKit.webViewProc(n, n2, n3, n4, n5);
        }
        return webKit.sessionProc(n, n2, n3, n4, n5);
    }

    static int Proc(int n, int n2, int n3, int n4, int n5, int n6) {
        Browser browser = WebKit.findBrowser(n);
        if (browser == null) {
            return 0;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.webViewProc(n, n2, n3, n4, n5, n6);
    }

    int sessionProc(int n, int n2, int n3, int n4, int n5) {
        if (n4 == 0) {
            this.failureCount = 0;
        } else if (++this.failureCount >= 3) {
            return 0;
        }
        int n6 = WebKitGTK.soup_message_get_uri(n2);
        int n7 = WebKitGTK.soup_uri_to_string(n6, 0);
        int n8 = C.strlen(n7);
        byte[] byArray = new byte[n8];
        OS.memmove(byArray, n7, n8);
        OS.g_free(n7);
        String string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        int n9 = 0;
        while (n9 < this.authenticationListeners.length) {
            AuthenticationEvent authenticationEvent = new AuthenticationEvent(this.browser);
            authenticationEvent.location = string;
            this.authenticationListeners[n9].authenticate(authenticationEvent);
            if (!authenticationEvent.doit) {
                OS.g_signal_stop_emission_by_name(n, WebKitGTK.authenticate);
                return 0;
            }
            if (authenticationEvent.user != null && authenticationEvent.password != null) {
                byte[] byArray2 = Converter.wcsToMbcs(null, authenticationEvent.user, true);
                byte[] byArray3 = Converter.wcsToMbcs(null, authenticationEvent.password, true);
                WebKitGTK.soup_auth_authenticate(n3, byArray2, byArray3);
                OS.g_signal_stop_emission_by_name(n, WebKitGTK.authenticate);
                return 0;
            }
            ++n9;
        }
        return 0;
    }

    int webFrameProc(int n, int n2, int n3) {
        switch (n3) {
            case 9: {
                return this.webframe_notify_load_status(n, n2);
            }
        }
        return 0;
    }

    int webViewProc(int n, int n2) {
        switch (n2) {
            case 13: {
                return this.webkit_close_web_view(n);
            }
            case 8: {
                return this.webkit_web_view_ready(n);
            }
        }
        return 0;
    }

    int webViewProc(int n, int n2, int n3) {
        switch (n3) {
            case 7: {
                return this.webkit_create_web_view(n, n2);
            }
            case 11: {
                return this.webkit_download_requested(n, n2);
            }
            case 9: {
                return this.webkit_notify_load_status(n, n2);
            }
            case 2: {
                return this.webkit_notify_progress(n, n2);
            }
            case 4: {
                return this.webkit_notify_title(n, n2);
            }
            case 5: {
                return this.webkit_populate_popup(n, n2);
            }
            case 6: {
                return this.webkit_status_bar_text_changed(n, n2);
            }
        }
        return 0;
    }

    int webViewProc(int n, int n2, int n3, int n4) {
        switch (n4) {
            case 1: {
                return this.webkit_hovering_over_link(n, n2, n3);
            }
        }
        return 0;
    }

    int webViewProc(int n, int n2, int n3, int n4, int n5) {
        switch (n5) {
            case 15: {
                return this.webkit_console_message(n, n2, n3, n4);
            }
            case 14: {
                return this.webkit_window_object_cleared(n, n2, n3, n4);
            }
        }
        return 0;
    }

    int webViewProc(int n, int n2, int n3, int n4, int n5, int n6) {
        switch (n6) {
            case 12: {
                return this.webkit_mime_type_policy_decision_requested(n, n2, n3, n4, n5);
            }
            case 3: {
                return this.webkit_navigation_policy_decision_requested(n, n2, n3, n4, n5);
            }
            case 10: {
                return this.webkit_resource_request_starting(n, n2, n3, n4, n5);
            }
        }
        return 0;
    }

    public void create(Composite composite, int n) {
        int n2;
        byte[] byArray;
        if (ExternalClass == 0) {
            int n3;
            if (Device.DEBUG) {
                int n4 = WebKitGTK.webkit_major_version();
                int n5 = WebKitGTK.webkit_minor_version();
                n3 = WebKitGTK.webkit_micro_version();
                System.out.println("WebKit version " + n4 + "." + n5 + "." + n3);
            }
            JSClassDefinition jSClassDefinition = new JSClassDefinition();
            byArray = Converter.wcsToMbcs(null, CLASSNAME_EXTERNAL, true);
            jSClassDefinition.className = C.malloc(byArray.length);
            OS.memmove(jSClassDefinition.className, byArray, byArray.length);
            jSClassDefinition.hasProperty = JSObjectHasPropertyProc.getAddress();
            jSClassDefinition.getProperty = JSObjectGetPropertyProc.getAddress();
            n3 = C.malloc(JSClassDefinition.sizeof);
            WebKitGTK.memmove(n3, jSClassDefinition, JSClassDefinition.sizeof);
            ExternalClass = WebKitGTK.JSClassCreate(n3);
            byArray = Converter.wcsToMbcs(null, "POST", true);
            PostString = C.malloc(byArray.length);
            C.memmove(PostString, byArray, byArray.length);
        }
        this.scrolledWindow = OS.gtk_scrolled_window_new(0, 0);
        OS.gtk_scrolled_window_set_policy(this.scrolledWindow, 1, 1);
        this.webView = WebKitGTK.webkit_web_view_new();
        this.webViewData = C.malloc(C.PTR_SIZEOF);
        C.memmove(this.webViewData, new int[]{this.webView}, C.PTR_SIZEOF);
        OS.gtk_container_add(this.scrolledWindow, this.webView);
        OS.gtk_container_add(this.browser.handle, this.scrolledWindow);
        OS.gtk_widget_show(this.scrolledWindow);
        OS.gtk_widget_show(this.webView);
        OS.g_signal_connect(this.webView, WebKitGTK.close_web_view, Proc2.getAddress(), 13);
        OS.g_signal_connect(this.webView, WebKitGTK.console_message, Proc5.getAddress(), 15);
        OS.g_signal_connect(this.webView, WebKitGTK.create_web_view, Proc3.getAddress(), 7);
        OS.g_signal_connect(this.webView, WebKitGTK.download_requested, Proc3.getAddress(), 11);
        OS.g_signal_connect(this.webView, WebKitGTK.hovering_over_link, Proc4.getAddress(), 1);
        OS.g_signal_connect(this.webView, WebKitGTK.mime_type_policy_decision_requested, Proc6.getAddress(), 12);
        OS.g_signal_connect(this.webView, WebKitGTK.navigation_policy_decision_requested, Proc6.getAddress(), 3);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_load_status, Proc3.getAddress(), 9);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_progress, Proc3.getAddress(), 2);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_title, Proc3.getAddress(), 4);
        OS.g_signal_connect(this.webView, WebKitGTK.populate_popup, Proc3.getAddress(), 5);
        OS.g_signal_connect(this.webView, WebKitGTK.resource_request_starting, Proc6.getAddress(), 10);
        OS.g_signal_connect(this.webView, WebKitGTK.status_bar_text_changed, Proc3.getAddress(), 6);
        OS.g_signal_connect(this.webView, WebKitGTK.web_view_ready, Proc2.getAddress(), 8);
        OS.g_signal_connect(this.webView, WebKitGTK.window_object_cleared, Proc5.getAddress(), 14);
        OS.g_signal_connect(this.scrolledWindow, OS.event, Proc3.getAddress(), 0);
        OS.g_signal_connect(this.scrolledWindow, OS.button_press_event, Proc3.getAddress(), 1);
        OS.g_signal_connect(this.scrolledWindow, OS.button_release_event, Proc3.getAddress(), 1);
        OS.g_signal_connect(this.scrolledWindow, OS.key_press_event, Proc3.getAddress(), 1);
        OS.g_signal_connect(this.scrolledWindow, OS.key_release_event, Proc3.getAddress(), 1);
        OS.g_signal_connect(this.scrolledWindow, OS.scroll_event, Proc3.getAddress(), 1);
        OS.g_signal_connect(this.scrolledWindow, OS.motion_notify_event, Proc3.getAddress(), 1);
        int n6 = WebKitGTK.webkit_web_view_get_settings(this.webView);
        OS.g_object_set(n6, WebKitGTK.javascript_can_open_windows_automatically, 1, 0);
        OS.g_object_set(n6, WebKitGTK.enable_universal_access_from_file_uris, 1, 0);
        byArray = Converter.wcsToMbcs(null, CHARSET_UTF8, true);
        OS.g_object_set(n6, WebKitGTK.default_encoding, byArray, 0);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (WebKit.this.ignoreDispose) {
                            WebKit.this.ignoreDispose = false;
                            break;
                        }
                        WebKit.this.ignoreDispose = true;
                        WebKit.this.browser.notifyListeners(event.type, event);
                        event.type = 0;
                        WebKit.this.onDispose(event);
                        break;
                    }
                    case 15: {
                        OS.gtk_widget_grab_focus(WebKit.this.webView);
                        break;
                    }
                    case 11: {
                        WebKit.this.onResize(event);
                    }
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(15, listener);
        this.browser.addListener(1, listener);
        this.browser.addListener(11, listener);
        int n7 = WebKitGTK.webkit_get_default_session();
        int n8 = WebKitGTK.soup_session_get_feature(n7, WebKitGTK.webkit_soup_auth_dialog_get_type());
        WebKitGTK.soup_session_feature_detach(n8, n7);
        OS.g_signal_connect(n7, WebKitGTK.authenticate, Proc5.getAddress(), this.webView);
        WebKitGTK.soup_session_feature_attach(n8, n7);
        String string = System.getProperty(PROPERTY_PROXYHOST);
        String string2 = System.getProperty(PROPERTY_PROXYPORT);
        int n9 = -1;
        if (string2 != null) {
            try {
                n2 = Integer.valueOf(string2);
                if (n2 >= 0 && n2 <= 65535) {
                    n9 = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (string != null || n9 != -1) {
            if (!string.startsWith(PROTOCOL_HTTP)) {
                string = PROTOCOL_HTTP + string;
            }
            if ((n2 = WebKitGTK.soup_uri_new(byArray = Converter.wcsToMbcs(null, string = String.valueOf(string) + ":" + n9, true))) != 0) {
                OS.g_object_set(n7, WebKitGTK.SOUP_SESSION_PROXY_URI, n2, 0);
                WebKitGTK.soup_uri_free(n2);
            }
        }
        this.eventFunction = new BrowserFunction(this.browser, "HandleWebKitEvent"){

            public Object function(Object[] objectArray) {
                return WebKit.this.handleEvent(objectArray) ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        this.browser.setData(KEY_CHECK_SUBWINDOW, Boolean.FALSE);
    }

    void addEventHandlers(boolean bl) {
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer("window.SWTkeyhandler = function SWTkeyhandler(e) {");
            stringBuffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.keyCode, e.charCode, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey);} catch (e) {}};");
            stringBuffer.append("document.addEventListener('keydown', SWTkeyhandler, true);");
            stringBuffer.append("document.addEventListener('keypress', SWTkeyhandler, true);");
            stringBuffer.append("document.addEventListener('keyup', SWTkeyhandler, true);");
            this.execute(stringBuffer.toString());
            stringBuffer = new StringBuffer("window.SWTmousehandler = function SWTmousehandler(e) {");
            stringBuffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.screenX, e.screenY, e.detail, e.button + 1, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey, e.relatedTarget != null);} catch (e) {}};");
            stringBuffer.append("document.addEventListener('mousedown', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mouseup', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mousemove', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mousewheel', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('dragstart', SWTmousehandler, true);");
            this.execute(stringBuffer.toString());
        } else {
            StringBuffer stringBuffer = new StringBuffer("for (var i = 0; i < frames.length; i++) {");
            stringBuffer.append("frames[i].document.addEventListener('keydown', window.SWTkeyhandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('keypress', window.SWTkeyhandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('keyup', window.SWTkeyhandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mousedown', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mouseup', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mousemove', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mouseover', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mouseout', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mousewheel', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('dragstart', window.SWTmousehandler, true);");
            stringBuffer.append('}');
            this.execute(stringBuffer.toString());
        }
    }

    public boolean back() {
        if (WebKitGTK.webkit_web_view_can_go_back(this.webView) == 0) {
            return false;
        }
        WebKitGTK.webkit_web_view_go_back(this.webView);
        return true;
    }

    public boolean close() {
        return this.close(true);
    }

    boolean close(boolean bl) {
        if (!this.jsEnabled) {
            return true;
        }
        String string = Compatibility.getMessage("SWT_OnBeforeUnload_Message1");
        String string2 = Compatibility.getMessage("SWT_OnBeforeUnload_Message2");
        String string3 = "SWTExecuteTemporaryFunctionCLOSE";
        StringBuffer stringBuffer = new StringBuffer("function ");
        stringBuffer.append(string3);
        stringBuffer.append("(win) {\n");
        stringBuffer.append("var fn = win.onbeforeunload; if (fn != null) {try {var str = fn(); ");
        if (bl) {
            stringBuffer.append("if (str != null) { ");
            stringBuffer.append("var result = confirm('");
            stringBuffer.append(string);
            stringBuffer.append("\\n\\n'+str+'\\n\\n");
            stringBuffer.append(string2);
            stringBuffer.append("');");
            stringBuffer.append("if (!result) return false;}");
        }
        stringBuffer.append("} catch (e) {}}");
        stringBuffer.append("try {for (var i = 0; i < win.frames.length; i++) {var result = ");
        stringBuffer.append(string3);
        stringBuffer.append("(win.frames[i]); if (!result) return false;}} catch (e) {} return true;");
        stringBuffer.append("\n};");
        this.execute(stringBuffer.toString());
        Boolean bl2 = (Boolean)this.evaluate("return " + string3 + "(window);");
        if (bl2 == null) {
            return false;
        }
        return bl2;
    }

    public boolean execute(String string) {
        int n = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        int n2 = WebKitGTK.webkit_web_frame_get_global_context(n);
        byte[] byArray = null;
        try {
            byArray = (String.valueOf(string) + '\u0000').getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, string, true);
        }
        int n3 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
        try {
            byArray = (String.valueOf(this.getUrl()) + '\u0000').getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, this.getUrl(), true);
        }
        int n4 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
        int n5 = WebKitGTK.JSEvaluateScript(n2, n3, 0, n4, 0, null);
        WebKitGTK.JSStringRelease(n4);
        WebKitGTK.JSStringRelease(n3);
        return n5 != 0;
    }

    public boolean forward() {
        if (WebKitGTK.webkit_web_view_can_go_forward(this.webView) == 0) {
            return false;
        }
        WebKitGTK.webkit_web_view_go_forward(this.webView);
        return true;
    }

    public String getBrowserType() {
        return "webkit";
    }

    public String getText() {
        int n = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        int n2 = WebKitGTK.webkit_web_frame_get_data_source(n);
        if (n2 == 0) {
            return "";
        }
        int n3 = WebKitGTK.webkit_web_data_source_get_data(n2);
        if (n3 == 0) {
            return "";
        }
        int n4 = WebKitGTK.webkit_web_data_source_get_encoding(n2);
        int n5 = OS.strlen(n4);
        byte[] byArray = new byte[n5];
        OS.memmove(byArray, n4, n5);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        n5 = OS.GString_len(n3);
        byArray = new byte[n5];
        int n6 = OS.GString_str(n3);
        C.memmove(byArray, n6, n5);
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(Converter.mbcsToWcs(null, byArray));
        }
    }

    public String getUrl() {
        int n = WebKitGTK.webkit_web_view_get_uri(this.webView);
        if (n == 0) {
            return ABOUT_BLANK;
        }
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n2 = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n2) == '#') {
                string = ABOUT_BLANK + string.substring(n2);
            }
        }
        return string;
    }

    boolean handleEvent(Object[] objectArray) {
        int n;
        String string = (String)objectArray[0];
        if (string.equals(DOMEVENT_KEYDOWN)) {
            int n2;
            this.lastKeyCode = n2 = this.translateKey(((Double)objectArray[1]).intValue());
            switch (n2) {
                case 8: 
                case 9: 
                case 27: 
                case 127: 
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: 
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000005: 
                case 0x1000006: 
                case 0x1000007: 
                case 0x1000008: 
                case 0x1000009: 
                case 0x100000A: 
                case 0x100000B: 
                case 0x100000C: 
                case 0x100000D: 
                case 0x100000E: 
                case 0x100000F: 
                case 0x1000010: 
                case 0x1000011: 
                case 0x1000012: 
                case 0x1000013: 
                case 0x1000014: 
                case 0x1000015: 
                case 16777298: 
                case 16777299: 
                case 16777300: 
                case 0x1000055: {
                    Event event = new Event();
                    event.widget = this.browser;
                    event.type = string.equals(DOMEVENT_KEYDOWN) ? 1 : 2;
                    event.keyCode = n2;
                    switch (n2) {
                        case 8: {
                            event.character = (char)8;
                            break;
                        }
                        case 127: {
                            event.character = (char)127;
                            break;
                        }
                        case 27: {
                            event.character = (char)27;
                            break;
                        }
                        case 9: {
                            event.character = (char)9;
                        }
                    }
                    this.lastCharCode = event.character;
                    event.stateMask = ((Boolean)objectArray[3] != false ? 65536 : 0) | ((Boolean)objectArray[4] != false ? 262144 : 0) | ((Boolean)objectArray[5] != false ? 131072 : 0) | ((Boolean)objectArray[6] != false ? 0x400000 : 0);
                    event.stateMask &= ~n2;
                    final int n3 = event.stateMask;
                    if (!this.sendKeyEvent(event) || this.browser.isDisposed()) {
                        return false;
                    }
                    if (!this.browser.isFocusControl() || n2 != 9 || (n3 & 0x50000) != 0) break;
                    this.browser.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (WebKit.this.browser.isDisposed()) {
                                return;
                            }
                            if (WebKit.this.browser.getDisplay().getFocusControl() == null) {
                                int n = (n3 & 0x20000) != 0 ? 8 : 16;
                                WebKit.this.browser.traverse(n);
                            }
                        }
                    });
                }
            }
            return true;
        }
        if (string.equals(DOMEVENT_KEYPRESS)) {
            if (this.lastKeyCode == 0) {
                return true;
            }
            this.lastCharCode = ((Double)objectArray[2]).intValue();
            if (((Boolean)objectArray[4]).booleanValue() && this.lastCharCode >= 0 && this.lastCharCode <= 127) {
                if (97 <= this.lastCharCode && this.lastCharCode <= 122) {
                    this.lastCharCode -= 32;
                }
                if (64 <= this.lastCharCode && this.lastCharCode <= 95) {
                    this.lastCharCode -= 64;
                }
            }
            Event event = new Event();
            event.widget = this.browser;
            event.type = 1;
            event.keyCode = this.lastKeyCode;
            event.character = (char)this.lastCharCode;
            event.stateMask = ((Boolean)objectArray[3] != false ? 65536 : 0) | ((Boolean)objectArray[4] != false ? 262144 : 0) | ((Boolean)objectArray[5] != false ? 131072 : 0) | ((Boolean)objectArray[6] != false ? 0x400000 : 0);
            return this.sendKeyEvent(event) && !this.browser.isDisposed();
        }
        if (string.equals(DOMEVENT_KEYUP)) {
            int n4 = this.translateKey(((Double)objectArray[1]).intValue());
            if (n4 == 0) {
                return true;
            }
            if (n4 != this.lastKeyCode) {
                this.lastKeyCode = n4;
                this.lastCharCode = 0;
            }
            Event event = new Event();
            event.widget = this.browser;
            event.type = 2;
            event.keyCode = this.lastKeyCode;
            event.character = (char)this.lastCharCode;
            event.stateMask = ((Boolean)objectArray[3] != false ? 65536 : 0) | ((Boolean)objectArray[4] != false ? 262144 : 0) | ((Boolean)objectArray[5] != false ? 131072 : 0) | ((Boolean)objectArray[6] != false ? 0x400000 : 0);
            switch (this.lastKeyCode) {
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: {
                    event.stateMask |= this.lastKeyCode;
                }
            }
            this.browser.notifyListeners(event.type, event);
            this.lastCharCode = 0;
            this.lastKeyCode = 0;
            return event.doit && !this.browser.isDisposed();
        }
        Point point = new Point(((Double)objectArray[1]).intValue(), ((Double)objectArray[2]).intValue());
        point = this.browser.getDisplay().map(null, (Control)this.browser, point);
        Event event = new Event();
        event.widget = this.browser;
        event.x = point.x;
        event.y = point.y;
        event.stateMask = n = ((Boolean)objectArray[5] != false ? 65536 : 0) | ((Boolean)objectArray[6] != false ? 262144 : 0) | ((Boolean)objectArray[7] != false ? 131072 : 0) | ((Boolean)objectArray[8] != false ? 0x400000 : 0);
        if (string.equals(DOMEVENT_MOUSEDOWN)) {
            event.type = 3;
            event.count = ((Double)objectArray[3]).intValue();
            event.button = ((Double)objectArray[4]).intValue();
            this.browser.notifyListeners(event.type, event);
            if (this.browser.isDisposed()) {
                return true;
            }
            if (((Double)objectArray[3]).intValue() == 2) {
                event = new Event();
                event.type = 8;
                event.widget = this.browser;
                event.x = point.x;
                event.y = point.y;
                event.stateMask = n;
                event.count = ((Double)objectArray[3]).intValue();
                event.button = ((Double)objectArray[4]).intValue();
                this.browser.notifyListeners(event.type, event);
            }
            return true;
        }
        if (string.equals(DOMEVENT_MOUSEUP)) {
            event.type = 4;
            event.count = ((Double)objectArray[3]).intValue();
            event.button = ((Double)objectArray[4]).intValue();
        } else if (string.equals(DOMEVENT_MOUSEMOVE)) {
            event.type = 5;
        } else if (string.equals(DOMEVENT_MOUSEWHEEL)) {
            event.type = 37;
            event.count = ((Double)objectArray[3]).intValue();
        } else if (string.equals(DOMEVENT_DRAGSTART)) {
            event.type = 29;
            event.button = ((Double)objectArray[4]).intValue() + 1;
            switch (event.button) {
                case 1: {
                    event.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    event.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    event.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    event.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    event.stateMask |= 0x2000000;
                }
            }
            this.browser.notifyListeners(event.type, event);
            return false;
        }
        this.browser.notifyListeners(event.type, event);
        return true;
    }

    int handleLoadCommitted(int n, boolean bl) {
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n2 = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n2) == '#') {
                string = ABOUT_BLANK + string.substring(n2);
            }
        }
        if (bl && string.startsWith(ABOUT_BLANK) && this.htmlBytes != null) {
            return 0;
        }
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.location = string;
        locationEvent.top = bl;
        int n3 = 0;
        while (n3 < this.locationListeners.length) {
            this.locationListeners[n3].changed(locationEvent);
            ++n3;
        }
        return 0;
    }

    int handleLoadFinished(int n, boolean bl) {
        Object object;
        Object object2;
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n2 = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n2) == '#') {
                string = ABOUT_BLANK + string.substring(n2);
            }
        }
        if (bl && this.htmlBytes != null && string.startsWith(ABOUT_BLANK)) {
            this.loadingText = true;
            object2 = Converter.wcsToMbcs(null, "text/html", true);
            byte[] byArray2 = Converter.wcsToMbcs(null, CHARSET_UTF8, true);
            object = this.untrustedText ? (Object)Converter.wcsToMbcs(null, ABOUT_BLANK, true) : (Object)Converter.wcsToMbcs(null, URI_FILEROOT, true);
            WebKitGTK.webkit_web_view_load_string(this.webView, this.htmlBytes, (byte[])object2, byArray2, (byte[])object);
            this.htmlBytes = null;
        }
        if (!this.loadingText) {
            int n3;
            int n4;
            if (bl && (n4 = WebKitGTK.webkit_web_frame_get_title(n3 = WebKitGTK.webkit_web_view_get_main_frame(this.webView))) == 0) {
                object = new TitleEvent(this.browser);
                ((TitleEvent)object).display = this.browser.getDisplay();
                ((TitleEvent)object).widget = this.browser;
                ((TitleEvent)object).title = string;
                int n5 = 0;
                while (n5 < this.titleListeners.length) {
                    this.titleListeners[n5].changed((TitleEvent)object);
                    ++n5;
                }
                if (this.browser.isDisposed()) {
                    return 0;
                }
            }
            object2 = new ProgressEvent(this.browser);
            ((ProgressEvent)object2).display = this.browser.getDisplay();
            ((ProgressEvent)object2).widget = this.browser;
            ((ProgressEvent)object2).current = 100;
            ((ProgressEvent)object2).total = 100;
            int n6 = 0;
            while (n6 < this.progressListeners.length) {
                this.progressListeners[n6].completed((ProgressEvent)object2);
                ++n6;
            }
        }
        this.loadingText = false;
        return 0;
    }

    public boolean isBackEnabled() {
        return WebKitGTK.webkit_web_view_can_go_back(this.webView) != 0;
    }

    public boolean isForwardEnabled() {
        return WebKitGTK.webkit_web_view_can_go_forward(this.webView) != 0;
    }

    void onDispose(Event event) {
        if (!this.browser.isDisposed() && !this.browser.isClosing) {
            this.close(false);
        }
        Enumeration enumeration = this.functions.elements();
        while (enumeration.hasMoreElements()) {
            ((BrowserFunction)enumeration.nextElement()).dispose(false);
        }
        this.functions = null;
        C.free(this.webViewData);
        this.postData = null;
        this.headers = null;
        this.htmlBytes = null;
    }

    void onResize(Event event) {
        Rectangle rectangle = this.browser.getClientArea();
        OS.gtk_widget_set_size_request(this.scrolledWindow, rectangle.width, rectangle.height);
    }

    void openDownloadWindow(final int n) {
        final Shell shell = new Shell();
        String string = Compatibility.getMessage("SWT_FileDownload");
        shell.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        gridLayout.verticalSpacing = 20;
        shell.setLayout(gridLayout);
        int n2 = WebKitGTK.webkit_download_get_suggested_filename(n);
        int n3 = OS.strlen(n2);
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, n2, n3);
        String string2 = new String(Converter.mbcsToWcs(null, byArray));
        int n4 = WebKitGTK.webkit_download_get_uri(n);
        n3 = OS.strlen(n4);
        byArray = new byte[n3];
        OS.memmove(byArray, n4, n3);
        String string3 = new String(Converter.mbcsToWcs(null, byArray));
        string = Compatibility.getMessage("SWT_Download_Location", new Object[]{string2, string3});
        Label label = new Label(shell, 64);
        label.setText(string);
        GridData gridData = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int n5 = monitor.getBounds().width / 2;
        int n6 = label.computeSize((int)-1, (int)-1).x;
        gridData.widthHint = Math.min(n6, n5);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        final Label label2 = new Label(shell, 0);
        label2.setText(Compatibility.getMessage("SWT_Download_Started"));
        gridData = new GridData(1808);
        label2.setLayoutData(gridData);
        final Button button = new Button(shell, 8);
        button.setText(Compatibility.getMessage("SWT_Cancel"));
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        button.setLayoutData(gridData);
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                WebKitGTK.webkit_download_cancel(n);
            }
        };
        button.addListener(13, listener);
        OS.g_object_ref(n);
        final Display display = this.browser.getDisplay();
        display.timerExec(500, new Runnable(){

            public void run() {
                int n2 = WebKitGTK.webkit_download_get_status(n);
                if (shell.isDisposed() || n2 == 3 || n2 == 2) {
                    shell.dispose();
                    display.timerExec(-1, this);
                    OS.g_object_unref(n);
                    return;
                }
                if (n2 == -1) {
                    label2.setText(Compatibility.getMessage("SWT_Download_Error"));
                    display.timerExec(-1, this);
                    OS.g_object_unref(n);
                    button.removeListener(13, listener);
                    button.addListener(13, new Listener(this, shell){
                        final /* synthetic */ 8 this$1;
                        private final /* synthetic */ Shell val$shell;
                        {
                            this.this$1 = var1_1;
                            this.val$shell = shell;
                        }

                        public void handleEvent(Event event) {
                            this.val$shell.dispose();
                        }
                    });
                    return;
                }
                long l = WebKitGTK.webkit_download_get_current_size(n) / 1024L;
                long l2 = WebKitGTK.webkit_download_get_total_size(n) / 1024L;
                String string = Compatibility.getMessage("SWT_Download_Status", new Object[]{new Long(l), new Long(l2)});
                label2.setText(string);
                display.timerExec(500, this);
            }
        });
        shell.pack();
        shell.open();
    }

    public void refresh() {
        WebKitGTK.webkit_web_view_reload(this.webView);
    }

    public boolean setText(String string, boolean bl) {
        byte[] byArray = null;
        try {
            byArray = (String.valueOf(string) + '\u0000').getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, string, true);
        }
        boolean bl2 = this.htmlBytes != null;
        this.htmlBytes = byArray;
        boolean bl3 = this.untrustedText = !bl;
        if (bl2) {
            return true;
        }
        byte[] byArray2 = Converter.wcsToMbcs(null, ABOUT_BLANK, true);
        WebKitGTK.webkit_web_view_load_uri(this.webView, byArray2);
        return true;
    }

    public boolean setUrl(String string, String string2, String[] stringArray) {
        this.postData = string2;
        this.headers = stringArray;
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = null;
            string3 = string.charAt(0) == SEPARATOR_FILE ? PROTOCOL_FILE + string : PROTOCOL_HTTP + string;
            try {
                new URL(string3);
                string = string3;
            }
            catch (MalformedURLException malformedURLException2) {}
        }
        int n = WebKitGTK.webkit_web_view_get_settings(this.webView);
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                int n3;
                String string4 = stringArray[n2];
                if (string4 != null && (n3 = string4.indexOf(58)) != -1) {
                    String string5 = string4.substring(0, n3).trim();
                    String string6 = string4.substring(n3 + 1).trim();
                    if (string5.length() > 0 && string6.length() > 0 && string5.equalsIgnoreCase(USER_AGENT)) {
                        byte[] byArray = Converter.wcsToMbcs(null, string6, true);
                        OS.g_object_set(n, WebKitGTK.user_agent, byArray, 0);
                    }
                }
                ++n2;
            }
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        WebKitGTK.webkit_web_view_load_uri(this.webView, byArray);
        OS.g_object_set(n, WebKitGTK.user_agent, 0, 0);
        return true;
    }

    public void stop() {
        WebKitGTK.webkit_web_view_stop_loading(this.webView);
    }

    int webframe_notify_load_status(int n, int n2) {
        int n3 = WebKitGTK.webkit_web_frame_get_load_status(n);
        switch (n3) {
            case 1: {
                int n4 = WebKitGTK.webkit_web_frame_get_uri(n);
                return this.handleLoadCommitted(n4, false);
            }
            case 2: {
                int n5 = WebKitGTK.webkit_web_frame_get_parent(n);
                if (WebKitGTK.webkit_web_frame_get_load_status(n5) != 2) break;
                int n6 = WebKitGTK.webkit_web_frame_get_uri(n);
                return this.handleLoadFinished(n6, false);
            }
        }
        return 0;
    }

    int webkit_close_web_view(int n) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        int n2 = 0;
        while (n2 < this.closeWindowListeners.length) {
            this.closeWindowListeners[n2].close(windowEvent);
            ++n2;
        }
        this.browser.dispose();
        return 0;
    }

    int webkit_console_message(int n, int n2, int n3, int n4) {
        return 1;
    }

    int webkit_create_web_view(int n, int n2) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        windowEvent.required = true;
        if (this.openWindowListeners != null) {
            int n3 = 0;
            while (n3 < this.openWindowListeners.length) {
                this.openWindowListeners[n3].open(windowEvent);
                ++n3;
            }
        }
        Widget widget = null;
        if (windowEvent.browser != null && windowEvent.browser.webBrowser instanceof WebKit) {
            widget = windowEvent.browser;
        }
        if (widget != null && !widget.isDisposed()) {
            return ((WebKit)((Browser)widget).webBrowser).webView;
        }
        return 0;
    }

    int webkit_download_requested(int n, int n2) {
        int n3 = WebKitGTK.webkit_download_get_suggested_filename(n2);
        int n4 = OS.strlen(n3);
        byte[] byArray = new byte[n4];
        OS.memmove(byArray, n3, n4);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        FileDialog fileDialog = new FileDialog(this.browser.getShell(), 4096);
        fileDialog.setFileName(string);
        String string2 = Compatibility.getMessage("SWT_FileDownload");
        fileDialog.setText(string2);
        String string3 = fileDialog.open();
        if (string3 != null) {
            string3 = URI_FILEROOT + string3;
            byte[] byArray2 = Converter.wcsToMbcs(null, string3, true);
            WebKitGTK.webkit_download_set_destination_uri(n2, byArray2);
            this.openDownloadWindow(n2);
        } else {
            WebKitGTK.webkit_download_cancel(n2);
        }
        return 1;
    }

    int webkit_hovering_over_link(int n, int n2, int n3) {
        if (n3 != 0) {
            int n4 = OS.strlen(n3);
            byte[] byArray = new byte[n4];
            OS.memmove(byArray, n3, n4);
            String string = new String(Converter.mbcsToWcs(null, byArray));
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = this.browser.getDisplay();
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = string;
            int n5 = 0;
            while (n5 < this.statusTextListeners.length) {
                this.statusTextListeners[n5].changed(statusTextEvent);
                ++n5;
            }
        }
        return 0;
    }

    int webkit_mime_type_policy_decision_requested(int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        boolean bl2 = bl = WebKitGTK.webkit_web_view_can_show_mime_type(this.webView, n4) != 0;
        if (!bl) {
            WebKitGTK.webkit_web_policy_decision_download(n5);
            return 1;
        }
        return 0;
    }

    int webkit_navigation_policy_decision_requested(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (this.loadingText) {
            return 0;
        }
        int n7 = WebKitGTK.webkit_network_request_get_uri(n3);
        int n8 = OS.strlen(n7);
        byte[] byArray = new byte[n8];
        OS.memmove(byArray, n7, n8);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n8 = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n8) == '#') {
                string = ABOUT_BLANK + string.substring(n8);
            }
        }
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.location = string;
        locationEvent.doit = true;
        if (this.locationListeners != null) {
            n6 = 0;
            while (n6 < this.locationListeners.length) {
                this.locationListeners[n6].changing(locationEvent);
                ++n6;
            }
        }
        if (locationEvent.doit && !this.browser.isDisposed()) {
            int n9;
            if (this.jsEnabledChanged) {
                this.jsEnabledChanged = false;
                n6 = WebKitGTK.webkit_web_view_get_settings(this.webView);
                OS.g_object_set(n6, WebKitGTK.enable_scripts, this.jsEnabled ? 1 : 0, 0);
            }
            if (n2 != (n6 = WebKitGTK.webkit_web_view_get_main_frame(this.webView)) && (n9 = OS.g_signal_handler_find(n2, 24, 0, 0, 0, Proc3.getAddress(), 9)) == 0) {
                OS.g_signal_connect(n2, WebKitGTK.notify_load_status, Proc3.getAddress(), 9);
            }
        } else {
            WebKitGTK.webkit_web_policy_decision_ignore(n5);
        }
        return 0;
    }

    int webkit_notify_load_status(int n, int n2) {
        int n3 = WebKitGTK.webkit_web_view_get_load_status(this.webView);
        switch (n3) {
            case 1: {
                int n4 = WebKitGTK.webkit_web_view_get_uri(this.webView);
                return this.handleLoadCommitted(n4, true);
            }
            case 2: {
                int n5 = WebKitGTK.webkit_web_view_get_uri(this.webView);
                return this.handleLoadFinished(n5, true);
            }
        }
        return 0;
    }

    int webkit_notify_progress(int n, int n2) {
        ProgressEvent progressEvent = new ProgressEvent(this.browser);
        progressEvent.display = this.browser.getDisplay();
        progressEvent.widget = this.browser;
        progressEvent.current = (int)(WebKitGTK.webkit_web_view_get_progress(this.webView) * 100.0);
        progressEvent.total = 100;
        int n3 = 0;
        while (n3 < this.progressListeners.length) {
            this.progressListeners[n3].changed(progressEvent);
            ++n3;
        }
        return 0;
    }

    int webkit_notify_title(int n, int n2) {
        String string;
        int n3 = WebKitGTK.webkit_web_view_get_title(this.webView);
        if (n3 == 0) {
            string = "";
        } else {
            int n4 = OS.strlen(n3);
            byte[] byArray = new byte[n4];
            OS.memmove(byArray, n3, n4);
            string = new String(Converter.mbcsToWcs(null, byArray));
        }
        TitleEvent titleEvent = new TitleEvent(this.browser);
        titleEvent.display = this.browser.getDisplay();
        titleEvent.widget = this.browser;
        titleEvent.title = string;
        int n5 = 0;
        while (n5 < this.titleListeners.length) {
            this.titleListeners[n5].changed(titleEvent);
            ++n5;
        }
        return 0;
    }

    int webkit_populate_popup(int n, int n2) {
        Point point = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = point.x;
        event.y = point.y;
        this.browser.notifyListeners(35, event);
        if (!event.doit) {
            int n3;
            int n4 = n3 = OS.gtk_container_get_children(n2);
            while (n4 != 0) {
                int n5 = OS.g_list_data(n4);
                OS.gtk_container_remove(n2, n5);
                n4 = OS.g_list_next(n4);
            }
            OS.g_list_free(n3);
            return 0;
        }
        Menu menu = this.browser.getMenu();
        if (menu != null && !menu.isDisposed()) {
            int n6;
            if (point.x != event.x || point.y != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            int n7 = n6 = OS.gtk_container_get_children(n2);
            while (n7 != 0) {
                int n8 = OS.g_list_data(n7);
                OS.gtk_container_remove(n2, n8);
                n7 = OS.g_list_next(n7);
            }
            OS.g_list_free(n6);
        }
        return 0;
    }

    int webkit_resource_request_starting(int n, int n2, int n3, int n4, int n5) {
        if (this.postData != null || this.headers != null) {
            int n6 = WebKitGTK.webkit_network_request_get_message(n4);
            if (n6 == 0) {
                this.headers = null;
                this.postData = null;
            } else {
                int n7;
                if (this.postData != null) {
                    WebKitGTK.SoupMessage_method(n6, PostString);
                    n7 = WebKitGTK.SoupMessage_request_body(n6);
                    byte[] byArray = Converter.wcsToMbcs(null, this.postData, false);
                    int n8 = C.malloc(byArray.length);
                    C.memmove(n8, byArray, byArray.length);
                    WebKitGTK.soup_message_body_append(n7, 1, n8, byArray.length);
                    WebKitGTK.soup_message_body_flatten(n7);
                    if (this.headers == null) {
                        this.headers = new String[0];
                    }
                    String[] stringArray = new String[this.headers.length + 1];
                    System.arraycopy(this.headers, 0, stringArray, 0, this.headers.length);
                    stringArray[this.headers.length] = ENCODING_FORM;
                    this.headers = stringArray;
                    this.postData = null;
                }
                n7 = WebKitGTK.SoupMessage_request_headers(n6);
                int n9 = 0;
                while (n9 < this.headers.length) {
                    int n10;
                    String string = this.headers[n9];
                    if (string != null && (n10 = string.indexOf(58)) != -1) {
                        String string2 = string.substring(0, n10).trim();
                        String string3 = string.substring(n10 + 1).trim();
                        if (string2.length() > 0 && string3.length() > 0) {
                            byte[] byArray = Converter.wcsToMbcs(null, string2, true);
                            byte[] byArray2 = Converter.wcsToMbcs(null, string3, true);
                            WebKitGTK.soup_message_headers_append(n7, byArray, byArray2);
                        }
                    }
                    ++n9;
                }
                this.headers = null;
            }
        }
        return 0;
    }

    int webkit_status_bar_text_changed(int n, int n2) {
        int n3 = OS.strlen(n2);
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, n2, n3);
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = new String(Converter.mbcsToWcs(null, byArray));
        int n4 = 0;
        while (n4 < this.statusTextListeners.length) {
            this.statusTextListeners[n4].changed(statusTextEvent);
            ++n4;
        }
        return 0;
    }

    int webkit_web_view_ready(int n) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        int n2 = WebKitGTK.webkit_web_view_get_window_features(this.webView);
        int[] nArray = new int[1];
        OS.g_object_get(n2, WebKitGTK.locationbar_visible, nArray, 0);
        windowEvent.addressBar = nArray[0] != 0;
        nArray[0] = 0;
        OS.g_object_get(n2, WebKitGTK.menubar_visible, nArray, 0);
        windowEvent.menuBar = nArray[0] != 0;
        nArray[0] = 0;
        OS.g_object_get(n2, WebKitGTK.statusbar_visible, nArray, 0);
        windowEvent.statusBar = nArray[0] != 0;
        nArray[0] = 0;
        OS.g_object_get(n2, WebKitGTK.toolbar_visible, nArray, 0);
        windowEvent.toolBar = nArray[0] != 0;
        nArray[0] = 0;
        OS.g_object_get(n2, WebKitGTK.x, nArray, 0);
        int n3 = nArray[0];
        nArray[0] = 0;
        OS.g_object_get(n2, WebKitGTK.y, nArray, 0);
        int n4 = nArray[0];
        nArray[0] = 0;
        OS.g_object_get(n2, WebKitGTK.width, nArray, 0);
        int n5 = nArray[0];
        nArray[0] = 0;
        OS.g_object_get(n2, WebKitGTK.height, nArray, 0);
        int n6 = nArray[0];
        nArray[0] = 0;
        if (n3 != -1 && n4 != -1) {
            windowEvent.location = new Point(n3, n4);
        }
        if (n5 != -1 && n6 != -1) {
            windowEvent.size = new Point(n5, n6);
        }
        int n7 = 0;
        while (n7 < this.visibilityWindowListeners.length) {
            this.visibilityWindowListeners[n7].show(windowEvent);
            ++n7;
        }
        return 0;
    }

    int webkit_window_object_cleared(int n, int n2, int n3, int n4) {
        int n5 = WebKitGTK.JSContextGetGlobalObject(n3);
        int n6 = WebKitGTK.JSObjectMake(n3, ExternalClass, this.webViewData);
        byte[] byArray = null;
        try {
            byArray = "external\u0000".getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, OBJECTNAME_EXTERNAL, true);
        }
        int n7 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
        WebKitGTK.JSObjectSetProperty(n3, n5, n7, n6, 0, null);
        WebKitGTK.JSStringRelease(n7);
        Enumeration enumeration = this.functions.elements();
        while (enumeration.hasMoreElements()) {
            BrowserFunction browserFunction = (BrowserFunction)enumeration.nextElement();
            this.execute(browserFunction.functionString);
        }
        int n8 = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        boolean bl = n8 == n2;
        this.addEventHandlers(bl);
        return 0;
    }

    int callJava(int n, int n2, int n3, int n4, int n5, int n6) {
        Object object = null;
        if (n4 == 3) {
            int[] nArray = new int[1];
            C.memmove(nArray, n5, C.PTR_SIZEOF);
            int n7 = WebKitGTK.JSValueGetType(n, nArray[0]);
            if (n7 == 3) {
                int n8 = ((Double)this.convertToJava(n, nArray[0])).intValue();
                nArray[0] = 0;
                Integer n9 = new Integer(n8);
                C.memmove(nArray, n5 + C.PTR_SIZEOF, C.PTR_SIZEOF);
                n7 = WebKitGTK.JSValueGetType(n, nArray[0]);
                if (n7 == 3) {
                    long l = ((Double)this.convertToJava(n, nArray[0])).longValue();
                    BrowserFunction browserFunction = (BrowserFunction)this.functions.get(n9);
                    if (browserFunction != null && l == browserFunction.token) {
                        try {
                            C.memmove(nArray, n5 + 2 * C.PTR_SIZEOF, C.PTR_SIZEOF);
                            Object object2 = this.convertToJava(n, nArray[0]);
                            if (object2 instanceof Object[]) {
                                Object[] objectArray = (Object[])object2;
                                try {
                                    object = browserFunction.function(objectArray);
                                }
                                catch (Exception exception) {
                                    object = WebBrowser.CreateErrorString(exception.getLocalizedMessage());
                                }
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (browserFunction.isEvaluate) {
                                browserFunction.function(new String[]{WebBrowser.CreateErrorString(new SWTException(51).getLocalizedMessage())});
                            }
                            object = WebBrowser.CreateErrorString(illegalArgumentException.getLocalizedMessage());
                        }
                    }
                }
            }
        }
        return this.convertToJS(n, object);
    }

    int convertToJS(int n, Object object) {
        if (object == null) {
            return WebKitGTK.JSValueMakeUndefined(n);
        }
        if (object instanceof String) {
            byte[] byArray = null;
            try {
                byArray = (String.valueOf((String)object) + '\u0000').getBytes(CHARSET_UTF8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = Converter.wcsToMbcs(null, (String)object, true);
            }
            int n2 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
            int n3 = WebKitGTK.JSValueMakeString(n, n2);
            WebKitGTK.JSStringRelease(n2);
            return n3;
        }
        if (object instanceof Boolean) {
            return WebKitGTK.JSValueMakeBoolean(n, (Boolean)object != false ? 1 : 0);
        }
        if (object instanceof Number) {
            return WebKitGTK.JSValueMakeNumber(n, ((Number)object).doubleValue());
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n4 = objectArray.length;
            int[] nArray = new int[n4];
            int n5 = 0;
            while (n5 < n4) {
                int n6;
                Object object2 = objectArray[n5];
                nArray[n5] = n6 = this.convertToJS(n, object2);
                ++n5;
            }
            return WebKitGTK.JSObjectMakeArray(n, n4, nArray, null);
        }
        SWT.error(51);
        return 0;
    }

    Object convertToJava(int n, int n2) {
        int n3 = WebKitGTK.JSValueGetType(n, n2);
        switch (n3) {
            case 2: {
                int n4 = (int)WebKitGTK.JSValueToNumber(n, n2, null);
                return new Boolean(n4 != 0);
            }
            case 3: {
                double d = WebKitGTK.JSValueToNumber(n, n2, null);
                return new Double(d);
            }
            case 4: {
                int n5 = WebKitGTK.JSValueToStringCopy(n, n2, null);
                if (n5 == 0) {
                    return "";
                }
                int n6 = WebKitGTK.JSStringGetMaximumUTF8CStringSize(n5);
                byte[] byArray = new byte[n6];
                n6 = WebKitGTK.JSStringGetUTF8CString(n5, byArray, n6);
                WebKitGTK.JSStringRelease(n5);
                try {
                    return new String(byArray, 0, n6 - 1, CHARSET_UTF8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return new String(Converter.mbcsToWcs(null, byArray));
                }
            }
            case 0: 
            case 1: {
                return null;
            }
            case 5: {
                byte[] byArray = null;
                try {
                    byArray = "length\u0000".getBytes(CHARSET_UTF8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = Converter.wcsToMbcs(null, PROPERTY_LENGTH, true);
                }
                int n7 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
                int n8 = WebKitGTK.JSObjectGetProperty(n, n2, n7, null);
                WebKitGTK.JSStringRelease(n7);
                n3 = WebKitGTK.JSValueGetType(n, n8);
                if (n3 != 3) break;
                int n9 = (int)WebKitGTK.JSValueToNumber(n, n8, null);
                Object[] objectArray = new Object[n9];
                int n10 = 0;
                while (n10 < n9) {
                    int n11 = WebKitGTK.JSObjectGetPropertyAtIndex(n, n2, n10, null);
                    if (n11 != 0) {
                        objectArray[n10] = this.convertToJava(n, n11);
                    }
                    ++n10;
                }
                return objectArray;
            }
        }
        SWT.error(5);
        return null;
    }
}

