/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import net.java.dev.designgridlayout.AbstractRow;
import net.java.dev.designgridlayout.BaselineHelper;
import net.java.dev.designgridlayout.IRowItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RowItem
implements IRowItem {
    private JComponent _component = null;
    private int _span = 1;
    private RowItem _spanPrevious = null;
    private RowItem _spanNext = null;
    private List<AbstractRow> _rows = Collections.emptyList();

    public RowItem(int span, JComponent component) {
        this._component = component;
        this._span = span;
    }

    public RowItem(RowItem original) {
        this._spanPrevious = original;
        original._spanNext = this;
    }

    @Override
    public JComponent component() {
        return this._spanPrevious != null ? this._spanPrevious.component() : this._component;
    }

    @Override
    public int preferredHeight() {
        if (this._spanPrevious == null && this._spanNext == null) {
            return this._component.getPreferredSize().height;
        }
        if (this._spanNext == null) {
            int height = 0;
            for (int i = 0; i < this._rows.size() - 1; ++i) {
                AbstractRow row = this._rows.get(i);
                height += row.height() + row.vgap();
            }
            return Math.max(0, this.component().getPreferredSize().height - height);
        }
        return 0;
    }

    @Override
    public int minimumWidth() {
        return this.component().getMinimumSize().width;
    }

    @Override
    public int preferredWidth() {
        return this.component().getPreferredSize().width;
    }

    @Override
    public int baseline() {
        return BaselineHelper.getBaseline(this.component());
    }

    @Override
    public void setSpannedRows(List<AbstractRow> rows) {
        this._rows = rows;
        if (this._spanNext != null) {
            this._spanNext.setSpannedRows(this._rows);
        }
    }

    @Override
    public boolean isFirstSpanRow() {
        return this._spanPrevious == null;
    }

    @Override
    public boolean isLastSpanRow() {
        return this._spanNext == null;
    }

    @Override
    public int rowSpan() {
        int rows = 1;
        RowItem next = this._spanNext;
        while (next != null) {
            ++rows;
            next = next._spanNext;
        }
        return rows;
    }

    public void replace(JComponent component) {
        this._component = component;
        this._span = this._spanPrevious.span();
        this._spanPrevious._spanNext = null;
        this._spanPrevious = null;
    }

    public int span() {
        return this._spanPrevious != null ? this._spanPrevious.span() : this._span;
    }
}

