/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import net.java.dev.designgridlayout.BaselineExtractor;
import net.java.dev.designgridlayout.ComponentGapsHelper;
import net.java.dev.designgridlayout.ComponentHelper;
import net.java.dev.designgridlayout.HeightGrowPolicy;
import net.java.dev.designgridlayout.LayoutHelper;
import net.java.dev.designgridlayout.MinWidthExtractor;
import net.java.dev.designgridlayout.NonGridRowItem;
import net.java.dev.designgridlayout.OrientationPolicy;
import net.java.dev.designgridlayout.PrefHeightExtractor;
import net.java.dev.designgridlayout.PrefWidthExtractor;

final class HorizontalLayout
implements LayoutManager {
    private final Container _parent;
    private final HeightGrowPolicy _heightTester;
    private final OrientationPolicy _orientation;
    private final List<NonGridRowItem> _children = new ArrayList<NonGridRowItem>();
    private boolean _inited = false;
    private int _baseline = 0;
    private int _height = 0;
    private int _minWidth = 0;
    private int _prefWidth = 0;
    private int[] _gaps = null;
    private int _gap = 0;

    HorizontalLayout(Container parent, HeightGrowPolicy heightTester, OrientationPolicy orientation) {
        this._parent = parent;
        this._heightTester = heightTester;
        this._orientation = orientation;
    }

    public HorizontalLayout add(JComponent ... children) {
        for (JComponent child : children) {
            this._children.add(new NonGridRowItem(child));
            this._parent.add(child);
        }
        return this;
    }

    public int getBaseline() {
        this.computeAll();
        return this._baseline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        this.checkParent(parent);
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.computeAll();
            boolean rtl = this._orientation.isRightToLeft();
            int parentWidth = parent.getSize().width;
            int availableWidth = parentWidth - this._gap;
            int prefWidth = this._prefWidth - this._gap;
            float ratio = 1.0f;
            if (availableWidth < prefWidth) {
                ratio = (float)availableWidth / (float)prefWidth;
            }
            int nth = 0;
            int x = 0;
            LayoutHelper helper = new LayoutHelper(this._heightTester, parentWidth, rtl);
            helper.setY(0);
            for (NonGridRowItem child : this._children) {
                helper.setRowAvailableHeight(this._parent.getHeight());
                int width = (int)((float)child.preferredWidth() * ratio);
                helper.setSizeLocation(child.component(), x, width, this._height, this._baseline);
                x += width + this._gaps[nth];
                ++nth;
            }
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        this.initSizeCalculation(parent);
        return new Dimension(this._minWidth, this._height);
    }

    public Dimension preferredLayoutSize(Container parent) {
        this.initSizeCalculation(parent);
        return new Dimension(this._prefWidth, this._height);
    }

    private void initSizeCalculation(Container parent) {
        this.checkParent(parent);
        this.computeAll();
    }

    public void addLayoutComponent(String name, Component comp) {
        throw new IllegalArgumentException("do not use this method");
    }

    public void removeLayoutComponent(Component comp) {
        throw new IllegalArgumentException("do not use this method");
    }

    private void computeAll() {
        if (!this._inited) {
            this._baseline = ComponentHelper.maxValues(this._children, BaselineExtractor.INSTANCE);
            this._minWidth = ComponentHelper.sumValues(this._children, MinWidthExtractor.INSTANCE);
            this._prefWidth = ComponentHelper.sumValues(this._children, PrefWidthExtractor.INSTANCE);
            this._height = ComponentHelper.maxValues(this._children, PrefHeightExtractor.INSTANCE);
            ComponentGapsHelper helper = ComponentGapsHelper.instance();
            this._gaps = new int[this._children.size()];
            for (int nth = 0; nth < this._children.size() - 1; ++nth) {
                int gap;
                JComponent left = this._children.get(nth).component();
                JComponent right = this._children.get(nth + 1).component();
                this._gaps[nth] = gap = helper.getHorizontalGap(left, right, 0, this._parent);
                this._gap += gap;
            }
            this._minWidth += this._gap;
            this._prefWidth += this._gap;
            this._gaps[this._children.size() - 1] = 0;
            this._inited = true;
        }
    }

    private void checkParent(Container parent) {
        if (parent != this._parent) {
            throw new IllegalArgumentException("must use HorizontalLayout instance with original parent container");
        }
    }
}

