/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.ppp;

import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.LinuxConnectionManager;
import ru.softlogic.ppp.WindowsConnectionManager;

public class ManagerFactory {
    private static ManagerFactory instance = new ManagerFactory();
    private ConnectionManager manager;

    private ManagerFactory() {
        String osName = SystemProp.getOSName();
        if (osName != null) {
            if (osName.equals("Linux")) {
                this.manager = new LinuxConnectionManager();
            } else if (osName.toLowerCase().indexOf("windows") != -1) {
                this.manager = new WindowsConnectionManager();
            }
        }
    }

    public static ManagerFactory getInstance() {
        return instance;
    }

    public ConnectionManager getManager() {
        return this.manager;
    }
}

