/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.ppp;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.ConnectionState;
import ru.softlogic.ppp.OperationResult;

class LinuxConnectionManager
implements ConnectionManager {
    private ExecutorService executor = Executors.newFixedThreadPool(3);

    @Override
    public String[] getConnectionsList() {
        return new String[]{"notavalible"};
    }

    @Override
    public String[] getActiveConnectionsList() {
        return new String[]{"notavalible"};
    }

    @Override
    public OperationResult connect(String name) {
        try {
            int res = this.executeProcess(Runtime.getRuntime().exec(SystemProp.getTerminalDir() + "/bin/script.sh start-ppp"));
            return new OperationResult(res, res != 0, "");
        }
        catch (IOException ex) {
            return new OperationResult(-10, true, ex.getMessage());
        }
    }

    @Override
    public OperationResult disconnect(String name) {
        try {
            int res = this.executeProcess(Runtime.getRuntime().exec(SystemProp.getTerminalDir() + "/bin/script.sh stop-ppp"));
            return new OperationResult(res, res != 0, "");
        }
        catch (IOException ex) {
            return new OperationResult(-10, true, ex.getMessage());
        }
    }

    @Override
    public int getConnectionState(String name) {
        return ConnectionState.OK_DISCONNECTED;
    }

    @Override
    public OperationResult getLastError() {
        return new OperationResult(0, false, null);
    }

    @Override
    public OperationResult disconnectAll() {
        try {
            int res = this.executeProcess(Runtime.getRuntime().exec(SystemProp.getTerminalDir() + "/bin/script.sh stop-ppp"));
            return new OperationResult(res, res != 0, "");
        }
        catch (IOException ex) {
            return new OperationResult(-10, true, ex.getMessage());
        }
    }

    private int executeProcess(Process proc) {
        ProcessExecutor pe = new ProcessExecutor(proc);
        Future<Integer> ft = this.executor.submit(pe);
        try {
            ft.get(60L, TimeUnit.SECONDS);
            return 0;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return -1;
        }
        catch (ExecutionException ex) {
            proc.destroy();
            return -2;
        }
        catch (TimeoutException ex) {
            proc.destroy();
            return -3;
        }
    }

    private class ProcessExecutor
    implements Callable<Integer> {
        private Process process;

        public ProcessExecutor(Process process) {
            if (process == null) {
                throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Process");
            }
            this.process = process;
        }

        @Override
        public Integer call() throws Exception {
            this.process.waitFor();
            return this.process.exitValue();
        }
    }
}

