/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.security;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import ru.softlogic.security.RiskFactors;
import ru.softlogic.security.Service;
import ru.softlogic.security.SystemCheckerImpl;

class WindowsSystemChecker
implements SystemCheckerImpl {
    private static final String REG_SERVICES = "SYSTEM\\CurrentControlSet\\services";
    private static final String REG_SERIALS = "HARDWARE\\DEVICEMAP\\\\SERIALCOMM";
    private static final String IMAGE_PATH = "ImagePath";
    private static final String DISPLAY_NAME = "DisplayName";
    private static final String[] SRV_NAMES = new String[]{"^com0com$", "vsbc\\d"};
    private static final String[] SRV_KEYWORD = new String[]{"eltima", "evsbc7.sys", "evsbc9.sys", "evsbc8.sys", "com0com.sys"};
    private static final String PRINTABLE = "/-:.,_$%\\()[]<> ";

    WindowsSystemChecker() {
    }

    @Override
    public RiskFactors getRiskFactors() {
        int factors = 0;
        String windir = System.getenv("WINDIR");
        LinkedList<Service> res = new LinkedList<Service>();
        if (Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)REG_SERVICES)) {
            for (String name : Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)REG_SERVICES)) {
                TreeMap params = Advapi32Util.registryGetValues((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)("SYSTEM\\CurrentControlSet\\services\\" + name));
                String ip = this.getValue(params.get(IMAGE_PATH));
                String dn = this.getValue(params.get(DISPLAY_NAME));
                if (!this.isMatch(name) && !this.hasKeyWord(ip) && !this.hasKeyWord(dn)) continue;
                res.add(new Service(name, dn, this.getFile(windir, ip)));
                if (name.toLowerCase().contains("sniff")) {
                    factors |= 2;
                    continue;
                }
                factors |= 1;
            }
        }
        TreeMap<String, String> ports = new TreeMap<String, String>();
        if (Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)REG_SERIALS)) {
            for (Map.Entry entry : Advapi32Util.registryGetValues((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)REG_SERIALS).entrySet()) {
                ports.put(WindowsSystemChecker.fix(this.getValue(entry.getValue())), WindowsSystemChecker.fix((String)entry.getKey()));
            }
        }
        return new RiskFactors(factors, res, new LinkedList<File>(), ports);
    }

    private File getFile(String windir, String path) {
        if ((path = path.replaceAll("%SystemRoot%", windir).replace("??\\", "")).toLowerCase().startsWith("syst")) {
            return new File(windir, path);
        }
        return new File(path);
    }

    private boolean hasKeyWord(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        value = value.toLowerCase();
        for (String kw : SRV_KEYWORD) {
            if (!value.contains(kw)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatch(String value) {
        value = value.toLowerCase();
        for (String f : SRV_NAMES) {
            if (!value.matches(f)) continue;
            return true;
        }
        return false;
    }

    private String getValue(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return ((String)obj).trim();
        }
        if (obj instanceof String[]) {
            String[] vals = (String[])obj;
            return vals.length > 0 && vals[0] != null ? vals[0].trim() : "";
        }
        return "";
    }

    private static String fix(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            sb.append(WindowsSystemChecker.isStringChar(ch) ? ch : (char)'?');
        }
        return sb.toString();
    }

    public static boolean isStringChar(char ch) {
        if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
            return true;
        }
        return PRINTABLE.indexOf(ch) >= 0;
    }
}

