/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.queue;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.cashin.validator.statistics.Statistics;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.adv.AdvStatistic;
import ru.softlogic.srv.api.card.SaleConfirm;
import ru.softlogic.srv.api.cbc.CbcStatus;
import ru.softlogic.srv.api.command.CommandResult;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.modem.ModemState;
import ru.softlogic.srv.api.network.NetworkStatistics;
import ru.softlogic.srv.api.oth.Demand;
import ru.softlogic.srv.api.oth.JammInfo;
import ru.softlogic.srv.connector.ZReportInfo;

public class QueueData
implements Serializable {
    static final long serialVersionUID = -4094143859376574009L;
    private List<Event> events;
    private List<ZReportInfo> zReportInfos;
    private List<Statistics> statistics;
    private List<SaleConfirm> saleConfirms;
    private List<CommandResult> commandResults;
    private List<ModemState> modemStates;
    private List<String> servicesDemande;
    private List<JammInfo> jammInfos;
    private List<Serializable> financialQueue;
    private List<NetworkStatistics> networkStatistics;
    private List<CbcStatus> cbcStates;
    private List<Demand> demands;
    private boolean remoteLock;
    private List<AdvStatistic> advStatistics;

    public boolean isRemoteLock() {
        return this.remoteLock;
    }

    public void setRemoteLock(boolean remoteLock) {
        this.remoteLock = remoteLock;
    }

    public List<CommandResult> getCommandResults() {
        if (this.commandResults == null) {
            this.commandResults = new LinkedList<CommandResult>();
        }
        return this.commandResults;
    }

    public List<SaleConfirm> getSaleConfirms() {
        if (this.saleConfirms == null) {
            this.saleConfirms = new LinkedList<SaleConfirm>();
        }
        return this.saleConfirms;
    }

    public List<Event> getEvents() {
        if (this.events == null) {
            this.events = new LinkedList<Event>();
        }
        return this.events;
    }

    public List<ZReportInfo> getZReportInfos() {
        if (this.zReportInfos == null) {
            this.zReportInfos = new LinkedList<ZReportInfo>();
        }
        return this.zReportInfos;
    }

    public List<ModemState> getModemStates() {
        if (this.modemStates == null) {
            this.modemStates = new LinkedList<ModemState>();
        }
        return this.modemStates;
    }

    public List<String> getServicesDemande() {
        if (this.servicesDemande == null) {
            this.servicesDemande = new LinkedList<String>();
        }
        return this.servicesDemande;
    }

    public List<Statistics> getStatistics() {
        if (this.statistics == null) {
            this.statistics = new LinkedList<Statistics>();
        }
        return this.statistics;
    }

    public List<AdvStatistic> getAdvStatistics() {
        if (this.advStatistics == null) {
            this.advStatistics = new LinkedList<AdvStatistic>();
        }
        return this.advStatistics;
    }

    public List<JammInfo> getJammInfos() {
        if (this.jammInfos == null) {
            this.jammInfos = new LinkedList<JammInfo>();
        }
        return this.jammInfos;
    }

    public List<Serializable> getFinancialQueue() {
        if (this.financialQueue == null) {
            this.financialQueue = new LinkedList<Serializable>();
        }
        return this.financialQueue;
    }

    public List<NetworkStatistics> getNetworkStatistics() {
        if (this.networkStatistics == null) {
            this.networkStatistics = new LinkedList<NetworkStatistics>();
        }
        return this.networkStatistics;
    }

    public List<CbcStatus> getCbcStates() {
        if (this.cbcStates == null) {
            this.cbcStates = new LinkedList<CbcStatus>();
        }
        return this.cbcStates;
    }

    public List<Demand> getDemandes() {
        if (this.demands == null) {
            this.demands = new LinkedList<Demand>();
        }
        return this.demands;
    }

    public int getSize() {
        return this.getEvents().size() + this.getStatistics().size() + this.getSaleConfirms().size() + this.getCommandResults().size() + this.getServicesDemande().size() + this.financialQueue.size();
    }

    public long getAge() {
        Date min = new Date();
        for (Event e : this.getEvents()) {
            if (e.getDate().compareTo(min) >= 0) continue;
            min = e.getDate();
        }
        for (Statistics st : this.getStatistics()) {
            if (st.getTo().compareTo(min) >= 0) continue;
            min = st.getTo();
        }
        for (SaleConfirm sc : this.getSaleConfirms()) {
            if (sc.getOperation().getDate().compareTo(min) >= 0) continue;
            min = sc.getOperation().getDate();
        }
        for (Serializable obj : this.getFinancialQueue()) {
            MoneyCollection mc;
            if (obj instanceof Operation) {
                Operation op = (Operation)obj;
                if (op.getDate().compareTo(min) >= 0) continue;
                min = op.getDate();
                continue;
            }
            if (!(obj instanceof MoneyCollection) || (mc = (MoneyCollection)obj).getDate().compareTo(min) >= 0) continue;
            min = mc.getDate();
        }
        return new Date().getTime() - min.getTime();
    }

    public String toString() {
        return "QueueData{events=" + this.events + ",z-report=" + this.zReportInfos + ",statistics=" + this.statistics + ",advStatistics=" + this.advStatistics + ",saleConfirms=" + this.saleConfirms + ",commandResults=" + this.commandResults + ",modemStates=" + this.modemStates + ",servicesDemande=" + this.servicesDemande + ",jammInfos=" + this.jammInfos + ",financialQueue=" + this.financialQueue + ",networkStatistics=" + this.networkStatistics + '}';
    }
}

