/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.connector.ws.security;

import java.security.SignatureException;
import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.softlogic.srv.connector.ws.security.SignatureAuth;
import ru.softlogic.srv.connector.ws.util.WSUtils;

public class SecurityHandler
implements SOAPHandler<SOAPMessageContext> {
    private Logger logger = Logger.getLogger((String)"net");
    private SignatureAuth auth;

    public SecurityHandler(SignatureAuth auth) {
        this.auth = auth;
    }

    public boolean handleMessage(SOAPMessageContext messageContext) {
        this.logger.setAdditivity(false);
        boolean outbound = (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        SOAPMessage msg = messageContext.getMessage();
        if (outbound) {
            return this.processOutputMessage(msg);
        }
        return this.processInputMessage(msg);
    }

    private boolean processOutputMessage(SOAPMessage msg) {
        SOAPHeader header = null;
        SOAPBody body = null;
        try {
            body = msg.getSOAPBody();
            String bodyString = WSUtils.nodeToString((Node)body);
            String bodySign = WSUtils.nodeToSign(msg.getSOAPBody().getFirstChild());
            this.logger.info((Object)("Request body: " + bodyString));
            header = msg.getSOAPHeader();
            Element signatureElement = (Element)header.getChildNodes().item(0);
            signatureElement.setAttribute("sign2", this.auth.signMessage(bodySign));
        }
        catch (SignatureException ex) {
            this.logger.error((Object)ex.getMessage());
        }
        catch (SOAPException ex) {
            this.logger.error((Object)ex.getMessage());
        }
        return true;
    }

    private boolean processInputMessage(SOAPMessage msg) {
        boolean canAccess = false;
        SOAPBody body = null;
        try {
            body = msg.getSOAPBody();
            String bodyString = WSUtils.nodeToString((Node)msg.getSOAPBody());
            String bodySign = WSUtils.nodeToSign(msg.getSOAPBody().getFirstChild());
            this.logger.info((Object)("Response body: " + bodyString));
            String signature = ((Element)msg.getSOAPHeader().getFirstChild()).getAttribute("sign2");
            canAccess = this.auth.verifySignature(bodySign, signature);
            if (!canAccess) {
                SOAPFault fault = body.addFault();
                fault.setFaultCode(new QName("http://soft-logic.ru", "AccessDenied"));
                fault.setFaultString("Sign error");
                throw new SOAPFaultException(fault);
            }
            return true;
        }
        catch (SignatureException ex) {
            this.logger.error((Object)ex.getMessage());
        }
        catch (SOAPException ex) {
            this.logger.error((Object)ex.getMessage());
        }
        return true;
    }

    public Set<QName> getHeaders() {
        return Collections.emptySet();
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        return true;
    }

    public void close(MessageContext context) {
    }
}

