/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.reference.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import ru.softlogic.cash.Sum;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.service.ProcessingType;
import ru.softlogic.reference.service.ServiceLang;
import ru.softlogic.reference.service.ServiceLimit;
import ru.softlogic.reference.service.ServiceModules;
import ru.softlogic.reference.service.VerifyType;
import ru.softlogic.service.comission.Commission;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Service")
public class Service
implements Serializable {
    public static final short PAPER_NOT_REQUIRED = 0;
    public static final short PAPER_REQUIRED = 1;
    public static final short PAPER_IGNORE = 2;
    public static final short PAPER_NOT_REQUIRED_SEND_SMS = 3;
    public static final short PAPER_REQUIRED_SEND_SMS = 4;
    public static final short CHANGE_PIN = 1;
    public static final short CHANGE_SERVICE = 2;
    public static final short CHANGE_CASH = 4;
    public static final short CHANGE_MOBILE = 8;
    public static final short CHANGE_TO_SAVE = 16;
    public static final short CHANGE_TO_KEEPER = 32;
    public static final short PAY_SCHEMA_FLAG_CASH = 1;
    public static final short PAY_SCHEMA_FLAG_CBC = 2;
    public static final short PAY_SCHEMA_FLAG_BANK_CARD = 4;
    public static final short PAY_SCHEMA_FLAG_KEEPER = 8;
    public static final short PAY_SCHEMA_FLAG_OTHER_BANK_CARD = 16;
    public static final long SHOW_CONFIRM = 1L;
    public static final long SHOW_CASHBACK = 2L;
    public static final long PAYMENT_SCHEMA_OR = 4L;
    public static final long DISABLE_EXIT_ON_CASH = 8L;
    public static final long USE_FOR_CHANGE = 16L;
    public static final long AUTO_FINISH_PAYMENT = 32L;
    public static final long PAYMENT_SAME_DETAILS = 64L;
    public static final long USE_IN_AD_SENDING = 128L;
    public static final long FISCAL_SERVICE = 256L;
    public static final long NOT_FISCAL = 512L;
    public static final long NAVIGATE_THROUGH_KEEPER = 1024L;
    public static final long SHOW_ONLINE_CHECK_INFO = 2048L;
    public static final long GROUP_PAYMENT_DIVIDED_COMMISSION = 4096L;
    public static final long DIVIDE_GROUP_PAYMENT = 8192L;
    public static final long PRINT_SINGLE_CHECK_ON_MOB_CHANGE = 16384L;
    public static final long FLAG_PAPER_NEED = 65536L;
    public static final long FLAG_PAPER_SHOW_WARNING = 131072L;
    public static final long FLAG_PAPER_SEND_SMS = 262144L;
    public static final long FLAG_PAPER_SEND_SMS_IF_ABSENT = 524288L;
    public static final long ZERO_AMOUNT = 0x200000L;
    static final long serialVersionUID = 1632469991915762973L;
    @XmlAttribute(name="id")
    private int id;
    @XmlAttribute(name="code")
    private int code;
    @XmlAttribute(name="barcode")
    private String barcodePrefix;
    @XmlAttribute(name="name")
    private String name;
    @XmlAttribute(name="pname")
    private String printName;
    @XmlAttribute(name="altName")
    protected String altName;
    @XmlElement(name="invitation")
    private String invitation;
    @XmlAttribute(name="image")
    private String image;
    @XmlElement(name="mins")
    private Sum minSum;
    @XmlElement(name="maxs")
    private Sum maxSum;
    @XmlElement(name="maxis")
    private Sum maxInputSum;
    @XmlElement(name="divs")
    private Sum divideSum;
    @XmlElement(name="multis")
    private Sum multiplicitySum;
    @XmlAttribute(name="vtype")
    private VerifyType verifyType;
    @XmlAttribute(name="ptype")
    private ProcessingType processingType;
    @XmlElement(name="pSource")
    private List<String> paymentSources;
    @XmlAttribute(name="pschemafl")
    private int paymentSchemaFlags;
    @XmlAttribute(name="bName")
    private String bankName;
    @XmlAttribute(name="bBik")
    private String bankBik;
    @XmlAttribute(name="bRs")
    private String bankRs;
    @XmlAttribute(name="bKs")
    private String bankKs;
    @XmlAttribute(name="provider")
    private ProviderType providerType;
    @XmlElement(name="text")
    private String printText;
    @XmlElement(name="cs")
    private List<Integer> childServices;
    @XmlElement(name="prepaid")
    private int[] prepaidSteps;
    @XmlElement(name="comm")
    private Commission commission;
    @XmlElement(name="minComm")
    private Commission minComm;
    @XmlElement(name="warning")
    private String warning;
    @XmlAttribute(name="render")
    private String checkRender;
    @XmlElement(name="prov")
    private Dealer provider;
    @XmlElement(name="oper")
    private Dealer operator;
    @XmlAttribute(name="printCheck")
    private Boolean printCheckDialog;
    @XmlAttribute(name="changet")
    private short changeType;
    @XmlAttribute(name="style")
    private String style;
    @XmlAttribute(name="currency")
    private String currencyCode;
    @XmlAttribute(name="togetherSID")
    private String togetherServicesId;
    @XmlAttribute(name="oferta")
    private String oferta;
    @XmlAttribute(name="ntmra")
    private Integer notTakeMoneyReachesAmount;
    @XmlElement(name="modules")
    private ServiceModules modules;
    @XmlAttribute(name="auto_process")
    private Integer autoProcessDueToInactivity;
    @XmlAttribute(name="stid")
    private Short serviceTypeId;
    @XmlAttribute(name="flags")
    private long flags;
    @XmlAttribute(name="lfuf")
    private int limitForUndrawnFunds;
    @XmlAttribute(name="firstBillEqMins")
    private boolean firstBillEqualsMinSum;
    @XmlElementWrapper(name="limits")
    @XmlElement(name="limit")
    private List<ServiceLimit> limits;
    @XmlAttribute(name="successSms")
    private Boolean successSms;
    @XmlAttribute(name="successSmsPhone")
    private String successSmsPhone;
    private Map<String, ServiceLang> langs = new HashMap<String, ServiceLang>();
    private Map<String, String> properties = new HashMap<String, String>();

    public Service() {
    }

    public Service(int id) {
        this.id = id;
    }

    public Service(Service oth) {
        this.id = oth.id;
        this.code = oth.code;
        this.name = oth.name;
        this.printName = oth.printName;
        this.invitation = oth.invitation;
        this.image = oth.image;
        this.minSum = oth.minSum;
        this.maxSum = oth.maxSum;
        this.verifyType = oth.verifyType;
        this.processingType = oth.processingType;
        this.providerType = oth.providerType;
        this.printText = oth.printText;
        this.childServices = oth.childServices;
        this.prepaidSteps = oth.prepaidSteps;
        this.commission = oth.commission;
        this.warning = oth.warning;
        this.checkRender = oth.checkRender;
        this.provider = oth.provider;
        this.operator = oth.operator;
        this.printCheckDialog = oth.printCheckDialog;
        this.paymentSchemaFlags = oth.paymentSchemaFlags;
        this.paymentSources = oth.paymentSources == null ? null : new ArrayList<String>(oth.paymentSources);
        this.flags = oth.flags;
        this.limitForUndrawnFunds = oth.limitForUndrawnFunds;
        this.limits = oth.limits;
        this.bankName = oth.bankName;
        this.bankBik = oth.bankBik;
        this.bankRs = oth.bankRs;
        this.bankKs = oth.bankKs;
        this.firstBillEqualsMinSum = oth.firstBillEqualsMinSum;
        this.successSms = oth.successSms;
        this.successSmsPhone = oth.successSmsPhone;
    }

    public List<Integer> getChildServices() {
        return this.childServices;
    }

    public void setChildServices(List<Integer> childServices) {
        this.childServices = childServices;
    }

    public Commission getCommission() {
        return this.commission;
    }

    public void setCommission(Commission commission) {
        this.commission = commission;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getInvitation() {
        return this.invitation;
    }

    public void setInvitation(String invitation) {
        this.invitation = invitation;
    }

    public Map<String, ServiceLang> getLangs() {
        return this.langs;
    }

    public void setLangs(Map<String, ServiceLang> langs) {
        this.langs = langs;
    }

    public int getLimitForUndrawnFunds() {
        return this.limitForUndrawnFunds;
    }

    public void setLimitForUndrawnFunds(int limitForUndrawnFunds) {
        this.limitForUndrawnFunds = limitForUndrawnFunds;
    }

    public List<ServiceLimit> getLimits() {
        return this.limits;
    }

    public void setLimits(List<ServiceLimit> limits) {
        this.limits = limits;
    }

    public Sum getMaxSum() {
        return this.maxSum;
    }

    public void setMaxSum(Sum maxSum) {
        this.maxSum = maxSum;
    }

    public Sum getMinSum() {
        return this.minSum;
    }

    public void setMinSum(Sum minSum) {
        this.minSum = minSum;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Short getPaperRequire() {
        return this.getPaperCondition();
    }

    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    public boolean isFlagExist(long flag) {
        return (this.flags & flag) != 0L;
    }

    public int[] getPrepaidSteps() {
        return this.prepaidSteps;
    }

    public void setPrepaidSteps(int[] prepaidSteps) {
        this.prepaidSteps = prepaidSteps;
    }

    public String getPrintName() {
        return this.printName;
    }

    public void setPrintName(String printName) {
        this.printName = printName;
    }

    public String getPrintText() {
        return this.printText;
    }

    public void setPrintText(String printText) {
        this.printText = printText;
    }

    public ProcessingType getProcessingType() {
        return this.processingType;
    }

    public void setProcessingType(ProcessingType processingType) {
        this.processingType = processingType;
    }

    public ProviderType getProviderType() {
        return this.providerType;
    }

    public void setProviderType(ProviderType providerType) {
        this.providerType = providerType;
    }

    public VerifyType getVerifyType() {
        return this.verifyType;
    }

    public void setVerifyType(VerifyType verifyType) {
        this.verifyType = verifyType;
    }

    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    public Dealer getOperator() {
        return this.operator;
    }

    public void setOperator(Dealer operator) {
        this.operator = operator;
    }

    public Dealer getProvider() {
        return this.provider;
    }

    public void setProvider(Dealer provider) {
        this.provider = provider;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public boolean isShowConfirm() {
        return (this.flags & 1L) != 0L;
    }

    public boolean isShowVerifyResult() {
        return (this.flags & 0x800L) != 0L;
    }

    public String getCheckRender() {
        return this.checkRender;
    }

    public void setCheckRender(String checkRender) {
        this.checkRender = checkRender;
    }

    public boolean isDisableExitOnCash() {
        return (this.flags & 8L) != 0L;
    }

    public boolean isShowCashback() {
        return (this.flags & 2L) != 0L;
    }

    public boolean isSendZeroAmount() {
        return (this.flags & 0x200000L) != 0L;
    }

    public Boolean getPrintCheckDialog() {
        return this.printCheckDialog;
    }

    public void setPrintCheckDialog(Boolean printCheckDialog) {
        this.printCheckDialog = printCheckDialog;
    }

    public Sum getDivideSum() {
        return this.divideSum;
    }

    public void setDivideSum(Sum divideSum) {
        this.divideSum = divideSum;
    }

    public Commission getMinComm() {
        return this.minComm;
    }

    public void setMinComm(Commission minComm) {
        this.minComm = minComm;
    }

    public String getBarcodePrefix() {
        return this.barcodePrefix;
    }

    public void setBarcodePrefix(String barcodePrefix) {
        this.barcodePrefix = barcodePrefix;
    }

    public Sum getMultiplicitySum() {
        return this.multiplicitySum;
    }

    public void setMultiplicitySum(Sum multiplicitySum) {
        this.multiplicitySum = multiplicitySum;
    }

    public Sum getMaxInputSum() {
        return this.maxInputSum;
    }

    public void setMaxInputSum(Sum maxInputSum) {
        this.maxInputSum = maxInputSum;
    }

    public String getAltName() {
        return this.altName;
    }

    public void setAltName(String altName) {
        this.altName = altName;
    }

    public short getChangeType() {
        return this.changeType;
    }

    public void setChangeType(short changeType) {
        this.changeType = changeType;
    }

    public boolean isUseForChange() {
        return (this.flags & 0x10L) != 0L;
    }

    public boolean isAutoFinishPayment() {
        return (this.flags & 0x20L) != 0L;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean isPaymentSameDetails() {
        return (this.flags & 0x40L) != 0L;
    }

    public String getTogetherServicesId() {
        return this.togetherServicesId;
    }

    public void setTogetherServicesId(String togetherServicesId) {
        this.togetherServicesId = togetherServicesId;
    }

    public boolean isUseInAdSending() {
        return (this.flags & 0x80L) != 0L;
    }

    public boolean isFiscalService() {
        return (this.flags & 0x100L) != 0L;
    }

    public boolean isNotFiscal() {
        return (this.flags & 0x200L) != 0L;
    }

    public boolean isPrintSingleCheckOnMobileChange() {
        return (this.flags & 0x4000L) != 0L;
    }

    public String getOferta() {
        return this.oferta;
    }

    public void setOferta(String oferta) {
        this.oferta = oferta;
    }

    public int getPaymentSchemaFlags() {
        return this.paymentSchemaFlags;
    }

    public void setPaymentSchemaFlags(int paymentSchemaFlags) {
        this.paymentSchemaFlags = paymentSchemaFlags;
    }

    public boolean isPaymentSchemaOr() {
        return (this.flags & 4L) != 0L;
    }

    public Integer getNotTakeMoneyReachesAmount() {
        return this.notTakeMoneyReachesAmount;
    }

    public void setNotTakeMoneyReachesAmount(Integer notTakeMoneyReachesAmount) {
        this.notTakeMoneyReachesAmount = notTakeMoneyReachesAmount;
    }

    public ServiceModules getModules() {
        return this.modules;
    }

    public void setModules(ServiceModules modules) {
        this.modules = modules;
    }

    public List<String> getPaymentSources() {
        return this.paymentSources;
    }

    public void setPaymentSources(List<String> paymentSources) {
        this.paymentSources = paymentSources;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Service other = (Service)obj;
        return this.id == other.id;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.id;
        return hash;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public boolean isGroupPaymentDividedCommission() {
        return (this.flags & 0x1000L) != 0L;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Integer getAutoProcessDueToInactivity() {
        return this.autoProcessDueToInactivity;
    }

    public void setAutoProcessDueToInactivity(Integer autoProcessDueToInactivity) {
        this.autoProcessDueToInactivity = autoProcessDueToInactivity;
    }

    public Short getServiceTypeId() {
        return this.serviceTypeId;
    }

    public void setServiceTypeId(Short serviceTypeId) {
        this.serviceTypeId = serviceTypeId;
    }

    public short getPaperCondition() {
        if (!this.isFlagExist(65536L) && this.isFlagExist(131072L)) {
            return 0;
        }
        if (this.isFlagExist(65536L)) {
            return 1;
        }
        if (!this.isFlagExist(65536L) && !this.isFlagExist(131072L)) {
            return 2;
        }
        if (this.isFlagExist(65536L) && this.isFlagExist(262144L)) {
            return 3;
        }
        if (this.isFlagExist(524288L)) {
            return 4;
        }
        return 2;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankBik() {
        return this.bankBik;
    }

    public void setBankBik(String bankBik) {
        this.bankBik = bankBik;
    }

    public String getBankRs() {
        return this.bankRs;
    }

    public void setBankRs(String bankRs) {
        this.bankRs = bankRs;
    }

    public String getBankKs() {
        return this.bankKs;
    }

    public void setBankKs(String bankKs) {
        this.bankKs = bankKs;
    }

    public boolean isFirstBillEqualsMinSum() {
        return this.firstBillEqualsMinSum;
    }

    public void setFirstBillEqualsMinSum(boolean firstBillEqualsMinSum) {
        this.firstBillEqualsMinSum = firstBillEqualsMinSum;
    }

    public Boolean getSuccessSms() {
        return this.successSms;
    }

    public void setSuccessSms(Boolean successSms) {
        this.successSms = successSms;
    }

    public String getSuccessSmsPhone() {
        return this.successSmsPhone;
    }

    public void setSuccessSmsPhone(String successSmsPhone) {
        this.successSmsPhone = successSmsPhone;
    }

    public String toString() {
        return "Service[" + this.id + ",code=" + this.code + ", name=" + this.name + ",print-name=" + this.printName + ",child=" + this.childServices + ",langs=" + this.langs + ",limitForUndrawnFunds=" + this.limitForUndrawnFunds + ",flags=" + this.flags + ",div-sum=" + this.divideSum + ",modules=" + this.modules + ",auto-process=" + this.autoProcessDueToInactivity + "]";
    }
}

