/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.cash;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Sum", namespace="http://soft-logic.ru")
public class Sum
implements Comparable<Sum>,
Serializable {
    static final long serialVersionUID = -8630614555296427348L;
    @XmlAttribute(name="c")
    private String currency;
    @XmlAttribute(name="s")
    private int sum;

    public Sum() {
    }

    public Sum(int sum) {
        this.sum = sum;
    }

    public Sum(double sum) {
        double koef = 100.0;
        this.sum = (int)Math.round(koef * sum);
    }

    public Sum(Sum sum) {
        this(sum.sum);
    }

    public final int getBasicSum() {
        return this.sum;
    }

    public final Currency getCurrency() {
        return Currency.getInstance(this.currency);
    }

    public final double getSum() {
        double koef = 0.01;
        return (double)this.sum * koef;
    }

    public String toString() {
        if ("uk".equals(Locale.getDefault().getLanguage())) {
            return NumberFormat.getNumberInstance().format(this.getSum()) + " \u0433\u0440\u043d.";
        }
        if ("NP".equals(Locale.getDefault().getCountry())) {
            return NumberFormat.getNumberInstance().format(this.getSum()) + " NRs";
        }
        return NumberFormat.getCurrencyInstance().format(this.getSum());
    }

    public Sum add(Sum addSum) {
        if (addSum == null) {
            throw new IllegalArgumentException("\u0421\u0443\u043c\u043c\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c null");
        }
        return new Sum(this.sum + addSum.getBasicSum());
    }

    public Sum sub(Sum subSum) {
        if (subSum == null) {
            throw new IllegalArgumentException("\u0421\u0443\u043c\u043c\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c null");
        }
        return new Sum(this.sum - subSum.getBasicSum());
    }

    public Sum mul(Sum mulSum) {
        if (mulSum == null) {
            throw new IllegalArgumentException("\u0421\u0443\u043c\u043c\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c null");
        }
        return new Sum(this.getSum() * mulSum.getSum());
    }

    public Sum mul(int multiplier) {
        return new Sum(this.getSum() * (double)multiplier);
    }

    public Sum mul(double multiplier) {
        return new Sum((int)Math.round((double)this.getBasicSum() * multiplier));
    }

    public Sum div(double divider) {
        return new Sum((int)Math.round((double)this.getBasicSum() / divider));
    }

    public Sum divRest(Sum divSum) {
        if (divSum == null) {
            throw new IllegalArgumentException("\u0421\u0443\u043c\u043c\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c null");
        }
        return new Sum(this.getSum() % divSum.getSum());
    }

    public Sum intSum() {
        int intSum = (int)this.getSum();
        return new Sum((double)intSum);
    }

    public boolean isEmpty() {
        return this.sum == 0;
    }

    @Override
    public int compareTo(Sum other) {
        return (int)Math.signum(this.sum - other.sum);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sum other = (Sum)obj;
        if (this.currency == null ? other.currency != null : !this.currency.equals(other.currency)) {
            return false;
        }
        return this.sum == other.sum;
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + (this.currency != null ? this.currency.hashCode() : 0);
        hash = 47 * hash + this.sum;
        return hash;
    }

    public static boolean isSumEmpty(Sum nsum) {
        return nsum != null && !nsum.isEmpty();
    }
}

