/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app;

import i18n.B;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.bwlist.PersonalNumber;
import ru.softlogic.reference.bwlist.PersonalNumberType;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.CommissionStep;
import ru.softlogic.service.comission.CommissionUnit;
import ru.softlogic.service.comission.FeeSum;

public class CommissionRender {
    protected static CommissionRender instance;
    protected Locale locale;
    protected ResourceBundle bundle;
    protected ResourceBundle jarBundle;
    private final Logger log = Logger.getLogger((String)"gui");

    public static synchronized CommissionRender getInstance() {
        if (instance == null) {
            instance = new CommissionRender();
        }
        return instance;
    }

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public void setJarBundle(ResourceBundle bundle) {
        this.jarBundle = bundle;
    }

    public void setLocale(Locale nLocale) {
        this.locale = nLocale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getString(String id) {
        try {
            return this.bundle.getString(id);
        }
        catch (Throwable ex) {
            try {
                return this.jarBundle.getString(id);
            }
            catch (Throwable e) {
                if (ProblemNotifier.getDefaultNotifier() != null) {
                    ProblemNotifier.getDefaultNotifier().onProblemOnce("No Message: " + id + "," + this.locale);
                }
                return id + "," + this.locale;
            }
        }
    }

    private String sumDescription(Sum sum, double percent) {
        String res = "";
        res = sum.isEmpty() ? CommissionRender.format(percent) + "%" : (Double.compare(percent, 0.0) == 0 ? sum.toString() : sum.toString() + " + " + CommissionRender.format(percent) + "%");
        if ("0%".equals(res)) {
            res = null;
        }
        return res;
    }

    public String getFeeSumDescription(FeeSum fs) {
        return this.sumDescription(new Sum(fs.getFee()), fs.getFeePercent());
    }

    public String getStepDescription(CommissionStep step) {
        return this.sumDescription(step.getFixedValue(), step.getPercentValue());
    }

    public String getBounds(Commission commission) {
        if (commission == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (commission.getMin() != null && !commission.getMin().isEmpty()) {
            sb.append(this.getString("Screen.std.sum.mincomm")).append(": ").append(commission.getMin().toString()).append("<br>");
        }
        if (commission.getMax() != null && !commission.getMax().isEmpty()) {
            sb.append(this.getString("Screen.std.sum.maxcomm")).append(": ").append(commission.getMax().toString()).append("<br>");
        }
        return sb.toString();
    }

    public String formatSum(double sum) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(0);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        return df.format(sum);
    }

    public static CommissionStep firstEnableStep(SortedSet<CommissionStep> steps, Date startPay, String paymentSource) {
        for (CommissionStep step : steps) {
            if (!CommissionCalculator.isStepEnable(step, startPay, paymentSource)) continue;
            return step;
        }
        return null;
    }

    public JPanel processComissionPanel(Commission commission, Service service, Map<String, Object> screenData, Locale locale, int paymentTool) {
        Sum maxCom;
        Sum com;
        Sum minCom;
        this.log.info((Object)"CommissionRender.processComissionPanel");
        if (commission == null) {
            return new JPanel();
        }
        Sum compareSum = this.getSumpurchaseORKeeperSum(screenData);
        if (compareSum == null) {
            compareSum = new Sum(1000);
        }
        Commission minCommission = service.getMinComm();
        Commission maxCommission = service.getCommission();
        Commission currentCommission = this.getPersonalCommission(service, screenData);
        if (minCommission != null && maxCommission != null && maxCommission.getId() == minCommission.getId()) {
            return this.processComissionPanel(maxCommission, null, locale, paymentTool);
        }
        if (minCommission != null && (minCom = CommissionCalculator.calculateCommissionSum(compareSum, null, minCommission, null, null, null, null, null)).compareTo(com = CommissionCalculator.calculateCommissionSum(compareSum, null, currentCommission, null, null, null, null, null)) > 0) {
            currentCommission = minCommission;
        }
        if (maxCommission != null && (maxCom = CommissionCalculator.calculateCommissionSum(compareSum, null, maxCommission, null, null, null, null, null)).compareTo(com = CommissionCalculator.calculateCommissionSum(compareSum, null, currentCommission, null, null, null, null, null)) < 0) {
            currentCommission = maxCommission;
        }
        return this.processComissionPanel(currentCommission, null, locale, paymentTool);
    }

    public JPanel processComissionPanel(Commission commission, Commission serviceCommission, Locale locale, int paymentTool) {
        return new JPanel();
    }

    private Commission getPersonalCommission(Service service, Map<String, Object> screenData) {
        Commission currentCommission = null;
        try {
            PersonalNumber[] personalNumbers = ReferenceManager.getInstance().getPersonalNumbers(service);
            if (screenData != null && personalNumbers != null && personalNumbers.length > 0) {
                block2: for (PersonalNumber pn : personalNumbers) {
                    for (String key : screenData.keySet()) {
                        InputElement value;
                        Object obj = screenData.get(key);
                        if (obj == null || !(obj instanceof InputElement) || (value = (InputElement)obj).getValue() == null || !value.getValue().equals(pn.getNumber()) || pn.getType() != PersonalNumberType.White) continue;
                        currentCommission = pn.getCommission();
                        continue block2;
                    }
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage());
        }
        return currentCommission;
    }

    private Sum getSumpurchaseORKeeperSum(Map<String, Object> screenData) {
        Sum compareSum = null;
        if (screenData != null) {
            Object obj = screenData.get("#sum");
            if (obj != null) {
                InputElement sumIE;
                if (obj instanceof TransactionSum) {
                    TransactionSum ts = (TransactionSum)obj;
                    compareSum = new Sum((double)ts.getSum() * Math.pow(10.0, -ts.getFractionDigits()));
                } else if (obj instanceof InputElement && (sumIE = (InputElement)obj).getValue().matches("^\\d+(\\.\\d{0,2})?")) {
                    compareSum = new Sum(Double.parseDouble(sumIE.getValue()));
                }
            } else {
                Object keeperSum = screenData.get("keeper-sum");
                if (keeperSum != null && keeperSum instanceof Sum) {
                    return (Sum)keeperSum;
                }
            }
        }
        return compareSum;
    }

    public Commission processCommission(Commission commission, Service service, Map<String, Object> screenData, Locale locale, boolean ignoreMinMaxCommission, Date startPay, Integer sum, String ps) {
        Sum maxCom;
        Sum com;
        Sum minCom;
        Sum compareSum;
        this.log.info((Object)"CommissionRender.processCommission");
        if (commission == null || ignoreMinMaxCommission || service == null) {
            return commission;
        }
        Sum sum2 = compareSum = sum != null ? new Sum(sum) : this.getSumpurchaseORKeeperSum(screenData);
        if (compareSum == null) {
            compareSum = new Sum(1000);
        }
        Commission minCommission = service.getMinComm();
        Commission maxCommission = service.getCommission();
        Commission currentCommission = this.getPersonalCommission(service, screenData);
        if (currentCommission == null) {
            currentCommission = commission;
        }
        if (minCommission != null && maxCommission != null && maxCommission.getId() == minCommission.getId()) {
            return maxCommission;
        }
        if (minCommission != null && (minCom = CommissionCalculator.calculateCommissionSum(compareSum, null, minCommission, null, null, null, startPay, ps)).compareTo(com = CommissionCalculator.calculateCommissionSum(compareSum, null, currentCommission, null, null, null, startPay, ps)) > 0) {
            currentCommission = minCommission;
        }
        if (maxCommission != null && (maxCom = CommissionCalculator.calculateCommissionSum(compareSum, null, maxCommission, null, null, null, startPay, ps)).compareTo(com = CommissionCalculator.calculateCommissionSum(compareSum, null, currentCommission, null, null, null, startPay, ps)) < 0) {
            currentCommission = maxCommission;
        }
        return currentCommission;
    }

    public String process(Commission commission, Service service, Map<String, Object> data, Locale locale, boolean ignoreMinMaxCommission, Date startPay, Integer sum, String ps) {
        if (commission == null) {
            return "";
        }
        Commission currentCom = this.processCommission(commission, service, data, locale, ignoreMinMaxCommission, startPay, sum, ps);
        return this.process(currentCom, null, locale, startPay, ps);
    }

    public String process(Commission commission, Commission serviceCommission, Locale locale, Date startPay, String src) {
        this.log.info((Object)"CommissionRender.process(parser)");
        if (commission == null) {
            return "";
        }
        this.setLocale(locale);
        TreeSet<CommissionStep> steps = this.loadSteps(commission, startPay, src);
        String serviceCommissionStr = this.processServiceCommission(serviceCommission, commission, false, this.getString("Screen.std.sum.commval") + ": {0}");
        if (serviceCommissionStr != null) {
            return serviceCommissionStr;
        }
        StringBuilder sb = new StringBuilder();
        CommissionStep firstStep = new CommissionStep(new Sum(0), commission.getPercentValue(), commission.getFixedValue());
        if (steps == null || steps.isEmpty()) {
            String res = this.getStepDescription(firstStep);
            String bounds = this.getBounds(commission);
            if (res != null || !bounds.isEmpty()) {
                sb.append("<b>").append(this.getString("Screen.std.sum.commval")).append(": ").append(res == null ? "0%" : res);
                sb.append("<br/>").append(this.getBounds(commission));
            } else {
                sb.append("<b>").append(this.getString("Screen.std.sum.nocomm"));
            }
        } else {
            sb.append("<table border=0 cellspacing=0 cellpadding=0><tr><th>").append(this.getString("Screen.std.sum.income2")).append("&nbsp;&nbsp;</th><th>").append(this.getString("Screen.std.sum.commission2")).append("</th></tr>");
            CommissionStep firstEnableStep = CommissionRender.firstEnableStep(steps, startPay, src != null ? src : "CASH");
            String res = "";
            if (firstEnableStep != null && !firstEnableStep.getSum().isEmpty()) {
                res = this.getStepDescription(firstStep);
                sb.append("<tr><td>").append(this.getString("Screen.std.sum.from")).append(" ").append(firstStep.getSum()).append("</td><td>").append(res != null ? res : this.getString("Screen.std.sum.voidcomm")).append("</td></tr>");
            }
            for (CommissionStep step : steps) {
                res = this.getStepDescription(step);
                sb.append("<tr><td>").append(this.getString("Screen.std.sum.from")).append(" ").append(step.getSum()).append("</td><td>").append(res != null ? res : this.getString("Screen.std.sum.voidcomm")).append("</td></tr>");
            }
            sb.append("</table><br/>");
            sb.append(this.getBounds(commission));
        }
        sb.append(this.processUnitsCommission(commission.getUnits()));
        return sb.toString();
    }

    public String processUnitsCommission(Set<CommissionUnit> units) {
        StringBuilder sb = new StringBuilder();
        if (units != null && !units.isEmpty()) {
            sb.append("<table border=0 cellspacing=0 cellpadding=0>");
            boolean first = true;
            Map<Integer, CashUnit> unitsList = this.loadUnitList();
            TreeMap<Sum, Sum> coins = new TreeMap<Sum, Sum>();
            TreeMap<Sum, Sum> notes = new TreeMap<Sum, Sum>();
            Sum prev = null;
            boolean same = true;
            for (CommissionUnit unit : units) {
                if (!(unit.getFixedValue().getSum() > 0.0)) continue;
                CashUnit cu = unitsList.get(unit.getCashUnit());
                if (cu != null && cu.getType() == 4) {
                    Sum percent = this.calculatePercent(cu.getNominal(), unit.getFixedValue());
                    coins.put(cu.getNominal(), percent);
                    if (first) {
                        prev = percent;
                        first = false;
                    }
                    if (prev.compareTo(percent) != 0) {
                        same = false;
                    }
                    prev = percent;
                    continue;
                }
                if (cu == null || cu.getType() != 3) continue;
                notes.put(cu.getNominal(), unit.getFixedValue());
            }
            first = true;
            for (Sum nominal : notes.keySet()) {
                if (first) {
                    sb.append("<tr><th>").append(this.getString("Screen.std.sum.notecomm")).append("</th></tr>");
                    first = false;
                }
                sb.append("<tr><td>").append(nominal).append(" ").append("</td><td>").append(notes.get(nominal)).append("</td></tr>");
            }
            if (same && coins.size() > 1) {
                sb.append("<tr><th>").append(this.getString("Screen.std.sum.coincomm.same")).append(((Sum)coins.get(coins.firstKey())).getSum()).append("%").append("</th></tr>");
            } else {
                first = true;
                for (Sum nominal : coins.keySet()) {
                    if (first) {
                        sb.append("<tr><th>").append(this.getString("Screen.std.sum.coincomm")).append("</th></tr>");
                        first = false;
                    }
                    sb.append("<tr><td>").append(nominal).append(" ").append("</td><td>").append(((Sum)coins.get(nominal)).getSum()).append("%").append("</td></tr>");
                }
            }
            sb.append("</table><br/>");
            return sb.toString();
        }
        return "";
    }

    private Sum calculatePercent(Sum nominal, Sum fixedValue) {
        return fixedValue.div(nominal.getSum()).mul(100);
    }

    public String processSrcList(Commission commission, Service service, Map<String, Object> screenData, Locale locale, Date startPay, Integer sum, List<String> src) {
        Sum com;
        boolean flag;
        Sum compareSum;
        this.log.info((Object)"CommissionRender.processSrcList");
        if (commission == null) {
            return "";
        }
        Sum sum2 = compareSum = sum != null ? new Sum(sum) : this.getSumpurchaseORKeeperSum(screenData);
        if (compareSum == null) {
            compareSum = new Sum(1000);
        }
        Commission minCommission = service.getMinComm();
        Commission maxCommission = service.getCommission();
        Commission currentCommission = this.getPersonalCommission(service, screenData);
        if (currentCommission == null) {
            currentCommission = commission;
        }
        if (minCommission != null && maxCommission != null && maxCommission.getId() == minCommission.getId()) {
            return this.process(maxCommission, null, locale, startPay, src);
        }
        if (minCommission != null) {
            flag = true;
            for (String paymentSource : src) {
                Sum minCom = CommissionCalculator.calculateCommissionSum(compareSum, null, minCommission, null, null, null, startPay, paymentSource);
                if (minCom.compareTo(com = CommissionCalculator.calculateCommissionSum(compareSum, null, currentCommission, null, null, null, startPay, paymentSource)) >= 0) continue;
                flag = false;
                break;
            }
            if (flag) {
                currentCommission = minCommission;
            }
        }
        if (maxCommission != null) {
            flag = true;
            for (String paymentSource : src) {
                Sum maxCom = CommissionCalculator.calculateCommissionSum(compareSum, null, maxCommission, null, null, null, startPay, paymentSource);
                if (maxCom.compareTo(com = CommissionCalculator.calculateCommissionSum(compareSum, null, currentCommission, null, null, null, startPay, paymentSource)) <= 0) continue;
                flag = false;
                break;
            }
            if (flag) {
                currentCommission = maxCommission;
            }
        }
        return this.process(currentCommission, null, locale, startPay, src);
    }

    private Map<Integer, CashUnit> loadUnitList() {
        HashMap<Integer, CashUnit> unitsList = new HashMap<Integer, CashUnit>();
        for (CashUnit cu : CashFactory.getDefaultInstance().getCoinUnits()) {
            unitsList.put(cu.getId(), cu);
        }
        for (CashUnit cu : CashFactory.getDefaultInstance().getCashUnits()) {
            unitsList.put(cu.getId(), cu);
        }
        return unitsList;
    }

    private TreeSet<CommissionStep> loadSteps(Commission commission, Date startPay, String src) {
        if (commission.getSteps() == null) {
            return null;
        }
        TreeSet<CommissionStep> steps = new TreeSet<CommissionStep>();
        for (CommissionStep step : commission.getSteps()) {
            if (!CommissionCalculator.isStepEnable(step, startPay, src != null ? src : "CASH")) continue;
            steps.add(step);
        }
        return steps;
    }

    private String processServiceCommission(Commission serviceCommission, Commission commission, boolean addCommToNoComm, String formateString) {
        if (serviceCommission != null && !serviceCommission.isStepsNotEmpty()) {
            CommissionStep firstStep = new CommissionStep(new Sum(0), serviceCommission.getPercentValue(), serviceCommission.getFixedValue());
            String res = this.getStepDescription(firstStep);
            StringBuilder sb = new StringBuilder();
            if (res != null) {
                if (formateString != null) {
                    sb.append("<b>").append(MessageFormat.format(formateString, this.getStepDescription(firstStep)));
                } else {
                    sb.append("<b>").append(this.getStepDescription(firstStep));
                }
                sb.append("<br/>").append(this.getBounds(commission));
            } else {
                sb.append("<b>").append(this.getString("Screen.std.sum.nocomm"));
                if (addCommToNoComm) {
                    sb.append("<br/>").append(this.getBounds(commission));
                }
            }
            return sb.toString();
        }
        return null;
    }

    private String processSteps(Commission commission, Date startPay, List<String> src) {
        HashMap<String, TreeSet<CommissionStep>> mSteps = new HashMap<String, TreeSet<CommissionStep>>();
        if (commission.getSteps() != null) {
            for (String ps : src) {
                mSteps.put(ps, this.loadSteps(commission, startPay, ps));
            }
        }
        StringBuilder sb = new StringBuilder();
        if (mSteps.isEmpty()) {
            CommissionStep firstStep = new CommissionStep(new Sum(0), commission.getPercentValue(), commission.getFixedValue());
            String res = this.getStepDescription(firstStep);
            if (res != null) {
                sb.append("<b>").append(this.getString("Screen.std.sum.commval")).append(": ").append(this.getStepDescription(firstStep));
                sb.append("<br/>").append(this.getBounds(commission));
            } else {
                sb.append("<b>").append(this.getString("Screen.std.sum.nocomm"));
                sb.append("<br/>").append(this.getBounds(commission));
            }
        } else {
            sb.append("<table style=\"font-size: 16pt;\" border=0 cellspacing=0 cellpadding=0>");
            for (String ps : src) {
                CommissionStep firstStep = null;
                TreeSet steps = (TreeSet)mSteps.get(ps);
                if (steps == null || steps.isEmpty()) continue;
                for (CommissionStep step : steps) {
                    if (step.getSum().getBasicSum() != 0) continue;
                    firstStep = step;
                }
                if (firstStep == null) {
                    firstStep = new CommissionStep(new Sum(0), commission.getPercentValue(), commission.getFixedValue());
                    firstStep.setPaymentSource(ps);
                    steps.add(firstStep);
                }
                sb.append("<tr><th>").append(this.getString("Screen.std.ps." + ps)).append("</th></tr>");
                if (steps.size() == 1) {
                    sb.append(this.getStepDescription(firstStep));
                    continue;
                }
                for (CommissionStep step : steps) {
                    sb.append(this.getStepDescription(step));
                }
                sb.append(this.getBounds(commission));
            }
            sb.append("</table><br/>");
        }
        return sb.toString();
    }

    public String process(Commission commission, Commission serviceCommission, Locale locale, Date startPay, List<String> src) {
        this.log.info((Object)"CommissionRender.process for List of PaymentSource(parser)");
        if (commission == null) {
            return "";
        }
        if (src.size() == 1) {
            return this.process(commission, serviceCommission, locale, startPay, src.get(0));
        }
        this.setLocale(locale);
        String serviceCommissioStr = this.processServiceCommission(serviceCommission, commission, true, null);
        if (serviceCommissioStr != null) {
            return serviceCommissioStr;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.processSteps(commission, startPay, src));
        HashSet<CommissionUnit> units = commission.getUnits();
        if (units != null && !units.isEmpty()) {
            sb.append("<table border=0 cellspacing=0 cellpadding=0>");
            boolean first = true;
            Map<Integer, CashUnit> unitsList = this.loadUnitList();
            TreeMap<Sum, Sum> coins = new TreeMap<Sum, Sum>();
            TreeMap<Sum, Sum> notes = new TreeMap<Sum, Sum>();
            for (CommissionUnit unit : units) {
                if (!(unit.getFixedValue().getSum() > 0.0)) continue;
                CashUnit cu = unitsList.get(unit.getCashUnit());
                if (cu != null && cu.getType() == 4) {
                    coins.put(cu.getNominal(), unit.getFixedValue());
                    continue;
                }
                if (cu == null || cu.getType() != 3) continue;
                notes.put(cu.getNominal(), unit.getFixedValue());
            }
            for (Sum nominal : notes.keySet()) {
                if (first) {
                    sb.append("<tr><th>").append(this.getString("Screen.std.sum.notecomm")).append("</th></tr>");
                    first = false;
                }
                sb.append("<tr><td>").append(nominal).append(" - ").append(notes.get(nominal)).append("</td></tr>");
            }
            first = true;
            for (Sum nominal : coins.keySet()) {
                if (first) {
                    sb.append("<tr><th>").append(this.getString("Screen.std.sum.coincomm")).append("</th></tr>");
                    first = false;
                }
                sb.append("<tr><td>").append(nominal).append(" - ").append(coins.get(nominal)).append("</td></tr>");
            }
            sb.append("</table><br/>");
        }
        return sb.toString();
    }

    public String process(Commission commission, Commission serviceCommission, Locale locale, Date startPay, FeeSum fs) {
        if (fs != null) {
            StringBuilder sb = new StringBuilder();
            String val = this.getFeeSumDescription(fs);
            if (val != null) {
                sb.append("<b>").append(this.getString("Screen.std.sum.commval")).append(": ").append(val);
            } else {
                sb.append("<b>").append(this.getString("Screen.std.sum.nocomm"));
            }
            return sb.toString();
        }
        return "";
    }

    public String processWithFeeSum(Commission commission, Service service, Map<String, Object> screenData, Locale locale, Date startPay, FeeSum fs) {
        Sum maxCom;
        Sum com;
        Sum minCom;
        Sum compareSum;
        this.log.info((Object)"CommissionRender.processWithFeeSum");
        if (commission == null && fs == null) {
            return "";
        }
        Sum sum = compareSum = fs != null ? new Sum(fs.getFee()) : this.getSumpurchaseORKeeperSum(screenData);
        if (compareSum == null) {
            compareSum = new Sum(1000);
        }
        Commission minCommission = service.getMinComm();
        Commission maxCommission = service.getCommission();
        Commission currentCommission = this.getPersonalCommission(service, screenData);
        if (currentCommission == null) {
            currentCommission = commission;
        }
        if (minCommission != null && maxCommission != null && maxCommission.getId() == minCommission.getId()) {
            return this.process(maxCommission, null, locale, startPay, fs);
        }
        if (minCommission != null && (minCom = CommissionCalculator.calculateCommissionSum(compareSum, null, minCommission, null, null, null, startPay, "CASH")).compareTo(com = CommissionCalculator.calculateCommissionSum(compareSum, null, currentCommission, null, null, null, startPay, "CASH")) > 0) {
            currentCommission = minCommission;
        }
        if (maxCommission != null && (maxCom = CommissionCalculator.calculateCommissionSum(compareSum, null, maxCommission, null, null, null, startPay, "CASH")).compareTo(com = CommissionCalculator.calculateCommissionSum(compareSum, null, currentCommission, null, null, null, startPay, "CASH")) < 0) {
            currentCommission = maxCommission;
        }
        return this.process(currentCommission, null, locale, startPay, fs);
    }

    public boolean isEmptyCommission(Commission commission, Commission minCommission) {
        if (this.isEmptyCommission(minCommission)) {
            return this.isEmptyCommission(commission);
        }
        return false;
    }

    public boolean isEmptyCommission(Commission commission) {
        if (commission == null) {
            return true;
        }
        if (commission.getPercentValue() > 0.0 || commission.isFixedValueNotEmpty() || commission.isStepsNotEmpty()) {
            return false;
        }
        HashSet<CommissionUnit> units = commission.getUnits();
        if (units != null && !units.isEmpty()) {
            Map<Integer, CashUnit> unitsList = this.loadUnitList();
            TreeMap<Sum, Sum> coins = new TreeMap<Sum, Sum>();
            TreeMap<Sum, Sum> notes = new TreeMap<Sum, Sum>();
            for (CommissionUnit unit : units) {
                if (!(unit.getFixedValue().getSum() > 0.0)) continue;
                CashUnit cu = unitsList.get(unit.getCashUnit());
                if (cu != null && cu.getType() == 4) {
                    coins.put(cu.getNominal(), unit.getFixedValue());
                    continue;
                }
                if (cu == null || cu.getType() != 3) continue;
                notes.put(cu.getNominal(), unit.getFixedValue());
            }
            if (!notes.keySet().isEmpty() || !coins.keySet().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public String processMinMax(Service service) {
        StringBuilder sb = new StringBuilder("<b>");
        if (service.getMinSum() != null && !service.getMinSum().isEmpty()) {
            sb.append(this.getString("Screen.std.sum.minimum")).append(" ").append(service.getMinSum()).append("<br>");
        }
        if (service.getMinSum() != null && !service.getMinSum().isEmpty()) {
            sb.append(this.getString("Screen.std.sum.maximum")).append(" ").append(service.getMaxSum()).append("<br>");
        }
        sb.append("</b>");
        return sb.toString();
    }

    public static String process(Commission commission, boolean multiLine) {
        return CommissionRender.process(commission, multiLine, true);
    }

    public static String process(Commission commission, boolean multiLine, boolean addText) {
        if (commission == null) {
            return "";
        }
        TreeSet<CommissionStep> steps = commission.getSteps();
        CommissionStep firsStep = new CommissionStep(new Sum(0), commission.getPercentValue(), commission.getFixedValue());
        if (steps == null || steps.isEmpty()) {
            return (addText ? B.get((String)"Gui.commission") + ": " : "") + CommissionRender.getStepDescription(firsStep, false) + (multiLine ? "<br>" : "") + CommissionRender.getBounds(commission, multiLine);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(B.get((String)"Gui.commission")).append(":").append(multiLine ? "<br>" : " ");
        if (!steps.first().getSum().isEmpty()) {
            builder.append(CommissionRender.getStepDescription(firsStep, true)).append(multiLine ? "<br>" : " ");
        }
        for (CommissionStep step : steps) {
            builder.append(CommissionRender.getStepDescription(step, true)).append(multiLine ? "<br>" : " ");
        }
        builder.append(CommissionRender.getBounds(commission, multiLine));
        return builder.toString();
    }

    private static String getStepDescription(CommissionStep step, boolean showSum) {
        double percent = step.getPercentValue();
        Sum fixed = step.getFixedValue();
        String res = "";
        res = fixed == null || fixed.isEmpty() ? CommissionRender.format(percent) + "%" : (percent == 0.0 ? fixed.toString() : CommissionRender.format(percent) + "% + " + fixed.toString());
        return (showSum && step.getSum() != null ? B.get((String)"Gui.commission.from") + ": " + step.getSum() + " - " : "") + res;
    }

    private static String getBounds(Commission commission, boolean multiLine) {
        if (commission == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (commission.getMin() != null && !commission.getMin().isEmpty()) {
            sb.append(B.get((String)"Gui.commission.min")).append(": ").append(commission.getMin().toString()).append(multiLine ? "<br>" : " ");
        }
        if (commission.getMax() != null && !commission.getMax().isEmpty()) {
            sb.append(B.get((String)"Gui.commission.max")).append(": ").append(commission.getMax().toString()).append(multiLine ? "<br>" : " ");
        }
        return sb.toString();
    }

    public static String format(double sum) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(0);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        return df.format(sum);
    }
}

