/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.CommissionStep;
import ru.softlogic.service.comission.CommissionType;
import ru.softlogic.service.comission.CommissionUnit;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.service.comission.SumResult;

public class CommissionCalculator {
    private static final SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");
    private static final GregorianCalendar dayCalendar = new GregorianCalendar();

    public static SumResult calculate(Sum in, Keeper keeper, Commission commission, Commission minCommission, Commission maxCommission, Sum trade, Sum maxPaymentSum, Sum diffSum, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee, Sum smsSum) {
        Sum serviceCommission;
        if (providerFee != null) {
            return CommissionCalculator.calculate(in, keeper, providerFee, trade, maxPaymentSum, diffSum);
        }
        SumResult dealerResult = CommissionCalculator.calculate(in, keeper, commission, trade, maxPaymentSum, diffSum, time, pSource, smsSum);
        Sum dealerCommission = CommissionCalculator.calculateCommissionSum(in, keeper, commission, trade, maxPaymentSum, diffSum, time, pSource);
        CommissionCalculator.updCurrentCommission(commission);
        if (!dealerResult.getOut().isEmpty() && minCommission != null && !ignoreMMC) {
            SumResult serviceResult = CommissionCalculator.calculate(in, keeper, minCommission, trade, maxPaymentSum, diffSum, time, pSource, smsSum);
            Sum serviceCommission2 = CommissionCalculator.calculateCommissionSum(in, keeper, minCommission, trade, maxPaymentSum, diffSum, time, pSource);
            if (serviceResult.getOut().isEmpty() || serviceCommission2.compareTo(dealerCommission) > 0) {
                dealerResult = serviceResult;
                CommissionCalculator.updCurrentCommission(minCommission);
                return dealerResult;
            }
        }
        if (maxCommission != null && !ignoreMMC && (serviceCommission = CommissionCalculator.calculateCommissionSum(in, keeper, maxCommission, trade, maxPaymentSum, diffSum, time, pSource)).compareTo(dealerCommission) < 0) {
            CommissionCalculator.updCurrentCommission(maxCommission);
            return CommissionCalculator.calculate(in, keeper, maxCommission, trade, maxPaymentSum, diffSum, time, pSource, smsSum);
        }
        return dealerResult;
    }

    public static Sum calculateCommissionSum(Sum in, Keeper keeper, Commission commission, Sum trade, Sum maxPaymentSum, Sum diffSum, Date time, String pSource) {
        Sum rest;
        if (in == null) {
            throw new IllegalArgumentException("\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        if (commission == null) {
            throw new IllegalArgumentException("\u0421\u0442\u0430\u0432\u043a\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        Sum nomSum = new Sum();
        Sum nomComm = new Sum();
        if (keeper != null && keeper.getCashUnits() != null && !keeper.getCashUnits().isEmpty() && commission.getUnits() != null && !commission.getUnits().isEmpty()) {
            for (CommissionUnit cu : commission.getUnits()) {
                for (CashUnit cashUnit : keeper.getCashUnits().keySet()) {
                    if (cu.getCashUnit() != cashUnit.getId() || cu.getFixedValue() == null) continue;
                    int count = keeper.getCashUnits().get(cashUnit);
                    nomSum = nomSum.add(cashUnit.getNominal().mul(count));
                    nomComm = nomComm.add(cu.getFixedValue().mul(count));
                }
            }
        }
        Sum baseSum = null;
        if (trade != null && !trade.isEmpty()) {
            baseSum = trade;
        } else if (diffSum != null && !diffSum.isEmpty() && diffSum.compareTo(in) < 0) {
            baseSum = diffSum;
        } else if (maxPaymentSum != null && !maxPaymentSum.isEmpty() && maxPaymentSum.compareTo(in) < 0) {
            baseSum = maxPaymentSum;
        } else {
            baseSum = in;
            if (Boolean.TRUE.equals(commission.getSeparateUnitTypesCalc())) {
                baseSum = baseSum.sub(nomSum);
            }
        }
        double percentValue = commission.getPercentValue();
        Sum fixedValue = commission.getFixedValue();
        CommissionStep cs = null;
        if (commission.getSteps() != null && commission.getSteps().size() > 0) {
            for (CommissionStep step : commission.getSteps().descendingSet()) {
                if (!CommissionCalculator.isStepEnable(step, time, pSource) || step.getSum().compareTo(baseSum) > 0) continue;
                cs = step;
                percentValue = step.getPercentValue();
                fixedValue = step.getFixedValue();
                break;
            }
        }
        Sum sumCommission = new Sum(baseSum.getSum() * percentValue / (100.0 + percentValue));
        if (commission.getType() == CommissionType.Direct) {
            sumCommission = new Sum(baseSum.getSum() * percentValue / 100.0);
        }
        if (fixedValue != null) {
            sumCommission = sumCommission.add(fixedValue);
        }
        if (!nomComm.isEmpty()) {
            sumCommission = sumCommission.add(nomComm);
        }
        if (cs != null && cs.getMin() != null && !cs.getMin().isEmpty() && sumCommission.compareTo(cs.getMin()) < 0) {
            sumCommission = cs.getMin();
        } else if (commission.getMin() != null && !commission.getMin().isEmpty() && sumCommission.compareTo(commission.getMin()) < 0) {
            sumCommission = commission.getMin();
        }
        if (cs != null && cs.getMax() != null && !cs.getMax().isEmpty() && sumCommission.compareTo(cs.getMax()) > 0) {
            sumCommission = cs.getMax();
        } else if (commission.getMax() != null && !commission.getMax().isEmpty() && sumCommission.compareTo(commission.getMax()) > 0) {
            sumCommission = commission.getMax();
        }
        if (commission.getRoundOrder() != null && !commission.getRoundOrder().isEmpty() && !(rest = sumCommission.divRest(commission.getRoundOrder())).isEmpty()) {
            sumCommission = sumCommission.add(commission.getRoundOrder().sub(rest));
        }
        return sumCommission;
    }

    public static Sum calculate(Sum trade, Commission commission, Commission serviceCommission, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee) {
        return CommissionCalculator.calculate(trade, commission, serviceCommission, time, pSource, ignoreMMC, providerFee, true);
    }

    public static SumResult calculate(Sum in, Keeper keeper, Commission commission, Commission minCommission, Commission maxCommission, Sum trade, Sum maxPaymentSum, Sum diffSum, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee, boolean setCurrentComm, Sum smsSum) {
        Sum serviceCommission;
        SumResult serviceResult;
        if (providerFee != null) {
            return CommissionCalculator.calculate(in, keeper, providerFee, trade, maxPaymentSum, diffSum);
        }
        SumResult dealerResult = CommissionCalculator.calculate(in, keeper, commission, trade, maxPaymentSum, diffSum, time, pSource, smsSum);
        Sum dealerCommission = dealerResult.getCommission();
        if (setCurrentComm) {
            CommissionCalculator.updCurrentCommission(commission);
        }
        if (!(dealerResult.getOut().isEmpty() || minCommission == null || ignoreMMC || !(serviceResult = CommissionCalculator.calculate(in, keeper, minCommission, trade, maxPaymentSum, diffSum, time, pSource, smsSum)).getOut().isEmpty() && serviceResult.getCommission().compareTo(dealerCommission) <= 0)) {
            dealerResult = serviceResult;
            if (setCurrentComm) {
                CommissionCalculator.updCurrentCommission(minCommission);
            }
            return dealerResult;
        }
        if (maxCommission != null && !ignoreMMC && (serviceCommission = (serviceResult = CommissionCalculator.calculate(in, keeper, maxCommission, trade, maxPaymentSum, diffSum, time, pSource, smsSum)).getCommission()).compareTo(dealerCommission) < 0) {
            if (setCurrentComm) {
                CommissionCalculator.updCurrentCommission(maxCommission);
            }
            return serviceResult;
        }
        return dealerResult;
    }

    public static SumResult calculate(Keeper keeper, Commission commission, Commission minCommission, Commission maxCommission, Sum trade, Sum maxPaymentSum, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee, Sum smsSum) {
        return CommissionCalculator.calculate(keeper, commission, minCommission, maxCommission, trade, maxPaymentSum, time, pSource, ignoreMMC, providerFee, true, smsSum);
    }

    public static SumResult calculate(Keeper keeper, Commission commission, Commission minCommission, Commission maxCommission, Sum trade, Sum maxPaymentSum, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee, boolean setCurrentComm, Sum smsSum) {
        SumResult serviceResult;
        if (providerFee != null) {
            return CommissionCalculator.calculate(keeper, providerFee, trade);
        }
        SumResult dealerResult = CommissionCalculator.calculate(keeper, commission, trade, maxPaymentSum, time, pSource, smsSum);
        if (setCurrentComm) {
            CommissionCalculator.updCurrentCommission(commission);
        }
        if (minCommission != null && !ignoreMMC && (serviceResult = CommissionCalculator.calculate(keeper, minCommission, trade, maxPaymentSum, time, pSource, smsSum)).getCommission().compareTo(dealerResult.getCommission()) > 0) {
            dealerResult = serviceResult;
            if (setCurrentComm) {
                CommissionCalculator.updCurrentCommission(minCommission);
            }
            return dealerResult;
        }
        if (maxCommission != null && !ignoreMMC && (serviceResult = CommissionCalculator.calculate(keeper, maxCommission, trade, maxPaymentSum, time, pSource, smsSum)).getCommission().compareTo(dealerResult.getCommission()) < 0) {
            if (setCurrentComm) {
                CommissionCalculator.updCurrentCommission(maxCommission);
            }
            return serviceResult;
        }
        return dealerResult;
    }

    private static SumResult calculate(Keeper keeper, Commission commission, Sum trade, Sum maxPaymentSum, Date time, String pSource, Sum smsSum) {
        Sum rest;
        if (keeper == null) {
            throw new IllegalArgumentException("\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        if (commission == null) {
            throw new IllegalArgumentException("\u0421\u0442\u0430\u0432\u043a\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        Sum s0 = new Sum(0);
        Sum baseSum = trade != null && !trade.isEmpty() ? trade : keeper.getSum();
        double percentValue = commission.getPercentValue();
        Sum fixedValue = commission.getFixedValue();
        CommissionStep cs = null;
        if (commission.getSteps() != null && !commission.getSteps().isEmpty()) {
            for (CommissionStep step : commission.getSteps().descendingSet()) {
                if (!CommissionCalculator.isStepEnable(step, time, pSource) || step.getSum().compareTo(baseSum) > 0) continue;
                cs = step;
                percentValue = step.getPercentValue();
                fixedValue = step.getFixedValue();
                break;
            }
        }
        Sum sumCommission = null;
        switch (commission.getType()) {
            case Direct: {
                sumCommission = new Sum(baseSum.getSum() * percentValue / 100.0);
                break;
            }
            case Inverce: {
                sumCommission = new Sum(baseSum.getSum() * percentValue / (100.0 + percentValue));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown commission type");
            }
        }
        if (fixedValue != null) {
            sumCommission = sumCommission.add(fixedValue);
        }
        if (cs != null && cs.getMin() != null && !cs.getMin().isEmpty() && sumCommission.compareTo(cs.getMin()) < 0) {
            sumCommission = cs.getMin();
        } else if (commission.getMin() != null && !commission.getMin().isEmpty() && sumCommission.compareTo(commission.getMin()) < 0) {
            sumCommission = commission.getMin();
        }
        if (cs != null && cs.getMax() != null && !cs.getMax().isEmpty() && sumCommission.compareTo(cs.getMax()) > 0) {
            sumCommission = cs.getMax();
        } else if (commission.getMax() != null && !commission.getMax().isEmpty() && sumCommission.compareTo(commission.getMax()) > 0) {
            sumCommission = commission.getMax();
        }
        if (commission.getRoundOrder() != null && !commission.getRoundOrder().isEmpty() && !(rest = sumCommission.divRest(commission.getRoundOrder())).isEmpty()) {
            sumCommission = sumCommission.add(commission.getRoundOrder().sub(rest));
        }
        if (sumCommission.compareTo(keeper.getSum()) > 0) {
            return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), s0, s0, s0, keeper.getSum(), null, smsSum);
        }
        Sum sumOut = keeper.getSum().sub(sumCommission);
        if (trade != null && !trade.isEmpty()) {
            if (sumOut.compareTo(trade) < 0) {
                return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), s0, s0, s0, keeper.getSum(), null, smsSum);
            }
            return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), trade, trade, sumCommission, sumOut.sub(trade), null, smsSum);
        }
        return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), sumOut, sumOut, sumCommission, s0, null, smsSum);
    }

    private static SumResult calculate(Sum in, Keeper keeper, Commission commission, Sum trade, Sum maxPaymentSum, Sum diffSum, Date time, String pSource, Sum smsSum) {
        Sum change;
        if (in == null) {
            throw new IllegalArgumentException("\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        if (commission == null) {
            throw new IllegalArgumentException("\u0421\u0442\u0430\u0432\u043a\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        Sum s0 = new Sum(0);
        Sum nomSum = new Sum();
        Sum nomComm = new Sum();
        if (keeper != null && keeper.getCashUnits() != null && !keeper.getCashUnits().isEmpty() && commission.getUnits() != null && !commission.getUnits().isEmpty()) {
            for (CommissionUnit cu : commission.getUnits()) {
                for (CashUnit cashUnit : keeper.getCashUnits().keySet()) {
                    if (cu.getCashUnit() != cashUnit.getId() || cu.getFixedValue() == null) continue;
                    int count = keeper.getCashUnits().get(cashUnit);
                    nomSum = nomSum.add(cashUnit.getNominal().mul(count));
                    nomComm = nomComm.add(cu.getFixedValue().mul(count));
                }
            }
        }
        Sum sumCommission = CommissionCalculator.calculateCommissionSum(in, keeper, commission, trade, maxPaymentSum, diffSum, time, pSource);
        if (smsSum != null) {
            sumCommission = sumCommission.add(smsSum);
        }
        Sum sumOut = null;
        Sum keeperCashSum = keeper.getCashSum();
        if (sumCommission.compareTo(in) >= 0) {
            return new SumResult(keeperCashSum, keeper.getCashlessSum(), s0, s0, s0, in, null, s0);
        }
        sumOut = in.sub(sumCommission);
        if (trade != null && !trade.isEmpty()) {
            if (sumOut.compareTo(trade) < 0) {
                return new SumResult(keeperCashSum, keeper.getCashlessSum(), s0, s0, s0, in, null, s0);
            }
            return new SumResult(keeperCashSum, keeper.getCashlessSum(), trade, trade, sumCommission, sumOut.sub(trade), null, smsSum);
        }
        if (diffSum != null && !diffSum.isEmpty()) {
            sumOut = diffSum.sub(sumCommission);
            change = in.sub(diffSum);
            if (change.compareTo(new Sum()) >= 0) {
                return new SumResult(keeperCashSum, keeper.getCashlessSum(), sumOut, sumOut, sumCommission, change, null, smsSum);
            }
            return new SumResult(keeperCashSum, keeper.getCashlessSum(), s0, s0, s0, in, null, smsSum);
        }
        if (maxPaymentSum != null && !maxPaymentSum.isEmpty() && sumOut.compareTo(maxPaymentSum) > 0) {
            sumOut = maxPaymentSum;
            change = in.sub(sumOut).sub(sumCommission);
            if (change.compareTo(new Sum()) >= 0) {
                return new SumResult(keeperCashSum, keeper.getCashlessSum(), sumOut, sumOut, sumCommission, change, null, smsSum);
            }
            return new SumResult(keeperCashSum, keeper.getCashlessSum(), s0, s0, s0, in, null, smsSum);
        }
        return new SumResult(keeperCashSum, keeper.getCashlessSum(), sumOut, sumOut, sumCommission, s0, null, smsSum);
    }

    public static Sum calculate(Sum trade, Commission commission, Commission serviceCommission, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee, boolean setCurrentComm) {
        Sum serviceResult;
        if (providerFee != null) {
            return CommissionCalculator.calculate(trade, providerFee);
        }
        Sum dealerResult = CommissionCalculator.calculate(trade, commission, time, pSource);
        if (setCurrentComm) {
            CommissionCalculator.updCurrentCommission(commission);
        }
        if (serviceCommission != null && !ignoreMMC && (serviceResult = CommissionCalculator.calculate(trade, serviceCommission, time, pSource)).compareTo(dealerResult) < 0) {
            if (setCurrentComm) {
                CommissionCalculator.updCurrentCommission(serviceCommission);
            }
            return serviceResult;
        }
        return dealerResult;
    }

    public static Sum calculateWithMinMax(Sum trade, Commission commission, Commission serviceCommission, Commission minServiceCommission, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee, boolean setCurrentComm) {
        if (providerFee != null) {
            return CommissionCalculator.calculate(trade, providerFee);
        }
        Sum dealerResult = CommissionCalculator.calculate(trade, commission, time, pSource);
        if (setCurrentComm) {
            CommissionCalculator.updCurrentCommission(commission);
        }
        if (!ignoreMMC) {
            Sum serviceResult;
            Sum minServiceResult;
            if (minServiceCommission != null && (minServiceResult = CommissionCalculator.calculate(trade, minServiceCommission, time, pSource)).compareTo(dealerResult) > 0) {
                if (setCurrentComm) {
                    CommissionCalculator.updCurrentCommission(minServiceCommission);
                }
                return minServiceResult;
            }
            if (serviceCommission != null && (serviceResult = CommissionCalculator.calculate(trade, serviceCommission, time, pSource)).compareTo(dealerResult) < 0) {
                if (setCurrentComm) {
                    CommissionCalculator.updCurrentCommission(serviceCommission);
                }
                return serviceResult;
            }
        }
        return dealerResult;
    }

    private static Sum calculate(Sum trade, Commission commission, Date time, String pSource) {
        if (commission == null) {
            throw new IllegalArgumentException("\u0421\u0442\u0430\u0432\u043a\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        if (commission.getSteps() != null && commission.getSteps().size() > 0) {
            for (CommissionStep commissionStep : commission.getSteps().descendingSet()) {
                if (!CommissionCalculator.isStepEnable(commissionStep, time, pSource) || commissionStep.getSum().compareTo(trade) != 0 || commissionStep.getPercentValue() != 0.0) continue;
                return trade.add(commissionStep.getFixedValue());
            }
        }
        Sum in = trade.intSum();
        Sum sum = new Sum(1);
        SumResult res = CommissionCalculator.calculate(in, CommissionCalculator.getKeeperBySum(in), commission, trade, null, null, time, pSource, null);
        while (res.getOut().compareTo(trade) < 0) {
            in = in.add(sum);
            res = CommissionCalculator.calculate(in, CommissionCalculator.getKeeperBySum(in), commission, trade, null, null, time, pSource, null);
        }
        return in;
    }

    public static Sum calculateMaxPurchase(Sum limitSum, Commission commission, Date time, String pSource) {
        if (commission == null) {
            throw new IllegalArgumentException("\u0421\u0442\u0430\u0432\u043a\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        if (commission.getSteps() == null && commission.getSteps() == null) {
            Sum result = limitSum;
            if (commission.getFixedValue() != null) {
                result = result.sub(commission.getFixedValue());
            }
            double percentValue = commission.getPercentValue();
            result = commission.getType() == CommissionType.Inverce ? result.mul((100.0 + percentValue) / (100.0 + 2.0 * percentValue)) : result.mul(1.0 - percentValue / (100.0 + percentValue));
            Sum comm = limitSum.sub(result);
            if (comm.compareTo(commission.getMin()) < 0) {
                result = limitSum.sub(commission.getMin());
            }
            if (!commission.getMax().isEmpty() && comm.compareTo(commission.getMax()) > 0) {
                result = limitSum.sub(commission.getMax());
            }
            return result;
        }
        Sum sum0 = new Sum(0);
        Sum step = limitSum.div(2.0);
        Sum in = limitSum;
        int dif = 0;
        while (true) {
            Sum tmp = in;
            in = in.sub(step);
            SumResult res = CommissionCalculator.calculate(in, new Keeper(), commission, null, null, null, time, pSource, null);
            if (dif < step.getBasicSum()) {
                step = step.div(2.0);
                in = tmp.add(step);
            }
            if (dif <= 0 && step.getBasicSum() == 1) break;
            dif = res.getCommission().add(in).getBasicSum() - limitSum.getBasicSum();
        }
        in = in.sub(step);
        return in;
    }

    private static Keeper getKeeperBySum(Sum in) {
        Keeper keeper = new Keeper();
        keeper.addCashBackCard(new CashBackCard(0, in));
        return keeper;
    }

    public static Sum calculate(Sum provTrade, double rate, Commission commission, Commission minCommission, Commission maxCommission, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee) {
        return CommissionCalculator.calculate(provTrade, rate, commission, minCommission, maxCommission, time, pSource, ignoreMMC, providerFee, true);
    }

    public static Sum calculate(Sum provTrade, double rate, Commission commission, Commission minCommission, Commission maxCommission, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee, boolean setCurrentComm) {
        Sum operTrade = provTrade.mul(rate);
        if (providerFee != null) {
            return CommissionCalculator.calculate(operTrade, providerFee);
        }
        return CommissionCalculator.calculate(operTrade, commission, minCommission, maxCommission, time, pSource, ignoreMMC, providerFee, setCurrentComm);
    }

    public static Sum calculate(Sum operTrade, Commission commission, Commission minCommission, Commission maxCommission, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee) {
        return CommissionCalculator.calculate(operTrade, commission, minCommission, maxCommission, time, pSource, ignoreMMC, providerFee, true);
    }

    public static Sum calculate(Sum operTrade, Commission commission, Commission minCommission, Commission maxCommission, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee, boolean setCurrentComm) {
        Sum serviceResult;
        if (providerFee != null) {
            return CommissionCalculator.calculate(operTrade, providerFee);
        }
        Sum dealerResult = CommissionCalculator.calculate(operTrade, commission, time, pSource);
        if (setCurrentComm) {
            CommissionCalculator.updCurrentCommission(commission);
        }
        if (minCommission != null && !ignoreMMC && (serviceResult = CommissionCalculator.calculate(operTrade, minCommission, time, pSource)).compareTo(dealerResult) > 0) {
            dealerResult = serviceResult;
            if (setCurrentComm) {
                CommissionCalculator.updCurrentCommission(minCommission);
            }
            return dealerResult;
        }
        if (maxCommission != null && !ignoreMMC && (serviceResult = CommissionCalculator.calculate(operTrade, maxCommission, time, pSource)).compareTo(dealerResult) < 0) {
            dealerResult = serviceResult;
            if (setCurrentComm) {
                CommissionCalculator.updCurrentCommission(maxCommission);
            }
        }
        return dealerResult;
    }

    public static synchronized boolean isStepEnable(CommissionStep step, Date time, String pSource) {
        if (step == null) {
            return false;
        }
        if (step.getPaymentSource() != null && !step.getPaymentSource().trim().isEmpty() && !step.getPaymentSource().equals(pSource)) {
            return false;
        }
        if (step.getDays() == null || step.getFromTime() == null || step.getToTime() == null || time == null) {
            return true;
        }
        try {
            if (step.getFromTime().after(timeFormatter.parse(timeFormatter.format(time)))) {
                return false;
            }
            if (step.getToTime().before(timeFormatter.parse(timeFormatter.format(time)))) {
                return false;
            }
            dayCalendar.setTime(time);
            int day = dayCalendar.get(7);
            day = day == 1 ? 6 : (day -= 2);
            if ((step.getDays() & 1 << day) == 0) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static List<SumResult> calculatePackForList(Sum in, Keeper keeper, Commission c, Commission minC, Commission maxC, List<Sum> trade, Sum maxPaymentSum, Sum maxTotal, Sum diffSum, Date time, String pSource, boolean ignoreMMC, Sum smsSum) {
        LinkedList<SumResult> sums = new LinkedList<SumResult>();
        Sum income = in;
        if (trade != null && !trade.isEmpty()) {
            for (Sum s : trade) {
                SumResult serviceResult;
                SumResult dealerResult = CommissionCalculator.calculate(income, keeper, c, s, maxPaymentSum, diffSum, time, pSource, smsSum);
                if (!(dealerResult.getOut().isEmpty() || minC == null || ignoreMMC || !(serviceResult = CommissionCalculator.calculate(income, keeper, minC, s, maxPaymentSum, diffSum, time, pSource, smsSum)).getOut().isEmpty() && serviceResult.getCommission().compareTo(dealerResult.getCommission()) <= 0)) {
                    dealerResult = serviceResult;
                }
                if (maxC != null && !ignoreMMC && (serviceResult = CommissionCalculator.calculate(income, keeper, maxC, s, maxPaymentSum, diffSum, time, pSource, smsSum)).getCommission().compareTo(dealerResult.getCommission()) < 0) {
                    dealerResult = serviceResult;
                }
                if (dealerResult.getOut().isEmpty()) {
                    return Collections.singletonList(new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(), new Sum(), new Sum(), in, null, smsSum));
                }
                income = dealerResult.getChange();
                if (!sums.isEmpty()) {
                    dealerResult.setCash(new Sum());
                    dealerResult.setCashLess(new Sum());
                }
                dealerResult.setChange(new Sum());
                sums.add(dealerResult);
            }
            ((SumResult)sums.get(0)).setChange(income);
        } else {
            SumResult dealerResult;
            boolean first = true;
            Commission zeroUnitsComm = new Commission(c.getId(), c.getName(), c.getType(), c.getMin(), c.getMax(), c.getRoundOrder(), c.getPercentValue(), c.getFixedValue(), c.getSteps());
            zeroUnitsComm.setNominals(c.getNominals());
            zeroUnitsComm.setUseTiming(c.getUseTiming());
            zeroUnitsComm.setSeparateUnitTypesCalc(c.getSeparateUnitTypesCalc());
            Sum ost = in;
            Sum maxOutComSum = new Sum();
            do {
                SumResult serviceResult;
                Sum mx;
                if ((mx = maxPaymentSum) == null && maxTotal != null) {
                    mx = maxPaymentSum;
                } else if (mx != null && maxTotal != null && mx.compareTo(maxTotal) > 0) {
                    mx = maxTotal;
                }
                if (!first) {
                    c = zeroUnitsComm;
                }
                first = false;
                if (diffSum != null && diffSum.compareTo(ost) < 0) {
                    income = diffSum;
                    ost = ost.sub(diffSum);
                } else if (diffSum == null && mx != null && mx.compareTo(ost) < 0) {
                    income = mx;
                    ost = ost.sub(mx);
                } else {
                    income = ost;
                    ost = new Sum();
                }
                dealerResult = CommissionCalculator.calculate(income, keeper, c, null, mx, diffSum, time, pSource, smsSum);
                if (!(dealerResult.getOut().isEmpty() || minC == null || ignoreMMC || !(serviceResult = CommissionCalculator.calculate(income, keeper, minC, null, mx, diffSum, time, pSource, smsSum)).getOut().isEmpty() && serviceResult.getCommission().compareTo(dealerResult.getCommission()) <= 0)) {
                    dealerResult = serviceResult;
                }
                if (maxC != null && !ignoreMMC && (serviceResult = CommissionCalculator.calculate(income, keeper, maxC, null, mx, diffSum, time, pSource, smsSum)).getCommission().compareTo(dealerResult.getCommission()) < 0) {
                    dealerResult = serviceResult;
                }
                if (dealerResult.getOut().isEmpty() && sums.isEmpty()) {
                    return Collections.singletonList(new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(), new Sum(), new Sum(), in, null, smsSum));
                }
                if (dealerResult.getOut().isEmpty()) {
                    ((SumResult)sums.get(0)).setChange(dealerResult.getChange());
                    break;
                }
                maxOutComSum = maxOutComSum.add(dealerResult.getOut().add(dealerResult.getCommission()));
                if (!sums.isEmpty()) {
                    dealerResult.setCash(new Sum());
                    dealerResult.setCashLess(new Sum());
                }
                dealerResult.setChange(new Sum());
                sums.add(dealerResult);
            } while (maxTotal == null || (maxTotal = maxTotal.sub(dealerResult.getOut())) == null || maxTotal.getBasicSum() > 0);
            Sum cashSum = keeper.getCashSum();
            Sum cashLessSum = keeper.getCashlessSum();
            if (!sums.isEmpty() && cashSum != null && cashLessSum != null) {
                ((SumResult)sums.get(0)).setChange(cashSum.add(cashLessSum.sub(maxOutComSum)));
            }
        }
        return sums;
    }

    public static SumResult calculatePack(Sum in, Keeper keeper, Commission c, Commission minC, Commission maxC, List<Sum> trade, Sum maxPSum, Sum maxTotal, Sum diffSum, Date time, String pSource, boolean ignoreMMC, Sum smsSum) {
        List<SumResult> sums = CommissionCalculator.calculatePackForList(in, keeper, c, minC, maxC, trade, maxPSum, maxTotal, diffSum, time, pSource, ignoreMMC, smsSum);
        SumResult sr = new SumResult();
        sr.setCash(new Sum());
        sr.setCashLess(new Sum());
        sr.setChange(new Sum());
        sr.setCommission(new Sum());
        sr.setOut(new Sum());
        sr.setOutProv(new Sum());
        for (SumResult s : sums) {
            sr.setCash(sr.getCash().add(s.getCash()));
            sr.setCashLess(sr.getCashLess().add(s.getCashLess()));
            sr.setChange(sr.getChange().add(s.getChange()));
            sr.setCommission(sr.getCommission().add(s.getCommission()));
            sr.setOut(sr.getOut().add(s.getOut()));
            sr.setOutProv(sr.getOutProv().add(s.getOutProv()));
            if (s.getCommService() == null) continue;
            if (sr.getCommService() == null) {
                sr.setCommService(new Sum());
            }
            sr.setCommService(sr.getCommService().add(s.getCommService()));
        }
        return sr;
    }

    public static Sum calculate(List<Sum> trade, Commission commission, Commission serviceCommission, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee) {
        return CommissionCalculator.calculate(trade, commission, serviceCommission, time, pSource, ignoreMMC, providerFee, true);
    }

    public static Sum calculate(List<Sum> trade, Commission commission, Commission serviceCommission, Commission minServiceCommission, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee) {
        Sum sr = new Sum();
        for (Sum st : trade) {
            Sum s = CommissionCalculator.calculateWithMinMax(st, commission, serviceCommission, minServiceCommission, time, pSource, ignoreMMC, providerFee, true);
            sr = sr.add(s);
        }
        return sr;
    }

    public static Sum calculate(List<Sum> trade, Commission commission, Commission serviceCommission, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee, boolean setCurrentComm) {
        Sum sr = new Sum();
        for (Sum st : trade) {
            Sum s = CommissionCalculator.calculate(st, commission, serviceCommission, time, pSource, ignoreMMC, providerFee, setCurrentComm);
            sr = sr.add(s);
        }
        return sr;
    }

    public static Sum calculate(Sum min, Sum div, Commission commission, Commission serviceCommission, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee) {
        return CommissionCalculator.calculate(min, div, commission, serviceCommission, time, pSource, ignoreMMC, providerFee, true);
    }

    public static Sum calculate(Sum min, Sum div, Commission commission, Commission serviceCommission, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee, boolean setCurrentComm) {
        Sum m = min == null ? new Sum() : min;
        LinkedList<Sum> sums = new LinkedList<Sum>();
        while (true) {
            if (m.compareTo(div) <= 0) break;
            sums.add(div);
            m = m.sub(div);
        }
        sums.add(m);
        return CommissionCalculator.calculate(sums, commission, serviceCommission, time, pSource, ignoreMMC, providerFee, setCurrentComm);
    }

    public static Sum calculateSumIn(Sum sumOut, Commission commission) {
        int fixCom;
        int comm;
        int commFixValue;
        if (commission.getSteps() != null && commission.getSteps().size() > 0) {
            Sum step = sumOut.div(2.0);
            Sum in = sumOut;
            while (true) {
                Date d = Session.getInstance().getPack().getDate();
                Sum res = CommissionCalculator.calculate(in, CommissionCalculator.getKeeperBySum(in), commission, null, null, null, d, "CASH", null).getOut();
                if (res.compareTo(sumOut) >= 0) {
                    if (step.getBasicSum() == 1) break;
                    in = in.sub(step);
                    step = step.div(2.0);
                    continue;
                }
                in = in.add(step);
            }
            return in;
        }
        int sumOutValue = sumOut.getBasicSum();
        float maxPercent = (float)commission.getPercentValue();
        int n = commFixValue = commission.getFixedValue() == null ? 0 : commission.getFixedValue().getBasicSum();
        if (commission.getType() == CommissionType.Inverce) {
            comm = Math.round((float)sumOutValue * maxPercent / 100.0f);
            fixCom = Math.round((float)commFixValue * maxPercent / 100.0f);
        } else {
            comm = Math.round((float)sumOut.getBasicSum() * maxPercent / (100.0f - maxPercent));
            fixCom = Math.round((float)commFixValue * maxPercent / (100.0f - maxPercent));
        }
        comm += commFixValue + fixCom;
        int minValue = commission.getMin() == null ? 0 : commission.getMin().getBasicSum();
        comm = Math.max(comm, minValue);
        if (commission.getMax() != null && commission.getMax().getBasicSum() != 0) {
            comm = Math.min(comm, commission.getMax().getBasicSum());
        }
        return new Sum(sumOutValue + comm);
    }

    private static SumResult calculate(Sum in, Keeper keeper, FeeSum providerFee, Sum trade, Sum maxPaymentSum, Sum diffSum) {
        if (in == null) {
            throw new IllegalArgumentException("\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        if (providerFee == null) {
            throw new IllegalArgumentException("\u0421\u0442\u0430\u0432\u043a\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        Sum s0 = new Sum(0);
        Sum sumCommission = new Sum(providerFee.getFee());
        if (sumCommission.compareTo(in) >= 0) {
            return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), s0, s0, s0, in, providerFee, null);
        }
        Sum sumOut = in.sub(sumCommission);
        if (trade != null && !trade.isEmpty()) {
            if (sumOut.compareTo(trade) < 0) {
                return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), s0, s0, s0, in, providerFee, null);
            }
            return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), trade, trade, sumCommission, sumOut.sub(trade), providerFee, null);
        }
        if (diffSum != null && !diffSum.isEmpty()) {
            sumOut = diffSum.sub(sumCommission);
            Sum change = in.sub(diffSum);
            if (change.compareTo(new Sum()) >= 0) {
                return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), sumOut, sumOut, sumCommission, change, providerFee, null);
            }
            return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), s0, s0, s0, in, providerFee, null);
        }
        if (maxPaymentSum != null && !maxPaymentSum.isEmpty() && sumOut.compareTo(maxPaymentSum) > 0) {
            sumOut = maxPaymentSum;
            Sum change = in.sub(sumOut).sub(sumCommission);
            if (change.compareTo(new Sum()) >= 0) {
                return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), sumOut, sumOut, sumCommission, change, providerFee, null);
            }
            return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), s0, s0, s0, in, providerFee, null);
        }
        return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), sumOut, sumOut, sumCommission, s0, providerFee, null);
    }

    private static SumResult calculate(Keeper keeper, FeeSum providerFee, Sum trade) {
        if (keeper == null) {
            throw new IllegalArgumentException("\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        if (providerFee == null) {
            throw new IllegalArgumentException("\u0421\u0442\u0430\u0432\u043a\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        Sum sumCommission = new Sum(providerFee.getFee());
        if (sumCommission.compareTo(keeper.getSum()) >= 0) {
            return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(0), new Sum(0), new Sum(0), keeper.getSum(), providerFee, null);
        }
        Sum sumOut = keeper.getSum().sub(sumCommission);
        if (trade != null && !trade.isEmpty()) {
            if (sumOut.compareTo(trade) < 0) {
                return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(0), new Sum(0), new Sum(0), keeper.getSum(), providerFee, null);
            }
            return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), trade, trade, sumCommission, sumOut.sub(trade), providerFee, null);
        }
        return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), sumOut, sumOut, sumCommission, new Sum(0), providerFee, null);
    }

    private static Sum calculate(Sum trade, FeeSum providerFee) {
        if (providerFee == null) {
            throw new IllegalArgumentException("\u0421\u0442\u0430\u0432\u043a\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        return new Sum(trade.getBasicSum() + providerFee.getFee());
    }

    private static void updCurrentCommission(Commission currentCommission) {
        Session.getInstance().getPack().setCommission(currentCommission);
    }

    public static Sum calculateCommission(Sum in, Keeper keeper, Commission commission, Commission minCommission, Commission maxCommission, Sum trade, Sum maxPaymentSum, Sum diffSum, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee, Sum smsSum) {
        Sum serviceCommission;
        if (providerFee != null) {
            return new Sum(providerFee.getFee());
        }
        SumResult dealerResult = CommissionCalculator.calculate(in, keeper, commission, trade, maxPaymentSum, diffSum, time, pSource, smsSum);
        Sum dealerCommission = CommissionCalculator.calculateCommissionSum(in, keeper, commission, trade, maxPaymentSum, diffSum, time, pSource);
        if (!dealerResult.getOut().isEmpty() && minCommission != null && !ignoreMMC) {
            SumResult serviceResult = CommissionCalculator.calculate(in, keeper, minCommission, trade, maxPaymentSum, diffSum, time, pSource, smsSum);
            Sum serviceCommission2 = CommissionCalculator.calculateCommissionSum(in, keeper, minCommission, trade, maxPaymentSum, diffSum, time, pSource);
            if (serviceResult.getOut().isEmpty() || serviceCommission2.compareTo(dealerCommission) > 0) {
                return serviceCommission2;
            }
        }
        if (maxCommission != null && !ignoreMMC && (serviceCommission = CommissionCalculator.calculateCommissionSum(in, keeper, maxCommission, trade, maxPaymentSum, diffSum, time, pSource)).compareTo(dealerCommission) < 0) {
            return serviceCommission;
        }
        return dealerCommission;
    }

    private static SumResult calculateWithoutChange(Sum in, Keeper keeper, Commission commission, Sum trade, Sum maxPaymentSum, Sum diffSum, Date time, String pSource, FeeSum providerFee) {
        Sum keeperCashSum;
        if (in == null) {
            throw new IllegalArgumentException("\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        if (commission == null) {
            throw new IllegalArgumentException("\u0421\u0442\u0430\u0432\u043a\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        if (providerFee != null) {
            Sum sumCommission = new Sum(providerFee.getFee());
            if (sumCommission.compareTo(in) >= 0) {
                return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(0), new Sum(0), in, new Sum(0), providerFee, null);
            }
            Sum sumOut = in.sub(sumCommission);
            return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), sumOut, sumOut, sumCommission, new Sum(), providerFee, null);
        }
        Sum sumCommission = CommissionCalculator.calculateCommissionSum(in, keeper, commission, trade, maxPaymentSum, diffSum, time, pSource);
        if (sumCommission.compareTo((keeperCashSum = keeper.getCashSum()).add(keeper.getCashlessSum())) >= 0) {
            return new SumResult(keeperCashSum, keeper.getCashlessSum(), new Sum(0), new Sum(0), in, new Sum(0), null, null);
        }
        Sum sumOut = in.sub(sumCommission);
        return new SumResult(keeperCashSum, keeper.getCashlessSum(), sumOut, sumOut, sumCommission, new Sum(), null, null);
    }

    public static SumResult calculateWithoutChange(Sum in, Keeper keeper, Commission commission, Commission minCommission, Commission maxCommission, Sum trade, Sum maxPaymentSum, Sum diffSum, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee) {
        Sum serviceCommission;
        if (providerFee != null) {
            return CommissionCalculator.calculateWithoutChange(in, keeper, null, trade, maxPaymentSum, diffSum, null, null, providerFee);
        }
        SumResult dealerResult = CommissionCalculator.calculateWithoutChange(in, keeper, commission, trade, maxPaymentSum, diffSum, time, pSource, null);
        Sum dealerCommission = CommissionCalculator.calculateCommissionSum(in, keeper, commission, trade, maxPaymentSum, diffSum, time, pSource);
        CommissionCalculator.updCurrentCommission(commission);
        if (!dealerResult.getOut().isEmpty() && minCommission != null && !ignoreMMC) {
            SumResult serviceResult = CommissionCalculator.calculateWithoutChange(in, keeper, minCommission, trade, maxPaymentSum, diffSum, time, pSource, null);
            Sum serviceCommission2 = CommissionCalculator.calculateCommissionSum(in, keeper, minCommission, trade, maxPaymentSum, diffSum, time, pSource);
            if (serviceResult.getOut().isEmpty() || serviceCommission2.compareTo(dealerCommission) > 0) {
                dealerResult = serviceResult;
                CommissionCalculator.updCurrentCommission(minCommission);
                return dealerResult;
            }
        }
        if (maxCommission != null && !ignoreMMC && (serviceCommission = CommissionCalculator.calculateCommissionSum(in, keeper, maxCommission, trade, maxPaymentSum, diffSum, time, pSource)).compareTo(dealerCommission) < 0) {
            CommissionCalculator.updCurrentCommission(maxCommission);
            return CommissionCalculator.calculateWithoutChange(in, keeper, maxCommission, trade, maxPaymentSum, diffSum, time, pSource, null);
        }
        return dealerResult;
    }

    public static SumResult calculatePayPart(Sum in, Keeper keeper, Commission commission, Commission minCommission, Commission maxCommission, Sum maxPaymentSum, Date time, String pSource, boolean ignoreMMC, FeeSum providerFee) {
        Sum serviceCommission;
        if (providerFee != null) {
            return CommissionCalculator.calculatePayPart(in, keeper, null, maxPaymentSum, null, null, providerFee);
        }
        SumResult dealerResult = CommissionCalculator.calculatePayPart(in, keeper, commission, maxPaymentSum, time, pSource, null);
        Sum dealerCommission = CommissionCalculator.calculateCommissionSum(in, keeper, commission, in, maxPaymentSum, null, time, pSource);
        CommissionCalculator.updCurrentCommission(commission);
        if (!dealerResult.getOut().isEmpty() && minCommission != null && !ignoreMMC) {
            SumResult serviceResult = CommissionCalculator.calculatePayPart(in, keeper, minCommission, maxPaymentSum, time, pSource, null);
            Sum serviceCommission2 = CommissionCalculator.calculateCommissionSum(in, keeper, minCommission, in, maxPaymentSum, null, time, pSource);
            if (serviceResult.getOut().isEmpty() || serviceCommission2.compareTo(dealerCommission) > 0) {
                dealerResult = serviceResult;
                CommissionCalculator.updCurrentCommission(minCommission);
                return dealerResult;
            }
        }
        if (maxCommission != null && !ignoreMMC && (serviceCommission = CommissionCalculator.calculateCommissionSum(in, keeper, maxCommission, in, maxPaymentSum, null, time, pSource)).compareTo(dealerCommission) < 0) {
            CommissionCalculator.updCurrentCommission(maxCommission);
            return CommissionCalculator.calculatePayPart(in, keeper, maxCommission, maxPaymentSum, time, pSource, null);
        }
        return dealerResult;
    }

    private static SumResult calculatePayPart(Sum in, Keeper keeper, Commission commission, Sum maxPaymentSum, Date time, String pSource, FeeSum providerFee) {
        Sum keeperCashSum;
        if (in == null) {
            throw new IllegalArgumentException("\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        if (commission == null) {
            throw new IllegalArgumentException("\u0421\u0442\u0430\u0432\u043a\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        if (providerFee != null) {
            Sum sumCommission = new Sum(providerFee.getFee());
            if (sumCommission.compareTo(in) >= 0) {
                return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(0), new Sum(0), in, new Sum(0), providerFee, null);
            }
            Sum sumOut = in.sub(sumCommission);
            return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), sumOut, sumOut, sumCommission, new Sum(), providerFee, null);
        }
        Sum sumCommission = CommissionCalculator.calculateCommissionSum(in, keeper, commission, in, maxPaymentSum, null, time, pSource);
        if (sumCommission.compareTo((keeperCashSum = keeper.getCashSum()).add(keeper.getCashlessSum())) >= 0) {
            return new SumResult(keeperCashSum, keeper.getCashlessSum(), new Sum(0), new Sum(0), in, new Sum(0), null, null);
        }
        Sum sumOut = in.sub(sumCommission);
        return new SumResult(keeperCashSum, keeper.getCashlessSum(), sumOut, sumOut, sumCommission, new Sum(), null, null);
    }
}

