/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keyclient;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import ru.softlogic.keyclient.KeyClientException;
import ru.softlogic.keyclient.PointKeyResult;
import ru.softlogic.keyclient.SocketFactory;

public class KeyClient {
    private String url;
    private Long configurationId;
    private DefaultHttpClient client;

    public KeyClient(String url, Long configurationId) {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("Url not specified");
        }
        this.url = url;
        this.configurationId = configurationId;
    }

    public PointKeyResult sendPointKey(String login, String password, String request) throws KeyClientException {
        if (login == null || login.isEmpty()) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 login");
        }
        if (password == null || password.length() == 0) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 password");
        }
        this.setClientOptions();
        LinkedList<BasicNameValuePair> nvps = new LinkedList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("type", "point"));
        nvps.add(new BasicNameValuePair("login", login));
        nvps.add(new BasicNameValuePair("password", password));
        nvps.add(new BasicNameValuePair("request", request));
        if (this.configurationId != null) {
            nvps.add(new BasicNameValuePair("hwcode", this.configurationId.toString()));
        }
        try {
            HttpPost post = new HttpPost(this.url);
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "utf-8"));
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 200) {
                EntityUtils.consume((HttpEntity)response.getEntity());
                throw new KeyClientException(response.getStatusLine().toString());
            }
            Header header = response.getFirstHeader("Result-Code");
            if (header == null) {
                throw new KeyClientException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u0441 \u0438\u043c\u0435\u043d\u0435\u043c Result-Code");
            }
            String value = header.getValue();
            if (value == null || !value.matches("^\\d+$")) {
                throw new KeyClientException("\u0424\u043e\u0440\u043c\u0430\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u043d\u0435\u0432\u0435\u0440\u0435\u043d: " + value);
            }
            int result = Integer.parseInt(value);
            if (result != 0) {
                return new PointKeyResult(result);
            }
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            if (body == null || body.isEmpty()) {
                throw new IOException("\u041e\u0442\u0441\u0443\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u0435\u043b\u043e \u043e\u0442\u0432\u0435\u0442\u0430");
            }
            String[] fields = body.split("\n");
            if (fields.length != 4) {
                throw new IOException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043e\u0442\u0432\u0435\u0442\u0430: " + body);
            }
            if (fields[0].isEmpty()) {
                throw new IOException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043f\u043e\u043b\u044f '\u0430\u0434\u0440\u0435\u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430'");
            }
            if (!fields[1].matches("^\\d+$")) {
                throw new IOException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043f\u043e\u043b\u044f 'http-\u043f\u043e\u0440\u0442'");
            }
            if (!fields[2].matches("^\\d+$")) {
                throw new IOException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043f\u043e\u043b\u044f 'https-\u043f\u043e\u0440\u0442'");
            }
            if (fields[3].isEmpty()) {
                throw new IOException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043f\u043e\u043b\u044f '\u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447 \u0441\u0435\u0440\u0432\u0435\u0440\u0430'");
            }
            return new PointKeyResult(result, fields[0], Integer.parseInt(fields[2]), Integer.parseInt(fields[1]), fields[3]);
        }
        catch (IOException ex) {
            throw new KeyClientException(ex);
        }
    }

    private void setClientOptions() throws KeyClientException {
        if (this.client == null) {
            try {
                URL urlTmp = new URL(this.url);
                this.client = new DefaultHttpClient();
                this.client.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

                    public long getKeepAliveDuration(HttpResponse hr, HttpContext hc) {
                        return 0L;
                    }
                });
                if ("https".equals(urlTmp.getProtocol())) {
                    int port = urlTmp.getPort();
                    if (port < 0) {
                        port = urlTmp.getDefaultPort();
                    }
                    this.client.getConnectionManager().getSchemeRegistry().register(new Scheme("https", port, (SchemeSocketFactory)SocketFactory.getFactory()));
                }
                this.client.getParams().setIntParameter("http.socket.timeout", 30000);
                this.client.getParams().setIntParameter("http.connection.timeout", 30000);
            }
            catch (Exception ex) {
                throw new KeyClientException(ex);
            }
        }
    }
}

