/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.text;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import ru.softlogic.input.model.field.text.Validator;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class JsValidator
implements Validator {
    public static final String VARIABLE_NAME = "number";
    private static final long serialVersionUID = 1L;
    private static transient JsValidateEngine jsEngine;
    private transient JsExceptionListener listener;
    private final String script;

    @JsonCreator
    public JsValidator(@JsonProperty(value="script") String script) {
        if (script == null || script.isEmpty()) {
            throw new NullPointerException("Script is empty");
        }
        this.script = script;
    }

    public JsValidator(String script, JsExceptionListener listener) {
        this(script);
        this.listener = listener;
    }

    public void setListener(JsExceptionListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate(String data) {
        Class<JsValidator> clazz = JsValidator.class;
        synchronized (JsValidator.class) {
            if (jsEngine == null) {
                try {
                    jsEngine = this.createValidatorEngine();
                }
                catch (Throwable ex) {
                    jsEngine = this.createRhinoValidator();
                }
            }
            try {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return jsEngine.validate(this.script, data);
            }
            catch (Throwable ex) {
                this.notifyListener(ex);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return false;
        }
    }

    private void notifyListener(Throwable ex) {
        if (this.listener != null) {
            this.listener.onError(ex);
        }
    }

    private JsValidateEngine createValidatorEngine() throws Throwable {
        return (JsValidateEngine)Class.forName("ru.softlogic.validators.js.StdJsValidator").newInstance();
    }

    private JsValidateEngine createRhinoValidator() {
        try {
            return (JsValidateEngine)Class.forName("ru.softlogic.validators.js.RhinoJsValidator").newInstance();
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static interface JsValidateEngine {
        public boolean validate(String var1, String var2) throws Exception;
    }

    public static interface JsExceptionListener
    extends Serializable {
        public void onError(Throwable var1);
    }
}

