/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.selector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.selector.DateStoreType;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorItem;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DateStore
implements ItemsStore {
    static final long serialVersionUID = 0L;
    private DateStoreType type;
    private String keyFormat;
    private String titleFormat;
    private int offset;
    private int count;
    private List<SelectorItem> result;

    @JsonCreator
    public DateStore(@JsonProperty(value="type") DateStoreType type, @JsonProperty(value="keyFormat") String keyFormat, @JsonProperty(value="titleFormat") String titleFormat, @JsonProperty(value="offset") int offset, @JsonProperty(value="count") int count) {
        this.type = type;
        this.keyFormat = keyFormat;
        this.titleFormat = titleFormat;
        this.offset = offset;
        this.count = count;
    }

    @Override
    public List<SelectorItem> getItems() {
        if (this.result == null) {
            ArrayList<SelectorItem> items = new ArrayList<SelectorItem>();
            GregorianCalendar cal = new GregorianCalendar();
            SimpleDateFormat key = new SimpleDateFormat(this.keyFormat);
            SimpleDateFormat title = new SimpleDateFormat(this.titleFormat);
            ((Calendar)cal).add(this.type.getPeriod(), this.offset);
            int step = 1;
            int cnt = this.count;
            if (cnt < 0) {
                step = -1;
                cnt = -cnt;
            }
            for (int i = 0; i < cnt; ++i) {
                items.add(new SelectorItem(title.format(cal.getTime()), key.format(cal.getTime())));
                ((Calendar)cal).add(this.type.getPeriod(), step);
            }
            this.result = items;
        }
        return this.result;
    }

    public String toString() {
        return "DateStore{type=" + (Object)((Object)this.type) + ", keyFormat=" + this.keyFormat + ", titleFormat=" + this.titleFormat + ", offset=" + this.offset + ", count=" + this.count + '}';
    }

    @Override
    public void init(ModelEnvironment environment) throws InitException {
        this.result = null;
    }

    public void setType(DateStoreType type) {
        this.type = type;
    }

    public void setKeyFormat(String keyFormat) {
        this.keyFormat = keyFormat;
    }

    public void setTitleFormat(String titleFormat) {
        this.titleFormat = titleFormat;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setResult(List<SelectorItem> result) {
        this.result = result;
    }

    public static long getSerialVersionUID() {
        return 0L;
    }

    public DateStoreType getType() {
        return this.type;
    }

    public String getKeyFormat() {
        return this.keyFormat;
    }

    public String getTitleFormat() {
        return this.titleFormat;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getCount() {
        return this.count;
    }

    public List<SelectorItem> getResult() {
        return this.result;
    }
}

