/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.selector;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorItem;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class DataStore
implements ItemsStore {
    static final long serialVersionUID = 0L;
    private String key;
    private List<Data> dataSource;
    private List<SelectorItem> result;

    @JsonCreator
    public DataStore(@JsonProperty(value="key") String key) {
        this.key = key;
    }

    @Override
    public void init(ModelEnvironment environment) throws InitException {
        this.result = null;
        Object obj = environment.getData().get(this.key);
        if (obj == null) {
            throw new InitException("DataStore " + this.key + " is not initialized. No data.");
        }
        if (!(obj instanceof List)) {
            throw new InitException("DataStore " + this.key + " is not initialized. Wrong type.");
        }
        this.dataSource = (List)obj;
    }

    @Override
    public List<SelectorItem> getItems() {
        if (this.dataSource == null) {
            return new ArrayList<SelectorItem>();
        }
        if (this.result == null) {
            ArrayList<SelectorItem> itemList = new ArrayList<SelectorItem>();
            for (Data d : this.dataSource) {
                SelectorItem si = new SelectorItem();
                si.setData(d);
                Map<String, InputElement> map = StoreHelper.convert(d.getElements());
                InputElement title = map.get("title");
                if (title == null) {
                    title = map.get("#title");
                }
                if (title != null) {
                    si.setTitle(title.getValueTitle());
                    si.setValue(title.getValue());
                    InputElement image = map.get("image");
                    if (image != null) {
                        si.setImage(image.getValue());
                    }
                }
                itemList.add(si);
            }
            this.result = itemList;
        }
        return this.result;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<Data> getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(List<Data> dataSource) {
        this.dataSource = dataSource;
    }

    public List<SelectorItem> getResult() {
        return this.result;
    }

    public void setResult(List<SelectorItem> result) {
        this.result = result;
    }

    public String toString() {
        return "DataStore [key='" + this.key + "'" + ", dataSource=" + this.dataSource + ", result=" + this.result + ']';
    }
}

