/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.date;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.GregorianCalendar;
import ru.softlogic.input.model.field.date.DateRange;
import ru.softlogic.input.model.field.date.Range;
import ru.softlogic.input.model.field.date.RelativeRangeValue;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RelativeDateRange
implements DateRange {
    public static final long serialVersionUID = 0L;
    @JsonProperty(value="from")
    private RelativeRangeValue from;
    @JsonProperty(value="to")
    private RelativeRangeValue to;
    @JsonProperty(value="current")
    private RelativeRangeValue current;

    public RelativeDateRange() {
    }

    public RelativeDateRange(int from, int to, int current) {
        if (from >= to) {
            throw new IllegalArgumentException("'From' must be less 'to'");
        }
        if (current < from || current > to) {
            throw new IllegalArgumentException("Current value must be in range " + from + "main" + to);
        }
        this.from = new RelativeRangeValue(from, 5);
        this.to = new RelativeRangeValue(to, 5);
        this.current = new RelativeRangeValue(current, 5);
    }

    @JsonCreator
    public RelativeDateRange(@JsonProperty(value="from") RelativeRangeValue from, @JsonProperty(value="to") RelativeRangeValue to, @JsonProperty(value="current") RelativeRangeValue current) {
        this.from = from;
        this.to = to;
        this.current = current == null ? new RelativeRangeValue(0, 5) : current;
    }

    @Override
    public Range getRange() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(this.current.getUnits(), this.current.getValue());
        Date dCurrent = cal.getTime();
        Date dFrom = null;
        Date dTo = null;
        if (this.from != null) {
            cal.add(this.current.getUnits(), -this.current.getValue());
            cal.add(this.from.getUnits(), this.from.getValue());
            dFrom = cal.getTime();
        }
        if (this.to != null) {
            if (this.from != null) {
                cal.add(this.from.getUnits(), -this.from.getValue());
            }
            cal.add(this.to.getUnits(), this.to.getValue());
            dTo = cal.getTime();
        }
        return new Range(dFrom, dTo, dCurrent);
    }

    public String toString() {
        return "RelativeDateRange{from=" + this.from + ", to=" + this.to + ", current=" + this.current + '}';
    }
}

