/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.barcode;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.barcode.BarcodeData;
import ru.softlogic.input.model.field.barcode.BarcodeException;
import ru.softlogic.input.model.field.barcode.BarcodeParser;
import ru.softlogic.input.model.field.barcode.BlockInit;
import ru.softlogic.input.model.field.barcode.BlockRule;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BlockParser
implements BarcodeParser {
    public static final long serialVersionUID = 0L;
    private BlockInit init;

    @JsonCreator
    public BlockParser(@JsonProperty(value="init") BlockInit init) {
        if (init == null) {
            throw new NullPointerException();
        }
        this.init = init;
    }

    @Override
    public BarcodeData parse(String data) throws BarcodeException {
        ArrayList<InputElement> result = new ArrayList<InputElement>();
        if (this.init.getRules() != null && data != null) {
            for (BlockRule rule : this.init.getRules()) {
                if (rule.getKey() == null || rule.getBegin() >= rule.getEnd() || rule.getEnd() > data.length()) {
                    throw new BarcodeException("Key void or rule invalid");
                }
                String value = data.substring(rule.getBegin(), rule.getEnd());
                InputElement be = new InputElement(rule.getKey(), rule.getTitle(), value, value, rule.getFlags());
                be.setOriginalValue(value);
                result.add(be);
            }
        }
        BarcodeData bd = new BarcodeData();
        bd.setElements(result);
        return bd;
    }

    public BlockInit getInit() {
        return this.init;
    }
}

