/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.text.SimpleDateFormat;
import java.util.Date;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ExecuteException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Set
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private InputElement element;

    public Set() {
    }

    public Set(InputElement element) {
        this.element = element;
    }

    public InputElement getElement() {
        return this.element;
    }

    public void setElement(InputElement element) {
        this.element = element;
    }

    public String toString() {
        return "Set{element=" + this.element + '}';
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        if (this.element == null) {
            throw new ExecuteException("Element no set");
        }
        Date now = new Date();
        InputElement ie = new InputElement();
        ie.setKey(this.processField(this.element.getKey(), now, context));
        ie.setKeyTitle(this.processField(this.element.getKeyTitle(), now, context));
        ie.setValue(this.processField(this.element.getValue(), now, context));
        ie.setValueTitle(this.processField(this.element.getValueTitle(), now, context));
        ie.setOriginalValue(this.processField(this.element.getOriginalValue(), now, context));
        ie.setKeyTitleId(this.element.getKeyTitleId());
        ie.setFlags(this.element.getFlags());
        context.put(ie.getKey(), ie);
        context.execute();
    }

    private String processField(String field, Date date, ActionContext context) throws ExecuteException {
        if (field == null) {
            return null;
        }
        if (field.contains("$now{") && field.contains("}")) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(field.substring(field.indexOf("$now{") + 5, field.lastIndexOf(125)));
                field = field.replaceAll("\\$now\\{.*\\}", sdf.format(date));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (field.contains("$service.id")) {
            field = field.replaceAll("\\$service\\.id", "" + context.getIdService());
        }
        if (field.contains("$offer.doc")) {
            field = field.replaceAll("\\$offer\\.doc", "" + context.getEnvironment().getOffer(null));
        }
        if (field.contains("$terminal.doc")) {
            field = field.replaceAll("\\$terminal\\.doc", "" + context.getEnvironment().getOffer("terminal"));
        }
        return field;
    }
}

