/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import java.io.File;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.utils.FileUtil;

public class ReadFile
implements ActionElement {
    public static final long serialVersionUID = 0L;
    public static final long MAX_FILE_SIZE = 102400L;
    private final String fileName;
    private final String targetKey;
    private final ActionMap actionMap;

    public ReadFile(String fileName, String targetKey, ActionMap actionMap) {
        if (fileName == null) {
            throw new NullPointerException("File name is not set");
        }
        if (targetKey == null) {
            throw new NullPointerException("Target key is not set");
        }
        this.fileName = fileName;
        this.targetKey = targetKey;
        this.actionMap = actionMap;
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        try {
            File file = new File(ContextHelper.replaceParams(this.fileName, context));
            if (!file.exists()) {
                throw new ExecuteException("File not exists: " + file.getName());
            }
            if (file.length() > 102400L) {
                throw new ExecuteException("File too big: " + file.length());
            }
            String content = FileUtil.readFile(file);
            InputElement val = new InputElement();
            val.setKey(this.targetKey);
            val.setKeyTitle(this.targetKey);
            val.setValue(content);
            val.setValueTitle(null);
            context.put(val.getKey(), val);
            if (this.actionMap != null && this.actionMap.getActionByType("success") != null) {
                Action action = this.actionMap.getActionByType("success");
                ActionContext local = new ActionContext(this.getContextName(), context, action.getSequence());
                local.execute();
            } else {
                context.execute();
            }
        }
        catch (Exception ex) {
            if (this.actionMap != null && this.actionMap.getActionByType("error") != null) {
                Action action = this.actionMap.getActionByType("error");
                ActionContext local = new ActionContext(this.getContextName(), context, action.getSequence());
                InputElement inputElement = new InputElement("#error", "#error", ex.getMessage());
                local.put(inputElement.getKey(), inputElement);
                local.execute();
            }
            context.cancelScript();
        }
    }

    private String getContextName() {
        return "read file:" + this.fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTargetKey() {
        return this.targetKey;
    }
}

