/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.LinkedList;
import java.util.Map;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ExecuteException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Pack
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private String type;
    private String key = "";
    private String elements;

    public String getKey() {
        return this.key;
    }

    public String getType() {
        return this.type;
    }

    public void setKey(String key) {
        if (key == null) {
            key = "";
        }
        this.key = key;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getElements() {
        return this.elements;
    }

    public void setElements(String elements) {
        this.elements = elements;
    }

    public String toString() {
        return "Pack{type=" + this.type + ", key=" + this.key + '}';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(ActionContext context) throws ExecuteException {
        if ("nested".equals(this.type)) {
            String[] keys;
            LinkedList<Data> nd = new LinkedList<Data>();
            for (String s : keys = this.elements.split(",")) {
                Object data = context.getData().get(s);
                if (!(data instanceof Data)) continue;
                nd.add((Data)data);
            }
            context.put(this.key, nd);
        } else {
            String[] keys;
            if (!"data".equals(this.type)) throw new ExecuteException("Unknown pack type");
            Object data = context.getData().get(this.key);
            if (data == null) {
                data = new Data(new LinkedList<InputElement>());
            }
            if (!(data instanceof Data)) throw new ExecuteException("" + data + " is not Data");
            Data dt = (Data)data;
            Map<String, InputElement> attrs = StoreHelper.convert(dt.getElements());
            for (String s : keys = this.elements.split(",")) {
                Object el = context.getData().get(s);
                if (!(el instanceof InputElement)) continue;
                InputElement el1 = (InputElement)el;
                attrs.put(s, el1);
            }
            dt.setElements(StoreHelper.convertNoClear(attrs));
            context.put(this.key, dt);
        }
        context.execute();
    }
}

