/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ExecuteException;

public class Hash
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private String srcKey;
    private String targetKey;
    private Algorithm method;

    public Hash() {
    }

    public Hash(String srcKey, String targetKey, Algorithm method) {
        this.srcKey = srcKey;
        this.targetKey = targetKey;
        this.method = method;
    }

    public String getSrcKey() {
        return this.srcKey;
    }

    public void setSrcKey(String srcKey) {
        this.srcKey = srcKey;
    }

    public String getTargetKey() {
        return this.targetKey;
    }

    public void setTargetKey(String targetKey) {
        this.targetKey = targetKey;
    }

    public Algorithm getMethod() {
        return this.method;
    }

    public void setMethod(Algorithm method) {
        this.method = method;
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        Object object;
        if (this.srcKey == null) {
            throw new ExecuteException("Attribute 'srcKey' not set");
        }
        if (this.method == null) {
            this.method = Algorithm.MD5;
        }
        if (this.targetKey == null) {
            this.targetKey = this.srcKey;
        }
        String hashedString = (object = context.getData().get(this.srcKey)) instanceof InputElement ? ((InputElement)object).getValue() : this.srcKey;
        byte[] result = this.getHash(this.method.getName(), hashedString);
        if (result == null) {
            throw new ExecuteException("Method not supported.");
        }
        context.put(this.targetKey, new InputElement(this.targetKey, this.targetKey, Hash.toHexString(result)));
        context.execute();
    }

    public byte[] getHash(String algorithm, String string) {
        byte[] res = null;
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            res = md.digest(string.getBytes());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return res;
    }

    public static String toHexString(byte[] data) {
        StringBuilder result = new StringBuilder();
        for (byte b : data) {
            result.append(String.format("%02X", b));
        }
        return result.toString();
    }

    public static enum Algorithm {
        MD5("MD5"),
        SHA256("SHA-256"),
        SHA1("SHA-1");

        private final String name;

        private Algorithm(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Algorithm getByNameIgnoreCase(String name) {
            for (Algorithm alg : Algorithm.values()) {
                if (!alg.name.equalsIgnoreCase(name) && !alg.toString().equalsIgnoreCase(name)) continue;
                return alg;
            }
            return null;
        }
    }
}

