/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.print;

import com.fasterxml.jackson.annotation.JsonInclude;
import ru.softlogic.input.model.advanced.AdvancedHardwareApi;
import ru.softlogic.input.model.advanced.Printer;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ExecuteException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CustomPrint
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private final String templateName;

    public CustomPrint() {
        this.templateName = "";
    }

    public CustomPrint(String templateName) {
        this.templateName = templateName;
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        AdvancedHardwareApi hardwareApi = context.getEnvironment().getHardwareApi();
        if (hardwareApi == null) {
            throw new ExecuteException("Advanced Hardware Api is null");
        }
        Printer printer = hardwareApi.getPrinter();
        if (printer == null) {
            throw new ExecuteException("Printer is null");
        }
        printer.printCustom(this.templateName, context.getData());
        context.execute();
    }

    public String toString() {
        return "CustomPrint{templateName=" + this.templateName + '}';
    }
}

