/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.hdw;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.AdvancedHardwareApi;
import ru.softlogic.input.model.advanced.AsyncTask;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.hdw.HardwareAsyncTask;
import ru.softlogic.input.model.advanced.actions.hdw.HardwareException;
import ru.softlogic.input.model.advanced.actions.hdw.HardwareRequest;
import ru.softlogic.input.model.advanced.actions.hdw.WebcamHandler;
import ru.softlogic.input.model.advanced.actions.request.Response;
import ru.softlogic.input.model.utils.FileUtil;

public class WebcamRequest
extends HardwareRequest {
    public static final long serialVersionUID = 0L;

    public WebcamRequest(String function, List<String> params, ActionMap actionMap) {
        super(function, params, actionMap);
    }

    @Override
    protected AsyncTask _getAsyncTask(ActionContext context, Map<String, String> map) {
        return new RequestTask(context, this.function, map, this.actionMap);
    }

    private class RequestTask
    extends HardwareAsyncTask {
        private static final long serialVersionUID = 1L;

        public RequestTask(ActionContext context, String function, Map<String, String> params, ActionMap actionMap) {
            super(context, function, params, actionMap);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Response<Data> _execute(AdvancedHardwareApi hardwareApi) throws HardwareException {
            WebcamHandler wh = hardwareApi.getWebcamHandler();
            if (wh == null) {
                throw new HardwareException("Webcam handler is null");
            }
            ArrayList<InputElement> ieList = new ArrayList<InputElement>();
            int serviceError = 0;
            if ("stop-video".equals(this.function)) {
                wh.stopVideo();
                return new Response<Data>(0, serviceError, new Data(ieList));
            } else if ("take-photo".equals(this.function)) {
                BufferedImage image = wh.takePhoto();
                if (image == null) throw new HardwareException("Can't take photo (null)");
                if (this.params.get("save-file") == null) return new Response<Data>(0, serviceError, new Data(ieList));
                try {
                    this.saveToFile(image, (String)this.params.get("save-file"));
                    return new Response<Data>(0, serviceError, new Data(ieList));
                }
                catch (IOException e) {
                    throw new HardwareException("Can't save file", e);
                }
            } else if ("start-video".equals(this.function)) {
                if (wh.startVideo()) return new Response<Data>(0, serviceError, new Data(ieList));
                serviceError = 1;
                return new Response<Data>(0, serviceError, new Data(ieList));
            } else if ("open".equals(this.function)) {
                if (wh.open()) return new Response<Data>(0, serviceError, new Data(ieList));
                serviceError = 1;
                return new Response<Data>(0, serviceError, new Data(ieList));
            } else {
                if (!"close".equals(this.function)) return new Response<Data>(0, serviceError, new Data(ieList));
                wh.close();
            }
            return new Response<Data>(0, serviceError, new Data(ieList));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveToFile(BufferedImage photo, String filePath) throws IOException {
            FileOutputStream fos = null;
            try {
                File file = FileUtil.checkFile(filePath);
                fos = new FileOutputStream(file);
                ImageIO.write((RenderedImage)photo, "jpeg", fos);
            }
            catch (Throwable throwable) {
                FileUtil.close(fos);
                throw throwable;
            }
            FileUtil.close(fos);
        }
    }
}

